/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.batch;

import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.HtmlTableCellRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.ComputeType;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResIcoCompute;
import com.dassault.cecilia.plugin.faulttree.compute.batch.BatchCompute;
import com.dassault.cecilia.plugin.faulttree.compute.batch.BatchItem;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfig;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMCS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class BatchContainer
implements Runnable {
    private static Logger _LOG = Logger.getLogger(BatchContainer.class.getPackage().getName());
    Plugable _plugable;
    EngineBDDConfig _engineBDDCfg;
    BatchCompute _batch;
    boolean _requestStop;
    boolean _requestSuspend;
    boolean _finnished;
    Object _requestSuspendLocker = new Object();
    int _curAction;
    int _maxAction;
    BatchItem _curItem;
    protected List<Integer> _errorIndex = new ArrayList<Integer>();
    protected List<BatchItem> _errorBatchItem = new ArrayList<BatchItem>();
    protected List<String> _errorMsgs = new ArrayList<String>();

    public void displayErrorMsg(String msg) {
        _LOG.log(Level.SEVERE, msg);
    }

    public BatchContainer(Plugable plugable, EngineBDDConfig engineBDDCfg, BatchCompute batch) {
        this._plugable = plugable;
        this._engineBDDCfg = engineBDDCfg;
        this._batch = batch;
        this._curAction = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._finnished = false;
        this._requestStop = false;
        this._requestSuspend = false;
        this._curAction = 0;
        this._maxAction = this._batch.getNbrItem();
        try {
            _LOG.finer("BatchContainer started");
            BatchCtrl batchCtrl = new BatchCtrl();
            while (this._curAction < this._maxAction) {
                Object paramCompute;
                this._curItem = this._batch.getItem(this._curAction++);
                String refPath = this._curItem.getTreePath();
                _LOG.finer("BatchContainer beginning item : " + refPath);
                batchCtrl.clear();
                if (this._requestStop) {
                    batchCtrl.addError(ResCompute.getString("BATCH_MSG_STOP_USER"));
                } else {
                    try {
                        this._curItem.execute(this._plugable, this._engineBDDCfg, batchCtrl, this._batch.getSaveResults(), this._batch.getIgnoreReference());
                    }
                    catch (Exception exc) {
                        _LOG.log(Level.SEVERE, "Exception compute batch for item: " + refPath, exc);
                        batchCtrl.addError("Exception: " + exc.getLocalizedMessage());
                    }
                    catch (Error err) {
                        _LOG.log(Level.SEVERE, "Error compute batch for item: " + refPath, err);
                        batchCtrl.addError("Error: " + err.getLocalizedMessage());
                    }
                    if (this._requestStop) {
                        batchCtrl.addError(ResCompute.getString("BATCH_MSG_STOP_USER"));
                    }
                }
                if (batchCtrl.withMsg()) {
                    this.addError(this._curAction, this._curItem, batchCtrl.getMsgs());
                }
                if (this._curItem._cmdType == ComputeType.MCS && ((ParamComputeAbstract)(paramCompute = this._curItem.getParametersMCSCompute())).getLimitOrder() != -1 && ((ParamComputeMCS)paramCompute).getComputePrForGate() != null && ((ParamComputeMCS)paramCompute).getComputePrForGate().booleanValue()) {
                    this.addError(this._curAction, this._curItem, ResCompute.getString("COMPUTE_PROBA_INTERMEDIATE_WITH_CUT_WARNING"));
                }
                if (!this._requestSuspend) continue;
                try {
                    _LOG.fine("BatchContainer request suspend");
                    paramCompute = this._requestSuspendLocker;
                    synchronized (paramCompute) {
                        this._requestSuspendLocker.wait();
                    }
                    _LOG.fine("BatchContainer request resume");
                }
                catch (InterruptedException e) {
                    _LOG.log(Level.INFO, "InterruptedException", e);
                    break;
                }
            }
            this._finnished = true;
            _LOG.finer("BatchContainer finalized");
        }
        catch (Throwable t) {
            _LOG.log(Level.WARNING, "During runnable BatchContainer : ", t);
            this._finnished = true;
        }
    }

    private void addError(int idx, BatchItem item, String msgs) {
        this._errorIndex.add(idx);
        this._errorBatchItem.add(item);
        this._errorMsgs.add(msgs);
    }

    public int getNbrTreeMsg() {
        return this._errorBatchItem.size();
    }

    public int getErrorTreeIndex(int idx) {
        return this._errorIndex.get(idx);
    }

    public BatchItem getErrorBatchItem(int idx) {
        return this._errorBatchItem.get(idx);
    }

    public String getErrorTreeMsg(int idx) {
        return this._errorMsgs.get(idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestStop() {
        this._requestStop = true;
        if (this._requestSuspend) {
            this._requestSuspend = false;
            Object object = this._requestSuspendLocker;
            synchronized (object) {
                this._requestSuspendLocker.notifyAll();
            }
        }
    }

    public void requestSuspend() {
        this._requestSuspend = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestResume() {
        this._requestSuspend = false;
        Object object = this._requestSuspendLocker;
        synchronized (object) {
            this._requestSuspendLocker.notifyAll();
        }
    }

    public String getInfo() {
        if (this._finnished) {
            if (this._requestStop) {
                return ResCompute.getString("TASK_INFO_CANCEL");
            }
            return ResCompute.getString("TASK_INFO_FINNISH");
        }
        if (this._curAction < 0) {
            return ResCompute.getString("TASK_INFO_NOSTART");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this._curAction).append("/").append(this._maxAction);
        if (this._curItem != null) {
            buffer.append(" - ").append(this._curItem.getInfoProgress());
        }
        return buffer.toString();
    }

    public float getProgress() {
        if (this._finnished) {
            return 1.0f;
        }
        if (this._curAction < 0) {
            return -1.0f;
        }
        if (this._curAction == 0) {
            return 0.0f;
        }
        if (this._curAction <= this._maxAction) {
            float result = this._curAction - 1;
            if (this._curItem != null) {
                result += this._curItem.getProgress();
            }
            return result / (float)this._maxAction;
        }
        return 1.0f;
    }

    private PlugPanel createPanelError() {
        return new PlugPanel(){

            public void trash() {
            }

            public Component getPanel() {
                class ErrorModelTable
                extends AbstractTableModel {
                    ErrorModelTable() {
                    }

                    @Override
                    public int getRowCount() {
                        return BatchContainer.this.getNbrTreeMsg();
                    }

                    @Override
                    public int getColumnCount() {
                        return 4;
                    }

                    @Override
                    public String getColumnName(int c) {
                        switch (c) {
                            case 0: {
                                return ResCompute.getString("BATCH_MSG_IDX");
                            }
                            case 1: {
                                return ResCompute.getString("BATCH_MSG_TREEPATH");
                            }
                            case 2: {
                                return ResCompute.getString("BATCH_DLG_TABLE_CONFIG");
                            }
                        }
                        return ResCompute.getString("BATCH_MSG_MESSAGES");
                    }

                    @Override
                    public Object getValueAt(int r, int c) {
                        switch (c) {
                            case 0: {
                                return Integer.toString(BatchContainer.this.getErrorTreeIndex(r));
                            }
                            case 1: {
                                return BatchContainer.this.getErrorBatchItem(r).getTreePath();
                            }
                            case 2: {
                                StringBuilder buffer = new StringBuilder();
                                BatchItem item = BatchContainer.this.getErrorBatchItem(r);
                                buffer.append((Object)item.getComputeType()).append(" - ");
                                buffer.append(item.getTreeConfiguration());
                                return buffer.toString();
                            }
                        }
                        return BatchContainer.this.getErrorTreeMsg(r);
                    }
                }
                JTable table = new JTable(new ErrorModelTable()){

                    @Override
                    public void createDefaultColumnsFromModel() {
                        super.createDefaultColumnsFromModel();
                        for (int col = 0; col < this.getColumnCount(); ++col) {
                            TableColumn tcol = this.getColumnModel().getColumn(col);
                            int width = 10;
                            switch (col) {
                                case 0: {
                                    width = 4;
                                    break;
                                }
                                case 1: {
                                    width = 20;
                                    tcol.setCellRenderer(new DefaultTableCellRenderer(){

                                        @Override
                                        public Component getTableCellRendererComponent(JTable component, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                                            super.getTableCellRendererComponent(component, value, isSelected, hasFocus, row, column);
                                            String tree = value.toString();
                                            StringBuffer bufferToolTip = new StringBuffer(tree.length() * 12 / 10);
                                            bufferToolTip.append("<html>");
                                            String[] path = tree.split("/");
                                            for (int i = 0; i < path.length; ++i) {
                                                bufferToolTip.append(path[i]).append("<br/>");
                                            }
                                            bufferToolTip.append("</html>");
                                            this.setToolTipText(bufferToolTip.toString());
                                            return this;
                                        }
                                    });
                                    break;
                                }
                                case 2: {
                                    width = 20;
                                    break;
                                }
                                case 3: {
                                    width = 50;
                                    tcol.setCellRenderer((TableCellRenderer)new HtmlTableCellRenderer());
                                }
                            }
                            tcol.setPreferredWidth(13 * width);
                        }
                    }
                };
                JScrollPane scroll = new JScrollPane(table);
                scroll.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                JPanel root = new JPanel(new BorderLayout());
                root.add((Component)scroll, "Center");
                root.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(ResCompute.getString("BATCH_MSG_TITLE_ERROR"))));
                return root;
            }

            public String getInfo(String key) {
                if (key.equals("ppanel.title")) {
                    return ResCompute.getString("PLUG_CMD_BATCH_NAME");
                }
                if (key.equals("ppanel.default.width")) {
                    return "800";
                }
                if (key.equals("ppanel.default.height")) {
                    return Integer.toString(Math.min((BatchContainer.this.getNbrTreeMsg() + 2) * 100, 600));
                }
                return null;
            }

            public Icon getIcon(String key) {
                if (key.equals("ppanel.icon")) {
                    return ResIcoCompute.getImageIcon("PLUGIN_BATCH");
                }
                return null;
            }
        };
    }

    public PlugTask createPlugTask(final String taskName, final String taskDesc) {
        return new PlugTask(){

            public void run() {
                try {
                    BatchContainer.this.run();
                }
                finally {
                    BatchContainer.this._plugable.getAppl().refreshDAOFolder();
                }
                if (BatchContainer.this.getNbrTreeMsg() == 0) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)BatchContainer.this._plugable.getWindow()), ResCompute.getString("BATCH_MSG_DONE"), ResCompute.getString("BATCH_MSG_TITLE"), 1);
                        }
                    });
                } else {
                    BatchContainer.this._plugable.addPanel(BatchContainer.this.createPanelError(), -1L);
                }
            }

            public void requestStop() {
                BatchContainer.this.requestStop();
            }

            public void requestSuspend(boolean high) {
                BatchContainer.this.requestSuspend();
            }

            public void requestResume() {
                BatchContainer.this.requestResume();
            }

            public String getInfo(String key) {
                if (key.equals("process.msg")) {
                    return BatchContainer.this.getInfo();
                }
                if (key.equals("process.p1000")) {
                    return Integer.toString((int)(BatchContainer.this.getProgress() * 1000.0f));
                }
                if (key.equals("ptask.desc")) {
                    return taskDesc;
                }
                if (key.equals("plugin.name")) {
                    return taskName;
                }
                return null;
            }

            public boolean isPriority() {
                return false;
            }

            public Icon getIcon(String key) {
                if (key.equals("ptask.icon")) {
                    return ResIcoCompute.getImageIcon("PLUGIN_BATCH");
                }
                return null;
            }
        };
    }

    class BatchCtrl
    implements BatchItem.BatchItemCtrl {
        List<String> _errors = new ArrayList<String>();
        List<String> _warnings = new ArrayList<String>();

        BatchCtrl() {
        }

        @Override
        public void addError(String msg) {
            this._errors.add(msg);
        }

        @Override
        public void addWarning(String msg) {
            this._warnings.add(msg);
        }

        @Override
        public boolean isCanceled() {
            return BatchContainer.this._requestStop || this._errors.size() > 0;
        }

        boolean withMsg() {
            return this._errors.size() > 0 || this._warnings.size() > 0;
        }

        boolean withError() {
            return this._errors.size() > 0;
        }

        String getMsgs() {
            StringBuffer buffer = new StringBuffer(512);
            for (String msg : this._errors) {
                buffer.append(msg).append("\n");
            }
            for (String msg : this._warnings) {
                buffer.append(msg).append("\n");
            }
            return buffer.toString();
        }

        void clear() {
            this._errors.clear();
            this._warnings.clear();
        }
    }
}

