/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.batch;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.general.attrib.AttrCriterion;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.plugin.faulttree.compute.ComputeType;
import com.dassault.cecilia.plugin.faulttree.compute.ParamCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.batch.BatchItem;
import com.dassault.cecilia.plugin.faulttree.compute.batch.ExportItem;
import com.dassault.cecilia.plugin.faulttree.compute.batch.ExportPanel;
import com.dassault.cecilia.plugin.faulttree.compute.compute.DlgPanelComputeMCS;
import com.dassault.cecilia.plugin.faulttree.compute.compute.DlgPanelComputeMEL;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfig;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMCS;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMEL;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilterLatent;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilterNone;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilterStandard;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilterWeight;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorter;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class BatchItemComputeDlg
extends JDialogCecilia {
    Map<Attr.Key, Set<String>> _attributes;
    Plugable _plugable;
    ArborRenderer _renderer;
    EngineBDDConfig _engineBDDConfig;
    ActionListener _actionListenerFilter = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            final MCSFilter filter = BatchItemComputeDlg.this.getMCSFilter();
            if (filter == null) {
                BatchItemComputeDlg.this._ctrlSorterSel.setEnabled(false);
                BatchItemComputeDlg.this._ctrlLimitedSel.setEnabled(false);
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!filter.selectFilter(BatchItemComputeDlg.this._ctrlFilterSel)) {
                        if (BatchItemComputeDlg.this._ctrlFilterCurrent.getClass() != filter.getClass()) {
                            BatchItemComputeDlg.this._ctrlFilterSel.setSelectedItem(BatchItemComputeDlg.this._ctrlFilterCurrent.getClass());
                        }
                        return;
                    }
                    BatchItemComputeDlg.this._ctrlFilterCurrent = filter;
                    BatchItemComputeDlg.this.refreshFilter();
                }
            });
            BatchItemComputeDlg.this._ctrlFilterBut.setEnabled(filter.withDialog());
            String filterAbstract = filter.getAbstract();
            if (filterAbstract.length() > 0) {
                BatchItemComputeDlg.this._ctrlFilterBut.setToolTipText(new StringBuffer().append("<html>").append(filterAbstract.replaceAll("\\n", "<br/>")).append("</html>").toString());
            } else {
                BatchItemComputeDlg.this._ctrlFilterBut.setToolTipText(null);
            }
            if (filter instanceof MCSFilterWeight) {
                BatchItemComputeDlg.this._ctrlSorterSel.setEnabled(false);
                BatchItemComputeDlg.this._ctrlLimitedSel.setEnabled(false);
            } else {
                BatchItemComputeDlg.this._ctrlSorterSel.setEnabled(true);
                BatchItemComputeDlg.this._ctrlLimitedSel.setEnabled(true);
            }
        }
    };
    private JPanel _ctrlParamsPanel;
    private CardLayout _ctrlParamsLayout;
    private ExportPanel _ctrlExport;
    private JComboBox _ctrlType;
    private DlgPanelComputeMEL _ctrlParamsMEL;
    private DlgPanelComputeMCS _ctrlParamsMCS;
    JComboBox _ctrlFilterSel;
    JButton _ctrlFilterBut;
    Map<Class<?>, MCSFilter> _ctrlFilters;
    MCSFilter _ctrlFilterCurrent;
    boolean _isInMultiEditionMode;
    JComboBox _ctrlSorterSel;
    JComboBox _ctrlLimitedSel;
    private Set<BatchItem> _items;

    public BatchItemComputeDlg(Window owner, Plugable plugable, Map<Attr.Key, Set<String>> attrs) {
        super(owner, true);
        this._attributes = new HashMap<Attr.Key, Set<String>>(attrs);
        this._plugable = plugable;
        this.create();
        this.init();
    }

    public void setRenderer(ArborRenderer renderer) {
        this._renderer = renderer;
    }

    public void setEngineBDDConfig(EngineBDDConfig engineBDDConfig) {
        this._engineBDDConfig = engineBDDConfig;
    }

    private void create() {
        JPanel root = new JPanel(new GridBagLayout());
        this.createCtrlType();
        JPanel panelMCS = this.createCtrlParametersMCS();
        JPanel panelMEL = this.createCtrlParametersMEL();
        root.add((Component)new JLabel(ResMsgVoc.getString((String)"VOC_TYPE")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 10), 0, 0));
        root.add((Component)this._ctrlType, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._ctrlParamsLayout = new CardLayout();
        this._ctrlParamsPanel = new JPanel(this._ctrlParamsLayout);
        this._ctrlParamsPanel.add((Component)panelMCS, ComputeType.MCS.toString());
        this._ctrlParamsPanel.add((Component)panelMEL, ComputeType.MEL.toString());
        this._ctrlParamsPanel.add((Component)new JPanel(), "");
        this._ctrlParamsPanel.setBorder(BorderFactory.createTitledBorder(ResMsgVoc.getString((String)"VOC_PARAMETERS")));
        this._ctrlType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BatchItemComputeDlg.this._ctrlType.getSelectedItem() == null) {
                    BatchItemComputeDlg.this._ctrlParamsLayout.show(BatchItemComputeDlg.this._ctrlParamsPanel, "");
                    return;
                }
                String computeTypeKey = BatchItemComputeDlg.this._ctrlType.getSelectedItem().toString();
                BatchItemComputeDlg.this._ctrlParamsLayout.show(BatchItemComputeDlg.this._ctrlParamsPanel, computeTypeKey);
                BatchItemComputeDlg.this._ctrlExport.configureComputeKey(computeTypeKey, true);
            }
        });
        root.add((Component)this._ctrlParamsPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._ctrlExport = new ExportPanel(this._plugable){

            @Override
            protected Map<Attr.Key, Set<String>> getAttributes() {
                return BatchItemComputeDlg.this._attributes;
            }
        };
        String defaultPath = System.getProperty("cecilia.export.path");
        if (defaultPath == null) {
            defaultPath = PlugableUtility.getStrOpt((Plugable)this._plugable, (String)"plugable.option.path", (String)".");
        }
        if (defaultPath != null) {
            defaultPath = FileUtility.getDiffPath((String)".", (String)defaultPath);
        }
        this._ctrlExport.configureDefaultPath(defaultPath);
        this._ctrlExport.setBorder(BorderFactory.createTitledBorder(ResCompute.getString("BATCH_DLG_EXPORT_TITLE")));
        root.add((Component)this._ctrlExport, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)root, "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
    }

    private void createCtrlType() {
        this._ctrlType = new JComboBox();
        this._ctrlType.addItem(ComputeType.MCS);
        this._ctrlType.addItem(ComputeType.MEL);
        this._ctrlType.setEditable(false);
        this._ctrlType.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                ComputeType type = (ComputeType)((Object)value);
                if (type == null) {
                    return this;
                }
                this.setText(type.toString() + " - " + type.getLabel());
                return this;
            }
        });
    }

    private JPanel createCtrlParametersMEL() {
        this._ctrlParamsMEL = new DlgPanelComputeMEL(this._plugable);
        this._ctrlParamsMEL.setVisibleRefCompute(false);
        this._ctrlParamsMEL.create();
        return this._ctrlParamsMEL;
    }

    private JPanel createCtrlParametersMCS() {
        JPanel panelMCS = new JPanel(new GridBagLayout());
        this._ctrlParamsMCS = new DlgPanelComputeMCS(this._plugable.getAppl().isReader()){

            @Override
            protected boolean displayPostTreatment() {
                return true;
            }
        };
        this._ctrlParamsMCS.setVisibleRefCompute(false);
        this._ctrlParamsMCS.create();
        this._ctrlParamsMCS.configureAttrs(this._attributes);
        panelMCS.add((Component)this._ctrlParamsMCS, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        boolean bSmallScreen = false;
        GraphicsConfiguration gc = JOptionCecilia.getGraphicConfiguration((Point)this.getParent().getLocation());
        if (gc.getBounds().height <= 720) {
            bSmallScreen = true;
        }
        JPanel panelFilter = this.createFilterSorterLimiter();
        panelMCS.add((Component)panelFilter, new GridBagConstraints(bSmallScreen ? 1 : 0, bSmallScreen ? 0 : 1, 1, 1, 1.0, 0.0, 15, 2, new Insets(0, 10, 10, 10), 0, 0));
        return panelMCS;
    }

    @Deprecated
    private JPanel createFilterSorterLimiter() {
        this.createCtrlFilter();
        this.createCtrlSorter();
        this.createCtrlLimitedAt();
        JPanel panelList = new JPanel(new GridBagLayout());
        panelList.setBorder(BorderFactory.createTitledBorder(ResCompute.getString("BATCH_DLG_RESULT_FORMAT")));
        panelList.add((Component)new JLabel(ResMsgVoc.getString((String)"VOC_FILTER")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 10, 5, 5), 0, 0));
        panelList.add((Component)this._ctrlFilterSel, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(2, 5, 5, 5), 0, 0));
        panelList.add((Component)this._ctrlFilterBut, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 5, 10), 0, 0));
        panelList.add((Component)new JLabel(ResCompute.getString("DLG_RESULT_SORTER")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 10, 5, 5), 0, 0));
        panelList.add((Component)this._ctrlSorterSel, new GridBagConstraints(1, 1, 2, 1, 0.1, 0.0, 17, 2, new Insets(2, 5, 5, 10), 0, 0));
        panelList.add((Component)new JLabel(ResCompute.getString("DLG_RESULT_SORTER_LIMIT")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 10, 5, 5), 0, 0));
        panelList.add((Component)this._ctrlLimitedSel, new GridBagConstraints(1, 2, 2, 1, 0.1, 0.0, 17, 2, new Insets(2, 5, 5, 10), 0, 0));
        return panelList;
    }

    private void createCtrlFilter() {
        this._ctrlFilters = new HashMap();
        this._ctrlFilterSel = new JComboBox();
        MCSFilter filter = new MCSFilterNone();
        this._ctrlFilterSel.addItem(filter.getClass());
        this._ctrlFilters.put(filter.getClass(), filter);
        this._ctrlFilterCurrent = filter;
        filter = new MCSFilterStandard(null, this._renderer, true, this._attributes);
        this._ctrlFilterSel.addItem(filter.getClass());
        this._ctrlFilters.put(filter.getClass(), filter);
        filter = new MCSFilterWeight(0.0);
        this._ctrlFilterSel.addItem(filter.getClass());
        this._ctrlFilters.put(filter.getClass(), filter);
        if (this._attributes.size() > 0) {
            filter = new MCSFilterLatent(this._attributes);
            this._ctrlFilterSel.addItem(filter.getClass());
            this._ctrlFilters.put(filter.getClass(), filter);
        }
        this._ctrlFilterSel.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Class cl;
                MCSFilter filter;
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText("");
                if (BatchItemComputeDlg.this._ctrlFilterSel.isEnabled() && (filter = BatchItemComputeDlg.this._ctrlFilters.get(cl = (Class)value)) != null) {
                    this.setText(filter.getTitle());
                }
                return this;
            }
        });
        this._ctrlFilterSel.addActionListener(this._actionListenerFilter);
        this._ctrlFilterBut = new JButton("...");
        this._ctrlFilterBut.setMargin(new Insets(0, 0, 0, 0));
        this._ctrlFilterBut.setEnabled(false);
        this._ctrlFilterBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MCSFilter filter = BatchItemComputeDlg.this.getMCSFilter();
                if (filter == null) {
                    return;
                }
                if (!filter.withDialog()) {
                    return;
                }
                if (filter instanceof MCSFilterStandard ? !((MCSFilterStandard)filter).displayDialog(BatchItemComputeDlg.this._ctrlFilterSel, BatchItemComputeDlg.this._isInMultiEditionMode) : (filter instanceof MCSFilterLatent ? !((MCSFilterLatent)filter).displayDialog(BatchItemComputeDlg.this._ctrlFilterSel, BatchItemComputeDlg.this._isInMultiEditionMode) : !filter.displayDialog(BatchItemComputeDlg.this._ctrlFilterSel))) {
                    return;
                }
                String filterAbstract = filter.getAbstract();
                if (filterAbstract.length() > 0) {
                    BatchItemComputeDlg.this._ctrlFilterBut.setToolTipText(new StringBuffer().append("<html>").append(filterAbstract.replaceAll("\\n", "<br/>")).append("</html>").toString());
                } else {
                    BatchItemComputeDlg.this._ctrlFilterBut.setToolTipText(null);
                }
            }
        });
    }

    private void refreshFilter() {
        this._ctrlFilterBut.setEnabled(this._ctrlFilterCurrent.withDialog());
        String filterAbstract = this._ctrlFilterCurrent.getAbstract();
        if (filterAbstract.length() > 0) {
            this._ctrlFilterBut.setToolTipText(new StringBuffer().append("<html>").append(filterAbstract.replaceAll("\\n", "<br/>")).append("</html>").toString());
        } else {
            this._ctrlFilterBut.setToolTipText(null);
        }
        if (this._ctrlFilterCurrent instanceof MCSFilterWeight) {
            this._ctrlSorterSel.setEnabled(false);
            this._ctrlLimitedSel.setEnabled(false);
        } else {
            this._ctrlSorterSel.setEnabled(true);
            this._ctrlLimitedSel.setEnabled(true);
        }
    }

    private MCSFilter getMCSFilter() {
        Object selectedItem = this._ctrlFilterSel.getSelectedItem();
        if (selectedItem == null) {
            return null;
        }
        if (!(selectedItem instanceof Class)) {
            return null;
        }
        return this._ctrlFilters.get(selectedItem);
    }

    private void createCtrlSorter() {
        this._ctrlSorterSel = new JComboBox();
        this._ctrlSorterSel.addItem(MCSSorter.Type.ORDER_LEXIC);
        this._ctrlSorterSel.addItem(MCSSorter.Type.ORDER_PROBA_LEXIC);
        this._ctrlSorterSel.addItem(MCSSorter.Type.PROBA_ORDER_LEXIC);
        this._ctrlSorterSel.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    label.setText("");
                } else {
                    label.setText(((MCSSorter.Type)((Object)value)).getLabel());
                }
                if (BatchItemComputeDlg.this._ctrlSorterSel.isEnabled()) {
                    label.setEnabled(true);
                } else {
                    label.setText("");
                    label.setEnabled(false);
                }
                return label;
            }
        });
        this._ctrlSorterSel.setEditable(false);
    }

    private void createCtrlLimitedAt() {
        this._ctrlLimitedSel = new JComboBox<Object>(new Object[]{ResCompute.getString("DLG_RESULT_SORTER_LIMIT_NONE").trim(), 50, 100, 200, 500, 1000});
        this._ctrlLimitedSel.setEditable(true);
        this._ctrlLimitedSel.setEditor(new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                JTextField _editor = new JTextField("", 4){

                    @Override
                    public void setText(String s) {
                        if (this.getText().equals(s)) {
                            return;
                        }
                        super.setText(s);
                    }

                    @Override
                    public void setBorder(Border b) {
                        if (!(b instanceof BasicComboBoxEditor.UIResource)) {
                            super.setBorder(b);
                        }
                    }
                };
                _editor.setBorder(null);
                return _editor;
            }
        });
    }

    private Integer getRankLimit() {
        Integer rankLimit = -1;
        Object selection = this._ctrlLimitedSel.getSelectedItem();
        if (selection != null) {
            if (selection instanceof Integer) {
                rankLimit = (Integer)selection;
            } else if (selection instanceof String) {
                try {
                    rankLimit = Integer.parseInt((String)selection);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (rankLimit <= 0) {
                rankLimit = -1;
            }
        } else {
            rankLimit = null;
        }
        return rankLimit;
    }

    public void setMultiEditionMode(boolean multiEdition) {
        this._isInMultiEditionMode = multiEdition;
    }

    public boolean getMultiEditionMode() {
        return this._isInMultiEditionMode;
    }

    protected boolean verifyParameters() {
        if ((ComputeType)((Object)this._ctrlType.getSelectedItem()) == ComputeType.MCS) {
            String attrName;
            this._ctrlParamsMCS.setMultiMode(this._isInMultiEditionMode);
            if (!this._ctrlParamsMCS.verifyParameters()) {
                return false;
            }
            MCSFilter filter = this.getMCSFilter();
            TypeProbability type = this._ctrlParamsMCS.getTypeProbability();
            if (type == TypeProbability.NONE) {
                if (filter != null && filter.withProbability()) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this._ctrlFilterSel), ResCompute.getString("BATCH_DLG_ERR_FILTER"), this.getTitle(), 0);
                    this._ctrlFilterSel.requestFocus();
                    return false;
                }
                MCSSorter.Type sorter = (MCSSorter.Type)((Object)this._ctrlSorterSel.getSelectedItem());
                if (sorter != null && sorter != MCSSorter.Type.ORDER_LEXIC) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this._ctrlSorterSel), ResCompute.getString("BATCH_DLG_ERR_SORTER"), this.getTitle(), 0);
                    this._ctrlSorterSel.requestFocus();
                    return false;
                }
            }
            Double missionTimeMCS = this._ctrlParamsMCS.getMissionTime();
            if (type != TypeProbability.NONE && missionTimeMCS != null && missionTimeMCS == -1.0) {
                JOptionPane.showMessageDialog((Component)((Object)this), ResCompute.getString("BATCH_ITEM_MSG_ERR_INCOMPLETE_TIME"), this.getTitle(), 0);
                return false;
            }
            if (filter != null && !this._isInMultiEditionMode && (attrName = filter.checkAttributes(this._attributes)) != null) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this._ctrlFilterSel), ResCompute.msgFormat("BATCH_ERROR_ATTRIBUTE", attrName), this.getTitle(), 0);
                this._ctrlFilterSel.requestFocus();
                return false;
            }
        } else {
            Double missionTimeMEL = this._ctrlParamsMEL.getMissionTime();
            if (missionTimeMEL != null && missionTimeMEL == -1.0) {
                JOptionPane.showMessageDialog((Component)((Object)this), ResCompute.getString("BATCH_ITEM_MSG_ERR_INCOMPLETE_TIME"), this.getTitle(), 0);
                return false;
            }
        }
        for (BatchItem item : this._items) {
            item.setError(2, null);
            item.setExports(this._ctrlExport.getTableModel().getExportList());
            HashMap<String, BatchItem> exportsFileMap = new HashMap<String, BatchItem>();
            item.checkExportPaths(exportsFileMap, this._attributes);
            if (!item.withError(2)) continue;
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this._ctrlExport), item.getError(2), this.getTitle(), 0);
            this._ctrlExport.requestFocus();
            return false;
        }
        return true;
    }

    public boolean getResult() {
        boolean result = super.getResult();
        if (result) {
            ComputeType type = (ComputeType)((Object)this._ctrlType.getSelectedItem());
            for (BatchItem item : this._items) {
                if (type == null) continue;
                switch (type) {
                    case MCS: {
                        BatchItem.CmdParamsMCS paramMCS = new BatchItem.CmdParamsMCS();
                        ParamComputeMCS params = null;
                        params = item.getComputeType() != ComputeType.MCS ? new ParamComputeMCS() : item.getParametersMCSCompute();
                        paramMCS._paramCompute = params;
                        if (this.getMCSFilter() != null && !this.getMCSFilter().equals(item.getParametersMCSFilter())) {
                            MCSFilter filter = this.getMCSFilter();
                            if (filter instanceof MCSFilterStandard) {
                                MCSFilterStandard filterStd = (MCSFilterStandard)filter;
                                if (item.getParametersMCSFilter() == null || !(item.getParametersMCSFilter() instanceof MCSFilterStandard)) {
                                    paramMCS._filter = filter;
                                } else {
                                    if (filterStd.withFilterName() != null) {
                                        ((MCSFilterStandard)item.getParametersMCSFilter()).setWithFilterName(filterStd.withFilterName());
                                    }
                                    if (filterStd.getFilterName() != null) {
                                        ((MCSFilterStandard)item.getParametersMCSFilter()).setFilterName(filterStd.getFilterName());
                                    }
                                    if (filterStd.withFilterRemark() != null) {
                                        ((MCSFilterStandard)item.getParametersMCSFilter()).setWithFilterRemark(filterStd.withFilterRemark());
                                    }
                                    if (filterStd.getFilterRemark() != null) {
                                        ((MCSFilterStandard)item.getParametersMCSFilter()).setFilterRemark(filterStd.getFilterRemark());
                                    }
                                    if (filterStd.withFilterProbability() != null) {
                                        ((MCSFilterStandard)item.getParametersMCSFilter()).setWithFilterProbability(filterStd.withFilterProbability());
                                    }
                                    if (filterStd.withFilterProbability() != null && filterStd.getProbabilityFilter() != null) {
                                        ((MCSFilterStandard)item.getParametersMCSFilter()).setProbabilityFilter(filterStd.getProbabilityFilter());
                                    }
                                    if (filterStd.withFilterAttr() != null) {
                                        ((MCSFilterStandard)item.getParametersMCSFilter()).setWithFilterAttr(filterStd.withFilterAttr());
                                    }
                                    if (filterStd.getAttrCriterion() != null) {
                                        ((MCSFilterStandard)item.getParametersMCSFilter()).setAttrCriterion(filterStd.getAttrCriterion());
                                    }
                                    paramMCS._filter = item.getParametersMCSFilter();
                                }
                            } else if (filter instanceof MCSFilterWeight) {
                                if (item.getParametersMCSFilter() == null || !(item.getParametersMCSFilter() instanceof MCSFilterWeight)) {
                                    paramMCS._filter = filter;
                                } else {
                                    if (((MCSFilterWeight)filter).getWeight() != null) {
                                        ((MCSFilterWeight)item.getParametersMCSFilter()).setWeight(((MCSFilterWeight)filter).getWeight());
                                    }
                                    paramMCS._filter = item.getParametersMCSFilter();
                                }
                            } else if (filter instanceof MCSFilterLatent) {
                                if (item.getParametersMCSFilter() == null || !(item.getParametersMCSFilter() instanceof MCSFilterLatent)) {
                                    paramMCS._filter = filter;
                                } else {
                                    if (((MCSFilterLatent)filter).getAttrCriterion() != null) {
                                        ((MCSFilterLatent)item.getParametersMCSFilter()).setAttrCriterion(((MCSFilterLatent)filter).getAttrCriterion());
                                    }
                                    paramMCS._filter = item.getParametersMCSFilter();
                                }
                            } else {
                                paramMCS._filter = filter;
                            }
                        } else {
                            paramMCS._filter = item.getParametersMCSFilter();
                        }
                        paramMCS._sorter = this._ctrlSorterSel.getSelectedItem() != null ? (MCSSorter.Type)((Object)this._ctrlSorterSel.getSelectedItem()) : item.getParametersMCSSorter();
                        paramMCS._rankLimit = this.getRankLimit() != null ? this.getRankLimit() : Integer.valueOf(item.getParametersMCSLimit());
                        params.copyFromCtrl(this._ctrlParamsMCS);
                        paramMCS._paramCompute = params;
                        item.configCompute(paramMCS);
                        break;
                    }
                    case MEL: {
                        ParamComputeMEL params = null;
                        params = item.getComputeType() != ComputeType.MEL ? new ParamComputeMEL() : item.getParametersMELCompute();
                        params.copyFromCtrl(this._ctrlParamsMEL);
                        item.configCompute(params);
                    }
                }
                item.setCmdType(type);
            }
            for (BatchItem item : this._items) {
                item.setExports(new ArrayList<ExportItem>());
                if (this._ctrlExport.getTableModel().getExportList() == null || this._ctrlExport.getTableModel().getExportList().isEmpty()) break;
                for (ExportItem expItem : this._ctrlExport.getTableModel().getExportList()) {
                    File f = expItem.getFile();
                    ExportItem cpy = expItem.getCopy();
                    if (this.withBalise(cpy)) {
                        cpy.setFile(ExportItem.createDirectory(item, f));
                    }
                    item.getExports().add(cpy);
                }
            }
        }
        return result;
    }

    private boolean withBalise(ExportItem item) {
        String absolutePath = item.getFile().getAbsolutePath();
        for (String balise : ExportItem.BALISES) {
            if (!absolutePath.contains(balise)) continue;
            return true;
        }
        return false;
    }

    public void setBatchItems(Collection<BatchItem> items) {
        this._items = new LinkedHashSet<BatchItem>(items);
        this.refreshFilter();
        BatchItem firstItem = items.iterator().next();
        ComputeType cmptType = firstItem.getComputeType();
        Integer memoryMCS = -1;
        Integer limitOrderMCS = -1;
        TypeProbability typeProbMCS = null;
        Number[] missionTimeSecMCS = null;
        Integer memoryMEL = -1;
        Integer limitOrderMEL = -1;
        TypeProbability typeProbMEL = null;
        Number[] missionTimeSecMEL = null;
        Boolean withAttrCriterion = null;
        AttrCriterion attrCriterion = null;
        Boolean computeForGate = null;
        MCSFilter filterMCS = null;
        Class<?> filterClass = null;
        Integer limitMCS = -1;
        MCSSorter.Type typeMCS = null;
        Map<ParamCompute.TypeImportanceFactor, Boolean> map = null;
        Boolean isSimplifiedMode = null;
        Boolean isPessimisticCompute = null;
        Boolean withListEvents = null;
        File fileEvents = null;
        Boolean postTreatDormantMCS = null;
        Boolean postTreatAtRiskMCS = null;
        Number[] specificTimeSecMCS = null;
        Boolean postTreatDormantMEL = null;
        Boolean postTreatAtRiskMEL = null;
        Number[] specificTimeSecMEL = null;
        ParamComputeMCS cmptMCS = firstItem.getParametersMCSCompute();
        typeProbMCS = cmptMCS.getTypeProbability();
        missionTimeSecMCS = ParamComputeAbstract.getSeparatedTimes(cmptMCS.getMissionTime());
        memoryMCS = cmptMCS.getMemory();
        limitOrderMCS = cmptMCS.getLimitOrder();
        map = cmptMCS.getImportanceFactors();
        postTreatDormantMCS = cmptMCS.getPostTreatmentDormant();
        postTreatAtRiskMCS = cmptMCS.getPostTreatmentAtRisk();
        specificTimeSecMCS = ParamComputeAbstract.getSeparatedTimes(cmptMCS.getSpecificTime());
        withAttrCriterion = cmptMCS.getCriteriumLSR() != null;
        attrCriterion = cmptMCS.getCriteriumLSR();
        computeForGate = cmptMCS.getComputePrForGate();
        filterClass = firstItem.getParametersMCSFilter().getClass();
        filterMCS = firstItem.getParametersMCSFilter().getCopy();
        limitMCS = firstItem.getParametersMCSLimit();
        typeMCS = firstItem.getParametersMCSSorter();
        ParamComputeMEL cmptMEL = firstItem.getParametersMELCompute();
        typeProbMEL = cmptMEL.getTypeProbability();
        missionTimeSecMEL = ParamComputeAbstract.getSeparatedTimes(cmptMEL.getMissionTime());
        memoryMEL = cmptMEL.getMemory();
        limitOrderMEL = cmptMEL.getLimitOrder();
        postTreatDormantMEL = cmptMEL.getPostTreatmentDormant();
        postTreatAtRiskMEL = cmptMEL.getPostTreatmentAtRisk();
        specificTimeSecMEL = ParamComputeAbstract.getSeparatedTimes(cmptMEL.getSpecificTime());
        isSimplifiedMode = cmptMEL.isSimplifiedMode();
        isPessimisticCompute = cmptMEL.withPessimistCompute();
        withListEvents = cmptMEL.withListMEL();
        if (withListEvents != null && withListEvents.booleanValue()) {
            fileEvents = cmptMEL.getListFileMEL();
        }
        ArrayList<ExportItem> listItems = new ArrayList<ExportItem>();
        for (ExportItem exportItem : firstItem.getExports()) {
            listItems.add(exportItem.getCopy());
        }
        if (items.size() > 1) {
            for (ExportItem exportItem : listItems) {
                String acceptableTreePath;
                String absolutPath = exportItem.getFile().getAbsolutePath();
                if (absolutPath.equals(acceptableTreePath = ExportItem.getPathWithBalises(firstItem, absolutPath))) continue;
                exportItem.setFile(new File(acceptableTreePath));
            }
        }
        boolean first = true;
        for (BatchItem item : items) {
            int memoryCmpt;
            int i;
            int memoryCmpt2;
            if (first) {
                first = false;
                continue;
            }
            cmptType = cmptType.equals((Object)item.getComputeType()) ? cmptType : null;
            ParamComputeMCS cmptMCS2 = item.getParametersMCSCompute();
            typeProbMCS = cmptMCS2.getTypeProbability().equals((Object)typeProbMCS) ? typeProbMCS : null;
            Number[] dblMCS = ParamComputeAbstract.getSeparatedTimes(cmptMCS2.getMissionTime());
            for (int i2 = 0; i2 < dblMCS.length; ++i2) {
                missionTimeSecMCS[i2] = !dblMCS[i2].equals(missionTimeSecMCS[i2]) ? (Number)null : (Number)dblMCS[i2];
            }
            if (memoryMCS != null && (memoryCmpt2 = cmptMCS2.getMemory().intValue()) != memoryMCS) {
                memoryMCS = null;
            }
            if (limitOrderMCS != null) {
                int limitCmptOrder = cmptMCS2.getLimitOrder();
                if (limitOrderMCS > 0 && limitCmptOrder > 0 && limitOrderMCS != limitCmptOrder) {
                    limitOrderMCS = 0;
                } else if (limitOrderMCS >= 0 ^ limitCmptOrder >= 0) {
                    limitOrderMCS = null;
                }
            }
            Map<ParamCompute.TypeImportanceFactor, Boolean> map2 = map = cmptMCS2.getImportanceFactors().equals(map) ? map : null;
            if (postTreatDormantMCS != null && postTreatDormantMCS != cmptMCS2.getPostTreatmentDormant()) {
                postTreatDormantMCS = null;
            }
            if (postTreatAtRiskMCS != null && postTreatAtRiskMCS != cmptMCS2.getPostTreatmentAtRisk()) {
                postTreatAtRiskMCS = null;
            }
            dblMCS = ParamComputeAbstract.getSeparatedTimes(cmptMCS2.getSpecificTime());
            for (int i2 = 0; i2 < dblMCS.length; ++i2) {
                specificTimeSecMCS[i2] = !dblMCS[i2].equals(specificTimeSecMCS[i2]) ? (Number)null : (Number)dblMCS[i2];
            }
            computeForGate = cmptMCS2.getComputePrForGate() == computeForGate ? computeForGate : null;
            Class<Object> clazz = filterClass = item.getParametersMCSFilter().getClass().equals(filterClass) ? filterClass : null;
            if (withAttrCriterion != null) {
                boolean withCriterion;
                boolean bl = withCriterion = cmptMCS2.getCriteriumLSR() != null;
                if (withCriterion != withAttrCriterion) {
                    withAttrCriterion = null;
                }
            }
            if (attrCriterion != null && (attrCriterion == null ^ cmptMCS2.getCriteriumLSR() == null || !attrCriterion.equals((Object)cmptMCS2.getCriteriumLSR()))) {
                attrCriterion = null;
            }
            if (filterClass != null) {
                MCSFilter filter = item.getParametersMCSFilter();
                if (filterMCS instanceof MCSFilterStandard) {
                    MCSFilterStandard standardFilterItem = (MCSFilterStandard)filter;
                    MCSFilterStandard currentFilter = (MCSFilterStandard)filterMCS;
                    if (!standardFilterItem.withFilterName().equals(currentFilter.withFilterName())) {
                        currentFilter.setWithFilterName(null);
                    }
                    if (!standardFilterItem.getFilterName().equals(currentFilter.getFilterName())) {
                        currentFilter.setFilterName(null);
                    }
                    if (!standardFilterItem.withFilterRemark().equals(currentFilter.withFilterRemark())) {
                        currentFilter.setWithFilterRemark(null);
                    }
                    if (!standardFilterItem.getFilterRemark().equals(currentFilter.getFilterRemark())) {
                        currentFilter.setFilterRemark(null);
                    }
                    if (!standardFilterItem.withFilterProbability().equals(currentFilter.withFilterProbability())) {
                        currentFilter.setWithFilterProbability(null);
                    }
                    if (!standardFilterItem.getProbabilityFilter().equals(currentFilter.getProbabilityFilter())) {
                        currentFilter.setProbabilityFilter(null);
                    }
                    if (!standardFilterItem.withFilterAttr().equals(currentFilter.withFilterAttr())) {
                        currentFilter.setWithFilterAttr(null);
                    }
                    if (standardFilterItem.getAttrCriterion() == null || !standardFilterItem.getAttrCriterion().equals((Object)currentFilter.getAttrCriterion())) {
                        currentFilter.setAttrCriterion(null);
                    }
                } else if (filterMCS instanceof MCSFilterWeight) {
                    if (!((MCSFilterWeight)filter).getWeight().equals(((MCSFilterWeight)filterMCS).getWeight())) {
                        ((MCSFilterWeight)filterMCS).setWeight(null);
                    }
                } else if (filterMCS instanceof MCSFilterLatent && !((MCSFilterLatent)filter).getAttrCriterion().equals((Object)((MCSFilterLatent)filterMCS).getAttrCriterion())) {
                    ((MCSFilterLatent)filterMCS).setAttrCriterion(null);
                }
            } else {
                filterMCS = null;
            }
            limitMCS = limitMCS.intValue() == item.getParametersMCSLimit() ? limitMCS : null;
            typeMCS = item.getParametersMCSSorter().equals((Object)typeMCS) ? typeMCS : null;
            ParamComputeMEL cmptMEL2 = item.getParametersMELCompute();
            typeProbMEL = cmptMEL2.getTypeProbability().equals((Object)typeProbMEL) ? typeProbMEL : null;
            Number[] dblMEL = ParamComputeAbstract.getSeparatedTimes(cmptMEL2.getMissionTime());
            for (i = 0; i < dblMEL.length; ++i) {
                missionTimeSecMEL[i] = !dblMEL[i].equals(missionTimeSecMEL[i]) ? (Number)null : (Number)dblMEL[i];
            }
            if (memoryMEL != null && (memoryCmpt = cmptMEL2.getMemory().intValue()) != memoryMEL) {
                memoryMEL = null;
            }
            if (limitOrderMEL != null) {
                int limitCmptOrder = cmptMEL2.getLimitOrder();
                if (limitOrderMEL > 0 && limitCmptOrder > 0 && limitOrderMEL != limitCmptOrder) {
                    limitOrderMEL = 0;
                } else if (limitOrderMEL >= 0 ^ limitCmptOrder >= 0) {
                    limitOrderMEL = null;
                }
            }
            isSimplifiedMode = isSimplifiedMode != null && cmptMEL2.isSimplifiedMode() == isSimplifiedMode.booleanValue() ? isSimplifiedMode : null;
            isPessimisticCompute = isPessimisticCompute != null && cmptMEL2.withPessimistCompute() == isPessimisticCompute.booleanValue() ? isPessimisticCompute : null;
            Boolean bl = withListEvents = cmptMEL2.withListMEL() == withListEvents.booleanValue() ? withListEvents : null;
            if (withListEvents == null) {
                fileEvents = null;
            }
            if (postTreatDormantMEL != null && postTreatDormantMEL != cmptMEL2.getPostTreatmentDormant()) {
                postTreatDormantMEL = null;
            }
            if (postTreatAtRiskMEL != null && postTreatAtRiskMEL != cmptMEL2.getPostTreatmentAtRisk()) {
                postTreatAtRiskMEL = null;
            }
            dblMEL = ParamComputeAbstract.getSeparatedTimes(cmptMEL2.getSpecificTime());
            for (i = 0; i < dblMEL.length; ++i) {
                specificTimeSecMEL[i] = !dblMEL[i].equals(specificTimeSecMEL[i]) ? (Number)null : (Number)dblMEL[i];
            }
            ArrayList<ExportItem> copyExpItem = new ArrayList<ExportItem>();
            if (items.size() > 1) {
                for (ExportItem expItem : item.getExports()) {
                    String acceptableTreePath;
                    ExportItem expItemCpy = expItem.getCopy();
                    String absolutPath = expItem.getFile().getAbsolutePath();
                    if (!absolutPath.equals(acceptableTreePath = ExportItem.getPathWithBalises(item, absolutPath))) {
                        expItemCpy.setFile(new File(acceptableTreePath));
                    }
                    copyExpItem.add(expItemCpy);
                }
            }
            listItems.retainAll(copyExpItem);
        }
        if (cmptType == null) {
            this._ctrlType.setSelectedItem(null);
            this._ctrlParamsMEL.defaultValues();
            this._ctrlParamsMCS.defaultValues();
        } else {
            this._ctrlType.setSelectedItem((Object)cmptType);
            this._ctrlParamsMCS.configureAttrs(this._attributes);
            this._ctrlParamsMEL.configureAttrs(this._attributes);
            ParamComputeMCS paramComputeMCS = new ParamComputeMCS();
            paramComputeMCS.setMemory(memoryMCS);
            paramComputeMCS.setLimitOrder(limitOrderMCS);
            paramComputeMCS.setTypeProbability(typeProbMCS);
            paramComputeMCS.setMissionTimeSeparated(missionTimeSecMCS);
            paramComputeMCS.setComputePrForGate(typeProbMCS == TypeProbability.BDD && computeForGate == null ? null : Boolean.valueOf(typeProbMCS == TypeProbability.BDD && computeForGate != null ? computeForGate : false));
            paramComputeMCS.setImportanceFactors(map);
            paramComputeMCS.setLSR(withAttrCriterion);
            paramComputeMCS.setCriteriumLSR(attrCriterion);
            paramComputeMCS.setPostTreatmentDormant(postTreatDormantMCS);
            paramComputeMCS.setPostTreatmentAtRisk(postTreatAtRiskMCS);
            paramComputeMCS.setSpecificTimeSeparated(specificTimeSecMCS);
            paramComputeMCS.setEngineBDDConfig(this._engineBDDConfig);
            paramComputeMCS.copyToCtrl(this._ctrlParamsMCS);
            this.updateFilters();
            if (filterClass != null) {
                this._ctrlFilterSel.removeActionListener(this._actionListenerFilter);
                this._ctrlFilterSel.setSelectedItem(filterClass);
                this._ctrlFilterSel.addActionListener(this._actionListenerFilter);
                this._ctrlFilterCurrent = filterMCS;
                this.setMultiEditionMode(items.size() > 1);
                if (this._ctrlFilterCurrent != null) {
                    if (this._ctrlFilters.containsKey(this._ctrlFilterCurrent.getClass())) {
                        this._ctrlFilters.remove(this._ctrlFilterCurrent.getClass());
                    }
                    this._ctrlFilters.put(this._ctrlFilterCurrent.getClass(), this._ctrlFilterCurrent);
                    this._ctrlFilterCurrent.configure(this._attributes);
                    this.refreshFilter();
                }
            } else {
                this._ctrlFilterSel.setSelectedItem(null);
            }
            this._ctrlSorterSel.setSelectedItem((Object)typeMCS);
            if (limitMCS == null) {
                this._ctrlLimitedSel.setSelectedItem(null);
            } else if (limitMCS >= 0) {
                this._ctrlLimitedSel.setSelectedItem(limitMCS);
            } else {
                this._ctrlLimitedSel.setSelectedItem(this._ctrlLimitedSel.getItemAt(0));
            }
            ParamComputeMEL paramComputeMEL = new ParamComputeMEL();
            paramComputeMEL.setMissionTimeSeparated(missionTimeSecMEL);
            paramComputeMEL.setTypeProbability(typeProbMEL);
            paramComputeMEL.setSimplifiedMode(isSimplifiedMode);
            paramComputeMEL.setMemory(memoryMEL);
            paramComputeMEL.setLimitOrder(limitOrderMEL);
            paramComputeMEL.setPessimistCompute(isPessimisticCompute);
            paramComputeMEL.setWithListMEL(withListEvents);
            paramComputeMEL.setListFileMEL(fileEvents);
            paramComputeMEL.setPostTreatmentDormant(postTreatDormantMEL);
            paramComputeMEL.setPostTreatmentAtRisk(postTreatAtRiskMEL);
            paramComputeMEL.setSpecificTimeSeparated(specificTimeSecMEL);
            paramComputeMEL.setEngineBDDConfig(this._engineBDDConfig);
            paramComputeMEL.copyToCtrl(this._ctrlParamsMEL);
        }
        this._ctrlExport.configureComputeKey(cmptType != null ? cmptType.toString() : "", false);
        this._ctrlExport.getTableModel().setExportList(listItems);
        this._ctrlExport.configureTreePath(items.size() == 1 ? firstItem.getTreePathForFiles() : "");
    }

    private void updateFilters() {
        this._ctrlFilters.clear();
        this._ctrlFilterSel.removeAllItems();
        MCSFilter filter = new MCSFilterNone();
        this._ctrlFilterSel.addItem(filter.getClass());
        this._ctrlFilters.put(filter.getClass(), filter);
        this._ctrlFilterCurrent = filter;
        filter = new MCSFilterStandard(null, this._renderer, true, this._attributes);
        this._ctrlFilterSel.addItem(filter.getClass());
        this._ctrlFilters.put(filter.getClass(), filter);
        filter = new MCSFilterWeight(0.0);
        this._ctrlFilterSel.addItem(filter.getClass());
        this._ctrlFilters.put(filter.getClass(), filter);
        if (this._attributes.size() > 0) {
            filter = new MCSFilterLatent(this._attributes);
            this._ctrlFilterSel.addItem(filter.getClass());
            this._ctrlFilters.put(filter.getClass(), filter);
        }
    }
}

