/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.batch;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.batch.BatchCompute;
import com.dassault.cecilia.plugin.faulttree.compute.batch.BatchItem;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import javax.swing.table.AbstractTableModel;

public class BatchTableModel
extends AbstractTableModel {
    public static final int IDX_PATH = 0;
    public static final int IDX_TREE = 1;
    public static final int IDX_CONFIG = 2;
    protected BatchCompute _model = null;
    ArborRenderer _renderer;

    public BatchTableModel(BatchCompute model) {
        this._model = model;
    }

    public void setRenderer(ArborRenderer renderer) {
        this._renderer = renderer;
    }

    @Override
    public int getRowCount() {
        return this._model.getNbrItem();
    }

    public BatchItem getItem(int idx) {
        return this._model.getItem(idx);
    }

    public void setItem(int idx, BatchItem item) {
        this._model.setItem(idx, item);
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int c) {
        switch (c) {
            case 0: {
                return ResCompute.getString("BATCH_DLG_TABLE_PATH");
            }
            case 1: {
                return ResCompute.getString("BATCH_DLG_TABLE_TREE");
            }
            case 2: {
                return ResCompute.getString("BATCH_DLG_TABLE_CONFIG");
            }
        }
        return ResMsgVoc.getString((String)"VOC_ERROR");
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return String.class;
    }

    @Override
    public Object getValueAt(int r, int c) {
        BatchItem item = this.getItem(r);
        switch (c) {
            case 0: {
                return item.getTreePathForFiles();
            }
            case 1: {
                return item.getTreeConfiguration();
            }
            case 2: {
                return item.getComputeConfiguration(this._renderer);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return false;
    }

    public void addData(BatchItem obj) {
        int idx = this._model.insert(obj, -1);
        this.fireTableRowsInserted(idx, idx);
    }

    public void insertData(BatchItem obj, int idx) {
        this._model.insert(obj, idx);
        this.fireTableRowsInserted(idx, idx);
    }

    public void removeData(int idx) {
        this.fireTableRowsDeleted(idx, idx);
        this._model.remove(idx);
    }

    public void down(int idxMin, int idxMax) {
        this._model.down(idxMin, idxMax);
        this.fireTableRowsUpdated(idxMin, idxMax + 1);
    }

    public void up(int idxMin, int idxMax) {
        this._model.up(idxMin, idxMax);
        this.fireTableRowsUpdated(idxMin - 1, idxMax);
    }
}

