/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.batch;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.other.ToggleBorderLayout;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.batch.ExportItemWordPanel;
import com.dassault.cecilia.plugin.faulttree.compute.batch.OptionsWordView;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ExportItemWordTreePanel
extends ExportItemWordPanel {
    private JCheckBox _ctrlGSRAuto;
    private JComboBox _ctrlGSRLevel;
    private JLabel _ctrlGSRLevelLbl;

    public ExportItemWordTreePanel(Window owner) {
        super(owner, true);
    }

    @Override
    protected void create() {
        int y = 0;
        this.createCtrlPageSetup(y++);
        this.createCtrlGSR(y++);
        this.createForOneHourCtrl(y);
    }

    private void createCtrlGSR(int y) {
        JPanel gsrPanel = new JPanel((LayoutManager)new ToggleBorderLayout());
        this._ctrlGSRAuto = new JCheckBox(ResCompute.getString("BATCH_EXPORT_TREE_GSR"));
        this._ctrlGSRLevelLbl = new JLabel(ResMsgVoc.getString((String)"VOC_LEVEL"));
        this._ctrlGSRLevel = new JComboBox();
        for (int level = 2; level <= 9; ++level) {
            this._ctrlGSRLevel.addItem(level);
        }
        this._ctrlGSRLevel.setEditable(false);
        this._ctrlGSRAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportItemWordTreePanel.this.refreshCtrlGSR();
            }
        });
        JPanel selectGSRPanel = new JPanel(new GridBagLayout());
        selectGSRPanel.add((Component)this._ctrlGSRLevelLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        selectGSRPanel.add((Component)this._ctrlGSRLevel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        ToggleBorderLayout.configure((Container)gsrPanel, (JToggleButton)this._ctrlGSRAuto, (JComponent)selectGSRPanel);
        this.add((Component)gsrPanel, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
    }

    protected void refreshCtrlGSR() {
        boolean rootSelect = this._ctrlGSRAuto.isSelected();
        this._ctrlGSRLevel.setEnabled(rootSelect);
        this._ctrlGSRLevelLbl.setEnabled(rootSelect);
    }

    @Override
    public void configureOptions(OptionsWordView options) {
        super.configureOptions(options);
        OptionsWordView.OptionsTreeView treeView = (OptionsWordView.OptionsTreeView)options;
        treeView._gsrAuto = this._ctrlGSRAuto.isSelected();
        treeView._gsrLevel = (Integer)this._ctrlGSRLevel.getSelectedItem();
    }

    @Override
    public void configureDlg(OptionsWordView options) {
        super.configureDlg(options);
        OptionsWordView.OptionsTreeView treeView = (OptionsWordView.OptionsTreeView)options;
        this._ctrlGSRAuto.setSelected(treeView._gsrAuto);
        this._ctrlGSRLevel.setSelectedItem(treeView._gsrLevel);
        this.refreshCtrlGSR();
    }

    public static class ExportItemWordTreeDlg
    extends ExportItemWordPanel.ExportItemWordDlg {
        private ExportItemWordTreePanel _panel;

        public ExportItemWordTreeDlg(Window owner) {
            super(owner, ResCompute.getString("BATCH_EXPORT_TREE_OPTS_TITLE"));
        }

        @Override
        protected JPanel createPanel() {
            this._panel = new ExportItemWordTreePanel(this.getOwner());
            return this._panel;
        }

        @Override
        public ExportItemWordTreePanel getPanel() {
            return this._panel;
        }
    }
}

