/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.batch;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.LeftDotTableCellRenderer;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.batch.ExportEditorFilePath;
import com.dassault.cecilia.plugin.faulttree.compute.batch.ExportItem;
import com.dassault.cecilia.plugin.faulttree.compute.batch.ExportItemCAAPanel;
import com.dassault.cecilia.plugin.faulttree.compute.batch.ExportItemWordPanel;
import com.dassault.cecilia.plugin.faulttree.compute.batch.ExportItemWordTreePanel;
import com.dassault.cecilia.plugin.faulttree.compute.batch.ExportItemWordWithCAAPanel;
import com.dassault.cecilia.plugin.faulttree.compute.batch.ExportTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ExportPanel
extends JPanel {
    private static Logger _LOG = Logger.getLogger(ExportPanel.class.getPackage().getName());
    Plugable _plugable;
    ExportTableModel _modelTable;
    JTable _ctrlTable;
    CeciliaAction _ctrlAdd;
    CeciliaAction _ctrlDel;
    CeciliaAction _ctrlUp;
    CeciliaAction _ctrlDown;
    JPopupMenu _popupList;
    JComboBox _editorFormat;
    ExportEditorFilePath _editorFile;
    String _defaultPath;
    String _treePath;
    String _computeKey;
    JCheckBox _ctrlForOneHour = new JCheckBox(ResCompute.getString("KEY_0050"));
    ExportItemWordPanel.ExportItemWordDlg _wordOptionsDlg = null;
    ExportItemWordTreePanel.ExportItemWordTreeDlg _treeOptionsDlg = null;
    ExportItemCAAPanel.ExportItemCAADlg _caaOptionsDlg = null;
    ExportItemWordWithCAAPanel.ExportItemWordWithCAADlg _caaWithWordOptionsDlg = null;

    public ExportPanel(Plugable plugable) {
        super(new BorderLayout());
        this._plugable = plugable;
        this._modelTable = new ExportTableModel();
        this._computeKey = "MCS";
        this._modelTable.configureComputeKey(this._computeKey);
        this.initialise();
    }

    public ExportTableModel getTableModel() {
        return this._modelTable;
    }

    public void configureDefaultPath(String value) {
        this._defaultPath = value;
    }

    public void configureTreePath(String value) {
        this._treePath = value;
    }

    protected Map<Attr.Key, Set<String>> getAttributes() {
        return null;
    }

    public void configureComputeKey(String value, boolean reconfig) {
        ExportItem item;
        int i;
        if (this._computeKey.equals(value)) {
            return;
        }
        this._modelTable.configureComputeKey(value);
        if (value.equals("MEL")) {
            this._editorFormat.removeItem((Object)ExportItem.Format.CAA_DOCBOOK);
            this._editorFormat.removeItem((Object)ExportItem.Format.CAA_WORD);
            this._editorFormat.removeItem((Object)ExportItem.Format.TREE_WORD);
            for (i = this._modelTable.getRowCount() - 1; i >= 0; --i) {
                item = this._modelTable.getItem(i);
                switch (item.getFormat()) {
                    case TREE_WORD: 
                    case CAA_WORD: 
                    case CAA_DOCBOOK: {
                        this._modelTable.removeData(i);
                    }
                }
            }
        } else if (value.equals("MCS")) {
            this._editorFormat.addItem(ExportItem.Format.CAA_DOCBOOK);
            this._editorFormat.addItem(ExportItem.Format.CAA_WORD);
            this._editorFormat.addItem(ExportItem.Format.TREE_WORD);
        }
        if (reconfig) {
            for (i = 0; i < this._modelTable.getRowCount(); ++i) {
                String extName;
                item = this._modelTable.getItem(i);
                File file = item.getFile();
                String oldName = file.getName();
                if (!oldName.endsWith(extName = "." + this._computeKey.toLowerCase() + item.getFormat()._ext)) continue;
                String newName = oldName.substring(0, oldName.length() - extName.length()) + "." + value.toLowerCase() + item.getFormat()._ext;
                item.setFile(new File(file.getParent(), newName));
                this._modelTable.fireTableCellUpdated(i, 1);
            }
        }
        this._computeKey = value;
        this.refreshCtrl();
    }

    private void createActions() {
        this._ctrlAdd = new CeciliaAction(ResIcoCore.getImageIcon((String)"BUT_ADD"), ResCompute.getString("ACTION_ADD_MENU"), ResCompute.getString("ACTION_ADD_TTIP")){

            public void actionPerformed(ActionEvent e) {
                int idx = ExportPanel.this._ctrlTable.getSelectedRow();
                ExportItem item = new ExportItem(ExportPanel.this._defaultPath, ExportPanel.this._treePath, ExportPanel.this._computeKey);
                ExportPanel.this._ctrlTable.clearSelection();
                List<ExportItem.Format> listFormatAvailable = ExportPanel.this.getListFormatAvailable();
                if (listFormatAvailable.isEmpty()) {
                    return;
                }
                Enum newFormat = null;
                for (ExportItem.Format format : listFormatAvailable) {
                    boolean isPresent = false;
                    for (int i = 0; i < ExportPanel.this._modelTable.getRowCount(); ++i) {
                        ExportItem existingItem = ExportPanel.this._modelTable.getItem(i);
                        if (existingItem.getFormat() != format) continue;
                        isPresent = true;
                        break;
                    }
                    if (isPresent) continue;
                    newFormat = format;
                    break;
                }
                if (newFormat == null) {
                    newFormat = listFormatAvailable.get(0);
                }
                if (!newFormat.equals((Object)ExportItem.Format.RESULT_WORD)) {
                    item.setFormat((ExportItem.Format)newFormat);
                    File file = item.getFile();
                    String oldName = file.getName();
                    String extName = ExportPanel.this._modelTable._computeKey + ExportItem.Format.RESULT_WORD._ext;
                    if (oldName.endsWith(extName)) {
                        String newName = oldName.substring(0, oldName.length() - extName.length()) + (((ExportItem.Format)newFormat).withComputeExt() ? ExportPanel.this._modelTable._computeKey : "") + ((ExportItem.Format)newFormat)._ext;
                        item.setFile(new File(file.getParent(), newName));
                    }
                }
                if (idx == -1) {
                    ExportPanel.this._modelTable.addData(item);
                    idx = ExportPanel.this._modelTable.getRowCount() - 1;
                } else {
                    ExportPanel.this._modelTable.insertData(item, idx);
                }
                ExportPanel.this._ctrlTable.setRowSelectionInterval(idx, idx);
                ExportPanel.this.refreshCtrl();
            }
        };
        this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon((String)"BUT_DEL"), ResCompute.getString("ACTION_DEL_MENU"), ResCompute.getString("ACTION_DEL_TTIP")){

            public void actionPerformed(ActionEvent e) {
                int[] idx = ExportPanel.this._ctrlTable.getSelectedRows();
                for (int i = idx.length - 1; i >= 0; --i) {
                    ExportPanel.this._modelTable.removeData(idx[i]);
                }
                if (idx.length > 0) {
                    ExportPanel.this.refreshCtrl();
                }
            }
        };
        this._ctrlUp = new CeciliaAction(ResIcoCore.getImageIcon((String)"BUT_UP"), ResCompute.getString("ACTION_UP_MENU"), ResCompute.getString("ACTION_UP_TTIP")){

            public void actionPerformed(ActionEvent e) {
                int idxMin = ExportPanel.this._ctrlTable.getSelectionModel().getMinSelectionIndex();
                int idxMax = ExportPanel.this._ctrlTable.getSelectionModel().getMaxSelectionIndex();
                if (idxMin != -1 && idxMin > 0) {
                    ExportPanel.this._modelTable.up(idxMin, idxMax);
                    ExportPanel.this._ctrlTable.setRowSelectionInterval(idxMin - 1, idxMax - 1);
                    ExportPanel.this.refreshCtrl();
                }
            }
        };
        this._ctrlDown = new CeciliaAction(ResIcoCore.getImageIcon((String)"BUT_DOWN"), ResCompute.getString("ACTION_DOWN_MENU"), ResCompute.getString("ACTION_DOWN_TTIP")){

            public void actionPerformed(ActionEvent e) {
                int idxMin = ExportPanel.this._ctrlTable.getSelectionModel().getMinSelectionIndex();
                int idxMax = ExportPanel.this._ctrlTable.getSelectionModel().getMaxSelectionIndex();
                if (idxMax != -1 && idxMax < ExportPanel.this._modelTable.getRowCount() - 1) {
                    ExportPanel.this._modelTable.down(idxMin, idxMax);
                    ExportPanel.this._ctrlTable.setRowSelectionInterval(idxMin + 1, idxMax + 1);
                    ExportPanel.this.refreshCtrl();
                }
            }
        };
        this._popupList = new JPopupMenu();
        this._popupList.add((Action)this._ctrlAdd);
        this._popupList.add((Action)this._ctrlDel);
        this._popupList.add((Action)this._ctrlUp);
        this._popupList.add((Action)this._ctrlDown);
    }

    private void createEditorFormat() {
        this._editorFormat = new JComboBox<ExportItem.Format>(ExportItem.Format.values());
        this._editorFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportPanel.this.refreshCtrl();
            }
        });
        this._editorFormat.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    this.setText(((ExportItem.Format)((Object)value)).getLabel());
                }
                return this;
            }
        });
    }

    private void createEditorFile() {
        ExportEditorFilePath.ExtendedFileFilter fileFilter = new ExportEditorFilePath.ExtendedFileFilter(){

            @Override
            public String getDescription() {
                return ResMsgCore.getString((String)"FILE_TYPE_XML");
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getAbsolutePath().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDefaultExtension() {
                return ".xml";
            }
        };
        this._editorFile = new ExportEditorFilePath(this._plugable, fileFilter);
    }

    private void createTable() {
        this._ctrlTable = new JTable(this._modelTable){

            @Override
            public void createDefaultColumnsFromModel() {
                super.createDefaultColumnsFromModel();
                for (int col = 0; col < this.getColumnCount(); ++col) {
                    TableColumn tcol = this.getColumnModel().getColumn(col);
                    int width = 90;
                    Serializable editor = null;
                    switch (col) {
                        case 0: {
                            width = 90;
                            editor = new DefaultCellEditor(ExportPanel.this._editorFormat);
                            tcol.setMaxWidth(width);
                            break;
                        }
                        case 1: {
                            width = 275;
                            editor = ExportPanel.this._editorFile;
                            break;
                        }
                        case 2: {
                            width = 35;
                            tcol.setMaxWidth(width);
                        }
                    }
                    if (editor != null) {
                        tcol.setCellEditor((TableCellEditor)((Object)editor));
                    }
                    tcol.setPreferredWidth(width);
                }
            }
        };
        this._ctrlTable.setRowHeight(this._ctrlTable.getRowHeight() + 10);
        this._ctrlTable.setDefaultRenderer(ExportItem.Format.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setText(((ExportItem.Format)((Object)value)).getLabel());
                return this;
            }
        });
        this._ctrlTable.setDefaultRenderer(File.class, (TableCellRenderer)new LeftDotTableCellRenderer());
        OptsCellRenderer optRenderer = new OptsCellRenderer();
        this._ctrlTable.setDefaultRenderer(Boolean.class, optRenderer);
        this._ctrlTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() != 1) {
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    Point p = e.getPoint();
                    int row = ExportPanel.this._ctrlTable.convertRowIndexToModel(ExportPanel.this._ctrlTable.rowAtPoint(p));
                    int column = ExportPanel.this._ctrlTable.convertColumnIndexToModel(ExportPanel.this._ctrlTable.columnAtPoint(p));
                    if (row >= 0 && column == 2) {
                        ExportPanel.this.editOptionsExport(row);
                    }
                }
            }
        });
        this._ctrlTable.setComponentPopupMenu(this._popupList);
        this._ctrlTable.setPreferredScrollableViewportSize(new Dimension(400, 50));
        ListSelectionModel selMod = this._ctrlTable.getSelectionModel();
        selMod.setSelectionMode(1);
        selMod.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ExportPanel.this.refreshCtrl();
            }
        });
        this._modelTable.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ExportPanel.this.refreshCtrl();
            }
        });
    }

    private JScrollPane createScrollTable() {
        JScrollPane scrollTable = new JScrollPane(this._ctrlTable);
        scrollTable.setComponentPopupMenu(this._popupList);
        return scrollTable;
    }

    protected void initialise() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.createActions();
        JToolBar toolbar = new JToolBar();
        toolbar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        toolbar.setFloatable(false);
        toolbar.add(Box.createGlue());
        toolbar.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlUp.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlDown.createButton(CeciliaAction.BorderStyle.LIGHT));
        this.add((Component)toolbar, "North");
        this.createEditorFormat();
        this.createEditorFile();
        this.createTable();
        this.add((Component)this.createScrollTable(), "Center");
        this.refreshCtrl();
    }

    protected void refreshCtrl() {
        int nbrSel = this._ctrlTable.getSelectedRowCount();
        int nbrElt = this._ctrlTable.getRowCount();
        this._ctrlDel.setEnabled(nbrSel > 0);
        this._ctrlUp.setEnabled(nbrSel > 0 && this._ctrlTable.getSelectionModel().getMinSelectionIndex() > 0);
        this._ctrlDown.setEnabled(nbrSel > 0 && this._ctrlTable.getSelectionModel().getMaxSelectionIndex() < nbrElt - 1);
        int selectedRow = this._ctrlTable.getSelectedRow();
        if (selectedRow == -1 || this._modelTable.getRowCount() <= selectedRow) {
            return;
        }
        ExportItem item = this._modelTable.getItem(selectedRow);
        ExportItem.Format currentValue = item.getFormat();
        this._editorFormat.removeAllItems();
        for (ExportItem.Format formatAvailable : this.getListFormatAvailable()) {
            this._editorFormat.addItem(formatAvailable);
        }
        if (((DefaultComboBoxModel)this._editorFormat.getModel()).getIndexOf((Object)currentValue) == -1) {
            this._editorFormat.addItem(currentValue);
        }
        this._editorFormat.updateUI();
    }

    public final List<ExportItem.Format> getListFormatAvailable() {
        ArrayList<ExportItem.Format> listFormatAvailable = new ArrayList<ExportItem.Format>();
        for (ExportItem.Format format : ExportItem.Format.getValues(this._computeKey)) {
            listFormatAvailable.add(format);
        }
        if (this.getAttributes() == null || this.getAttributes().isEmpty()) {
            listFormatAvailable.remove((Object)ExportItem.Format.CAA_DOCBOOK);
            listFormatAvailable.remove((Object)ExportItem.Format.CAA_WORD);
        }
        return listFormatAvailable;
    }

    protected void editOptionsExport(int row) {
        ExportItem item = this._modelTable.getItem(row);
        switch (item.getFormat()) {
            case EVENTS_WORD: 
            case RESULT_WORD: {
                this.editWordExport(item, row);
                break;
            }
            case CAA_DOCBOOK: {
                this.editCAAExport(item, row);
                break;
            }
            case TREE_WORD: {
                this.editTreeExport(item, row);
                break;
            }
            case CAA_WORD: {
                this.editCAAWordExport(item, row);
                break;
            }
            default: {
                this.editDefaultExport(item, row);
            }
        }
    }

    private void editDefaultExport(ExportItem item, int row) {
        boolean forOneHour = item.isForOneHour();
        Object[] params = new Object[]{this._ctrlForOneHour};
        this._ctrlForOneHour.setSelected(forOneHour);
        int result = JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf((Component)this._ctrlTable), params, ResCompute.getString("BATCH_EXPORT_OPTS_TITLE"), 2);
        if (result == 0 && forOneHour != this._ctrlForOneHour.isSelected()) {
            item.setForOneHour(this._ctrlForOneHour.isSelected());
            this._modelTable.fireTableCellUpdated(row, 2);
        }
    }

    private void editWordExport(ExportItem item, int row) {
        if (this._wordOptionsDlg == null) {
            this._wordOptionsDlg = new ExportItemWordPanel.ExportItemWordDlg(SwingUtilities.getWindowAncestor(this._ctrlTable));
            this._wordOptionsDlg.pack();
            this._wordOptionsDlg.setLocationRelativeTo(this._ctrlTable);
        }
        this._wordOptionsDlg.getPanel().setForOneHour(item.isForOneHour());
        this._wordOptionsDlg.getPanel().configureDlg(item.getWordOptions());
        this._wordOptionsDlg.setVisible(true);
        if (this._wordOptionsDlg.getResult()) {
            item.setForOneHour(this._wordOptionsDlg.getPanel().isForOneHour());
            this._wordOptionsDlg.getPanel().configureOptions(item.getWordOptions());
            this._modelTable.fireTableCellUpdated(row, 2);
        }
    }

    private void editTreeExport(ExportItem item, int row) {
        if (this._treeOptionsDlg == null) {
            this._treeOptionsDlg = new ExportItemWordTreePanel.ExportItemWordTreeDlg(SwingUtilities.getWindowAncestor(this._ctrlTable));
            this._treeOptionsDlg.pack();
            this._treeOptionsDlg.setLocationRelativeTo(this._ctrlTable);
        }
        this._treeOptionsDlg.getPanel().setForOneHour(item.isForOneHour());
        this._treeOptionsDlg.getPanel().configureDlg(item.getWordOptions());
        this._treeOptionsDlg.setVisible(true);
        if (this._treeOptionsDlg.getResult()) {
            item.setForOneHour(this._treeOptionsDlg.getPanel().isForOneHour());
            this._treeOptionsDlg.getPanel().configureOptions(item.getWordOptions());
            this._modelTable.fireTableCellUpdated(row, 2);
        }
    }

    private void editCAAExport(ExportItem item, int row) {
        if (this._caaOptionsDlg == null) {
            this._caaOptionsDlg = new ExportItemCAAPanel.ExportItemCAADlg(SwingUtilities.getWindowAncestor(this._ctrlTable));
            this._caaOptionsDlg.getPanel().setAttributes(this.getAttributes());
            this._caaOptionsDlg.pack();
            this._caaOptionsDlg.setLocationRelativeTo(this._ctrlTable);
        }
        this._caaOptionsDlg.getPanel().setForOneHour(item.isForOneHour());
        this._caaOptionsDlg.getPanel().configureDlg(item.getCAAOptions());
        this._caaOptionsDlg.setVisible(true);
        if (this._caaOptionsDlg.getResult()) {
            item.setForOneHour(this._caaOptionsDlg.getPanel().isForOneHour());
            this._caaOptionsDlg.getPanel().configureOptions(item.getCAAOptions());
            this._modelTable.fireTableCellUpdated(row, 2);
        }
    }

    private void editCAAWordExport(ExportItem item, int row) {
        if (this._caaWithWordOptionsDlg == null) {
            this._caaWithWordOptionsDlg = new ExportItemWordWithCAAPanel.ExportItemWordWithCAADlg(SwingUtilities.getWindowAncestor(this._ctrlTable));
            this._caaWithWordOptionsDlg.getPanel().setAttributes(this.getAttributes());
            this._caaWithWordOptionsDlg.pack();
            this._caaWithWordOptionsDlg.setLocationRelativeTo(this._ctrlTable);
        }
        this._caaWithWordOptionsDlg.getPanel().setForOneHour(item.isForOneHour());
        this._caaWithWordOptionsDlg.getPanel().configureDlg(item.getWordOptions(), item.getCAAOptions());
        this._caaWithWordOptionsDlg.setVisible(true);
        if (this._caaWithWordOptionsDlg.getResult()) {
            item.setForOneHour(this._caaWithWordOptionsDlg.getPanel().isForOneHour());
            this._caaWithWordOptionsDlg.getPanel().configureOptions(item.getWordOptions(), item.getCAAOptions());
            this._modelTable.fireTableCellUpdated(row, 2);
        }
    }

    class OptsCellRenderer
    extends JPanel
    implements TableCellRenderer,
    UIResource {
        public OptsCellRenderer() {
            super(new GridBagLayout());
            JButton ctrlBut = new JButton("...");
            ctrlBut.setHorizontalAlignment(0);
            ctrlBut.setEnabled(true);
            ctrlBut.setMargin(new Insets(0, 0, 0, 0));
            ctrlBut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    _LOG.finest("optRenderer");
                }
            });
            this.add((Component)ctrlBut, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            ExportItem item = ExportPanel.this._modelTable.getItem(row);
            if (item != null) {
                this.setToolTipText(item.getAbstractOptions());
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }
}

