/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.plugin.faulttree.compute.compute.AverageRiskFormulaeDevelopped;
import com.dassault.cecilia.plugin.faulttree.compute.compute.AverageRiskFormulaeDeveloppedBig;
import com.dassault.cecilia.plugin.faulttree.compute.compute.AverageRiskFormulaeLimited;
import com.dassault.cecilia.plugin.faulttree.compute.compute.AverageRiskIntegrate;
import com.dassault.cecilia.plugin.faulttree.compute.compute.AverageRiskMarkovProxy;
import com.dassault.cecilia.plugin.faulttree.compute.compute.AverageRiskMarkovProxyOld;

public abstract class AverageRiskCompute {
    protected static final boolean _TRACE = false;
    protected static final boolean _twoFailureVincent = false;

    public abstract double computeOneFailures(double var1, double var3);

    public abstract double computeTwoFailures(double var1, double var3, double var5, double var7);

    public abstract double computeThreeFailures(double var1, double var3, double var5, double var7, double var9, double var11);

    public static AverageRiskCompute create(Type type) {
        switch (type) {
            case FormulaeLimited: {
                return new AverageRiskFormulaeLimited();
            }
            case FormulaeDevelopped: {
                return new AverageRiskFormulaeDevelopped();
            }
            case FormulaeDeveloppedPrime: {
                return new AverageRiskFormulaeDevelopped(){

                    @Override
                    public double computeTwoFailuresExcluded(double tm, double l1, double T1, double l2, double T2) {
                        return this.computeTwoFailuresExcludedPrime(tm, l1, T1, l2, T2);
                    }

                    @Override
                    public double computeThreeFailuresExcluded(double tm, double l1, double T1, double l2, double T2, double l3, double T3) {
                        return this.computeThreeFailuresExcludedPrime(tm, l1, T1, l2, T2, l3, T3);
                    }
                };
            }
            case FormulaeDeveloppedBig: {
                return new AverageRiskFormulaeDeveloppedBig();
            }
            case FormulaeDeveloppedBigPrime: {
                return new AverageRiskFormulaeDeveloppedBig(){

                    @Override
                    public double computeTwoFailuresExcluded(double tm, double l1, double T1, double l2, double T2) {
                        return this.computeTwoFailuresExcludedPrime(tm, l1, T1, l2, T2);
                    }

                    @Override
                    public double computeThreeFailuresExcluded(double tm, double l1, double T1, double l2, double T2, double l3, double T3) {
                        return this.computeThreeFailuresExcludedPrime(tm, l1, T1, l2, T2, l3, T3);
                    }
                };
            }
            case Integrate: {
                return new AverageRiskIntegrate();
            }
            case IntegratePrime: {
                return new AverageRiskIntegrate(){

                    @Override
                    public double computeTwoFailuresExcluded(double tm, double l1, double T1, double l2, double T2) {
                        return this.computeTwoFailuresExcludedPrime(tm, l1, T1, l2, T2);
                    }

                    @Override
                    public double computeThreeFailuresExcluded(double tm, double l1, double T1, double l2, double T2, double l3, double T3) {
                        return this.computeThreeFailuresExcludedPrime(tm, l1, T1, l2, T2, l3, T3);
                    }
                };
            }
            case Markov1: {
                return new AverageRiskMarkovProxy(true);
            }
            case Markov2: {
                return new AverageRiskMarkovProxy(false);
            }
            case MarkovOld: {
                return new AverageRiskMarkovProxyOld(true);
            }
        }
        return null;
    }

    double computeTwoFailuresExcludedPrime(double tm, double l1, double T1, double l2, double T2) {
        double Qfor1 = this.computeOneFailures(l2, T2);
        double Qfor2 = this.computeOneFailures(l1, T1);
        double QTot = Qfor2 + Qfor1;
        double result = 0.0;
        result += Qfor1 / QTot * (1.0 - Math.exp(-l1 * tm)) * Qfor1;
        return result += Qfor2 / QTot * (1.0 - Math.exp(-l2 * tm)) * Qfor2;
    }

    public double computeTwoFailuresExcluded(double tm, double l1, double T1, double l2, double T2) {
        double Qfor1 = this.computeOneFailures(l2, T2);
        double Qfor2 = this.computeOneFailures(l1, T1);
        double result = 0.0;
        result += (1.0 - Math.exp(-l1 * tm)) * Qfor1;
        return result += (1.0 - Math.exp(-l2 * tm)) * Qfor2;
    }

    double computeThreeFailuresExcludedPrime(double tm, double l1, double T1, double l2, double T2, double l3, double T3) {
        double Qfor1 = this.computeTwoFailures(l2, T2, l3, T3);
        double Qfor2 = this.computeTwoFailures(l1, T1, l3, T3);
        double Qfor3 = this.computeTwoFailures(l1, T1, l2, T2);
        double QTot = Qfor2 + Qfor1 + Qfor3;
        double result = 0.0;
        result += Qfor1 / QTot * (1.0 - Math.exp(-l1 * tm)) * Qfor1;
        result += Qfor2 / QTot * (1.0 - Math.exp(-l2 * tm)) * Qfor2;
        return result += Qfor3 / QTot * (1.0 - Math.exp(-l3 * tm)) * Qfor3;
    }

    public double computeThreeFailuresExcluded(double tm, double l1, double T1, double l2, double T2, double l3, double T3) {
        double result = 0.0;
        result += (1.0 - Math.exp(-l1 * tm)) * this.computeTwoFailures(l2, T2, l3, T3);
        result += (1.0 - Math.exp(-l2 * tm)) * this.computeTwoFailures(l1, T1, l3, T3);
        return (result += (1.0 - Math.exp(-l3 * tm)) * this.computeTwoFailures(l1, T1, l2, T2)) / 3.0;
    }

    public static enum Type {
        FormulaeLimited,
        FormulaeDevelopped,
        FormulaeDeveloppedPrime,
        FormulaeDeveloppedBig,
        FormulaeDeveloppedBigPrime,
        Integrate,
        IntegratePrime,
        Markov1,
        Markov2,
        MarkovOld;

    }
}

