/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.plugin.faulttree.compute.compute.AverageRiskCompute;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

class AverageRiskFormulaeDeveloppedBig
extends AverageRiskCompute {
    static MathContext _MC = new MathContext(100, RoundingMode.HALF_UP);
    static BigDecimal _E = AverageRiskFormulaeDeveloppedBig.expLT1(BigDecimal.ONE);

    AverageRiskFormulaeDeveloppedBig() {
    }

    private static BigDecimal expLT1(BigDecimal x) {
        if (x.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ONE;
        }
        BigDecimal term = BigDecimal.ONE.multiply(x);
        BigDecimal sum = BigDecimal.ONE.add(x);
        for (int k = 2; k < 50; ++k) {
            term = term.multiply(x);
            term = term.divide(new BigDecimal(k), _MC);
            sum = sum.add(term);
        }
        return sum;
    }

    private static BigDecimal expPos(BigDecimal x) {
        int cmp = x.compareTo(BigDecimal.ONE);
        if (cmp == 0) {
            return _E;
        }
        if (cmp < 0) {
            return AverageRiskFormulaeDeveloppedBig.expLT1(x);
        }
        if (x.compareTo(new BigDecimal(Integer.MAX_VALUE)) > 0) {
            throw new ArithmeticException();
        }
        int sup1 = x.intValue();
        BigDecimal res = _E.pow(sup1, _MC);
        return res.multiply(AverageRiskFormulaeDeveloppedBig.expLT1(x.subtract(new BigDecimal(sup1))));
    }

    public static BigDecimal exp(BigDecimal x) {
        int cmp = x.compareTo(BigDecimal.ZERO);
        if (cmp == 0) {
            return BigDecimal.ONE;
        }
        if (cmp > 0) {
            return AverageRiskFormulaeDeveloppedBig.expPos(x);
        }
        cmp = x.compareTo(BigDecimal.ONE.negate());
        if (cmp > 0) {
            return AverageRiskFormulaeDeveloppedBig.expLT1(x);
        }
        BigDecimal pos = AverageRiskFormulaeDeveloppedBig.expPos(x.negate());
        return BigDecimal.ONE.divide(pos, _MC);
    }

    @Override
    public double computeOneFailures(double l1, double t1) {
        BigDecimal L1 = new BigDecimal(Double.toString(l1));
        BigDecimal T1 = new BigDecimal(Double.toString(t1));
        BigDecimal L1T1 = L1.multiply(T1);
        BigDecimal res = AverageRiskFormulaeDeveloppedBig.exp(L1T1.negate());
        res = BigDecimal.ONE.subtract(res);
        res = res.divide(L1T1, _MC);
        res = BigDecimal.ONE.subtract(res);
        return res.doubleValue();
    }

    @Override
    public double computeTwoFailures(double l1, double t1, double l2, double t2) {
        BigDecimal L1 = new BigDecimal(Double.toString(l1));
        BigDecimal T1 = new BigDecimal(Double.toString(t1));
        BigDecimal L2 = new BigDecimal(Double.toString(l2));
        BigDecimal T2 = new BigDecimal(Double.toString(t2));
        BigDecimal Two = new BigDecimal(2);
        BigDecimal Result = T1.multiply(Two);
        double result = 2.0 * t1;
        BigDecimal Tmp1 = BigDecimal.ONE.subtract(AverageRiskFormulaeDeveloppedBig.exp(L1.multiply(T1).negate()));
        Tmp1 = Tmp1.divide(L1, _MC).multiply(Two);
        Result = Result.subtract(Tmp1);
        Tmp1 = T2.subtract(T1).multiply(L2);
        Tmp1 = BigDecimal.ONE.add(AverageRiskFormulaeDeveloppedBig.exp(Tmp1.negate()));
        BigDecimal Tmp2 = BigDecimal.ONE.subtract(AverageRiskFormulaeDeveloppedBig.exp(L1.add(L2).multiply(T1).negate()));
        Tmp2 = Tmp2.divide(L1.add(L2), _MC);
        BigDecimal Tmp3 = BigDecimal.ONE.subtract(AverageRiskFormulaeDeveloppedBig.exp(L2.multiply(T1).negate()));
        Tmp3 = Tmp3.divide(L2, _MC);
        Result = Result.add(Tmp1.multiply(Tmp2.subtract(Tmp3)));
        Result = Result.divide(T1.multiply(Two), _MC);
        return Result.doubleValue();
    }

    @Override
    public double computeThreeFailures(double l1, double t1, double l2, double t2, double l3, double t3) {
        BigDecimal L1 = new BigDecimal(Double.toString(l1));
        BigDecimal T1 = new BigDecimal(Double.toString(t1));
        BigDecimal L2 = new BigDecimal(Double.toString(l2));
        BigDecimal T2 = new BigDecimal(Double.toString(t2));
        BigDecimal L3 = new BigDecimal(Double.toString(l3));
        BigDecimal T3 = new BigDecimal(Double.toString(t3));
        BigDecimal two = new BigDecimal(2);
        BigDecimal res = T1.multiply(two);
        BigDecimal tmp1 = BigDecimal.ONE.subtract(AverageRiskFormulaeDeveloppedBig.exp(L1.multiply(T1).negate()));
        tmp1 = tmp1.divide(L1, _MC).multiply(two);
        res = res.subtract(tmp1);
        tmp1 = BigDecimal.ONE.add(AverageRiskFormulaeDeveloppedBig.exp(T2.subtract(T1).multiply(L2).negate()));
        BigDecimal tmp2 = BigDecimal.ONE.subtract(AverageRiskFormulaeDeveloppedBig.exp(L1.add(L2).multiply(T1).negate()));
        tmp2 = tmp2.divide(L1.add(L2), _MC);
        BigDecimal tmp3 = BigDecimal.ONE.subtract(AverageRiskFormulaeDeveloppedBig.exp(L2.multiply(T1).negate()));
        tmp3 = tmp3.divide(L2, _MC);
        res = res.add(tmp1.multiply(tmp2.subtract(tmp3)));
        tmp1 = BigDecimal.ONE.add(AverageRiskFormulaeDeveloppedBig.exp(T3.subtract(T1).multiply(L3).negate()));
        tmp2 = BigDecimal.ONE.subtract(AverageRiskFormulaeDeveloppedBig.exp(L1.add(L3).multiply(T1).negate()));
        tmp2 = tmp2.divide(L1.add(L3), _MC);
        tmp3 = BigDecimal.ONE.subtract(AverageRiskFormulaeDeveloppedBig.exp(L3.multiply(T1).negate()));
        tmp3 = tmp3.divide(L3, _MC);
        res = res.add(tmp1.multiply(tmp2.subtract(tmp3)));
        tmp1 = T2.subtract(T1).multiply(L2).negate();
        BigDecimal tmp4 = T3.subtract(T1).multiply(L3);
        tmp1 = BigDecimal.ONE.add(AverageRiskFormulaeDeveloppedBig.exp(tmp1.subtract(tmp4)));
        tmp4 = L3.add(L2);
        tmp2 = BigDecimal.ONE.subtract(AverageRiskFormulaeDeveloppedBig.exp(tmp4.multiply(T1).negate()));
        tmp2 = tmp2.divide(tmp4, _MC);
        tmp4 = tmp4.add(L1);
        tmp3 = BigDecimal.ONE.subtract(AverageRiskFormulaeDeveloppedBig.exp(tmp4.multiply(T1).negate()));
        tmp3 = tmp3.divide(tmp4, _MC);
        res = res.add(tmp1.multiply(tmp2.subtract(tmp3)));
        res = res.divide(T1.multiply(two), _MC);
        return res.doubleValue();
    }
}

