/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.plugin.faulttree.compute.compute.AverageRiskCompute;

class AverageRiskIntegrate
extends AverageRiskCompute {
    AverageRiskIntegrate() {
    }

    @Override
    public double computeOneFailures(double l1, double T1) {
        double MaxT = T1;
        double Inc = Math.min(1.0, T1 / 1000.0);
        double OldT = 0.0;
        double OldVal = 0.0;
        double CurT = 0.0;
        double Sum = 0.0;
        while (CurT < MaxT) {
            double Proba1;
            if ((CurT += Inc) > MaxT) {
                CurT = MaxT;
            }
            double CurVal = Proba1 = 1.0 - Math.exp(-l1 * (CurT / T1 - (double)((long)(CurT / T1))) * T1);
            Sum += (CurT - OldT) * (OldVal + CurVal) / 2.0;
            OldT = CurT;
            OldVal = CurVal;
        }
        return Sum / MaxT;
    }

    @Override
    public double computeTwoFailures(double l1, double T1, double l2, double T2) {
        double MaxT = T2;
        double Inc = Math.min(1.0, T1 / 1000.0);
        double OldT = 0.0;
        double OldVal = 0.0;
        double CurT = 0.0;
        double Sum = 0.0;
        while (CurT < MaxT) {
            if ((CurT += Inc) > MaxT) {
                CurT = MaxT;
            }
            double Proba1 = 1.0 - Math.exp(-l1 * (CurT / T1 - (double)((long)(CurT / T1))) * T1);
            double Proba2 = 1.0 - Math.exp(-l2 * (CurT / T2 - (double)((long)(CurT / T2))) * T2);
            double CurVal = Proba1 * Proba2;
            Sum += (CurT - OldT) * (OldVal + CurVal) / 2.0;
            OldT = CurT;
            OldVal = CurVal;
        }
        return Sum / MaxT;
    }

    @Override
    public double computeThreeFailures(double l1, double T1, double l2, double T2, double l3, double T3) {
        double MaxT = T3;
        double Inc = Math.min(1.0, T1 / 1000.0);
        double OldT = 0.0;
        double OldVal = 0.0;
        double CurT = 0.0;
        double Sum = 0.0;
        while (CurT < MaxT) {
            if ((CurT += Inc) > MaxT) {
                CurT = MaxT;
            }
            double Proba1 = 1.0 - Math.exp(-l1 * (CurT / T1 - (double)((long)(CurT / T1))) * T1);
            double Proba2 = 1.0 - Math.exp(-l2 * (CurT / T2 - (double)((long)(CurT / T2))) * T2);
            double Proba3 = 1.0 - Math.exp(-l3 * (CurT / T3 - (double)((long)(CurT / T3))) * T3);
            double CurVal = Proba1 * Proba2 * Proba3;
            Sum += (CurT - OldT) * (OldVal + CurVal) / 2.0;
            OldT = CurT;
            OldVal = CurVal;
        }
        return Sum / MaxT;
    }
}

