/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainer;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainerWithMsg;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public abstract class ComputeAbstract {
    private static Logger _LOG = Logger.getLogger(ComputeAbstract.class.getPackage().getName());
    BooleanStore _store = new BooleanStore();
    File _dagFile;
    File _xmlFile;
    boolean _bEndOfAction = false;

    public BooleanStore getStore() {
        return this._store;
    }

    public void defineFiles(File dagFile, File xmlFile) {
        this._dagFile = dagFile;
        this._xmlFile = xmlFile;
    }

    public File getXmlFile() {
        return this._xmlFile;
    }

    public File getDagFile() {
        return this._dagFile;
    }

    public boolean isEndOfAction() {
        return this._bEndOfAction;
    }

    public void setEndOfAction(boolean value) {
        this._bEndOfAction = value;
    }

    public abstract ParamComputeAbstract getParameters();

    public abstract String getTaskShort();

    public abstract String getTaskName();

    public abstract String getTaskDesc(boolean var1);

    public abstract ImageIcon getTaskIcon();

    public abstract void prepareCompute(TaskContainer var1, EngineBDDAbstract var2, String var3, File var4, InfoDatum var5, Plugable var6);

    public void launchCompute(InfoDatum idatum, Plugable launcher, EngineBDDAbstract engineBDD, String pathTree) {
        File resFile;
        try {
            resFile = File.createTempFile("EngineBDD", ".res");
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Error during create tmpFile", e);
            return;
        }
        File dagFile = this.getDagFile();
        if (dagFile == null) {
            _LOG.severe("No access to dag file");
            return;
        }
        engineBDD.setInputFile(dagFile);
        TaskContainerWithMsg task = new TaskContainerWithMsg(launcher, this.getTaskShort() + " - " + pathTree);
        this.prepareCompute(task, engineBDD, pathTree, resFile, idatum, launcher);
        PlugTask plugTask = task.createPlugTask(this.getTaskName(), this.getTaskDesc(true) + pathTree, this.getTaskIcon());
        launcher.addTask(plugTask, idatum.getModel().getUID());
    }

    public abstract void prepareDisplay(TaskContainer var1, boolean var2, String var3, InfoDatum var4, Plugable var5);

    public void launchDisplay(InfoDatum idatum, Plugable launcher, boolean bComputeProbability, String pathTree) {
        TaskContainerWithMsg task = new TaskContainerWithMsg(launcher, this.getTaskShort() + " - " + pathTree);
        this.prepareDisplay(task, bComputeProbability, pathTree, idatum, launcher);
        PlugTask plugTask = task.createPlugTask(this.getTaskName(), this.getTaskDesc(false) + pathTree, this.getTaskIcon());
        launcher.addTask(plugTask, idatum.getModel().getUID());
    }
}

