/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.crc.client.CRCSchedulerUtil;
import com.dassault.cecilia.crc.client.ResSheduler;
import com.dassault.cecilia.crc.common.CRCEngineType;
import com.dassault.cecilia.crc.common.CRCException;
import com.dassault.cecilia.crc.common.io.IOFilesExchange;
import com.dassault.cecilia.crc.common.pojo.InitComputationResponse;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfig;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfigProxy;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineControl;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineExecute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineProcess;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class EngineBDDAbstract
implements EngineExecute {
    private static Logger _LOG = Logger.getLogger(EngineBDDAbstract.class.getName());
    protected static final String CONFIG_ENGINE_MEMORY_FILE_ERROR = "ENGINE_ERROR_999";
    public static final String PROP_DEFINE_PATH_ENGINE_DEFAULT_VALUE = "./enginebdd";
    boolean _distrib = false;
    String _treepath;
    Integer _memory;
    EngineBDDConfig _config;
    File _optionsFile;
    File _inputFile;
    String _lawProbabilities;
    StringBuilder _command;
    public static final String SUFFIX_CONFIG_FILENAME = "g.cfg";
    public static final String PREFIX_CONFIG_FILENAME_CECILIA_BDD = "CeciliaBDDx64.";
    private static final String PREFIX_CONFIG_FILENAME_ARALIA4 = "Aralia4x64.";

    public EngineBDDAbstract(EngineBDDConfig config) {
        this._config = new EngineBDDConfigProxy(config);
        this._command = new StringBuilder(1024);
    }

    protected String getConfigFilename(Integer memory, EngineBDDConfig.EngineType engineType) {
        return EngineBDDConfig.EngineType.CeciliaBDD.equals((Object)engineType) ? PREFIX_CONFIG_FILENAME_CECILIA_BDD + String.format("%03d", memory) + SUFFIX_CONFIG_FILENAME : PREFIX_CONFIG_FILENAME_ARALIA4 + String.format("%03d", memory) + SUFFIX_CONFIG_FILENAME;
    }

    public boolean isDistrib() {
        return this._distrib;
    }

    protected void finalize() throws Throwable {
        if (this._optionsFile != null && !this._optionsFile.delete()) {
            _LOG.info("Can not delete the configuration file : " + this._optionsFile);
        }
    }

    public void setInputFile(File inputFile) {
        this._inputFile = inputFile;
    }

    public File getInputFile() {
        return this._inputFile;
    }

    public void appendLawProbabilities(String lawProbabilities) throws IOException {
        if (this._inputFile != null) {
            try (OutputStreamWriter writer = null;){
                writer = new FileWriter(this._inputFile, true);
                writer.append("\n");
                writer.append(lawProbabilities);
                writer.flush();
            }
        }
        this._lawProbabilities = lawProbabilities;
    }

    public String getLawProbabilities() {
        return this._lawProbabilities;
    }

    public EngineBDDConfig.EngineType getEngineType() {
        return this._config.getEngineType(this._distrib);
    }

    public boolean isEngineDistrib() {
        return this._distrib;
    }

    public Appendable getCmdsAppendable() {
        return this._command;
    }

    public void setRequestMemorySpace(Integer memory) throws Exception {
        _LOG.finer("Request memory for computation: " + memory);
        this._memory = memory;
        switch (this._config.getComputeType()) {
            case LOCAL: {
                if (memory <= this._config.getMemoryMax(EngineBDDConfig.ComputeType.LOCAL)) break;
                throw new IllegalArgumentException(ResCompute.msgFormat("DLG_ENGINE_MEMORY_ERR_LOCAL", this._config.getMemoryMax(EngineBDDConfig.ComputeType.LOCAL), memory));
            }
            case DISTRIB: {
                if (memory <= this._config.getMemoryMax(EngineBDDConfig.ComputeType.DISTRIB)) break;
                throw new IllegalArgumentException(ResCompute.msgFormat("DLG_ENGINE_MEMORY_ERR_DISTRIB", this._config.getMemoryMax(EngineBDDConfig.ComputeType.DISTRIB), memory));
            }
            case AUTOMATIC: {
                if (!this._distrib) {
                    if (memory <= this._config.getMemoryMax(EngineBDDConfig.ComputeType.LOCAL)) break;
                    if (memory > this._config.getMemoryMax(EngineBDDConfig.ComputeType.DISTRIB)) {
                        throw new IllegalArgumentException(ResCompute.msgFormat("DLG_ENGINE_MEMORY_ERR_DISTRIB", this._config.getMemoryMax(EngineBDDConfig.ComputeType.DISTRIB), memory));
                    }
                    this._distrib = true;
                    _LOG.info("La configuration memoire impose d'utiliser le mode distribue");
                    break;
                }
                if (memory <= this._config.getMemoryMax(EngineBDDConfig.ComputeType.DISTRIB)) break;
                throw new IllegalArgumentException(ResCompute.msgFormat("DLG_ENGINE_MEMORY_ERR_DISTRIB", this._config.getMemoryMax(EngineBDDConfig.ComputeType.DISTRIB), memory));
            }
        }
        EngineBDDConfig.EngineType engineType = this.getEngineType();
        if (memory > this._config.getMemoryMax(engineType)) {
            throw new IllegalArgumentException(ResCompute.msgFormat("DLG_ENGINE_MEMORY_ERR_ENGINE", new Object[]{this._config.getMemoryMax(engineType), memory, engineType}));
        }
    }

    public void defineComputeType(BooleanStore store) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(store.getInfo(BooleanStore.INFO_PROJECT)).append("/");
        buffer.append(store.getInfo(BooleanStore.INFO_SYSTEM)).append("/");
        buffer.append(store.getInfo(BooleanStore.INFO_TREE)).append("(");
        buffer.append(store.getInfo(BooleanStore.INFO_VERSION)).append(")");
        this._treepath = buffer.toString();
        switch (this._config.getComputeType()) {
            case LOCAL: {
                this._distrib = false;
                break;
            }
            case DISTRIB: {
                this._distrib = true;
                break;
            }
            case AUTOMATIC: {
                String bigTree = store.getInfo(BooleanStore.INFO_BIGTREE);
                if (bigTree != null && bigTree.equals("true")) {
                    _LOG.info("EngineBDD - Automatic compute type : BigTree => type distrib");
                    this._distrib = true;
                    break;
                }
                double note = store.getNbrLeaves() * Integer.getInteger("cecilia.ft.engine.type.AutomaticWeightLeaf", 100) / 100 + store.getNbrGates() * Integer.getInteger("cecilia.ft.engine.type.AutomaticWeightGate", 50) / 100;
                if (note > (double)Integer.getInteger("cecilia.ft.engine.type.AutomaticLimit", 150).intValue()) {
                    this._distrib = true;
                }
                if (!_LOG.isLoggable(Level.INFO)) break;
                StringBuffer buffer2 = new StringBuffer();
                buffer2.append("EngineBDD - Automatic compute type (NbrLeaves=").append(store.getNbrLeaves());
                buffer2.append(",NbrGates=").append(store.getNbrGates()).append(")");
                buffer2.append(">[Note=").append(note).append("]");
                buffer2.append(">[Distrib=").append(this._distrib).append("]");
                _LOG.info(buffer2.toString());
            }
        }
    }

    public abstract void prepareComputeType();

    @Override
    public EngineBDDConfig.ResultType execute(EngineControl ctrl) {
        if (this._distrib) {
            _LOG.log(Level.INFO, "EngineBDD - execute in distrib mode with " + this._config.getEngineType(true));
            return this.executeDistrib(ctrl);
        }
        _LOG.log(Level.INFO, "EngineBDD - execute in local mode with " + this._config.getEngineType(false));
        return this.executeLocal(ctrl);
    }

    protected abstract EngineBDDConfig.ResultType executeDistrib(EngineControl var1);

    protected boolean verifyMaxMemory(EngineControl ctrl, boolean switchIfNeeded) {
        try {
            int maxMemory = CRCSchedulerUtil.getMaxMemory((boolean)switchIfNeeded);
            if (this._memory > maxMemory) {
                _LOG.info("Not enough memory available: memory(=" + this._memory + ") > maxMemory(=" + maxMemory + ")");
                ctrl.appendUserMsg(ResSheduler.getString((String)"NOT_ENOUGH_MEMORY_ON_MANAGER"));
                return false;
            }
        }
        catch (CRCException e) {
            ctrl.appendUserMsg(ResSheduler.msgFormat((String)"MSG_SCHEDULER_ERROR_CALLING", (Object[])new Object[]{CRCSchedulerUtil.getUrlSchedulerBase()}));
            return false;
        }
        return true;
    }

    protected String convertComputeErrorCodeToUserMessage(String errorCode) {
        if (errorCode == null) {
            return "<null>";
        }
        if (CONFIG_ENGINE_MEMORY_FILE_ERROR.equals(errorCode)) {
            return ResSheduler.msgFormat((String)"MSG_SCHEDULER_ENGINE_MEMORY_CONFIG_FILE_NOT_MANAGED", (Object[])new Object[]{this._memory, this.getEngineType()});
        }
        if (errorCode.startsWith("ENGINE_ERROR_")) {
            errorCode = errorCode.substring("ENGINE_ERROR_".length());
            return ResSheduler.msgFormat((String)"MSG_SCHEDULER_ENGINE_ERROR", (Object[])new Object[]{errorCode});
        }
        return ResSheduler.msgFormat((String)"MSG_SCHEDULER_ERROR", (Object[])new Object[]{errorCode});
    }

    protected String convertAPICallToUserMessage(APICall apiCall) {
        if (apiCall == null) {
            return ResSheduler.msgFormat((String)"MSG_SCHEDULER_ERROR_CALLING", (Object[])new Object[]{CRCSchedulerUtil.getUrlSchedulerBase()});
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(ResSheduler.msgFormat((String)"MSG_SCHEDULER_ERROR_CALLING", (Object[])new Object[]{apiCall.toString()}));
        return buffer.toString();
    }

    protected InitComputationResponse initAndLaunch(EngineControl ctrl, boolean grouped, boolean bAralia, String cmd) {
        InitComputationResponse computation = null;
        APICall apiCall = null;
        try {
            apiCall = APICall.INIT;
            computation = grouped ? CRCSchedulerUtil.initGrouped() : CRCSchedulerUtil.initSingle();
            long computeID = computation.getId();
            apiCall = APICall.UPLOAD;
            IOFilesExchange ioFilesExchange = CRCSchedulerUtil.createOrGetIOFilesExchange((boolean)computation.isSftp());
            ioFilesExchange.upload(computeID, this._inputFile);
            apiCall = APICall.LAUNCH;
            CRCEngineType crcEngineType = bAralia ? CRCEngineType.ARALIA4 : CRCEngineType.CECILIA_BDD;
            CRCSchedulerUtil.launchComputation((InitComputationResponse)computation, (CRCEngineType)crcEngineType, (String)cmd, (Integer)this._memory);
        }
        catch (CRCException e) {
            _LOG.severe("ERROR  " + e);
            ctrl.appendUserMsg(this.convertAPICallToUserMessage(apiCall));
            computation = null;
        }
        return computation;
    }

    /*
     * Exception decompiling
     */
    protected EngineBDDConfig.ResultType waitAndDownload(EngineControl ctrl, InitComputationResponse compute, File resFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [45[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract EngineBDDConfig.ResultType executeLocal(EngineControl var1);

    protected EngineBDDConfig.ResultType executeCompute(EngineControl ctrl, String additionalCmd) {
        Thread thread = null;
        EngineVerify verifyCtrl = new EngineVerify(ctrl);
        EngineBDDConfig.EngineType type = this._config.getEngineType(false);
        _LOG.fine("executeCompute memory=" + this._memory + " engineType=" + type.name() + " distrib=" + this._distrib);
        if (type != null) {
            switch (type) {
                case Aralia4: {
                    thread = this.createThreadAralia4(this._command.toString(), additionalCmd, verifyCtrl);
                    break;
                }
                case CeciliaBDD: {
                    thread = this.createThreadCeciliaBDD(this._command.toString(), additionalCmd, verifyCtrl);
                }
            }
        }
        if (thread == null) {
            return EngineBDDConfig.ResultType.ErrNoEngine;
        }
        thread.start();
        try {
            while (thread.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!ctrl.isCanceled() || ((EngineProcess)thread).getProcess() == null) continue;
                thread.interrupt();
                Process process = ((EngineProcess)thread).getProcess();
                process.destroy();
                process.getInputStream().close();
                process.getOutputStream().close();
                process.getErrorStream().close();
                break;
            }
            if (verifyCtrl._bufferError.length() > 0) {
                _LOG.log(Level.INFO, "Error msgs during compute : \n" + verifyCtrl._bufferError);
                if (verifyCtrl._bMemoryError) {
                    return EngineBDDConfig.ResultType.ErrMemoryExhaustid;
                }
                return EngineBDDConfig.ResultType.ErrCompute;
            }
        }
        catch (IOException e) {
            _LOG.log(Level.WARNING, "Compute local BDDEngine error.", e);
            verifyCtrl.appendUserMsg(ResCompute.msgFormat("MSG_ENGINE_EXCEPTION_ERROR", e.getMessage()));
            return EngineBDDConfig.ResultType.ErrCompute;
        }
        return EngineBDDConfig.ResultType.NoError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EngineProcess createThreadAralia4(String cmd, String additionalCmd, EngineControl ctrl) {
        File commandFile;
        List<String> execArray = this._config.createExecLine();
        if (execArray == null) {
            return null;
        }
        execArray = new ArrayList<String>(execArray);
        try {
            commandFile = File.createTempFile("BDDEngine", ".cdag");
            try (FileWriter writer = null;){
                writer = new FileWriter(commandFile);
                writer.write(cmd);
                if (additionalCmd.length() > 0) {
                    writer.write(additionalCmd);
                }
            }
        }
        catch (IOException ioe) {
            _LOG.log(Level.WARNING, "Error during create Aralia4 command file", ioe);
            return null;
        }
        String enginePath = System.getProperty("cecilia.ft.engine.define.PathAralia4", PROP_DEFINE_PATH_ENGINE_DEFAULT_VALUE);
        String configFilename = this.getConfigFilename(this._memory, EngineBDDConfig.EngineType.Aralia4);
        if (configFilename == null || !new File(enginePath + "/" + configFilename).exists()) {
            _LOG.log(Level.SEVERE, "Error retrieving memory file config for " + this._memory + "Bytes");
            ctrl.appendUserMsg(ResCompute.getString("MSG_ENGINE_LOCAL_CONFIG_MEMORY_ERROR"));
            return null;
        }
        this._optionsFile = new File(enginePath + "/" + configFilename);
        if (this._optionsFile != null) {
            execArray.add(this._optionsFile.getAbsolutePath());
        }
        if (this._inputFile != null) {
            execArray.add(this._inputFile.getAbsolutePath());
        }
        execArray.add(commandFile.getAbsolutePath());
        String[] args = new String[execArray.size()];
        EngineProcess thread = new EngineProcess(execArray.toArray(args), commandFile, "exit;\n", ctrl);
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EngineProcess createThreadCeciliaBDD(String cmd, String additionalCmd, EngineControl ctrl) {
        List<String> execArray = this._config.createExecLine();
        if (execArray == null) {
            return null;
        }
        execArray = new ArrayList<String>(execArray);
        File commandFile = null;
        try {
            commandFile = File.createTempFile("BDDEngineCmd", ".cdag");
            try (FileWriter writer = null;){
                writer = new FileWriter(commandFile);
                writer.write(cmd);
                if (additionalCmd.length() > 0) {
                    writer.write(additionalCmd);
                }
            }
        }
        catch (IOException ioe) {
            _LOG.log(Level.WARNING, "Error during create CeciliaBDD command file", ioe);
            return null;
        }
        execArray.add("--verify");
        String enginePath = System.getProperty("cecilia.ft.engine.define.PathCeciliaBDD", PROP_DEFINE_PATH_ENGINE_DEFAULT_VALUE);
        String configFilename = this.getConfigFilename(this._memory, EngineBDDConfig.EngineType.CeciliaBDD);
        if (configFilename == null || !new File(enginePath + "/" + configFilename).exists()) {
            _LOG.log(Level.SEVERE, "Error retrieving memory file config for " + this._memory + "Bytes");
            ctrl.appendUserMsg(ResCompute.getString("MSG_ENGINE_LOCAL_CONFIG_MEMORY_ERROR"));
            return null;
        }
        this._optionsFile = new File(enginePath + "/" + configFilename);
        if (this._optionsFile != null) {
            execArray.add("-c");
            execArray.add(this._optionsFile.getAbsolutePath());
        }
        if (this._inputFile != null) {
            execArray.add("-f");
            execArray.add(this._inputFile.getAbsolutePath());
        }
        execArray.add("-e");
        execArray.add(commandFile.getAbsolutePath());
        String[] args = new String[execArray.size()];
        _LOG.info("execArray=" + execArray);
        EngineProcess thread = new EngineProcess(execArray.toArray(args), commandFile, "", ctrl);
        return thread;
    }

    protected static enum APICall {
        INIT,
        MEL,
        UPLOAD,
        LAUNCH,
        STATUS,
        GET,
        ABORD,
        END;

    }

    class EngineVerify
    implements EngineControl {
        EngineControl _delegate;
        boolean _bMemoryError;
        boolean _bOtherError;
        StringBuffer _bufferError;

        EngineVerify(EngineControl delegate) {
            this._delegate = delegate;
            this._bMemoryError = false;
            this._bOtherError = false;
            this._bufferError = new StringBuffer(1024);
        }

        @Override
        public void appendErr(String msg) {
            if (msg.contains("Memory exhausted")) {
                this._bufferError.append(msg);
                this._bMemoryError = true;
                this.appendUserMsg(ResCompute.getString("MSG_ENGINE_MEMORY_ERROR"));
            } else {
                if (this._bufferError.length() < 1024) {
                    this._bufferError.append(msg);
                }
                if (!this._bOtherError) {
                    this._bOtherError = true;
                    this.appendUserMsg(ResCompute.msgFormat("MSG_ENGINE_OTHER_ERROR", msg));
                }
            }
            this._delegate.appendErr(msg);
        }

        @Override
        public void appendOut(String msg) {
            this._delegate.appendOut(msg);
        }

        @Override
        public boolean isCanceled() {
            return this._delegate.isCanceled();
        }

        @Override
        public void appendUserMsg(String msg) {
            this._delegate.appendUserMsg(msg);
        }
    }
}

