/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.crc.client.CRCSchedulerUtil;
import com.dassault.cecilia.crc.client.Computation;
import com.dassault.cecilia.crc.client.ResSheduler;
import com.dassault.cecilia.crc.client.historical.HistoricalRequestTableModel;
import com.dassault.cecilia.crc.common.CRCClientException;
import com.dassault.cecilia.crc.common.CRCException;
import com.dassault.cecilia.crc.common.ComputationRequestStatus;
import com.dassault.cecilia.crc.common.io.IOFilesExchange;
import com.dassault.cecilia.crc.common.pojo.InitComputationResponse;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMCS;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfig;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineControl;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineMELHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EngineBDDMEL
extends EngineBDDAbstract {
    private static Logger _LOG = Logger.getLogger(EngineBDDMEL.class.getName());
    Boolean _stopEngine = false;
    int _nbrTreated = 0;
    TargetsAccessor _targets;
    EngineMELHelper _melHelperCompute;
    BooleanMCS _mcsForPessimistCompute;

    public EngineBDDMEL(EngineBDDConfig config) {
        super(config);
    }

    public void prepareCompute(TargetsAccessor targets, EngineMELHelper melHelperCompute) {
        this._targets = targets;
        this._melHelperCompute = melHelperCompute;
    }

    @Override
    public void prepareComputeType() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected EngineBDDConfig.ResultType executeDistrib(EngineControl ctrl) {
        EngineBDDConfig.ResultType nbr2;
        long computeID;
        DistribMEL distribMEL;
        boolean forAralia;
        block35: {
            EngineBDDConfig.ResultType execResult = EngineBDDConfig.ResultType.NoError;
            if (!this.verifyMaxMemory(ctrl, true)) {
                return EngineBDDConfig.ResultType.ErrCompute;
            }
            execResult = this.transformMCSResultIfExist();
            if (execResult != EngineBDDConfig.ResultType.NoError) {
                return execResult;
            }
            forAralia = this.getEngineType() == EngineBDDConfig.EngineType.Aralia4;
            distribMEL = new DistribMEL(ctrl);
            computeID = -1L;
            try {
                File nominalResFile = this._melHelperCompute.createTmpFile();
                StringBuilder tgtCmd = new StringBuilder(this._command.length() + 1024);
                tgtCmd.append(this._command.toString()).append("\n");
                this._melHelperCompute.setCurrentTarget(ResCompute.getString("MEL_TARGET_NOMINAL"));
                this._melHelperCompute.generate(tgtCmd, forAralia, nominalResFile.getName(), true);
                distribMEL.addUnit(new DistribMELUnit(null, nominalResFile));
                InitComputationResponse compute = this.initAndLaunch(ctrl, true, forAralia, tgtCmd.toString());
                if (compute == null) {
                    return EngineBDDConfig.ResultType.ErrCompute;
                }
                computeID = compute.getId();
                distribMEL.fixID(distribMEL.getFromTgt(null), computeID);
                if (!this._melHelperCompute.withPessimistCompute() || this._mcsForPessimistCompute != null) break block35;
                execResult = this.waitAndDownload(ctrl, compute, nominalResFile);
                if (execResult != EngineBDDConfig.ResultType.NoError) {
                    return execResult;
                }
                if (ctrl.isCanceled()) {
                    return EngineBDDConfig.ResultType.ErrCompute;
                }
                this._melHelperCompute.setCurrentTarget(ResCompute.getString("MEL_TARGET_NOMINAL"));
                BooleanResult result = this._melHelperCompute.readResult(nominalResFile.getAbsolutePath(), ctrl);
                if (!Boolean.getBoolean("cecilia.ft.compute.KeepFile.MEL")) {
                    nominalResFile.delete();
                }
                if (ctrl.isCanceled()) {
                    return EngineBDDConfig.ResultType.ErrCompute;
                }
                if (result.getMCS().isAlwaysTrue() || result.getMCS().isAlwaysFalse()) {
                    this._melHelperCompute.computeProbabilities(result, ctrl);
                    this._melHelperCompute.addResult(null, result);
                    return EngineBDDConfig.ResultType.NoError;
                }
                if (this._mcsForPessimistCompute == null) {
                    File dagFile = this._melHelperCompute.defineEquationFromMCS(result.getMCS());
                    try {
                        IOFilesExchange ioFilesExchange = CRCSchedulerUtil.createOrGetIOFilesExchange((boolean)compute.isSftp());
                        ioFilesExchange.upload(computeID, dagFile);
                    }
                    catch (CRCException e) {
                        _LOG.severe("ERROR  " + e);
                        ctrl.appendUserMsg(this.convertAPICallToUserMessage(EngineBDDAbstract.APICall.UPLOAD));
                        return EngineBDDConfig.ResultType.ErrCompute;
                    }
                }
                result.getMCS().limitAt(this._melHelperCompute.getParameters().getLimitOrder());
                result = this._melHelperCompute.postTreatResult(result, ctrl);
                this._melHelperCompute.computeProbabilities(result, ctrl);
                this._melHelperCompute.addResult(null, result);
                distribMEL.getFromTgt(null)._state = DistribMELUnit.Progress.READ;
                ++this._nbrTreated;
            }
            catch (IOException e) {
                _LOG.log(Level.SEVERE, "IOException during MEL.Compute.Nominal", e);
                ctrl.appendUserMsg(ResCompute.msgFormat("MSG_ENGINE_ERROR_COMPUTE_TARGET", ResCompute.getString("MEL_TARGET_NOMINAL")));
                return EngineBDDConfig.ResultType.ErrCompute;
            }
        }
        HashMap<String, String> cmdParams = new HashMap<String, String>();
        Iterator<String> iTgt = this._targets.iterate();
        while (iTgt.hasNext()) {
            String tgt = iTgt.next();
            try {
                File tgtResult = this._melHelperCompute.createTmpFile();
                StringBuilder tgtCmd = new StringBuilder(this._command.length() + 1024);
                tgtCmd.append(this._command.toString()).append("\n").append(tgt).append(" := 1;\n");
                this._melHelperCompute.setCurrentTarget(tgt);
                this._melHelperCompute.generate(tgtCmd, forAralia, tgtResult.getName(), false);
                cmdParams.put(tgt, tgtCmd.toString());
                distribMEL.addUnit(new DistribMELUnit(tgt, tgtResult));
            }
            catch (IOException e) {
                _LOG.log(Level.SEVERE, "IOException during MEL.Compute." + tgt, e);
                ctrl.appendUserMsg(ResCompute.msgFormat("MSG_ENGINE_ERROR_COMPUTE_TARGET", tgt));
                return EngineBDDConfig.ResultType.ErrCompute;
            }
        }
        try {
            try {
                Iterator iParams = cmdParams.entrySet().iterator();
                while (iParams.hasNext()) {
                    int nbr2;
                    LinkedHashMap<String, String> batchParams = new LinkedHashMap<String, String>();
                    for (nbr2 = 0; iParams.hasNext() && nbr2 < 250; ++nbr2) {
                        Map.Entry entry = iParams.next();
                        batchParams.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    if (nbr2 <= 0) continue;
                    Map ids = CRCSchedulerUtil.initAndLaunchMelComputationChilds((Long)computeID, batchParams);
                    for (String target : ids.keySet()) {
                        DistribMELUnit unit = distribMEL.getFromTgt(target);
                        distribMEL.fixID(unit, (Long)ids.get(target));
                    }
                }
            }
            catch (CRCException e) {
                ctrl.appendUserMsg(this.convertAPICallToUserMessage(EngineBDDAbstract.APICall.MEL));
                throw new Exception(e);
            }
            finally {
                distribMEL._bFinnishSendRequest = true;
            }
            Object thread = new Thread("DistribMEL-GetStatus"){

                @Override
                public void run() {
                    distribMEL.waitAndGetStatus();
                }
            };
            thread.setPriority(1);
            thread.start();
            thread = new Thread("DistribMEL-Download"){

                @Override
                public void run() {
                    distribMEL.downloadAndRead();
                }
            };
            thread.setPriority(1);
            thread.start();
            distribMEL.waitFinnish();
            thread = EngineBDDConfig.ResultType.NoError;
            return thread;
        }
        catch (NoCutsFromNominalComputeException e) {
            distribMEL.abortCompute();
            nbr2 = EngineBDDConfig.ResultType.NoError;
            return nbr2;
        }
        catch (StopDistribException e) {
            distribMEL.abortCompute();
            nbr2 = EngineBDDConfig.ResultType.ErrCompute;
            return nbr2;
        }
        catch (Exception e) {
            Throwable cur;
            for (cur = e; cur != null; cur = cur.getCause()) {
                if (!cur.getClass().getName().toLowerCase().contains("timeout")) continue;
                ctrl.appendUserMsg(cur.getMessage() + "  (" + cur.getClass().getSimpleName() + ")");
                break;
            }
            if (cur == null) {
                ctrl.appendUserMsg(e.getMessage());
            }
            _LOG.log(Level.FINE, "Exception during DistribMEL", e);
            distribMEL.abortCompute();
            EngineBDDConfig.ResultType resultType = EngineBDDConfig.ResultType.ErrCompute;
            return resultType;
        }
        finally {
            distribMEL.cleanCompute();
            distribMEL.saveComputes();
        }
    }

    @Override
    protected EngineBDDConfig.ResultType executeLocal(EngineControl ctrl) {
        EngineBDDConfig.ResultType execResult = EngineBDDConfig.ResultType.NoError;
        execResult = this.transformMCSResultIfExist();
        if (execResult != EngineBDDConfig.ResultType.NoError) {
            return execResult;
        }
        try {
            File fileResult = this._melHelperCompute.createTmpFile();
            StringBuffer nominalCmd = new StringBuffer(1024);
            this._melHelperCompute.setCurrentTarget(ResCompute.getString("MEL_TARGET_NOMINAL"));
            this._melHelperCompute.generate(nominalCmd, this.getEngineType() == EngineBDDConfig.EngineType.Aralia4, fileResult.getAbsolutePath(), true);
            execResult = this.executeCompute(ctrl, nominalCmd.toString());
            if (execResult != EngineBDDConfig.ResultType.NoError) {
                return execResult;
            }
            BooleanResult result = this._melHelperCompute.readResult(fileResult.getAbsolutePath(), ctrl);
            if (result.getMCS().isAlwaysTrue() || result.getMCS().isAlwaysFalse()) {
                this._melHelperCompute.computeProbabilities(result, ctrl);
                this._melHelperCompute.addResult(null, result);
                return EngineBDDConfig.ResultType.NoError;
            }
            if (this._melHelperCompute.withPessimistCompute()) {
                if (this._mcsForPessimistCompute == null) {
                    File dagFile = this._melHelperCompute.defineEquationFromMCS(result.getMCS());
                    this.setInputFile(dagFile);
                    String laws = this.getLawProbabilities();
                    if (laws != null && !laws.isBlank()) {
                        this.appendLawProbabilities(laws);
                    }
                }
                result.getMCS().limitAt(this._melHelperCompute.getParameters().getLimitOrder());
            }
            result = this._melHelperCompute.postTreatResult(result, ctrl);
            this._melHelperCompute.computeProbabilities(result, ctrl);
            this._melHelperCompute.addResult(null, result);
            ++this._nbrTreated;
        }
        catch (IOException ioe) {
            _LOG.log(Level.SEVERE, "IOException during MEL.Compute.Nominal", ioe);
            ctrl.appendUserMsg(ResCompute.msgFormat("MSG_ENGINE_ERROR_COMPUTE_TARGET", ResCompute.getString("MEL_TARGET_NOMINAL")));
            execResult = EngineBDDConfig.ResultType.ErrCompute;
        }
        if (execResult != EngineBDDConfig.ResultType.NoError) {
            return execResult;
        }
        Iterator<String> iTgt = this._targets.iterate();
        while (!ctrl.isCanceled() && iTgt.hasNext() && execResult == EngineBDDConfig.ResultType.NoError) {
            String tgt = iTgt.next();
            try {
                File tgtResult = this._melHelperCompute.createTmpFile();
                StringBuffer tgtCmd = new StringBuffer(1024);
                tgtCmd.append(tgt).append(" := 1;\n");
                this._melHelperCompute.setCurrentTarget(tgt);
                this._melHelperCompute.generate(tgtCmd, this.getEngineType() == EngineBDDConfig.EngineType.Aralia4, tgtResult.getAbsolutePath(), false);
                execResult = this.executeCompute(ctrl, tgtCmd.toString());
                if (execResult != EngineBDDConfig.ResultType.NoError) {
                    return execResult;
                }
                BooleanResult result = this._melHelperCompute.readResult(tgtResult.getAbsolutePath(), ctrl);
                result = this._melHelperCompute.postTreatResult(result, ctrl);
                this._melHelperCompute.computeProbabilities(result, ctrl);
                this._melHelperCompute.addResult(tgt, result);
                ++this._nbrTreated;
            }
            catch (IOException ioe) {
                _LOG.log(Level.SEVERE, "IOException during MEL.Compute." + tgt, ioe);
                ctrl.appendUserMsg(ResCompute.msgFormat("MSG_ENGINE_ERROR_COMPUTE_TARGET", tgt));
                execResult = EngineBDDConfig.ResultType.ErrCompute;
            }
        }
        return execResult;
    }

    @Override
    public int getMaxStep() {
        return this._targets.size() + 1;
    }

    @Override
    public int getCurStep() {
        return this._nbrTreated;
    }

    public void setMCSForPessimistCompute(BooleanMCS mcs) {
        this._mcsForPessimistCompute = mcs;
    }

    private EngineBDDConfig.ResultType transformMCSResultIfExist() {
        if (this._mcsForPessimistCompute != null) {
            this._mcsForPessimistCompute.prepare();
            _LOG.finest("MEL - From MCS result: " + this._mcsForPessimistCompute.getOrderAbstract());
            this._mcsForPessimistCompute.limitAt(this._melHelperCompute.getParameters().getLimitOrder() + 1);
            try {
                File dagFile = this._melHelperCompute.defineEquationFromMCS(this._mcsForPessimistCompute);
                _LOG.fine("MEL - Transforme MCS result (orderLimit=" + this._melHelperCompute.getParameters().getLimitOrder() + ") [" + this._mcsForPessimistCompute.getOrderAbstract() + "]: \nDagFile " + this._inputFile + " => " + dagFile.toString());
                this.setInputFile(dagFile);
                String laws = this.getLawProbabilities();
                if (laws != null && !laws.isBlank()) {
                    this.appendLawProbabilities(laws);
                }
                return EngineBDDConfig.ResultType.NoError;
            }
            catch (IOException ioe) {
                _LOG.log(Level.SEVERE, "IOException during MEL.Compute.Transform MCS", ioe);
                this._melHelperCompute.addError(ResCompute.msgFormat("MSG_ENGINE_ERROR_COMPUTE_TARGET", ResCompute.getString("MEL_TARGET_NOMINAL")));
                return EngineBDDConfig.ResultType.ErrCompute;
            }
        }
        return EngineBDDConfig.ResultType.NoError;
    }

    public static interface TargetsAccessor {
        public int size();

        default public int getNbrEvents() {
            return this.size();
        }

        public Iterator<String> iterate();
    }

    class DistribMEL
    implements EngineControl {
        boolean _bFinnishSendRequest = false;
        EngineControl _delegate;
        Map<Long, DistribMELUnit> _mapFromID = new LinkedHashMap<Long, DistribMELUnit>();
        Map<String, DistribMELUnit> _mapFromTgt = new LinkedHashMap<String, DistribMELUnit>();
        LinkedList<DistribMELUnit> _fifoReadUnit = new LinkedList();
        DistribMELUnit _nominal;
        boolean _stopGeneral = false;
        Exception _distribException;

        DistribMEL(EngineControl delegate) {
            this._delegate = delegate;
        }

        @Override
        public boolean isCanceled() {
            if (this._bFinnishSendRequest) {
                if (this._distribException != null) {
                    return true;
                }
                if (this._stopGeneral) {
                    return true;
                }
                return this._delegate.isCanceled();
            }
            return false;
        }

        @Override
        public void appendErr(String msg) {
            this._delegate.appendErr(msg);
        }

        @Override
        public void appendOut(String msg) {
            this._delegate.appendOut(msg);
        }

        @Override
        public void appendUserMsg(String msg) {
            _LOG.info("AppendUserMsg: " + msg);
            this._delegate.appendUserMsg(msg);
        }

        void addUnit(DistribMELUnit unit) {
            if (this._nominal == null && unit._target == null) {
                this._nominal = unit;
            } else {
                this._mapFromTgt.put(unit._target, unit);
            }
        }

        DistribMELUnit getFromTgt(String tgt) {
            if (tgt == null) {
                return this._nominal;
            }
            return this._mapFromTgt.get(tgt);
        }

        DistribMELUnit getFromID(long id) {
            return this._mapFromID.get(id);
        }

        void fixID(DistribMELUnit unit, long id) {
            DistribMELUnit other = this._mapFromID.get(id);
            if (other != null) {
                throw new IllegalArgumentException();
            }
            unit._id = id;
            this._mapFromID.put(id, unit);
        }

        private void setDistribException(Exception e) {
            if (this._distribException != null) {
                _LOG.log(Level.WARNING, "Previous DistribMEL Exception", this._distribException);
            }
            this._distribException = e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitAndGetStatus() {
            LinkedHashSet<Long> computeIDs = new LinkedHashSet<Long>(this._mapFromID.keySet());
            if (this._nominal._state != DistribMELUnit.Progress.INIT) {
                computeIDs.remove(this._nominal._id);
            }
            long[] timerSleep = new long[]{1000L, 2000L, 3000L, 5000L, 10000L};
            int idxTimerSleep = 0;
            int nbrConnectError = 0;
            try {
                while (!computeIDs.isEmpty() && !this.isCanceled()) {
                    if (idxTimerSleep < timerSleep.length) {
                        Thread.sleep(timerSleep[idxTimerSleep++]);
                    } else {
                        Thread.sleep(timerSleep[idxTimerSleep - 1]);
                        if (!EngineBDDMEL.this.verifyMaxMemory(this, false)) {
                            throw new Exception();
                        }
                    }
                    Map statusMap = null;
                    try {
                        statusMap = CRCSchedulerUtil.getStatusFromIds(new ArrayList<Long>(computeIDs));
                        nbrConnectError = 0;
                    }
                    catch (CRCClientException e) {
                        if (++nbrConnectError > Integer.getInteger("cecilia.remote.computation.scheduler.status.nbrError", 2)) continue;
                        throw e;
                    }
                    boolean change = false;
                    boolean error = false;
                    for (Long id : statusMap.keySet()) {
                        ComputationRequestStatus status = (ComputationRequestStatus)statusMap.get(id);
                        DistribMELUnit unit = this.getFromID(id);
                        if (status.equals((Object)unit._status)) continue;
                        change = true;
                        unit._status = status;
                        switch (status) {
                            case REQUEST_ABORTED: {
                                try {
                                    unit._state = DistribMELUnit.Progress.END;
                                    CRCSchedulerUtil.endComputation((Long)id);
                                }
                                catch (CRCException e) {
                                    this.appendUserMsg(unit._target + " - " + EngineBDDMEL.this.convertAPICallToUserMessage(EngineBDDAbstract.APICall.END));
                                }
                                computeIDs.remove(id);
                                break;
                            }
                            case RESULT_RECEIVED_FROM_MANAGER: {
                                unit._state = DistribMELUnit.Progress.DOWNLOAD;
                                LinkedList<DistribMELUnit> e = this._fifoReadUnit;
                                synchronized (e) {
                                    if (unit._target == null) {
                                        this._fifoReadUnit.addFirst(unit);
                                    } else {
                                        this._fifoReadUnit.addLast(unit);
                                    }
                                }
                                computeIDs.remove(id);
                                break;
                            }
                            case REQUEST_ERROR: {
                                unit._state = DistribMELUnit.Progress.READ;
                                Computation compute = CRCSchedulerUtil.getComputation((Long)id);
                                if (compute == null) {
                                    this.appendUserMsg(unit._target + " - " + EngineBDDMEL.this.convertAPICallToUserMessage(EngineBDDAbstract.APICall.GET));
                                } else {
                                    this.appendUserMsg(unit._target + " - " + EngineBDDMEL.this.convertComputeErrorCodeToUserMessage(compute.getErrorCode()));
                                    try {
                                        unit._state = DistribMELUnit.Progress.END;
                                        CRCSchedulerUtil.endComputation((Long)id);
                                    }
                                    catch (CRCException e) {
                                        this.appendUserMsg(unit._target + " - " + EngineBDDMEL.this.convertAPICallToUserMessage(EngineBDDAbstract.APICall.END));
                                    }
                                }
                                error = true;
                                computeIDs.remove(id);
                            }
                        }
                    }
                    if (error) {
                        throw new StopDistribException();
                    }
                    if (!change || idxTimerSleep <= 0) continue;
                    --idxTimerSleep;
                }
            }
            catch (CRCException e) {
                this.appendUserMsg(EngineBDDMEL.this.convertAPICallToUserMessage(EngineBDDAbstract.APICall.STATUS));
                this.setDistribException((Exception)((Object)e));
            }
            catch (Exception e) {
                this.setDistribException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void downloadAndRead() {
            int nbrRead = 0;
            if (this._nominal._state != DistribMELUnit.Progress.INIT) {
                ++nbrRead;
            }
            int nbrCompute = this._mapFromID.size();
            try {
                while (nbrRead < nbrCompute && !this.isCanceled()) {
                    DistribMELUnit unit = null;
                    LinkedList<DistribMELUnit> linkedList = this._fifoReadUnit;
                    synchronized (linkedList) {
                        if (!this._fifoReadUnit.isEmpty()) {
                            unit = this._fifoReadUnit.removeFirst();
                        }
                    }
                    if (unit == null) {
                        Thread.sleep(250L);
                        continue;
                    }
                    ++nbrRead;
                    unit._state = DistribMELUnit.Progress.READ;
                    Computation comput = CRCSchedulerUtil.getComputation((Long)unit._id);
                    if (comput == null) {
                        this.appendUserMsg(unit._target + " - " + EngineBDDMEL.this.convertAPICallToUserMessage(EngineBDDAbstract.APICall.GET));
                        throw new StopDistribException();
                    }
                    boolean withSftp = comput.isSftp();
                    int maxError = withSftp ? Integer.getInteger("cecilia.remote.computation.scheduler.result.nbrError", 5) : 0;
                    int delayError = Integer.getInteger("cecilia.remote.computation.scheduler.result.delayIfError", 30000);
                    if (delayError < 0) {
                        delayError = 0;
                    }
                    while (true) {
                        try {
                            IOFilesExchange ioFilesExchange = CRCSchedulerUtil.createOrGetIOFilesExchange((boolean)withSftp);
                            ioFilesExchange.download(unit._id, unit._resFile, comput.isZipMode());
                            break;
                        }
                        catch (CRCException e) {
                            if (maxError <= 0) {
                                _LOG.log(Level.INFO, "Probleme lors de la recuperation du fichier de resultat", e);
                                this.appendUserMsg(unit._target + " - " + ResSheduler.getString((String)"MSG_SCHEDULER_ERROR_DOWNLOAD_FILE"));
                                throw e;
                            }
                            _LOG.log(Level.FINER, "Probleme lors de la recuperation du fichier de resultat - Nouvelle trentative dans " + delayError + " ms");
                            if (--maxError == 0) {
                                withSftp = false;
                            }
                            if (delayError <= 0) continue;
                            try {
                                Thread.sleep(delayError);
                            }
                            catch (InterruptedException e2) {
                                // empty catch block
                                break;
                            }
                        }
                    }
                    if (unit._target != null) {
                        try {
                            unit._state = DistribMELUnit.Progress.END;
                            CRCSchedulerUtil.endComputation((Long)unit._id);
                        }
                        catch (CRCException e) {
                            this.appendUserMsg(unit._target + " - " + EngineBDDMEL.this.convertAPICallToUserMessage(EngineBDDAbstract.APICall.END));
                        }
                    }
                    if (!unit._resFile.canRead()) {
                        throw new IOException("MCS result file not be loadable for distrib request " + unit._target);
                    }
                    EngineBDDMEL.this._melHelperCompute.setCurrentTarget(unit._target == null ? ResCompute.getString("MEL_TARGET_NOMINAL") : unit._target);
                    BooleanResult mcsResult = EngineBDDMEL.this._melHelperCompute.readResult(unit._resFile.getAbsolutePath(), this);
                    if (!Boolean.getBoolean("cecilia.ft.compute.KeepFile.MEL")) {
                        unit._resFile.delete();
                    }
                    mcsResult = EngineBDDMEL.this._melHelperCompute.postTreatResult(mcsResult, this);
                    EngineBDDMEL.this._melHelperCompute.computeProbabilities(mcsResult, this);
                    EngineBDDMEL.this._melHelperCompute.addResult(unit._target, mcsResult);
                    ++EngineBDDMEL.this._nbrTreated;
                    if (unit._target != null || !mcsResult.getMCS().isAlwaysTrue() && !mcsResult.getMCS().isAlwaysFalse()) continue;
                    throw new NoCutsFromNominalComputeException();
                }
            }
            catch (Exception e) {
                this.setDistribException(e);
            }
        }

        public void waitFinnish() throws Exception {
            while (EngineBDDMEL.this._nbrTreated != this._mapFromID.size()) {
                if (this._distribException != null) {
                    throw this._distribException;
                }
                if (this._delegate.isCanceled()) {
                    this.abortCompute();
                    return;
                }
                Thread.sleep(250L);
            }
        }

        public void abortCompute() {
            try {
                CRCSchedulerUtil.abortComputationGroup((Long)this._nominal._id);
            }
            catch (CRCException e) {
                this.appendUserMsg(EngineBDDMEL.this.convertAPICallToUserMessage(EngineBDDAbstract.APICall.ABORD));
            }
        }

        public void cleanCompute() {
            LinkedHashSet<Long> computeIDs = new LinkedHashSet<Long>();
            for (DistribMELUnit unit : this._mapFromID.values()) {
                if (unit._state == DistribMELUnit.Progress.END || unit._id < 0L || unit._target == null) continue;
                computeIDs.add(unit._id);
            }
            CompletableFuture.runAsync(() -> {
                if (!computeIDs.isEmpty()) {
                    long[] timerSleep = new long[]{1000L, 2000L, 3000L, 5000L, 10000L, 30000L, 60000L};
                    int idxTimerSleep = 0;
                    try {
                        while (!computeIDs.isEmpty() && idxTimerSleep < timerSleep.length) {
                            Thread.sleep(timerSleep[idxTimerSleep++]);
                            Map statusMap = CRCSchedulerUtil.getStatusFromIds(new ArrayList(computeIDs));
                            boolean change = false;
                            for (Long id : statusMap.keySet()) {
                                ComputationRequestStatus status = (ComputationRequestStatus)statusMap.get(id);
                                DistribMELUnit unit = this.getFromID(id);
                                if (!status.equals((Object)unit._status)) {
                                    change = true;
                                }
                                unit._status = status;
                                switch (status) {
                                    case REQUEST_ABORTED: 
                                    case RESULT_RECEIVED_FROM_MANAGER: 
                                    case REQUEST_ERROR: {
                                        try {
                                            unit._state = DistribMELUnit.Progress.END;
                                            CRCSchedulerUtil.endComputation((Long)id);
                                        }
                                        catch (CRCException e) {
                                            _LOG.info("CleanCompute: " + unit._target + " - " + EngineBDDMEL.this.convertAPICallToUserMessage(EngineBDDAbstract.APICall.END));
                                        }
                                        computeIDs.remove(id);
                                    }
                                }
                            }
                            if (!change || idxTimerSleep <= 0) continue;
                            --idxTimerSleep;
                        }
                    }
                    catch (CRCException e) {
                        _LOG.info("CleanCompute: " + EngineBDDMEL.this.convertAPICallToUserMessage(EngineBDDAbstract.APICall.STATUS));
                    }
                    catch (Exception e) {
                        _LOG.log(Level.WARNING, "CleanCompute: ", e);
                    }
                }
                try {
                    CRCSchedulerUtil.endComputation((Long)this._nominal._id);
                }
                catch (CRCException e) {
                    _LOG.info("CleanCompute: null - " + EngineBDDMEL.this.convertAPICallToUserMessage(EngineBDDAbstract.APICall.END));
                }
            });
        }

        public void saveComputes() {
            CompletableFuture.runAsync(() -> {
                HistoricalRequestTableModel historical = CRCSchedulerUtil.getHistoricalRequests();
                for (DistribMELUnit unit : this._mapFromID.values()) {
                    Computation computation;
                    if (unit._id < 0L || (computation = CRCSchedulerUtil.getComputation((Long)unit._id)) == null) continue;
                    historical.addComputation(computation, EngineBDDMEL.this._treepath);
                }
            });
        }
    }

    static class DistribMELUnit {
        String _target;
        File _resFile;
        long _id = -1L;
        Progress _state = Progress.INIT;
        ComputationRequestStatus _status = null;
        String _errorCode = null;

        DistribMELUnit(String tgt, File resFile) {
            this._target = tgt;
            this._resFile = resFile;
        }

        static enum Progress {
            INIT,
            DOWNLOAD,
            READ,
            END;

        }
    }

    static class NoCutsFromNominalComputeException
    extends Exception {
    }

    static class StopDistribException
    extends Exception {
    }
}

