/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MCSInputStream
extends FilterInputStream {
    int _maxIndex;
    int _nbrBits;
    int _maxValue;
    byte _buffer;
    short _pos;
    private static final byte ONE = 1;

    public MCSInputStream(InputStream stream, int maxIndex) {
        super(stream);
        this._maxIndex = maxIndex++;
        this._buffer = 0;
        this._pos = 0;
        this._nbrBits = 1;
        this._maxValue = 1;
        maxIndex >>= 1;
        while (this._maxValue < maxIndex) {
            this._maxValue <<= 1;
            ++this._nbrBits;
        }
    }

    public final int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public int readIndex() throws IOException {
        int idx = 0;
        for (int i = 0; i < this._nbrBits; ++i) {
            if (this._pos == 0) {
                this._buffer = (byte)this.read();
                this._pos = (short)8;
            }
            idx <<= 1;
            if (this._buffer < 0) {
                idx |= 1;
            }
            this._buffer = (byte)(this._buffer << 1);
            this._pos = (short)(this._pos - 1);
        }
        if (idx >= this._maxIndex) {
            throw new IOException("Read index greater or equal indexMax : " + idx);
        }
        return idx;
    }
}

