/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.dbobj.general.attrib.AttrCriterion;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ParamCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.DlgPanelComputeStd;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class ParamComputeAbstract
implements ParamCompute {
    private static Logger _LOG = Logger.getLogger(ParamComputeAbstract.class.getPackage().getName());
    boolean _bRefComputeSelect = false;
    boolean _bRefIgnoreSelect = false;
    boolean _bRefComputeEnable = true;
    boolean _bRefIgnoreEnable = true;
    Integer _memory;
    EngineBDDConfig _engineBDDConfig;
    Integer _limitOrder = Integer.getInteger("cecilia.ft.compute.LimitOrder", -1);
    TypeProbability _prType = null;
    TypeProbability _prTypeDefault = null;
    Double _missionTimeSec = 3600.0;
    Number[] _missionTimeSeparated = null;
    Boolean _bPostTreatmentDormant = false;
    Boolean _bPostTreatmentAtRisk = false;
    Double _specificTimeSec = 540.0;
    Number[] _specificTimeSeparated = null;
    Boolean _LSR = false;
    AttrCriterion _LSRAttrCriterion = null;
    public static final String PROP_COMPUTE_LIMITORDER = "cecilia.ft.compute.LimitOrder";
    public static final String PROP_COMPUTE_MEMORY_CONFIG = "cecilia.ft.compute.MemoryConfig";
    private static DocumentBuilderFactory _dbf = null;

    public boolean withLSR() {
        return this._LSR;
    }

    public void setLSR(Boolean withLSR) {
        this._LSR = withLSR;
    }

    public AttrCriterion getCriteriumLSR() {
        return this._LSRAttrCriterion;
    }

    public void setCriteriumLSR(AttrCriterion criterion) {
        this._LSRAttrCriterion = criterion;
    }

    public ParamComputeAbstract() {
        this._memory = Integer.getInteger(PROP_COMPUTE_MEMORY_CONFIG, 2);
    }

    @Override
    public double getMissionTime() {
        return this._missionTimeSec;
    }

    public void setMissionTimeSec(Double missionTimeSec) {
        this._missionTimeSec = missionTimeSec;
        this._missionTimeSeparated = null;
    }

    public void setMissionTimeSeparated(Number[] missionTime) {
        this._missionTimeSeparated = missionTime;
    }

    @Override
    public double getMissionTimeH() {
        return this._missionTimeSec / 3600.0;
    }

    public static Number[] getSeparatedTimes(double missionTimeInSec) {
        Number[] result = new Number[3];
        Integer hours = 0;
        while (missionTimeInSec >= 3600.0) {
            missionTimeInSec -= 3600.0;
            Integer n = hours;
            hours = hours + 1;
        }
        result[0] = hours;
        Integer mins = 0;
        while (missionTimeInSec >= 60.0) {
            missionTimeInSec -= 60.0;
            Integer n = mins;
            mins = mins + 1;
        }
        result[1] = mins;
        result[2] = missionTimeInSec;
        return result;
    }

    @Override
    public TypeProbability getTypeProbability() {
        return this._prType;
    }

    public void setTypeProbability(TypeProbability type) {
        this._prType = type;
    }

    public void setDefaultTypeProbability(TypeProbability type) {
        if (this._prType == null) {
            this._prType = type;
        }
        this._prTypeDefault = type;
    }

    @Override
    public int getLimitOrder() {
        return this._limitOrder;
    }

    @Override
    public Integer getMemory() {
        return this._memory;
    }

    public void setEngineBDDConfig(EngineBDDConfig engineBDDConfig) {
        this._engineBDDConfig = engineBDDConfig;
    }

    public void setMemory(Integer memory) {
        this._memory = memory;
    }

    public void setLimitOrder(Integer limitOrder) {
        this._limitOrder = limitOrder;
    }

    public void setReferenceCompute(boolean value, boolean enable) {
        this._bRefComputeSelect = value;
        this._bRefComputeEnable = enable;
    }

    public void setReferenceIgnore(boolean value, boolean enable) {
        this._bRefIgnoreSelect = value;
        this._bRefIgnoreEnable = enable;
    }

    public boolean isReferenceCompute() {
        return this._bRefComputeSelect;
    }

    public boolean isPreviousReferenceComputeIgnore() {
        return this._bRefIgnoreSelect;
    }

    public Boolean getPostTreatmentDormant() {
        return this._bPostTreatmentDormant;
    }

    public void setPostTreatmentDormant(Boolean value) {
        this._bPostTreatmentDormant = value;
    }

    public Boolean getPostTreatmentAtRisk() {
        return this._bPostTreatmentAtRisk;
    }

    public void setPostTreatmentAtRisk(Boolean value) {
        this._bPostTreatmentAtRisk = value;
    }

    public double getSpecificTime() {
        return this._specificTimeSec;
    }

    public void setSpecificTimeSec(Double specificTimeSec) {
        this._specificTimeSec = specificTimeSec;
        this._specificTimeSeparated = null;
    }

    public void setSpecificTimeSeparated(Number[] specificTime) {
        this._specificTimeSeparated = specificTime;
    }

    public double getSpecificTimeH() {
        return this._specificTimeSec / 3600.0;
    }

    @Override
    public String getAbstract() {
        StringBuffer sb = new StringBuffer();
        if (this._limitOrder > 0) {
            sb.append(ResCompute.getString("DLG_PARAM_MCS_TR"));
            sb.append(" : ").append(this._limitOrder).append("\n");
        }
        sb.append(ResCompute.getString("DLG_PARAM_TYPE"));
        sb.append(" : ").append(this._prType.getLabel()).append("\n");
        if (this._prType != TypeProbability.NONE) {
            sb.append(ResCompute.getString("DLG_PARAM_TIME"));
            sb.append(" : ").append(this.getMissionTimeH()).append("\n");
        }
        if (this._LSR.booleanValue() && this._LSRAttrCriterion != null) {
            sb.append(ResCompute.getString("DLG_PARAM_MEL_LSR")).append(" : ");
            sb.append(this._LSRAttrCriterion.toString()).append("\n");
        }
        if (this._bPostTreatmentDormant.booleanValue()) {
            sb.append(ResCompute.getString("PTD_TITLE")).append("\n");
            if (this._bPostTreatmentAtRisk.booleanValue()) {
                sb.append(ResCompute.getString("PTF_TITLE"));
                sb.append("(").append(this.getSpecificTimeH()).append(")\n");
            }
        }
        return sb.toString();
    }

    public String getShortAbstract() {
        StringBuilder sb = new StringBuilder();
        if (this._limitOrder > 0) {
            sb.append("!").append(this._limitOrder).append(" ");
        }
        sb.append(this._prType.toString());
        if (this._prType != TypeProbability.NONE) {
            sb.append(" ").append(this.getMissionTime());
        }
        if (this._bPostTreatmentDormant.booleanValue()) {
            sb.append(" {Dor}");
        }
        if (this._bPostTreatmentAtRisk.booleanValue()) {
            sb.append(" {EoF(").append(this.getSpecificTime()).append(")}");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ParamComputeAbstract)) {
            return false;
        }
        ParamComputeAbstract other = (ParamComputeAbstract)obj;
        if (this._limitOrder == null ? other._limitOrder != null : !this._limitOrder.equals(other._limitOrder)) {
            return false;
        }
        if (this._prType == null ? other._prType != null : !this._prType.equals((Object)other._prType)) {
            return false;
        }
        if (this._missionTimeSec == null ? other._missionTimeSec != null : !this._missionTimeSec.equals(other._missionTimeSec)) {
            return false;
        }
        if (this._LSR != other._LSR) {
            return false;
        }
        if (this._LSR.booleanValue() && this._LSRAttrCriterion != null && !this._LSRAttrCriterion.equals((Object)other._LSRAttrCriterion)) {
            return false;
        }
        if (this._bPostTreatmentDormant == null ? other._bPostTreatmentDormant != null : !this._bPostTreatmentDormant.equals(other._bPostTreatmentDormant)) {
            return false;
        }
        if (this._bPostTreatmentAtRisk == null ? other._bPostTreatmentAtRisk != null : !this._bPostTreatmentAtRisk.equals(other._bPostTreatmentAtRisk)) {
            return false;
        }
        return !(this._specificTimeSec == null ? other._specificTimeSec != null : !this._specificTimeSec.equals(other._specificTimeSec));
    }

    public int hashCode() {
        int hashCode = this._limitOrder != null ? this._limitOrder.hashCode() : -2;
        hashCode = 5 * hashCode + (this._missionTimeSec != null ? this._missionTimeSec.hashCode() : -1);
        hashCode = 7 * hashCode + (this._prType != null ? this._prType.hashCode() : -1);
        hashCode = 11 * hashCode + (this._LSR != false ? 1 : 0);
        hashCode = 13 * hashCode + (this._LSRAttrCriterion != null ? this._LSRAttrCriterion.hashCode() : 0);
        hashCode = 17 * hashCode + (this._bPostTreatmentDormant != null ? this._bPostTreatmentDormant.hashCode() : 0);
        hashCode = 19 * hashCode + (this._bPostTreatmentAtRisk != null ? this._bPostTreatmentAtRisk.hashCode() : 0);
        hashCode = 23 * hashCode + (this._specificTimeSec != null ? this._specificTimeSec.hashCode() : -1);
        return hashCode;
    }

    public boolean isCompatible(ParamComputeAbstract parameters, boolean sameData) {
        if (parameters._limitOrder != this._limitOrder) {
            return false;
        }
        if (parameters.getTypeProbability() == TypeProbability.BDD) {
            return sameData && parameters.equals(this);
        }
        return true;
    }

    public void copy(ParamComputeAbstract src) {
        this._memory = src._memory;
        this._limitOrder = src._limitOrder;
        this._missionTimeSec = src._missionTimeSec;
        this._prType = src._prType;
        if (src._LSR != null) {
            this._LSR = src._LSR;
            if (src.getCriteriumLSR() != null) {
                this._LSRAttrCriterion = new AttrCriterion(src.getCriteriumLSR());
            }
        }
        this._bPostTreatmentDormant = src._bPostTreatmentDormant;
        this._bPostTreatmentAtRisk = src._bPostTreatmentAtRisk;
        this._specificTimeSec = src._specificTimeSec;
    }

    protected abstract String getTypeCompute();

    public void saveToXML(Appendable output, String indent, String appendPrAttribute) throws IOException {
        output.append(indent).append("<ftc.parameters type='").append(this.getTypeCompute()).append("'>\n");
        output.append(indent).append("  <cuts");
        output.append(" truncated='").append(Integer.toString(this._limitOrder)).append("'");
        output.append("/>\n");
        output.append(indent).append("  <pr");
        output.append(" mission-time='").append(this._missionTimeSec.toString()).append("'");
        output.append(" type='").append(this._prType.toString()).append("'");
        if (appendPrAttribute != null) {
            output.append(appendPrAttribute);
        }
        output.append("/>\n");
        this.savePostTreatmentToXML(output, indent, appendPrAttribute);
        output.append(indent).append("</ftc.parameters>\n");
    }

    protected void savePostTreatmentToXML(Appendable output, String indent, String appendPrAttribute) throws IOException {
        if (this._LSR.booleanValue()) {
            output.append(indent).append("  <latent-specific-risk");
            this._LSRAttrCriterion.saveToXML(output);
            output.append("/>\n");
        }
        if (this._bPostTreatmentDormant.booleanValue()) {
            output.append(indent).append("  <post-traitment");
            output.append(" name='").append("dormant").append("'");
            output.append(" value='true'");
            output.append("/>\n");
        }
        if (this._bPostTreatmentAtRisk.booleanValue()) {
            output.append(indent).append("  <post-traitment");
            output.append(" name='").append("at-risk").append("'");
            output.append(" value='true'");
            output.append(" mission-time='").append(this._specificTimeSec.toString()).append("'");
            output.append("/>\n");
        }
    }

    public void loadFromXML(Element xmlElt) throws SAXException, IOException {
        if (!xmlElt.getNodeName().equals("ftc.parameters") && !xmlElt.getNodeName().equals("compute-parameters")) {
            throw new SAXException();
        }
        String type = xmlElt.getAttribute("type");
        if (!type.equalsIgnoreCase(this.getTypeCompute())) {
            throw new SAXException("No '" + this.getTypeCompute() + "' parameters");
        }
        NodeList childs = xmlElt.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node xmlChild = childs.item(i);
            String xmlChildName = xmlChild.getNodeName();
            if (xmlChildName.equals("memory")) {
                String memoryValue = ((Element)xmlChild).getAttribute("config");
                if (memoryValue.isEmpty()) {
                    this._memory = -1;
                    continue;
                }
                try {
                    this._memory = Integer.parseInt(memoryValue);
                }
                catch (NumberFormatException nfe) {
                    throw new SAXException(nfe);
                }
                if (this._memory >= 0) continue;
                this._memory = -1;
                continue;
            }
            if (xmlChildName.equals("cuts")) {
                String truncated = ((Element)xmlChild).getAttribute("truncated");
                if (truncated.isEmpty()) {
                    this._limitOrder = -1;
                    continue;
                }
                try {
                    this._limitOrder = Integer.parseInt(truncated);
                }
                catch (NumberFormatException nfe) {
                    throw new SAXException(nfe);
                }
                if (this._limitOrder >= 0) continue;
                this._limitOrder = -1;
                continue;
            }
            if (xmlChildName.equals("pr")) {
                String missionTime = ((Element)xmlChild).getAttribute("mission-time");
                try {
                    this._missionTimeSec = Double.parseDouble(missionTime);
                }
                catch (NumberFormatException nfe) {
                    throw new SAXException(nfe);
                }
                String type2 = ((Element)xmlChild).getAttribute("type");
                try {
                    this._prType = TypeProbability.valueOf((String)type2);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new SAXException("Unknown type '" + type2 + "'", e);
                }
            }
            if (xmlChildName.equals("latent-specific-risk")) {
                this._LSRAttrCriterion = AttrCriterion.loadFromXML((Element)((Element)xmlChild));
                this._LSR = true;
                continue;
            }
            if (!xmlChildName.equals("post-traitment")) continue;
            String name = ((Element)xmlChild).getAttribute("name");
            String value = ((Element)xmlChild).getAttribute("value");
            if (name.isEmpty() || value.isEmpty() || !Boolean.parseBoolean(value)) continue;
            if (name.equalsIgnoreCase("dormant")) {
                this._bPostTreatmentDormant = true;
                continue;
            }
            if (name.equalsIgnoreCase("at-risk")) {
                this._bPostTreatmentAtRisk = true;
                String missionTime = ((Element)xmlChild).getAttribute("mission-time");
                try {
                    this._specificTimeSec = Double.parseDouble(missionTime);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new SAXException(nfe);
                }
            }
            throw new SAXException("Unknown 'name' attribute for element 'post-traitment'");
        }
    }

    public void loadFromXML(InputStream inputStream) throws IOException {
        if (_dbf == null) {
            _dbf = DocumentBuilderFactory.newInstance();
            _dbf.setValidating(false);
            _dbf.setIgnoringComments(true);
            _dbf.setIgnoringElementContentWhitespace(true);
            _dbf.setCoalescing(false);
            _dbf.setExpandEntityReferences(true);
        }
        try {
            DocumentBuilder db = _dbf.newDocumentBuilder();
            Document doc = db.parse(inputStream);
            Element root = doc.getDocumentElement();
            if (root.getNodeName().equals("ftc")) {
                NodeList childs = root.getChildNodes();
                Element xmlParam = null;
                for (int i = 0; i < childs.getLength(); ++i) {
                    Node xmlChild = childs.item(i);
                    String xmlChildName = xmlChild.getNodeName();
                    if (!xmlChildName.equals("ftc.parameters") || !(xmlChild instanceof Element)) continue;
                    if (xmlParam != null) {
                        throw new SAXException("Only one element 'ftc.parameters'");
                    }
                    xmlParam = (Element)xmlChild;
                }
                if (xmlParam != null) {
                    this.loadFromXML(xmlParam);
                    return;
                }
                throw new SAXException("Must have one element 'ftc.parameters'");
            }
            if (!root.getNodeName().equals("ftc.parameters")) {
                throw new IOException(ResMsgCore.msgFormat((String)"FILE_ERROR_OPEN_XML_ROOT", (Object[])new Object[]{"ftc"}));
            }
            this.loadFromXML(root);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            _LOG.log(Level.WARNING, "Exception during read file parameters", e);
            StringBuffer sb = new StringBuffer(32);
            sb.append(e.getClass().getName());
            sb.append(" : ");
            String mess = e.getMessage();
            if (mess == null) {
                sb.append("<null>");
            } else {
                sb.append(mess);
            }
            throw new IOException(sb.toString());
        }
    }

    public void copyToCtrl(DlgPanelComputeStd panel) {
        panel.setEngineBDDConfig(this._engineBDDConfig);
        panel.setMemory(this._memory);
        panel.setLimitOrder(this._limitOrder);
        panel.setTypeProbability(this._prTypeDefault, this._prType);
        if (this._missionTimeSeparated == null) {
            panel.setMissionTime(this._missionTimeSec);
        } else {
            panel.setMissionTimeSeparated(this._missionTimeSeparated);
        }
        panel.setPostTreatmentDormant(this._bPostTreatmentDormant);
        panel.setPostTreatmentAtRisk(this._bPostTreatmentAtRisk);
        if (this._specificTimeSeparated == null) {
            panel.setSpecificTime(this._specificTimeSec);
        } else {
            panel.setSpecificTimeSeparated(this._specificTimeSeparated);
        }
        panel.setRefCompute(this._bRefComputeSelect, this._bRefComputeEnable);
        panel.setRefIgnore(this._bRefIgnoreSelect, this._bRefIgnoreEnable);
        panel.configureLSR(this._LSR, this._LSRAttrCriterion);
        panel.updateCtrls();
    }

    public void copyFromCtrl(DlgPanelComputeStd panel) {
        Integer order;
        if (panel.getMemory() != null) {
            this._memory = panel.getMemory();
        }
        if ((order = panel.getLimitOrder()) != null && order != 0) {
            this._limitOrder = panel.getLimitOrder();
        }
        if (panel.getTypeProbability() != null) {
            this._prType = panel.getTypeProbability();
        }
        if (panel.getMissionTime() != null) {
            this._missionTimeSec = panel.getMissionTime();
        }
        if (panel.isPostTreatmentDormant() != null) {
            this._bPostTreatmentDormant = panel.isPostTreatmentDormant();
        }
        if (panel.isPostTreatmentAtRisk() != null) {
            this._bPostTreatmentAtRisk = panel.isPostTreatmentAtRisk();
        }
        if (panel.getSpecificTime() != null) {
            this._specificTimeSec = panel.getSpecificTime();
        }
        this._bRefComputeSelect = panel.isRefCompute();
        this._bRefIgnoreSelect = panel.isRefComputeIgnore();
        if (panel.isWithLSR() != null) {
            this._LSR = panel.isWithLSR();
            if (this._LSR.booleanValue() && panel.getLSRAttributeCriterium() != null) {
                this._LSRAttrCriterion = panel.getLSRAttributeCriterium();
            } else if (!this._LSR.booleanValue()) {
                this._LSRAttrCriterion = null;
            }
        }
    }

    public abstract DlgPanelComputeStd createPanel(BooleanStore var1, Plugable var2);

    protected abstract String getTitle();

    public boolean displayDialog(BooleanStore store, Plugable plugable) {
        DlgPanelComputeStd panel = this.createPanel(store, plugable);
        panel.configureAttrs(store.getAttributes());
        panel.create();
        this.copyToCtrl(panel);
        Window owner = plugable.getWindow();
        DlgParametersCompute dlg = new DlgParametersCompute(owner, this.getTitle(), panel);
        dlg.pack();
        dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf((Component)owner));
        dlg.setVisible(true);
        if (dlg.getResult()) {
            this.copyFromCtrl(panel);
            return true;
        }
        return false;
    }

    @Override
    public void generateComputeScript(Appendable output, BooleanNode rootNode, boolean forAralia, String pathResult, Iterator<BooleanNode> iterNodes) throws IOException {
        String root = rootNode.getEngineName();
        if (pathResult != null && this._missionTimeSec >= 0.0 && this._prType != TypeProbability.NONE) {
            if (this._limitOrder > 0) {
                if (forAralia) {
                    output.append("option set clear-useless-computations on;\n");
                }
                output.append("compute ").append(forAralia ? "p-BDD" : "PBDD").append(" truncated ").append(Integer.toString(this._limitOrder)).append(" to pseudo-BDD ").append(root).append(";\n");
                output.append("compute ZQC from pseudo-BDD to good-ZQC ").append(root).append(";\n");
                if (this._prType == TypeProbability.BDD) {
                    output.append("compute back from good-ZQC to good-BDD ").append(root).append(";\n");
                    output.append("compute Pr from good-BDD ").append(root).append(" > \"");
                } else {
                    output.append("compute Pr from good-ZQC ").append(root).append(" > \"");
                }
            } else {
                output.append("compute BDD to good-BDD ").append(root).append(";\n");
                output.append("compute ZQC from good-BDD to good-ZQC ").append(root).append(";\n");
                if (this._prType == TypeProbability.BDD) {
                    output.append("compute Pr from good-BDD ").append(root).append(" > \"");
                } else {
                    output.append("compute Pr from good-ZQC ").append(root).append(" > \"");
                }
            }
            output.append(pathResult);
            output.append("\";\n");
        } else if (this._limitOrder > 0) {
            if (forAralia) {
                output.append("option set clear-useless-computations on;\n");
            }
            output.append("compute ").append(forAralia ? "p-BDD" : "PBDD").append(" truncated ").append(Integer.toString(this._limitOrder)).append(" to pseudo-BDD ").append(root).append(";\n");
            output.append("compute ZQC from pseudo-BDD to good-ZQC ").append(root).append(";\n");
        } else {
            output.append("compute BDD to good-BDD ").append(root).append(";\n");
            output.append("compute ZQC from good-BDD to good-ZQC ").append(root).append(";\n");
        }
        output.append("display products good-ZQC ").append(root).append(" >> \"");
        output.append(pathResult);
        output.append("\";\n");
    }

    static class DlgParametersCompute
    extends JDialogCecilia {
        DlgPanelComputeStd _options;

        DlgParametersCompute(Window owner, String title, DlgPanelComputeStd options) {
            super(owner, title, true);
            this._options = options;
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this._options, "Center");
            this.getContentPane().add((Component)this.createButPanel(true), "South");
            this.init();
        }

        protected boolean verifyParameters() {
            return this._options.verifyParameters();
        }
    }
}

