/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.swing.other.PartialCheckBox;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.lib.util.io.XMLWriter;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ParamCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.DlgPanelComputeMCS;
import com.dassault.cecilia.plugin.faulttree.compute.compute.DlgPanelComputeStd;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeAbstract;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ParamComputeMCS
extends ParamComputeAbstract {
    private static Logger _LOG = Logger.getLogger(ParamComputeMCS.class.getPackage().getName());
    boolean _isBigTree = false;
    Boolean _computePrForGate = false;
    Map<ParamCompute.TypeImportanceFactor, Boolean> _importanceFactors = new HashMap<ParamCompute.TypeImportanceFactor, Boolean>();
    boolean _withImportanceFactor = true;
    String _criticity = "";
    protected static final String XML_ELT_PARAMS_MCS = "MCS";
    private static final String PROP_MCSCOMPUTE_TRUNCATED = "cecilia.ft.engine.ComputePrProcessTruncated";

    public void setBigTree(boolean value) {
        this._isBigTree = value;
    }

    public Boolean getComputePrForGate() {
        return this._computePrForGate;
    }

    public void setComputePrForGate(Boolean value) {
        this._computePrForGate = value;
    }

    public Map<ParamCompute.TypeImportanceFactor, Boolean> getImportanceFactors() {
        return this._importanceFactors;
    }

    public void setImportanceFactors(Map<ParamCompute.TypeImportanceFactor, Boolean> map) {
        this._importanceFactors = map;
    }

    public void setCriticity(String value) {
        this._criticity = value;
    }

    public String getCriticity() {
        return this._criticity;
    }

    @Override
    public String getAbstract() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.getAbstract());
        if (this._prType == TypeProbability.BDD && this._computePrForGate.booleanValue()) {
            sb.append(ResCompute.getString("DLG_PARAM_GATE")).append("\n");
        }
        if (this._importanceFactors.size() > 0) {
            boolean ifHeader = false;
            for (Map.Entry<ParamCompute.TypeImportanceFactor, Boolean> eIF : this._importanceFactors.entrySet()) {
                if (!eIF.getValue().booleanValue()) continue;
                if (!ifHeader) {
                    ifHeader = true;
                    sb.append(ResCompute.getString("DLG_PARAM_IF")).append(" : ");
                } else {
                    sb.append(", ");
                }
                sb.append(eIF.getKey().toString());
            }
            if (ifHeader) {
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public String getShortAbstract() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getShortAbstract());
        if (this._prType == TypeProbability.BDD && this._computePrForGate.booleanValue()) {
            sb.append(" G");
        }
        if (this._importanceFactors.size() > 0) {
            boolean ifHeader = false;
            for (Map.Entry<ParamCompute.TypeImportanceFactor, Boolean> eIF : this._importanceFactors.entrySet()) {
                if (!eIF.getValue().booleanValue()) continue;
                if (!ifHeader) {
                    ifHeader = true;
                    sb.append(" IF");
                }
                sb.append(eIF.getKey().getInitial());
            }
        }
        if (!this._criticity.isEmpty()) {
            sb.append(" C!").append(this._criticity);
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ParamComputeMCS)) {
            return false;
        }
        ParamComputeMCS other = (ParamComputeMCS)obj;
        if (this._computePrForGate != other._computePrForGate) {
            return false;
        }
        if (this._importanceFactors.size() != other._importanceFactors.size()) {
            return false;
        }
        for (Map.Entry<ParamCompute.TypeImportanceFactor, Boolean> eIF : this._importanceFactors.entrySet()) {
            Boolean otherIF = other._importanceFactors.get((Object)eIF.getKey());
            if (otherIF != null && otherIF.equals(eIF.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = 19 * hashCode + (this._computePrForGate != null && this._computePrForGate != false ? 1 : 0);
        hashCode = 23 * hashCode + this._importanceFactors.hashCode();
        return hashCode;
    }

    public void copy(ParamComputeMCS src) {
        super.copy(src);
        this._computePrForGate = src._computePrForGate;
        this._importanceFactors.clear();
        for (Map.Entry<ParamCompute.TypeImportanceFactor, Boolean> eIF : src._importanceFactors.entrySet()) {
            this._importanceFactors.put(eIF.getKey(), eIF.getValue());
        }
        this._criticity = src._criticity;
    }

    public ParamComputeMCS() {
    }

    public ParamComputeMCS(ParamComputeAbstract parameters) {
        this();
        this.copy(parameters);
    }

    @Override
    public void saveToXML(Appendable output, String indent, String appendPrAttribute) throws IOException {
        output.append(indent).append("<ftc.parameters type='MCS'>\n");
        output.append(indent).append("  <memory");
        output.append(" config='").append(Integer.toString(this.getMemory())).append("'");
        output.append("/>\n");
        output.append(indent).append("  <cuts");
        output.append(" truncated='").append(Integer.toString(this._limitOrder)).append("'");
        if (!this._criticity.isEmpty()) {
            output.append(" criticity='").append(XMLWriter.toXML((String)this._criticity)).append("'");
        }
        output.append("/>\n");
        output.append(indent).append("  <pr");
        output.append(" mission-time='").append(Double.toString(this._missionTimeSec)).append("'");
        output.append(" type='").append(this._prType.toString()).append("'");
        output.append(" gate='").append(Boolean.toString(this._computePrForGate)).append("'");
        if (appendPrAttribute != null) {
            output.append(appendPrAttribute);
        }
        output.append("/>\n");
        for (Map.Entry<ParamCompute.TypeImportanceFactor, Boolean> eIF : this._importanceFactors.entrySet()) {
            if (!eIF.getValue().booleanValue()) continue;
            output.append(indent).append("  <if");
            output.append(" type='").append(eIF.getKey().toString().toLowerCase()).append("'");
            output.append("/>\n");
        }
        this.savePostTreatmentToXML(output, indent, appendPrAttribute);
        output.append(indent).append("</ftc.parameters>\n");
    }

    @Override
    public void loadFromXML(Element xmlElt) throws SAXException, IOException {
        super.loadFromXML(xmlElt);
        NodeList childs = xmlElt.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node xmlChild = childs.item(i);
            String xmlChildName = xmlChild.getNodeName();
            if (xmlChildName.equals("cuts")) {
                String criticity = ((Element)xmlChild).getAttribute("criticity");
                if (criticity == null) continue;
                this._criticity = criticity;
                continue;
            }
            if (xmlChildName.equals("pr")) {
                String gate = ((Element)xmlChild).getAttribute("gate");
                this._computePrForGate = "true".equals(gate);
                continue;
            }
            if (!xmlChildName.equals("if")) continue;
            String type = ((Element)xmlChild).getAttribute("type");
            ParamCompute.TypeImportanceFactor IF = ParamCompute.TypeImportanceFactor.valueOf("cpr".equals(type) ? "CPr" : type.toUpperCase());
            if (IF == null) {
                throw new SAXException("Unknown type '" + type + "'");
            }
            this._importanceFactors.put(IF, true);
        }
    }

    @Override
    protected String getTypeCompute() {
        return XML_ELT_PARAMS_MCS;
    }

    @Override
    public void copyToCtrl(DlgPanelComputeStd panel) {
        super.copyToCtrl(panel);
        if (!(panel instanceof DlgPanelComputeMCS)) {
            return;
        }
        DlgPanelComputeMCS cutsPanel = (DlgPanelComputeMCS)panel;
        cutsPanel._withoutPrGate = this._isBigTree;
        if (this._computePrForGate == null) {
            cutsPanel._ctrlPrGate.setSelected(false);
            cutsPanel._ctrlPrGate.setState(PartialCheckBox.State.PARTIAL);
            cutsPanel._ctrlPrGate.updateUI();
        } else {
            cutsPanel._ctrlPrGate.setSelected(this._computePrForGate.booleanValue());
            cutsPanel._ctrlPrGate.updateUI();
        }
        cutsPanel._selectIFs.clear();
        if (this._importanceFactors == null) {
            this._importanceFactors = new LinkedHashMap<ParamCompute.TypeImportanceFactor, Boolean>();
            cutsPanel._ctrlIFCheck.setPartial(true);
        } else {
            for (Map.Entry<ParamCompute.TypeImportanceFactor, Boolean> eIF : this._importanceFactors.entrySet()) {
                if (!eIF.getValue().booleanValue()) continue;
                cutsPanel._selectIFs.add(eIF.getKey());
            }
            cutsPanel._ctrlIFCheck.setSelected(cutsPanel._selectIFs.size() > 0);
        }
        cutsPanel._ctrlIFCheck.updateUI();
        panel.updateCtrls();
    }

    @Override
    public void copyFromCtrl(DlgPanelComputeStd panel) {
        super.copyFromCtrl(panel);
        if (!(panel instanceof DlgPanelComputeMCS)) {
            return;
        }
        DlgPanelComputeMCS cutsPanel = (DlgPanelComputeMCS)panel;
        if (this._prType == TypeProbability.BDD) {
            if (cutsPanel._ctrlPrGate.isEnabled() && cutsPanel._ctrlPrGate.getState() != PartialCheckBox.State.PARTIAL) {
                this._computePrForGate = cutsPanel._ctrlPrGate.isSelected();
            }
            if (!cutsPanel._ctrlIFCheck.isPartial()) {
                this._importanceFactors.clear();
                for (ParamCompute.TypeImportanceFactor IF : cutsPanel._selectIFs) {
                    this._importanceFactors.put(IF, true);
                }
            }
        } else {
            this._computePrForGate = false;
        }
    }

    @Override
    public DlgPanelComputeStd createPanel(BooleanStore store, Plugable plugable) {
        return new DlgPanelComputeMCS(plugable.getAppl().isReader());
    }

    @Override
    protected String getTitle() {
        return ResCompute.getString("PLUG_CMD_NOMINAL_NAME");
    }

    @Override
    public void generateComputeScript(Appendable output, BooleanNode rootNode, boolean forAralia, String pathResult, Iterator<BooleanNode> iterNodes) throws IOException {
        block21: {
            String root = rootNode.getEngineName();
            String prBDD = null;
            if (pathResult != null && this._missionTimeSec >= 0.0 && this._prType != TypeProbability.NONE) {
                if (this._limitOrder > 0) {
                    if (forAralia && (this._prType != TypeProbability.BDD || !this._computePrForGate.booleanValue())) {
                        output.append("option set clear-useless-computations on;\n");
                        _LOG.finest("Aralia4: option set clear-useless-computations on;");
                    }
                    output.append("compute ").append(forAralia ? "p-BDD" : "PBDD").append(" truncated ").append(Integer.toString(this._limitOrder)).append(" to pseudo-BDD ").append(root).append(";\n");
                    output.append("compute ZQC from pseudo-BDD to good-ZQC ").append(root).append(";\n");
                    if (this._prType == TypeProbability.BDD) {
                        if (this._computePrForGate.booleanValue() && !Boolean.getBoolean(PROP_MCSCOMPUTE_TRUNCATED)) {
                            output.append("compute Pr from pseudo-BDD * > \"").append(pathResult).append("\";\n");
                        }
                        output.append("compute back from good-ZQC to good-BDD ").append(root).append(";\n");
                        if (this._computePrForGate.booleanValue() && Boolean.getBoolean(PROP_MCSCOMPUTE_TRUNCATED)) {
                            while (iterNodes.hasNext()) {
                                String name;
                                BooleanNode node = iterNodes.next();
                                if (node.isLeaf() || (name = node.getEngineName()).equals(root)) continue;
                                output.append("compute ").append(forAralia ? "p-BDD" : "PBDD").append(" truncated ").append(Integer.toString(this._limitOrder)).append(" to pseudo-BDD ").append(name).append(";\n");
                                output.append("compute ZQC from pseudo-BDD to good-ZQC ").append(name).append(";\n");
                                output.append("compute back from good-ZQC to good-BDD ").append(name).append(";\n");
                                output.append("compute Pr from good-BDD ").append(name).append(" >> \"").append(pathResult).append("\";\n");
                            }
                        }
                        output.append("compute Pr from good-BDD ").append(root).append(" >> \"");
                        prBDD = "good-BDD";
                    } else {
                        output.append("compute Pr from good-ZQC ").append(root).append(" > \"");
                    }
                } else {
                    output.append("compute BDD to good-BDD *;\n");
                    prBDD = "good-BDD";
                    output.append("compute ZQC from good-BDD to good-ZQC ").append(root).append(";\n");
                    if (this._prType == TypeProbability.BDD) {
                        if (this._computePrForGate.booleanValue()) {
                            output.append("compute Pr from good-BDD * > \"");
                        } else {
                            output.append("compute Pr from good-BDD ").append(root).append(" > \"");
                        }
                    } else {
                        output.append("compute Pr from good-ZQC ").append(root).append(" > \"");
                    }
                }
                output.append(pathResult);
                output.append("\";\n");
            } else if (this._limitOrder > 0) {
                if (forAralia && (this._prType != TypeProbability.BDD || !this._computePrForGate.booleanValue())) {
                    output.append("option set clear-useless-computations on;\n");
                    _LOG.finest("Aralia4: option set clear-useless-computations on;");
                }
                output.append("compute ").append(forAralia ? "p-BDD" : "PBDD").append(" truncated ").append(Integer.toString(this._limitOrder)).append(" to pseudo-BDD ").append(root).append(";\n");
                output.append("compute ZQC from pseudo-BDD to good-ZQC ").append(root).append(";\n");
            } else {
                output.append("compute BDD to good-BDD ").append(root).append(";\n");
                output.append("compute ZQC from good-BDD to good-ZQC ").append(root).append(";\n");
            }
            output.append("display products good-ZQC ").append(root).append(" >> \"");
            output.append(pathResult);
            output.append("\";\n");
            if (prBDD == null || this._prType != TypeProbability.BDD) break block21;
            if (forAralia) {
                for (Map.Entry<ParamCompute.TypeImportanceFactor, Boolean> eIF : this._importanceFactors.entrySet()) {
                    if (!eIF.getValue().booleanValue()) continue;
                    output.append("compute ").append(eIF.getKey().toString()).append(" from ").append(prBDD).append(" ").append(root).append(" leaves(").append(root).append(") >> \"");
                    output.append(pathResult).append("\";\n");
                }
            } else {
                for (Map.Entry<ParamCompute.TypeImportanceFactor, Boolean> eIF : this._importanceFactors.entrySet()) {
                    if (!eIF.getValue().booleanValue()) continue;
                    output.append("compute IF from ").append(prBDD).append(" ").append(root).append(" >> \"");
                    output.append(pathResult).append("\";\n");
                    break;
                }
            }
        }
    }
}

