/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.lib.util.io.XMLWriter;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.DlgPanelComputeMEL;
import com.dassault.cecilia.plugin.faulttree.compute.compute.DlgPanelComputeMELInteractive;
import com.dassault.cecilia.plugin.faulttree.compute.compute.DlgPanelComputeStd;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeAbstract;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParamComputeMEL
extends ParamComputeAbstract {
    Boolean _simplifiedMode = false;
    Boolean _pessimistCompute = false;
    Boolean _useMCSResult = false;
    Boolean _melList = false;
    File _melListFile = null;
    protected static final String XML_ELT_PARAMS_MEL = "MEL";

    protected boolean forceSimplifedMode() {
        return false;
    }

    public boolean isSimplifiedMode() {
        return this._simplifiedMode;
    }

    public void setSimplifiedMode(Boolean value) {
        this._simplifiedMode = value;
    }

    protected boolean forcePessimistCompute() {
        return false;
    }

    public boolean withPessimistCompute() {
        return this._pessimistCompute;
    }

    public void setPessimistCompute(Boolean pessimistCompute) {
        this._pessimistCompute = this._limitOrder != null && this._limitOrder < -1 ? Boolean.valueOf(false) : pessimistCompute;
    }

    public boolean withMCSResult() {
        return this._useMCSResult;
    }

    public void setUseMCSResult(Boolean value) {
        this._useMCSResult = value;
    }

    public boolean withListMEL() {
        return this._melList;
    }

    public void setWithListMEL(Boolean listMEL) {
        this._melList = listMEL;
    }

    public File getListFileMEL() {
        return this._melListFile;
    }

    public void setListFileMEL(File file) {
        this._melListFile = file;
    }

    @Override
    public String getAbstract() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.getAbstract());
        if (this._simplifiedMode.booleanValue()) {
            sb.append(ResCompute.getString("DLG_PARAM_MEL_SIMPLIFIED")).append("\n");
        } else if (this._limitOrder > 0 && this._pessimistCompute.booleanValue()) {
            sb.append(ResCompute.getString("DLG_PARAM_MEL_APPROX")).append("\n");
        }
        if (this._melList.booleanValue() && this._melListFile != null) {
            sb.append(ResCompute.getString("DLG_PARAM_MEL_LIST")).append(" : ");
            sb.append(this._melListFile.toString()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public String getShortAbstract() {
        StringBuilder sb = new StringBuilder();
        if (this._simplifiedMode.booleanValue()) {
            sb.append("# ");
            sb.append(this._prType.toString());
            if (this._prType != TypeProbability.NONE) {
                sb.append(" ").append(this.getMissionTimeH());
            }
        } else {
            if (this._limitOrder > 0 && this._pessimistCompute.booleanValue()) {
                sb.append("~");
            }
            sb.append(super.getShortAbstract());
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ParamComputeMEL)) {
            return false;
        }
        ParamComputeMEL other = (ParamComputeMEL)obj;
        if (this._simplifiedMode != other._simplifiedMode) {
            return false;
        }
        if (this._pessimistCompute != other._pessimistCompute) {
            return false;
        }
        if (this._melList != other._melList) {
            return false;
        }
        return this._melList == false || this._melListFile.getAbsolutePath().equals(other._melListFile.getAbsolutePath());
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = 19 * hashCode + (this._melList != null && this._melList != false ? 1 : 0);
        hashCode = 23 * hashCode + (this._melListFile != null ? this._melListFile.hashCode() : 0);
        hashCode = 29 * hashCode + (this._simplifiedMode != null && this._simplifiedMode != false ? 1 : 0);
        hashCode = 37 * hashCode + (this._pessimistCompute != null && this._pessimistCompute != false ? 1 : 0);
        return hashCode;
    }

    public void copy(ParamComputeMEL src) {
        super.copy(src);
        this._simplifiedMode = src._simplifiedMode;
        this._pessimistCompute = src._pessimistCompute;
        this._melList = src._melList;
        if (this._melList.booleanValue()) {
            this._melListFile = src._melListFile;
        }
    }

    public Collection<String> getEvents(BooleanStore store, Collection<String> missingEvents) throws IOException {
        if (this._melList.booleanValue()) {
            return ParamComputeMEL.getEvents(store, this._melListFile, missingEvents);
        }
        ArrayList<String> events = new ArrayList<String>();
        Iterator<BooleanNode> iNode = store.iterate();
        while (iNode.hasNext()) {
            BooleanNode node = iNode.next();
            if (!node.isLeaf()) continue;
            events.add(node.getEngineName());
        }
        return events;
    }

    public static Collection<String> getEvents(final BooleanStore store, File eventsFile, final Collection<String> missingEvents) throws IOException {
        final LinkedHashSet<String> events = new LinkedHashSet<String>();
        DefaultHandler handler = null;
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            handler = new DefaultHandler(){

                @Override
                public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
                    String eltName;
                    if (attrs == null) {
                        return;
                    }
                    String string = eltName = "".equals(sName) ? qName : sName;
                    if (eltName.equals("EVENT")) {
                        int idx = attrs.getIndex("NAME");
                        if (idx == -1) {
                            throw new SAXException("No attribute 'NAME' for element 'EVENT' !");
                        }
                        String name = attrs.getValue(idx);
                        if (store != null) {
                            BooleanNode event = store.getNode(name);
                            if (event == null) {
                                if (missingEvents != null) {
                                    missingEvents.add(name);
                                }
                            } else {
                                events.add(event.getEngineName());
                            }
                        }
                    } else if (!eltName.equals("EVENT_SET") && !eltName.equals("EXPORT")) {
                        throw new SAXException("Element '" + eltName + "' unknown !");
                    }
                }
            };
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse(eventsFile, handler);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append("SAX Parser Exception\n");
            sb.append(e.getMessage());
            throw new IOException(sb.toString(), e);
        }
        return events;
    }

    @Override
    protected String getTypeCompute() {
        return XML_ELT_PARAMS_MEL;
    }

    @Override
    public void saveToXML(Appendable output, String indent, String appendPrAttribute) throws IOException {
        output.append(indent).append("<ftc.parameters type='MEL'>\n");
        output.append(indent).append("  <memory");
        output.append(" config='").append(Integer.toString(this.getMemory())).append("'");
        output.append("/>\n");
        output.append(indent).append("  <cuts");
        if (!this.forceSimplifedMode()) {
            output.append(" simplified='").append(Boolean.toString(this._simplifiedMode)).append("'");
        }
        if (!this._simplifiedMode.booleanValue()) {
            output.append(" truncated='").append(Integer.toString(this._limitOrder)).append("'");
            if (!this.forcePessimistCompute()) {
                output.append(" approximate='").append(Boolean.toString(this._pessimistCompute)).append("'");
            }
        }
        output.append("/>\n");
        output.append(indent).append("  <pr");
        output.append(" mission-time='").append(Double.toString(this._missionTimeSec)).append("'");
        output.append(" type='").append(this._prType.toString()).append("'");
        if (appendPrAttribute != null) {
            output.append(appendPrAttribute);
        }
        output.append("/>\n");
        if (this._melList.booleanValue()) {
            output.append(indent).append("  <filter");
            output.append(" file='").append(XMLWriter.toXML((String)this._melListFile.getAbsolutePath())).append("'");
            output.append("/>\n");
        }
        this.savePostTreatmentToXML(output, indent, appendPrAttribute);
        output.append(indent).append("</ftc.parameters>\n");
    }

    @Override
    public void loadFromXML(Element xmlElt) throws SAXException, IOException {
        super.loadFromXML(xmlElt);
        NodeList childs = xmlElt.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node xmlChild = childs.item(i);
            String xmlChildName = xmlChild.getNodeName();
            if (xmlChildName.equals("cuts")) {
                String approx;
                if (!this.forceSimplifedMode()) {
                    approx = ((Element)xmlChild).getAttribute("simplified");
                    this._simplifiedMode = "true".equals(approx);
                }
                if (this._simplifiedMode.booleanValue() || this.forcePessimistCompute()) continue;
                approx = ((Element)xmlChild).getAttribute("approximate");
                this._pessimistCompute = "true".equals(approx);
                continue;
            }
            if (!xmlChildName.equals("filter")) continue;
            String file = ((Element)xmlChild).getAttribute("file");
            this._melListFile = new File(file);
            this._melList = true;
        }
    }

    @Override
    public void copyToCtrl(DlgPanelComputeStd panel) {
        super.copyToCtrl(panel);
        if (!(panel instanceof DlgPanelComputeMEL)) {
            return;
        }
        DlgPanelComputeMEL melPanel = (DlgPanelComputeMEL)panel;
        melPanel.configureApproximate(this._pessimistCompute, this.forcePessimistCompute());
        melPanel.configureListFile(this._melList, this._melListFile);
        melPanel.configureSimplified(this._simplifiedMode, this.forceSimplifedMode());
        panel.updateCtrls();
    }

    @Override
    public void copyFromCtrl(DlgPanelComputeStd panel) {
        super.copyFromCtrl(panel);
        if (!(panel instanceof DlgPanelComputeMEL)) {
            return;
        }
        DlgPanelComputeMEL melPanel = (DlgPanelComputeMEL)panel;
        if (melPanel.isSimplified() != null) {
            this._simplifiedMode = melPanel.isSimplified();
        }
        if (melPanel.isApproximate() != null) {
            this._pessimistCompute = melPanel.isApproximate();
        }
        this._melListFile = melPanel.getListFile();
        this._melList = this._melListFile != null;
    }

    @Override
    public DlgPanelComputeStd createPanel(BooleanStore store, Plugable plugable) {
        return new DlgPanelComputeMELInteractive(plugable, store);
    }

    @Override
    protected String getTitle() {
        return ResCompute.getString("PLUG_CMD_MEL_NAME");
    }
}

