/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.Util;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.DBKTableModel;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.criticity.CriticityResult;
import com.dassault.cecilia.dbobj.faulttree.ft.export.ExpFTCriticityResult;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.lib.util.format.StringUtilities;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanAttribute;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanExpression;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ComputeMCS;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMCS;
import com.dassault.cecilia.plugin.faulttree.compute.export.ExportAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.pref.PrintExportMCS;
import com.dassault.cecilia.plugin.faulttree.compute.results.CriticityResultTableModelFromStore;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilterNone;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class ExportMCS
extends ExportAbstract {
    BooleanResult _result;
    MCS _mcsOrigin;
    MCS _mcsFilter;
    MCSFilter _filter;

    public ExportMCS(BooleanStore store, ParamComputeMCS parameters, BooleanResult result, MCS mcs, PrintExportMCS prefs) {
        super(store, parameters, prefs);
        this._result = result;
        this._mcsFilter = this._mcsOrigin = mcs;
        this._filter = new MCSFilterNone();
    }

    public ExportMCS(ComputeMCS compute, PrintExportMCS prefs) {
        this(compute.getStore(), compute.getParameters(), compute.getResults(), compute.getResults().getMCS(), prefs);
    }

    public ExportMCS setMCSFilter(MCS mcs, MCSFilter filter) {
        this._mcsFilter = mcs;
        this._filter = filter;
        return this;
    }

    @Override
    protected void exportScribeProbabilityRoot(SrbInputStream outScribe, BooleanNode root) {
        double prb = root.getProbability();
        this.exportScribeProbability(outScribe, prb);
    }

    @Override
    protected void exportScribeComputeInformations(SrbInputStream outScribe) {
        String criticity;
        int limit = this._parameters.getLimitOrder();
        outScribe.concat(".br \n");
        outScribe.concat(ResCompute.getString("KEY_0690") + "@:@<HP2>" + (limit <= 0 ? "-" : Integer.toString(limit)) + "<EHP2>\n");
        outScribe.concat(".br \n");
        if (((ParamComputeAbstract)this._parameters).getPostTreatmentDormant().booleanValue()) {
            outScribe.concat(".br \n");
            outScribe.concat(ResCompute.getString("VOC_DORMANT") + "@:@<HP2>" + ResMsgVoc.getString((String)"VOC_YES") + "<EHP2>\n");
            outScribe.concat(".br \n");
        }
        if (((ParamComputeAbstract)this._parameters).getPostTreatmentAtRisk().booleanValue()) {
            outScribe.concat(".br \n");
            outScribe.concat(ResCompute.getString("VOC_ENDOFFLY") + "@:@<HP2>" + this._renderer.formatMissionTime(((ParamComputeAbstract)this._parameters).getSpecificTime()) + "<EHP2>\n");
            outScribe.concat(".br \n");
        }
        if ((criticity = this._store.getInfo(BooleanStore.INFO_CRITICITY)) != null) {
            outScribe.concat(ResMsgVoc.getString((String)"VOC_CRITICITY") + "@:@<HP2>" + criticity + "<EHP2>\n");
            outScribe.concat(".br \n");
            CriticityResult critRes = this._result.getCriticityResult();
            ExpFTCriticityResult res = new ExpFTCriticityResult(new CriticityResultTableModelFromStore(critRes, this._store, this._renderer)){

                protected void logMsg(Level lvl, String msg) {
                }
            };
            try {
                res.writeScribe(outScribe);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void exportFormatScribe(SrbInputStream outScribe) {
        outScribe.concat("<GDOC SEC=''>\n");
        outScribe.concat("<TITLE>" + ResCompute.getString("KEY_0732") + "\n");
        outScribe.concat("<DOCNUM>\n");
        outScribe.concat("<DATE>" + ExportMCS.getCurrentDateAsDDMMYYYY() + "\n");
        outScribe.concat(".ti @\n");
        outScribe.concat(".tp 5 7 18 20 30 35 40 50 60\n");
        outScribe.concat("<BODY>\n");
        this.exportScribeBegining(outScribe);
        this.exportScribeFilterConfiguration(outScribe);
        outScribe.concat("<EUL>\n");
        outScribe.concat(".sk 1\n");
        this.exportScribeDSFConfiguration(outScribe);
        this.exportScribeMCSSummary(outScribe);
        this.exportScribeMCSTable(outScribe);
        this.exportScribeMCSEnd(outScribe);
    }

    protected void exportScribeFilterConfiguration(SrbInputStream outScribe) {
        outScribe.concat("<H1>" + ResCompute.getString("KEY_0733") + "\n");
        outScribe.concat("<UL>\n");
        outScribe.concat("<LI>" + ResCompute.getString("DLG_RESULT_FILTER") + " :<HP2>");
        outScribe.concat(this._filter.getAbstract());
        outScribe.concat("<EHP2>\n");
        outScribe.concat(".br \n");
        outScribe.concat("<LI>" + ResCompute.getString("DLG_RESULT_SORTER") + " : <HP2>" + this._filter.getTypeSorter().getLabel() + "<EHP2>\n");
        outScribe.concat(".br \n");
        int rankLimit = this._filter.getRankLimit();
        if (rankLimit > 0) {
            outScribe.concat("<LI>" + ResCompute.getString("KEY_0744") + " : <HP2>" + Integer.toString(rankLimit) + "<EHP2>\n");
        } else {
            outScribe.concat("<LI>" + ResCompute.getString("KEY_0744") + " : -\n");
        }
        outScribe.concat(".br \n");
    }

    private void exportScribeMCSSummary(SrbInputStream outScribe) {
        String msg;
        outScribe.concat("<H1>" + ResCompute.getString("KEY_0745") + "\n");
        outScribe.concat("<UL>\n");
        outScribe.concat("<LI>" + ResCompute.getString("KEY_0746") + " : <HP2>" + this._mcsOrigin.getCutCount() + "<EHP2>\n");
        outScribe.concat(".br \n");
        if (this._result != null && (msg = this._result.getWarning()) != null) {
            outScribe.concat("<LI>" + msg + "\n.br \n");
        }
        outScribe.concat("<EUL>\n");
        outScribe.concat(".sk 1\n");
        outScribe.concat("<TABLEAU>\n");
        outScribe.concat("<TABTIT>" + ResCompute.getString("KEY_0747") + "\n");
        outScribe.concat("<TABCOL>" + ResMsgVoc.getString((String)"VOC_ORDER") + "\n");
        outScribe.concat("<TABCOL>" + ResMsgVoc.getString((String)"VOC_QUANTITY") + "\n");
        outScribe.concat("<TABCOL>" + ResMsgVoc.getString((String)"VOC_OCCURRENCE") + "\n");
        outScribe.concat("<TABDEF CWIDTH = '10 12 12'   ALIGN = 'C C C'>\n");
        for (int c = 0; c < this._mcsOrigin.getOrderMax(); ++c) {
            int q = this._mcsOrigin.getOrderNumber(c);
            if (q <= 0) continue;
            outScribe.concat("<C>" + c + "\n");
            if (q > 1000000000) {
                outScribe.concat("<C>> 1000000000\n");
            } else {
                outScribe.concat("<C>" + q + "\n");
            }
            double p = this._mcsOrigin.getOrderProbability(c);
            outScribe.concat("<C>" + this._renderer.formatProbability(p) + "\n");
        }
        outScribe.concat("<ETABLEAU>\n");
    }

    protected void exportScribeMCSTabHeader(SrbInputStream out) {
        StringBuffer cwidth = new StringBuffer();
        StringBuffer align = new StringBuffer();
        if (this._prefs.getBooleanValue("Fields.Number")) {
            out.concat("<TABCOL>" + ResMsgVoc.getString((String)"VOC_NUMBER") + "\n");
            cwidth.append("7 ");
            align.append("C ");
        }
        if (this._prefs.getBooleanValue("Fields.Occurence")) {
            out.concat("<TABCOL>" + ResMsgVoc.getString((String)"VOC_OCCURRENCE") + "\n");
            cwidth.append("11 ");
            align.append("C ");
        }
        for (int i = 0; i < 8; ++i) {
            if (!this._prefs.getBooleanValue("Fields.IF." + i)) continue;
            out.concat("<TABCOL>" + ResMsgObj.getString((String)PrintExportMCS.getIFKeyName(i)) + "\n");
            cwidth.append("15 ");
            align.append("C ");
        }
        out.concat("<TABCOL>" + ResMsgVoc.getString((String)"VOC_NAME") + "\n");
        cwidth.append("20 ");
        align.append("L ");
        if (this._prefs.getBooleanValue("Fields.Comment")) {
            out.concat("<TABCOL>" + ResMsgVoc.getString((String)"VOC_COMMENT") + "\n");
            cwidth.append("20 ");
            align.append("L ");
        }
        if (this._prefs.getBooleanValue("Fields.Law")) {
            out.concat("<TABCOL>" + ResMsgVoc.getString((String)"VOC_LAW") + "\n");
            cwidth.append("15 ");
            align.append("C ");
        }
        if (this._prefs.getBooleanValue("Fields.Inspected")) {
            out.concat("<TABCOL>" + ResMsgVoc.getString((String)"VOC_PERIODICITY") + "\n");
            cwidth.append("12 ");
            align.append("C ");
        }
        if (this._prefs.getBooleanValue("Fields.InflightTested")) {
            out.concat("<TABCOL>" + ResMsgVoc.getString((String)"VOC_EXPORURE_TIME") + "\n");
            cwidth.append("10 ");
            align.append("C ");
        }
        if (this._prefs.getBooleanValue("Fields.Properties")) {
            out.concat("<TABCOL>" + ResMsgVoc.getString((String)"VOC_PROPERTIES") + "\n");
            cwidth.append("11 ");
            align.append("C ");
        }
        if (this._prefs.getBooleanValue("Fields.BTP")) {
            out.concat("<TABCOL>" + ResMsgVoc.getString((String)"VOC_FRB") + "\n");
            cwidth.append("20 ");
            align.append("L ");
        }
        if (this._prefs.getBooleanValue("Fields.FMEA")) {
            out.concat("<TABCOL>" + ResMsgVoc.getString((String)"VOC_FMEA") + "\n");
            cwidth.append("20 ");
            align.append("L ");
        }
        if (this._prefs.getBooleanValue("Fields.Attributes")) {
            out.concat("<TABCOL>" + ResMsgVoc.getString((String)"VOC_ATTRIBUTES") + "\n");
            cwidth.append("20 ");
            align.append("L ");
        }
        if (cwidth.charAt(cwidth.length() - 1) == ' ') {
            cwidth.deleteCharAt(cwidth.length() - 1);
        }
        if (align.charAt(align.length() - 1) == ' ') {
            align.deleteCharAt(align.length() - 1);
        }
        out.concat("<TABDEF CWIDTH = '" + cwidth + "'   ALIGN = '" + align + "'>\n");
    }

    protected void exportScribeEventInTab(SrbInputStream out, int index, double proba, Evt evt) {
        Object obj;
        if (this._prefs.getBooleanValue("Fields.Number")) {
            out.concat("<C>" + (index > 0 ? Integer.toString(index) : " ") + "\n");
        }
        if (this._prefs.getBooleanValue("Fields.Occurence")) {
            String occurrence = " ";
            if (index > 0) {
                occurrence = this._renderer.formatProbability(proba);
            }
            out.concat("<C>" + occurrence + "\n");
        }
        out.concat("<C>" + this.convertName(evt.getName()) + "\n");
        if (this._prefs.getBooleanValue("Fields.Comment")) {
            out.concat("<C>");
            this.exportScribeComment(out, this.convertComment((String)evt.getInfo(Evt.KeyInfo.COMMENT, this._renderer)));
            out.concat("\n");
        }
        if (this._prefs.getBooleanValue("Fields.Law")) {
            obj = evt.getInfo(Evt.KeyInfo.LAW, this._renderer);
            out.concat("<C>" + (obj == null ? "-" : obj.toString()) + "\n");
        }
        if (this._prefs.getBooleanValue("Fields.Inspected")) {
            obj = evt.getInfo(Evt.KeyInfo.INSPECTED_VALUE, null);
            out.concat("<C>" + (String)(obj == null ? "-" : obj.toString() + " h") + "\n");
        }
        if (this._prefs.getBooleanValue("Fields.InflightTested")) {
            obj = evt.getInfo(Evt.KeyInfo.TESTED_VALUE, null);
            out.concat("<C>" + (String)(obj == null ? "-" : obj.toString() + " h") + "\n");
        }
        if (this._prefs.getBooleanValue("Fields.Properties")) {
            StringBuffer properties = new StringBuffer();
            if (((Boolean)evt.getInfo(Evt.KeyInfo.UNDEVELOPPED, this._renderer)).booleanValue()) {
                properties.append("U ");
            }
            if (((Boolean)evt.getInfo(Evt.KeyInfo.SUBTREE, this._renderer)).booleanValue()) {
                properties.append("ST ");
            }
            if (evt.getInfo(Evt.KeyInfo.INSPECTED, this._renderer) != null) {
                properties.append("EI ");
            }
            if (evt.getInfo(Evt.KeyInfo.TESTED, this._renderer) != null) {
                properties.append("ITE ");
            }
            if (((Boolean)evt.getInfo(Evt.KeyInfo.GSR, this._renderer)).booleanValue()) {
                properties.append("GSR ");
            }
            out.concat("<C>" + properties + "\n");
        }
        if (this._prefs.getBooleanValue("Fields.BTP")) {
            obj = evt.getInfo(Evt.KeyInfo.BTP, this._renderer);
            out.concat("<C>" + (obj == null ? "-" : obj.toString()) + "\n");
        }
        if (this._prefs.getBooleanValue("Fields.FMEA")) {
            obj = evt.getInfo(Evt.KeyInfo.FMEA, this._renderer);
            out.concat("<C>" + (obj == null ? "-" : obj.toString()) + "\n");
        }
        if (this._prefs.getBooleanValue("Fields.Attributes")) {
            Iterator<? extends Attr> itr = evt.getAttributs().iterator();
            boolean first = true;
            while (itr.hasNext()) {
                Attr attr = itr.next();
                if (attr.getKey().getType() == AttrType.FIELD || !first) continue;
                first = false;
                out.concat("<C>" + this.exportOneAttribute(attr) + "\n");
                break;
            }
            if (first) {
                out.concat("<C>-\n");
            }
        }
    }

    protected void exportScribeEventAttributesInTab(SrbInputStream out, Evt evt, int skipCols) {
        Iterator<? extends Attr> itr = evt.getAttributs().iterator();
        boolean first = true;
        while (itr.hasNext()) {
            Attr attr = itr.next();
            if (attr.getKey().getType() == AttrType.FIELD) continue;
            if (first) {
                first = false;
                continue;
            }
            for (int col = 0; col < skipCols; ++col) {
                out.concat("<C>\n");
            }
            out.concat("<C>" + this.exportOneAttribute(attr) + "\n");
        }
    }

    private void exportScribeMCSTable(SrbInputStream outScribe) {
        if (this._filter.getTypeSorter() == MCSSorter.Type.PROBA_ORDER_LEXIC) {
            outScribe.concat("<H1>" + ResCompute.getString("KEY_0732") + "\n");
            this.exportScribeMCSTable(outScribe, this._mcsFilter);
        } else {
            int skipCols = this.countMCSColumns();
            boolean withAttribute = this._prefs.getBooleanValue("Fields.Attributes");
            int index = 0;
            int curOrder = -1;
            MCS.CutIterator cutIter = this._mcsFilter.cutIterate();
            while (cutIter.hasNext()) {
                Cut cut = cutIter.next();
                int order = cut.getOrder();
                if (order != curOrder) {
                    if (curOrder != -1) {
                        outScribe.concat("<ETABLEAU>\n");
                    }
                    outScribe.concat("<H1>" + ResCompute.getString("KEY_0748") + " " + order + "\n");
                    outScribe.concat("<TABLEAU>\n");
                    outScribe.concat("<TABTIT>" + ResCompute.getString("KEY_0732") + "\n");
                    this.exportScribeMCSTabHeader(outScribe);
                    curOrder = order;
                    index = 1;
                } else {
                    ++index;
                }
                for (int e = 0; e < cut.getOrder(); ++e) {
                    Evt evt = cut.getEvent(e);
                    if (e == 0) {
                        this.exportScribeEventInTab(outScribe, index, cut.getProbability(), evt);
                    } else {
                        this.exportScribeEventInTab(outScribe, -1, -1.0, evt);
                    }
                    if (!withAttribute) continue;
                    this.exportScribeEventAttributesInTab(outScribe, evt, skipCols);
                }
            }
            if (curOrder != -1) {
                outScribe.concat("<ETABLEAU>\n");
            }
        }
    }

    protected void exportScribeMCSTable(SrbInputStream outScribe, MCS mcs) {
        outScribe.concat("<TABLEAU>\n");
        outScribe.concat("<TABTIT>" + ResCompute.getString("KEY_0732") + "\n");
        this.exportScribeMCSTabHeader(outScribe);
        int skipCols = this.countMCSColumns();
        boolean withAttribute = this._prefs.getBooleanValue("Fields.Attributes");
        MCS.CutIterator cutIter = mcs.cutIterate();
        int index = 1;
        while (cutIter.hasNext()) {
            Cut cut = cutIter.next();
            for (int e = 0; e < cut.getOrder(); ++e) {
                Evt evt = cut.getEvent(e);
                if (e == 0) {
                    this.exportScribeEventInTab(outScribe, index, cut.getProbability(), evt);
                } else {
                    this.exportScribeEventInTab(outScribe, -1, -1.0, evt);
                }
                if (!withAttribute) continue;
                this.exportScribeEventAttributesInTab(outScribe, evt, skipCols);
            }
            ++index;
        }
        outScribe.concat("<ETABLEAU>\n");
    }

    protected void exportScribeLimitedWidth(SrbInputStream outScribe, String msg, int maxCar, String startAddLines, String endOfLine) {
        List lines = StringUtilities.splitWordsLimitedWidth((String)msg, (int)maxCar);
        boolean firstLine = true;
        for (String line : lines) {
            if (firstLine) {
                firstLine = false;
                outScribe.concat(line + "\n");
            } else {
                outScribe.concat(startAddLines + line + "\n");
            }
            outScribe.concat(endOfLine);
        }
    }

    @Override
    protected void exportScribeMCSReminderAdditionnalInformations(SrbInputStream outScribe) {
        if (((ParamComputeAbstract)this._parameters).getPostTreatmentDormant().booleanValue()) {
            outScribe.concat("<LI>" + ResCompute.getString("PTD_TITLE") + " :\n");
            outScribe.concat(".br \n");
            this.exportScribeLimitedWidth(outScribe, "* @:@" + ResCompute.getString("PTD_EXPORT_REMINDER"), 80, " @ @  ", ".br \n");
            outScribe.concat(".sk 1\n");
        }
        if (((ParamComputeAbstract)this._parameters).getPostTreatmentAtRisk().booleanValue() && Boolean.getBoolean("cecilia.ft.compute.EvtAtRiskSharped")) {
            outScribe.concat("<LI>" + ResCompute.getString("PTF_TITLE") + " :\n");
            outScribe.concat(".br \n");
            outScribe.concat(".sk 1\n");
            this.exportScribeLimitedWidth(outScribe, "# @:@" + ResCompute.getString("PTF_EXPORT_REMINDER"), 80, " @ @  ", ".br \n");
            outScribe.concat(".sk 1\n");
        }
    }

    @Override
    protected void exportDocBookProbabilityRoot(DBKOutput xmlWriter, BooleanNode root) throws IOException {
        double prb = root.getProbability();
        this.exportDocBookProbability(xmlWriter, prb);
    }

    @Override
    protected void exportDocBookComputeInformations(DBKOutput xmlWriter) throws IOException {
        String criticity;
        int limit = this._parameters.getLimitOrder();
        xmlWriter.write("<para>", false);
        xmlWriter.write(ResCompute.getString("KEY_0690") + " : " + (limit <= 0 ? "-" : Integer.toString(limit)), true);
        xmlWriter.write("</para>\n", false);
        if (((ParamComputeAbstract)this._parameters).getPostTreatmentDormant().booleanValue()) {
            xmlWriter.write("<para>", false);
            xmlWriter.write(ResCompute.getString("PTD_TITLE"), true);
            xmlWriter.write("</para>\n", false);
        }
        if (((ParamComputeAbstract)this._parameters).getPostTreatmentAtRisk().booleanValue()) {
            xmlWriter.write("<para>", false);
            xmlWriter.write(ResCompute.getString("PTF_TITLE") + " : " + this._renderer.formatMissionTime(((ParamComputeAbstract)this._parameters).getSpecificTime()), true);
            xmlWriter.write("</para>\n", false);
        }
        if ((criticity = this._store.getInfo(BooleanStore.INFO_CRITICITY)) != null) {
            xmlWriter.write("<para>", false);
            xmlWriter.write(ResMsgVoc.getString((String)"VOC_CRITICITY") + " : " + criticity, true);
            xmlWriter.write("</para>\n", false);
            CriticityResult critRes = this._result.getCriticityResult();
            ExpFTCriticityResult res = new ExpFTCriticityResult(new CriticityResultTableModelFromStore(critRes, this._store, this._renderer)){

                protected void logMsg(Level lvl, String msg) {
                }
            };
            try {
                res.writeDocbook(xmlWriter);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void exportFormatDocBook(DBKOutput xmlWriter) throws IOException {
        if (xmlWriter.getXmlOutputFile() == null) {
            return;
        }
        xmlWriter.printHeadXML();
        xmlWriter.write("  <info>\n", false);
        xmlWriter.write("    <title>", false);
        xmlWriter.write(ResCompute.getString("PLUG_CMD_NOMINAL_NAME"), true);
        xmlWriter.write("</title>\n", false);
        xmlWriter.write("    <para>", false);
        xmlWriter.write(ResMsgArbor.msgFormat((String)"IO_PRINT_PRODUCTOR", (Object[])new Object[]{"Cecilia WorkShop", "6.3.1"}), true);
        xmlWriter.write("</para>\n", false);
        xmlWriter.write("  </info>\n", false);
        this.exportDocBookBegining(xmlWriter);
        this.exportDocBookFilterConfiguration(xmlWriter);
        this.exportDocBookDSFConfiguration(xmlWriter);
        this.exportDocBookMCSSummary(xmlWriter);
        this.exportDocBookMCSTable(xmlWriter);
        this.exportDocBookEnd(xmlWriter);
        xmlWriter.printFootXML();
    }

    protected void exportDocBookFilterConfiguration(DBKOutput xmlWriter) throws IOException {
        if (this._filter == null) {
            return;
        }
        xmlWriter.writeSection(1, ResCompute.getString("KEY_0733"));
        xmlWriter.write("<para>", false);
        xmlWriter.write(ResCompute.getString("DLG_RESULT_FILTER") + " : " + this._filter.getAbstract(), true);
        xmlWriter.write("</para>\n", false);
        xmlWriter.write("<para>", false);
        xmlWriter.write(ResCompute.getString("DLG_RESULT_SORTER") + " : " + this._filter.getTypeSorter().getLabel(), true);
        xmlWriter.write("</para>\n", false);
        int rankLimit = this._filter.getRankLimit();
        xmlWriter.write("<para>", false);
        if (rankLimit > 0) {
            xmlWriter.write(ResCompute.getString("KEY_0744") + " : " + Integer.toString(rankLimit), true);
        } else {
            xmlWriter.write(ResCompute.getString("KEY_0744") + " : -", true);
        }
        xmlWriter.write("</para>\n", false);
        xmlWriter.writeEndSection(1);
    }

    protected void exportDocBookEventInTab(List<List> rows, List<List> moreRows, int size, int index, double proba, Evt evt) {
        Object obj;
        ArrayList<String> row = new ArrayList<String>();
        ArrayList<Integer> moreRow = new ArrayList<Integer>();
        if (this._prefs.getBooleanValue("Fields.Number")) {
            if (index > 0) {
                row.add(Integer.toString(index));
                moreRow.add(size - 1);
            } else {
                row.add(" ");
                moreRow.add(-1);
            }
        }
        if (this._prefs.getBooleanValue("Fields.Occurence")) {
            String occurrence = " ";
            if (index > 0) {
                occurrence = this._renderer.formatProbability(proba);
            }
            row.add(occurrence);
            moreRow.add(index > 0 ? size - 1 : -1);
        }
        row.add(this.convertName(evt.getName()));
        moreRow.add(0);
        if (this._prefs.getBooleanValue("Fields.Comment")) {
            this.printDBookComment(row, this.convertComment((String)evt.getInfo(Evt.KeyInfo.COMMENT, this._renderer)));
            moreRow.add(0);
        }
        if (this._prefs.getBooleanValue("Fields.Law")) {
            obj = evt.getInfo(Evt.KeyInfo.LAW, this._renderer);
            row.add((String)(obj == null ? "-" : obj.toString() + " "));
            moreRow.add(0);
        }
        if (this._prefs.getBooleanValue("Fields.Inspected")) {
            obj = evt.getInfo(Evt.KeyInfo.INSPECTED_VALUE, null);
            row.add((String)(obj == null ? "-" : obj.toString() + " h"));
            moreRow.add(0);
        }
        if (this._prefs.getBooleanValue("Fields.InflightTested")) {
            obj = evt.getInfo(Evt.KeyInfo.TESTED_VALUE, null);
            row.add((String)(obj == null ? "-" : obj.toString() + " h"));
            moreRow.add(0);
        }
        if (this._prefs.getBooleanValue("Fields.Properties")) {
            StringBuffer properties = new StringBuffer();
            if (((Boolean)evt.getInfo(Evt.KeyInfo.UNDEVELOPPED, this._renderer)).booleanValue()) {
                properties.append("U ");
            }
            if (((Boolean)evt.getInfo(Evt.KeyInfo.SUBTREE, this._renderer)).booleanValue()) {
                properties.append("ST ");
            }
            if (evt.getInfo(Evt.KeyInfo.INSPECTED, this._renderer) != null) {
                properties.append("EI ");
            }
            if (evt.getInfo(Evt.KeyInfo.TESTED, this._renderer) != null) {
                properties.append("ITE ");
            }
            if (((Boolean)evt.getInfo(Evt.KeyInfo.GSR, this._renderer)).booleanValue()) {
                properties.append("GSR ");
            }
            row.add(properties.toString());
            moreRow.add(0);
        }
        if (this._prefs.getBooleanValue("Fields.BTP")) {
            obj = evt.getInfo(Evt.KeyInfo.BTP, this._renderer);
            row.add(obj == null ? "-" : obj.toString());
            moreRow.add(0);
        }
        if (this._prefs.getBooleanValue("Fields.FMEA")) {
            obj = evt.getInfo(Evt.KeyInfo.FMEA, this._renderer);
            row.add(obj == null ? "-" : obj.toString());
            moreRow.add(0);
        }
        if (this._prefs.getBooleanValue("Fields.Attributes")) {
            StringBuffer text = new StringBuffer();
            Iterator<? extends Attr> itr = evt.getAttributs().iterator();
            while (itr.hasNext()) {
                Attr attr = itr.next();
                if (attr.getKey().getType() == AttrType.FIELD) continue;
                text.append(this.exportOneAttribute(attr));
                if (!itr.hasNext()) continue;
                text.append(", ");
            }
            if (text.length() == 0) {
                text.append("-");
            }
            row.add(text.toString());
            moreRow.add(0);
        }
        rows.add(row);
        moreRows.add(moreRow);
    }

    private void exportDocBookMCSSummary(DBKOutput xmlWriter) throws IOException {
        String msg;
        xmlWriter.writeSection(1, ResCompute.getString("KEY_0745"));
        xmlWriter.write("<para>", false);
        xmlWriter.write(ResCompute.getString("KEY_0746") + " : " + this._mcsOrigin.getCutCount(), true);
        xmlWriter.write("</para>\n", false);
        if (this._result != null && (msg = this._result.getWarning()) != null) {
            xmlWriter.write("<para>", false);
            xmlWriter.write(msg, true);
            xmlWriter.write("</para>\n", false);
        }
        ArrayList rows = new ArrayList();
        for (int c = 0; c < this._mcsOrigin.getOrderMax(); ++c) {
            int q = this._mcsOrigin.getOrderNumber(c);
            if (q <= 0) continue;
            ArrayList<String> row = new ArrayList<String>();
            row.add(Integer.toString(c));
            if (q > 1000000000) {
                row.add("> 1000000000");
            } else {
                row.add(Integer.toString(q));
            }
            double p = this._mcsOrigin.getOrderProbability(c);
            row.add(this._renderer.formatProbability(p));
            rows.add(row);
        }
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(ResMsgVoc.getString((String)"VOC_ORDER"));
        headers.add(ResMsgVoc.getString((String)"VOC_QUANTITY"));
        headers.add(ResMsgVoc.getString((String)"VOC_OCCURRENCE"));
        DBKTableModel tableModel = new DBKTableModel(rows, headers, DBKTableModel.DataType.OBJECTS);
        xmlWriter.insertTable(tableModel);
        xmlWriter.writeEndSection(1);
    }

    private void exportDocBookMCSTable(DBKOutput xmlWriter) throws IOException {
        if (this._filter.getTypeSorter() == MCSSorter.Type.PROBA_ORDER_LEXIC) {
            xmlWriter.writeSection(1, ResCompute.getString("KEY_0732"));
            this.exportDocBookMCSTable(xmlWriter, this._mcsFilter);
            xmlWriter.writeEndSection(1);
        } else {
            List<String> tabHeader = this.getDBookTabHeader(this._prefs);
            int index = 0;
            int curOrder = -1;
            ArrayList<List> rows = null;
            ArrayList moreRows = null;
            MCS.CutIterator cutIter = this._mcsFilter.cutIterate();
            while (cutIter.hasNext()) {
                Cut cut = cutIter.next();
                int order = cut.getOrder();
                if (order != curOrder) {
                    if (curOrder != -1) {
                        DBKTableModel tableModel = new DBKTableModel(rows, tabHeader, moreRows, DBKTableModel.DataType.OBJECTS);
                        xmlWriter.insertTable(tableModel);
                        xmlWriter.writeEndSection(1);
                    }
                    xmlWriter.writeSection(1, ResCompute.getString("KEY_0748") + " " + order);
                    curOrder = order;
                    index = 1;
                    rows = new ArrayList<List>();
                    moreRows = new ArrayList();
                } else {
                    ++index;
                }
                for (int e = 0; e < order; ++e) {
                    Evt evt = cut.getEvent(e);
                    if (e == 0) {
                        this.exportDocBookEventInTab(rows, moreRows, order, index, cut.getProbability(), evt);
                        continue;
                    }
                    this.exportDocBookEventInTab(rows, moreRows, order, -1, -1.0, evt);
                }
            }
            if (curOrder != -1) {
                DBKTableModel tableModel = new DBKTableModel(rows, tabHeader, moreRows, DBKTableModel.DataType.OBJECTS);
                xmlWriter.insertTable(tableModel);
                xmlWriter.writeEndSection(1);
            }
        }
    }

    protected void exportDocBookMCSTable(DBKOutput xmlWriter, MCS mcs) throws IOException {
        List<String> tabHeader = this.getDBookTabHeader(this._prefs);
        ArrayList<List> rows = new ArrayList<List>();
        ArrayList<List> moreRows = new ArrayList<List>();
        MCS.CutIterator cutIter = mcs.cutIterate();
        int index = 1;
        while (cutIter.hasNext()) {
            Cut cut = cutIter.next();
            int order = cut.getOrder();
            for (int e = 0; e < order; ++e) {
                Evt evt = cut.getEvent(e);
                if (e == 0) {
                    this.exportDocBookEventInTab(rows, moreRows, order, index, cut.getProbability(), evt);
                    continue;
                }
                this.exportDocBookEventInTab(rows, moreRows, order, -1, -1.0, evt);
            }
            ++index;
        }
        DBKTableModel tableModel = new DBKTableModel(rows, tabHeader, moreRows, DBKTableModel.DataType.OBJECTS);
        xmlWriter.insertTable(tableModel);
    }

    @Override
    protected void exportDocBookMCSReminderAdditionnalInformations(DBKOutput xmlWriter) throws IOException {
        if (((ParamComputeAbstract)this._parameters).getPostTreatmentDormant().booleanValue()) {
            xmlWriter.write("<para>", false);
            xmlWriter.write(ResCompute.getString("PTD_TITLE"), true);
            xmlWriter.write("</para>\n", false);
            xmlWriter.write("<para>", false);
            xmlWriter.write("*  : " + ResCompute.getString("PTD_EXPORT_REMINDER"), true);
            xmlWriter.write("</para>\n", false);
        }
        if (((ParamComputeAbstract)this._parameters).getPostTreatmentAtRisk().booleanValue() && Boolean.getBoolean("cecilia.ft.compute.EvtAtRiskSharped")) {
            xmlWriter.write("<para>", false);
            xmlWriter.write(ResCompute.getString("PTF_TITLE"), true);
            xmlWriter.write("</para>\n", false);
            xmlWriter.write("<para>", false);
            xmlWriter.write("#  : " + ResCompute.getString("PTF_EXPORT_REMINDER"), true);
            xmlWriter.write("</para>\n", false);
        }
    }

    @Override
    public void exportFormatXML(Appendable writer) throws IOException {
        this.exportXMLHeader(writer, "MINIMAL_CUT");
        MCS.CutIterator cutIter = this._mcsFilter.cutIterate();
        while (cutIter.hasNext()) {
            Cut cut = cutIter.next();
            writer.append("\t\t\t\t\t<CUT");
            double proba = cut.getProbability();
            if (proba >= 0.0) {
                writer.append(" PROBABILITY=\"").append(this._renderer.formatProbability(proba)).append("\"");
            }
            writer.append(">\n");
            for (int e = 0; e < cut.getOrder(); ++e) {
                Attr attrLaw;
                Object law;
                String value;
                Evt evt = cut.getEvent(e);
                writer.append("\t\t\t\t\t\t<EVENT NAME=\"").append(Util.formatStringForXml((String)evt.getName())).append("\"");
                double proba2 = evt.getProbability();
                if (proba2 >= 0.0) {
                    writer.append(" PROBABILITY=\"").append(this._renderer.formatProbability(proba2)).append("\"");
                }
                if ((value = (String)evt.getInfo(Evt.KeyInfo.COMMENT, this._renderer)) != null && value.length() > 0) {
                    writer.append(" COMMENT=\"").append(Util.formatStringForXml((String)value)).append("\"");
                }
                if (((Boolean)evt.getInfo(Evt.KeyInfo.GSR, this._renderer)).booleanValue()) {
                    writer.append(" GSR=\"true\"");
                }
                if (!(value = (String)evt.getInfo(Evt.KeyInfo.STATE, this._renderer)).equals(ResMsgVoc.getString((String)"VOC_NORMAL"))) {
                    if (value.equals(ResMsgVoc.getString((String)"VOC_TRUE"))) {
                        writer.append(" STATE=\"true\"");
                    } else {
                        writer.append(" STATE=\"false\"");
                    }
                }
                if ((value = (String)evt.getInfo(Evt.KeyInfo.INSPECTED, this._renderer)) != null && value.length() > 0) {
                    if (value.endsWith("'") && value.length() > 2) {
                        value = value.substring(1, value.length() - 1);
                    }
                    writer.append(" ISINSPECTED=\"").append(Util.formatStringForXml((String)value)).append("\"");
                }
                if ((value = (String)evt.getInfo(Evt.KeyInfo.TESTED, this._renderer)) != null && value.length() > 0) {
                    if (value.endsWith("'") && value.length() > 2) {
                        value = value.substring(1, value.length() - 1);
                    }
                    writer.append(" ISINFLIGHTTESTED=\"").append(Util.formatStringForXml((String)value)).append("\"");
                }
                writer.append(">\n");
                value = (String)evt.getInfo(Evt.KeyInfo.TREENAME, this._renderer);
                if (value != null && value.length() > 0) {
                    writer.append("\t\t\t\t\t\t<SUBTREE NAME=\"").append(Util.formatStringForXml((String)value)).append("\"></SUBTREE>\n");
                }
                Object object = law = (attrLaw = evt.getAttribute(BooleanAttribute.KEY_LAW)) != null ? attrLaw.getValue() : null;
                if (law != null && law instanceof BooleanExpression) {
                    double proba3 = evt.getProbability();
                    if (proba3 < 0.0) {
                        proba3 = Double.NaN;
                    }
                    BooleanExpression.exportXML((BooleanExpression)law, proba3, writer, "\t\t\t\t\t\t\t", this._renderer);
                }
                writer.append("\t\t\t\t\t\t</EVENT>\n");
            }
            writer.append("\t\t\t\t\t</CUT>\n");
        }
        this.exportXMLFooter(writer, "MINIMAL_CUT");
    }
}

