/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.melsynthesis;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgDisplayError;
import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.faulttree.TreeInfoCompute;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationDatumUtility;
import com.dassault.cecilia.dbobj.project.CriticityCriterion;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMEL;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ComputeType;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResIcoCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMEL;
import com.dassault.cecilia.plugin.faulttree.compute.melsynthesis.MELResult;
import com.dassault.cecilia.plugin.faulttree.compute.melsynthesis.MELSynthesisCell;
import com.dassault.cecilia.plugin.faulttree.compute.melsynthesis.MELSynthesisResultPanel;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultLoadMEL;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MELSynthesisGenerator {
    private static Logger _LOG = Logger.getLogger(MELSynthesisGenerator.class.getPackage().getName());
    Plugable _launcher;
    CeciliaAppl _appl;
    Window _owner;

    public MELSynthesisGenerator(Plugable launcher, Window owner) {
        this._launcher = launcher;
        this._appl = (CeciliaAppl)launcher.getAppl();
        this._owner = owner;
    }

    public void run(List<DBFolder> folders) {
        ArrayList<MELResult> listResult = new ArrayList<MELResult>();
        LinkedHashMap<DBFolder, GeneralError<DBFolder>> errors = new LinkedHashMap<DBFolder, GeneralError<DBFolder>>();
        for (DBFolder folder : folders) {
            FTEquation equation = (FTEquation)this._appl.getDAOFactory().findOrCreateWrap(folder);
            String messError = null;
            if (folder.isLocked()) {
                messError = ResCompute.getString("MSG_SYNTHESIS_MEL_LOCKED_FOLDER");
            } else if (folder.getAccessRight(this._appl.getDBUser()) == DBAccess.Right.NONE) {
                messError = ResCompute.getString("MSG_SYNTHESIS_MEL_INSUFFICIENT_RIGHTS");
            } else if (equation.getCriticityLevel() == null) {
                messError = ResCompute.getString("MSG_SYNTHESIS_MEL_NO_SEVERITY_ASSIGNED");
            }
            if (messError != null) {
                errors.put(folder, (GeneralError<DBFolder>)new GeneralError((Object)folder, messError, folder.isLocked() ? MsgType.WARNING : MsgType.ERROR));
                if (!folder.isLocked()) {
                    listResult.add(new MELResult(equation));
                    continue;
                }
            }
            FTEquationDatumUtility ftEquDatum = new FTEquationDatumUtility(equation, (Component)this._owner, this._appl);
            StringBuilder key = new StringBuilder();
            key.append("Tree.Compute.");
            key.append(ComputeType.MEL.toString());
            String confStr = null;
            if (!equation.getConfigs().isEmpty()) {
                key.append('@');
                for (FTConfig conf : equation.getConfigs()) {
                    if (!conf.isDefault()) continue;
                    confStr = conf.toString();
                    break;
                }
                if (confStr == null) {
                    confStr = ((FTConfig)equation.getConfigs().get(0)).toString();
                }
                key.append(confStr);
            }
            TreeInfoCompute infoDatum = ftEquDatum.getDatum(key.toString());
            BooleanStore store = new BooleanStore();
            BooleanMEL mel = null;
            String errorStr = null;
            ParamComputeMEL iparameters = null;
            try {
                errorStr = ResCompute.getString("MSG_SYNTHESIS_MEL_ERROR_READ_COMPUTATION");
                File equFile = (File)infoDatum.getInputFiles().get("ceciliabdd.file.xml");
                if (equFile == null || !equFile.exists() || equFile.length() == 0L) {
                    _LOG.info("Pas de fichier d'\u00e9quation");
                } else {
                    store.loadXML(new FileInputStream(equFile));
                    File paramFile = (File)infoDatum.getInputFiles().get("result.parameters");
                    if (paramFile == null || !paramFile.exists() || paramFile.length() == 0L) {
                        _LOG.info("Pas de fichier de param\u00e8tres");
                    } else {
                        iparameters = new ParamComputeMEL();
                        iparameters.loadFromXML(new FileInputStream(paramFile));
                        File melResultFile = (File)infoDatum.getInputFiles().get("result.mel");
                        if (melResultFile == null || !melResultFile.exists() || melResultFile.length() == 0L) {
                            _LOG.info("Pas de fichier de r\u00e9sultats");
                        } else {
                            mel = new BooleanMEL(store);
                            errorStr = TaskIResultLoadMEL.loadMELWithError(melResultFile, store, mel);
                        }
                    }
                }
            }
            catch (Throwable error) {
                errorStr = ResCompute.getString("MSG_SYNTHESIS_MEL_ERROR_READ_COMPUTATION");
                _LOG.log(Level.FINE, "Exception during loadMELWithError", error);
            }
            if (errorStr != null) {
                _LOG.info(errorStr);
                errors.put(folder, (GeneralError<DBFolder>)new GeneralError((Object)folder, ResCompute.getString("MSG_SYNTHESIS_MEL_ERROR_READ_COMPUTATION")));
            }
            listResult.add(new MELResult(equation, confStr, store, mel, iparameters));
        }
        this._launcher.addPanel((PlugPanel)new MELSynthesisResultPanel(this._appl, listResult, errors, this.generateMapEventToTopEvent(this._appl, listResult)), -1L);
        if (!errors.isEmpty()) {
            this.displayErrors(new ArrayList<GeneralError<DBFolder>>(errors.values()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, List<MELSynthesisCell>> generateMapEventToTopEvent(CeciliaAppl appl, List<MELResult> results) {
        void var8_11;
        LinkedHashMap<String, List<MELSynthesisCell>> mapEventToTopEvent = new LinkedHashMap<String, List<MELSynthesisCell>>();
        GeneralTextPreferencies prefs = (GeneralTextPreferencies)appl.getPreferencies().getItem(GeneralTextPreferencies.PREF_KEY).getPlug();
        DoubleFormat format = prefs != null ? prefs.getDoubleFormat() : null;
        LinkedHashSet<String> eventsSet = new LinkedHashSet<String>();
        for (MELResult mELResult : results) {
            BooleanMEL melResult = mELResult.getMelResult();
            if (melResult == null) continue;
            for (int i = 0; i < melResult.getNbrItems(); ++i) {
                BooleanMEL.Item item = melResult.getItemAt(i);
                String nameItem = item.getNode().getName();
                eventsSet.add(nameItem);
            }
        }
        ArrayList eventsList = new ArrayList(eventsSet);
        Collections.sort(eventsList);
        for (String event : eventsList) {
            ArrayList<MELSynthesisCell> list = new ArrayList<MELSynthesisCell>(results.size());
            for (int i = 0; i < results.size(); ++i) {
                list.add(new MELSynthesisCell(String.valueOf(Double.NaN), "-", false));
            }
            mapEventToTopEvent.put(event, list);
        }
        boolean bl = false;
        while (var8_11 < results.size()) {
            BooleanMEL melResult;
            MELResult result = results.get((int)var8_11);
            if (result != null && (melResult = result.getMelResult()) != null) {
                for (int j = 0; j < melResult.getNbrItems(); ++j) {
                    BooleanMEL.Item item = melResult.getItemAt(j);
                    String name = item.getNode().getName();
                    List listProba = (List)mapEventToTopEvent.get(name);
                    CriticityCriterion criticity = MELSynthesisGenerator.getCriticity(appl, result.getEqu());
                    double proba = item.getProbability();
                    String probaStr = format != null ? format.formatProbability(proba) : String.valueOf(proba);
                    boolean isCorrectProba = proba < criticity.getProbability();
                    boolean isCorrectOrder = true;
                    for (int idxOrder = 0; idxOrder <= criticity.getOrder(); ++idxOrder) {
                        isCorrectOrder &= item.getOrderNumber(idxOrder) == 0L;
                    }
                    String mess = null;
                    if (!isCorrectProba && !isCorrectOrder) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(ResCompute.getString("MSG_MEL_QUANTITATIVE_OBJECTIVE"));
                        sb.append("/");
                        sb.append(ResCompute.getString("MSG_MEL_QUALITATIVE_OBJECTIVE"));
                        mess = sb.toString();
                    } else if (!isCorrectProba) {
                        mess = ResCompute.getString("MSG_MEL_QUANTITATIVE_OBJECTIVE");
                    } else if (!isCorrectOrder) {
                        mess = ResCompute.getString("MSG_MEL_QUALITATIVE_OBJECTIVE");
                    }
                    listProba.set((int)var8_11, new MELSynthesisCell(probaStr, mess, isCorrectProba && isCorrectOrder));
                }
            }
            ++var8_11;
        }
        return mapEventToTopEvent;
    }

    public static CriticityCriterion getCriticity(CeciliaAppl cAppl, FTEquation equ) {
        String criticityName = equ.getCriticityLevel();
        List criticities = equ.getProjectCriticities(cAppl);
        if (criticities == null) {
            return null;
        }
        for (CriticityCriterion criticity : criticities) {
            if (!criticity.getName().equals(criticityName)) continue;
            return criticity;
        }
        return null;
    }

    private void displayErrors(List<GeneralError<DBFolder>> errors) {
        DBFolderDlgDisplayError dlg = new DBFolderDlgDisplayError(this._owner);
        dlg.setTitle(ResMsgVoc.getString((String)"VOC_ERROR") + " - " + ResCompute.getString("MSG_MEL_SYNTHESIS_TITLE"));
        dlg.setErrors(errors);
        dlg.setIconImage(ResIcoCompute.getImageIcon("PLUGIN_SYNTHESE").getImage());
        dlg.setModal(false);
        dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf((Component)this._owner));
        dlg.setVisible(true);
    }
}

