/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.melsynthesis;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.export.ExpBookUtility;
import com.dassault.cecilia.core.cecilia.export.JChooserFileUtility;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResIcoCompute;
import com.dassault.cecilia.plugin.faulttree.compute.melsynthesis.MELResult;
import com.dassault.cecilia.plugin.faulttree.compute.melsynthesis.MELSynthesisCell;
import com.dassault.cecilia.plugin.faulttree.compute.melsynthesis.MELSynthesisExport;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;

public class MELSynthesisResultPanel
extends JPanel
implements PlugPanel {
    private static Logger _LOG = Logger.getLogger(MELSynthesisResultPanel.class.getPackage().getName());
    private final CeciliaAppl _cAppl;
    private final List<MELResult> _results;
    private final Map<DBFolder, GeneralError<DBFolder>> _errors;
    private final Map<String, List<MELSynthesisCell>> _eventsToProba;

    public MELSynthesisResultPanel(CeciliaAppl cAppl, List<MELResult> results, Map<DBFolder, GeneralError<DBFolder>> errors, Map<String, List<MELSynthesisCell>> eventsToProba) {
        super(new GridBagLayout());
        this._errors = errors;
        this._cAppl = cAppl;
        this._results = results;
        this._eventsToProba = eventsToProba;
        this.doCreate();
    }

    private void doCreate() {
        JButton exportButton = new JButton(ResCompute.getString("MSG_MEL_EXPORT_EXCEL"));
        exportButton.addActionListener(e -> this.exportExcel());
        this.add((Component)exportButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(10, 0, 0, 10), 0, 0));
        MELSynthesisTableModel tableModel = new MELSynthesisTableModel(this._results, this._eventsToProba);
        JTable table = new JTable(tableModel){

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                if (column == 0) {
                    return super.getCellRenderer(row, column);
                }
                return new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable jtable, Object value, boolean isSelected, boolean hasFocus, int jrow, int jcol) {
                        JLabel lbl = (JLabel)super.getTableCellRendererComponent(jtable, value, isSelected, hasFocus, jrow, jcol);
                        MELSynthesisCell cell = (MELSynthesisCell)jtable.getValueAt(jrow, jcol);
                        String probaStr = cell.getProbability();
                        String text = probaStr == null || probaStr.isEmpty() || probaStr.equals(String.valueOf(Double.NaN)) ? "-" : probaStr;
                        lbl.setText(text);
                        if (cell.getMess() != null && !cell.getMess().isEmpty()) {
                            lbl.setToolTipText(cell.getMess());
                        }
                        lbl.setForeground(cell.isOK() ? Color.GREEN : Color.RED);
                        return lbl;
                    }
                };
            }

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        GeneralError<DBFolder> error;
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        if (realIndex == 0) {
                            return null;
                        }
                        MELResult melResult = MELSynthesisResultPanel.this._results.get(realIndex - 1);
                        FTEquation ftEquation = melResult.getEqu();
                        String topEvent = ftEquation.getTopEvent().getName();
                        String treeName = ftEquation.getDBFolder().getParent().getName();
                        String refPath = ftEquation.getRefPath();
                        StringBuilder sb = new StringBuilder();
                        sb.append("<html>");
                        sb.append(refPath);
                        if (!topEvent.equals(treeName)) {
                            sb.append("<br>");
                            sb.append(ResCompute.getString("DLG_RESULT_INFO_ROOT"));
                            sb.append(": ").append(topEvent);
                        }
                        sb.append("<br>");
                        sb.append(ResCompute.getString("DLG_RESULT_INFO_CONFIG"));
                        sb.append(": ");
                        if (melResult.getConfig() != null) {
                            sb.append(melResult.getConfig());
                        } else {
                            sb.append("Default");
                        }
                        String criticity = melResult.getEqu().getCriticityLevel();
                        if (criticity != null) {
                            sb.append("<br>");
                            sb.append(ResCompute.getString("MSG_MEL_EXPORT_SEVERITY"));
                            sb.append(": ").append(criticity);
                        }
                        if (melResult.getParameters() != null) {
                            if (melResult.getParameters().getLimitOrder() > 0) {
                                sb.append("<br>");
                                sb.append(ResMsgVoc.getString((String)"VOC_TRUNCATED"));
                                sb.append(": ").append(melResult.getParameters().getLimitOrder());
                            }
                            sb.append("<br>");
                            sb.append(ResMsgVoc.getString((String)"VOC_TYPE"));
                            sb.append(": ").append(melResult.getParameters().getTypeProbability().getLabel());
                            sb.append("<br>");
                            sb.append(ResMsgVoc.getString((String)"VOC_TIME"));
                            sb.append(": ").append(melResult.getParameters().getMissionTimeH());
                        }
                        if (melResult.getMelResult() != null && melResult.getMelResult().getNominalItem() != null) {
                            sb.append("<br>");
                            sb.append(ResCompute.getString("MSG_MEL_EXPORT_CMPT_PROBA"));
                            double proba = melResult.getMelResult().getNominalItem().getProbability();
                            sb.append(": ").append(proba);
                        }
                        if ((error = MELSynthesisResultPanel.this._errors.get(MELSynthesisResultPanel.this._results.get(realIndex - 1).getEqu().getDBFolder())) != null) {
                            sb.append("<br>");
                            sb.append("<font color=\"#880000\">").append(error.getMsg()).append("</font>");
                        }
                        sb.append("</html>");
                        return sb.toString();
                    }
                };
            }
        };
        table.setRowSorter(new TableRowSorter<MELSynthesisTableModel>(tableModel));
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    public Component getPanel() {
        return this;
    }

    public void trash() {
    }

    public String getInfo(String key) {
        if (key == "ppanel.title") {
            return ResCompute.getString("MSG_MEL_SYNTHESIS_TITLE");
        }
        if (key == "ppanel.default.height") {
            return "600";
        }
        if (key == "ppanel.default.width") {
            return "500";
        }
        return null;
    }

    public Icon getIcon(String key) {
        return ResIcoCompute.getImageIcon("PLUGIN_SYNTHESE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel() {
        if (this._eventsToProba.isEmpty()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        File file = ExpBookUtility.selectFile((JChooserFileUtility.Type)JChooserFileUtility.Type.XML, (Plugable)this._cAppl.getPlugable(), (Component)this, null, (String)".excel", (String)"MELSynthesis.excel.xml");
        if (file == null) {
            return;
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            MELSynthesisExport melExport = new MELSynthesisExport(this._cAppl, writer, this._results, this._eventsToProba);
            melExport.start();
        }
        catch (IOException error) {
            _LOG.severe("An error occurred during the MEL export : " + error.getMessage());
            JOptionPane.showMessageDialog(this, error.getMessage(), "Error - " + this.getInfo("ppanel.title"), 0);
            error.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException error) {
                    _LOG.severe("An error occurred when closing the MEL export");
                }
            }
        }
    }

    public static class MELSynthesisTableModel
    extends DefaultTableModel {
        public static final int IDX_EVENTNAME = 0;
        private final List<MELResult> _melResults;
        private final Map<String, List<MELSynthesisCell>> _eventsToProba;

        public MELSynthesisTableModel(List<MELResult> melResults, Map<String, List<MELSynthesisCell>> eventsToProba) {
            this._melResults = melResults;
            this._eventsToProba = eventsToProba;
        }

        @Override
        public int getRowCount() {
            if (this._eventsToProba == null) {
                return 0;
            }
            return this._eventsToProba.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            return MELSynthesisCell.class;
        }

        @Override
        public int getColumnCount() {
            if (this._melResults == null) {
                return 0;
            }
            return this._melResults.size() + 1;
        }

        @Override
        public String getColumnName(int column) {
            String treeName;
            if (column == 0) {
                return ResCompute.getString("MSG_MEL_EVENT_NAME");
            }
            String topEvent = this._melResults.get(column - 1).getEqu().getTopEvent().getName();
            if (topEvent.equals(treeName = this._melResults.get(column - 1).getEqu().getDBFolder().getParent().getName())) {
                return topEvent;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(treeName);
            sb.append(" (");
            sb.append(topEvent);
            sb.append(')');
            return sb.toString();
        }

        @Override
        public Object getValueAt(int row, int column) {
            String nameEvent = this.getNameEvent(row);
            if (column == 0) {
                return nameEvent;
            }
            return this._eventsToProba.get(nameEvent).get(column - 1);
        }

        private String getNameEvent(int row) {
            Iterator<String> iterator = this._eventsToProba.keySet().iterator();
            String nameEvent = null;
            for (int i = 0; i <= row && iterator.hasNext(); ++i) {
                nameEvent = iterator.next();
            }
            return nameEvent;
        }
    }
}

