/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.general.attrib.AttrCriterion;
import com.dassault.cecilia.dbobj.general.attrib.gui.AttributeCriterionPanel;
import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilterSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MCSFilterLatent
extends MCSFilterSorter {
    AttrCriterion _attrCriterion = null;
    Map<Attr.Key, Set<String>> _attrMap;
    MCSFilterLSRDlg _dlg = null;

    public MCSFilterLatent() {
        this._attrMap = null;
    }

    public MCSFilterLatent(Map<Attr.Key, Set<String>> attrMap) {
        this._attrMap = attrMap;
    }

    public final AttrCriterion getAttrCriterion() {
        return this._attrCriterion;
    }

    public final void setAttrCriterion(AttrCriterion attrCriterion) {
        this._attrCriterion = attrCriterion;
    }

    @Override
    public MCSFilter getCopy() {
        MCSFilterLatent copy = new MCSFilterLatent();
        copy._attrMap = this._attrMap;
        copy._attrCriterion = this._attrCriterion.getCopy();
        return copy;
    }

    @Override
    public void prepareFilter() {
    }

    @Override
    public boolean keepCut(Cut cut) {
        if (this._attrCriterion == null) {
            return false;
        }
        int order = cut.getOrder();
        int nbrMatch = 0;
        for (int i = order - 1; i >= 0; --i) {
            Evt evt = cut.getEvent(i);
            boolean match = false;
            for (Attr attr : evt.getAttributs()) {
                if (!this._attrCriterion.match(attr)) continue;
                match = true;
                break;
            }
            if (!match) continue;
            ++nbrMatch;
        }
        return nbrMatch == order - 1;
    }

    @Override
    public String getTitle() {
        return ResCompute.getString("DLG_RESULT_FILTER_LSR");
    }

    @Override
    public String getAbstract() {
        StringBuffer sb = new StringBuffer(512);
        sb.append(this.getTitle()).append(" : ");
        if (this._attrCriterion != null) {
            sb.append(this._attrCriterion.toString());
        }
        return sb.toString();
    }

    @Override
    public void configure(Map<Attr.Key, Set<String>> attrs) {
        this._attrMap = attrs;
    }

    @Override
    public String checkAttributes(Map<Attr.Key, Set<String>> attrs) {
        if (this._attrCriterion == null) {
            return null;
        }
        if (Attr.Key.containsAttribut(attrs, (Attr.Key)this._attrCriterion.getKey())) {
            return null;
        }
        return this._attrCriterion.getName();
    }

    @Override
    public boolean withDialog() {
        return true;
    }

    @Override
    public boolean selectFilter(Component owner) {
        if (this._attrCriterion == null) {
            return this.displayDialog(owner);
        }
        return true;
    }

    public boolean displayDialog(Component owner, boolean multiEdition) {
        if (this._dlg == null) {
            this._dlg = new MCSFilterLSRDlg(SwingUtilities.getWindowAncestor(owner), this.getTitle(), this._attrMap);
            this._dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf((Component)owner));
        }
        this._dlg.setIsMultiEdition(multiEdition);
        return this.displayDialog(owner);
    }

    @Override
    public boolean displayDialog(Component owner) {
        if (this._dlg == null) {
            this._dlg = new MCSFilterLSRDlg(SwingUtilities.getWindowAncestor(owner), this.getTitle(), this._attrMap);
            this._dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf((Component)owner));
        }
        if (this._attrCriterion != null) {
            this._dlg._critirionPanel.setCurrentAttributeCriterion(this._attrCriterion);
        } else {
            this._dlg._critirionPanel.setCurrentAttributeCriterion(null);
        }
        this._dlg.setVisible(true);
        if (!this._dlg.getResult()) {
            return false;
        }
        this._attrCriterion = this._dlg._critirionPanel.getCurrentAttributeCriterion();
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof MCSFilterLatent)) {
            return false;
        }
        MCSFilterLatent filterLatent = (MCSFilterLatent)obj;
        if (filterLatent._attrCriterion == null ^ this._attrCriterion == null) {
            return false;
        }
        return filterLatent._attrCriterion == null || filterLatent._attrCriterion.equals((Object)this._attrCriterion);
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = hashCode * 5 + (this._attrCriterion != null ? this._attrCriterion.hashCode() : 0);
        return hashCode;
    }

    @Override
    public void saveToXML(Appendable output, String indent) throws IOException {
        output.append(indent).append("<filter-attribute");
        this._attrCriterion.saveToXML(output);
        output.append("/>\n");
    }

    @Override
    public void loadFromXML(Element xmlTgt) throws SAXException, IOException {
        NodeList childs = xmlTgt.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node xmlChild = childs.item(i);
            if (!xmlChild.getNodeName().equals("filter-attribute")) continue;
            this._attrCriterion = AttrCriterion.loadFromXML((Element)((Element)xmlChild));
        }
    }

    static class MCSFilterLSRDlg
    extends JDialogCecilia {
        AttributeCriterionPanel _critirionPanel;
        boolean _isMultiEdition = false;

        MCSFilterLSRDlg(Window owner, String title, Map<Attr.Key, Set<String>> attributes) {
            super(owner, title, true);
            this._critirionPanel = new AttributeCriterionPanel(attributes);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this._critirionPanel, "Center");
            this.getContentPane().add((Component)this.createButPanel(true), "South");
            this.init();
            this.pack();
            this.setResizable(false);
        }

        public final void setIsMultiEdition(boolean isMultiEdition) {
            this._isMultiEdition = isMultiEdition;
        }

        protected boolean verifyParameters() {
            if (this._isMultiEdition && this._critirionPanel.getNameValue() == null) {
                return true;
            }
            if (!this._critirionPanel.verifyParameters()) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this._critirionPanel), ResCompute.getString("DLG_PARAM_ERR_ATTRIB"));
                return false;
            }
            return true;
        }
    }
}

