/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.core.Util;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.util.format.StringUtilities;
import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilterSorter;
import java.awt.Component;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MCSFilterName
extends MCSFilterSorter {
    String _name;
    Vector _tabSearchString;

    public MCSFilterName(String name) {
        this._name = name;
    }

    @Override
    public MCSFilter getCopy() {
        return new MCSFilterName(this._name);
    }

    @Override
    public void prepareFilter() {
        this._tabSearchString = StringUtilities.buildTabSearchString((String)this._name);
    }

    @Override
    public boolean keepCut(Cut cut) {
        for (int i = cut.getOrder() - 1; i >= 0; --i) {
            Evt evt = cut.getEvent(i);
            if (!StringUtilities.isASearchEvent((String)evt.getName(), (List)this._tabSearchString)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getTitle() {
        return ResCompute.getString("KEY_0323");
    }

    @Override
    public String getAbstract() {
        return ResCompute.getString("KEY_0323") + " : " + this._name;
    }

    @Override
    public boolean withDialog() {
        return true;
    }

    @Override
    public boolean displayDialog(Component owner) {
        String name = JOptionPane.showInputDialog(JOptionCecilia.getTopContainerOf((Component)owner), ResCompute.getString("DLG_RESULT_FILTER_NAME_INPUT"), this._name);
        if (name == null) {
            return false;
        }
        this._name = name;
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof MCSFilterName)) {
            return false;
        }
        MCSFilterName filterName = (MCSFilterName)obj;
        if (filterName._name == null ^ this._name == null) {
            return false;
        }
        return filterName._name == null || filterName._name.equals(this._name);
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = hashCode * 5 + (this._name != null ? this._name.hashCode() : 0);
        return hashCode;
    }

    @Override
    public void saveToXML(Appendable output, String indent) throws IOException {
        output.append(indent).append("<filter-name value='");
        Util.appendForXml((Appendable)output, (String)this._name).append("'/>\n");
    }

    @Override
    public void loadFromXML(Element xmlTgt) throws SAXException, IOException {
    }
}

