/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorterOrder;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorterOrderRank;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorterProba;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorterProbaRank;

public abstract class MCSFilterSorter
extends MCSFilter {
    MCSSorter _sorter;

    protected void prepareSort() {
        if (this._rankLimit > 0) {
            switch (this._typeSorter) {
                case ORDER_LEXIC: {
                    this._sorter = new MCSSorterOrderRank(false, this._rankLimit);
                    break;
                }
                case ORDER_PROBA_LEXIC: {
                    this._sorter = new MCSSorterOrderRank(true, this._rankLimit);
                    break;
                }
                case PROBA_ORDER_LEXIC: {
                    this._sorter = new MCSSorterProbaRank(this._rankLimit);
                }
            }
        } else {
            switch (this._typeSorter) {
                case ORDER_LEXIC: {
                    this._sorter = new MCSSorterOrder(false);
                    break;
                }
                case ORDER_PROBA_LEXIC: {
                    this._sorter = new MCSSorterOrder(true);
                    break;
                }
                case PROBA_ORDER_LEXIC: {
                    this._sorter = new MCSSorterProba();
                }
            }
        }
    }

    @Override
    public MCS filterMCS(MCS source) {
        this.prepareFilter();
        this.prepareSort();
        MCS.CutIterator iter = source.cutIterate();
        while (iter.hasNext()) {
            Cut cut = iter.next();
            if (!this.keepCut(cut)) continue;
            this._sorter.addCut(cut);
        }
        return this._sorter.getMCS();
    }

    public abstract void prepareFilter();

    @Override
    public abstract boolean keepCut(Cut var1);

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof MCSFilterSorter)) {
            return false;
        }
        MCSFilterSorter filterSorter = (MCSFilterSorter)obj;
        if (filterSorter._sorter == null ^ this._sorter == null) {
            return false;
        }
        return filterSorter._sorter == null || filterSorter._sorter.equals(this._sorter);
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        return hashCode * 3 + (this._sorter != null ? this._sorter.hashCode() : 0);
    }
}

