/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class MCSOrdersTableModel
implements TableModel {
    boolean _withProbability = true;
    int[] _fullOrdersNumber;
    double[] _fullOrdersProbability;
    MCS _currentMCS;
    protected List<TableModelListener> _tableModelListenerList = new ArrayList<TableModelListener>();

    public MCSOrdersTableModel(MCS mcs) {
        this.refreshInternalData(mcs);
    }

    private void refreshInternalData(MCS mcs) {
        this._currentMCS = mcs;
        int orderMax = mcs.getOrderMax();
        this._fullOrdersNumber = new int[orderMax];
        this._fullOrdersProbability = new double[orderMax];
        if (orderMax > 0) {
            int sumNumber = 0;
            double sumProba = 0.0;
            for (int i = 1; i < orderMax; ++i) {
                int n = mcs.getOrderNumber(i);
                this._fullOrdersNumber[i - 1] = n;
                sumNumber += n;
                double d = mcs.getOrderProbability(i);
                this._fullOrdersProbability[i - 1] = d;
                sumProba += d;
            }
            this._fullOrdersNumber[orderMax - 1] = sumNumber;
            this._fullOrdersProbability[orderMax - 1] = sumProba;
        }
    }

    public void setWithProbability(boolean value) {
        this._withProbability = value;
    }

    public void changeTable(MCS mcs) {
        if (mcs == this._currentMCS) {
            return;
        }
        this.refreshInternalData(mcs);
        this.fireTableChanged(new TableModelEvent(this));
    }

    protected void fireTableChanged(TableModelEvent e) {
        for (TableModelListener listener : this._tableModelListenerList) {
            listener.tableChanged(e);
        }
    }

    private int convertColumnIndex(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                if (this._withProbability) break;
                return 3;
            }
        }
        return columnIndex;
    }

    @Override
    public int getRowCount() {
        return this._fullOrdersNumber.length;
    }

    @Override
    public int getColumnCount() {
        return this._withProbability ? 3 : 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (this.convertColumnIndex(columnIndex)) {
            case 0: {
                return ResCompute.getString("DLG_RESULT_ORDERS");
            }
            case 1: {
                return ResCompute.getString("DLG_RESULT_CUTS");
            }
            case 2: {
                return ResCompute.getString("DLG_RESULT_PROBAS");
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (this.convertColumnIndex(columnIndex)) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return Double.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (this.convertColumnIndex(columnIndex)) {
            case 0: {
                if (rowIndex < this._fullOrdersNumber.length - 1) {
                    return rowIndex + 1;
                }
                return ResCompute.getString("DLG_RESULT_TOTAL");
            }
            case 1: {
                return this._fullOrdersNumber[rowIndex];
            }
            case 2: {
                return this._fullOrdersProbability[rowIndex];
            }
        }
        return ResMsgVoc.getString((String)"VOC_ERROR");
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this._tableModelListenerList.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this._tableModelListenerList.remove(l);
    }
}

