/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpBookUtility;
import com.dassault.cecilia.core.cecilia.export.JChooserFileUtility;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.cecilia.pref.PrintPreviewPrefsDlg;
import com.dassault.cecilia.core.cecilia.print.ListProcessorJavaInteractive;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.PlugModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.PlugPanelExtend;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.pluginmanager.ExtendedPlugable;
import com.dassault.cecilia.core.swing.DlgTime;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.criticity.CriticityResult;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.wrap.PageableThread;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.plugin.faulttree.compute.ActionControl;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMCS;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.CAAItem;
import com.dassault.cecilia.plugin.faulttree.compute.CAASelector;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import com.dassault.cecilia.plugin.faulttree.compute.PluginCmdEngine;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResIcoCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ComputeMCS;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfig;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDMCS;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMCS;
import com.dassault.cecilia.plugin.faulttree.compute.export.ExportMCS;
import com.dassault.cecilia.plugin.faulttree.compute.pref.PrintExportMCS;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborForOneHourRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborPreferenciesRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.results.CAAItemPanel;
import com.dassault.cecilia.plugin.faulttree.compute.results.CAASelectorPanel;
import com.dassault.cecilia.plugin.faulttree.compute.results.CriticityResultPanel;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSOrdersTable;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSOrdersWithFilterTableModel;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSTablePanel;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultCriticity;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class MCSPanel
extends JPanel
implements MCSTablePanel.MCSFilterListener,
PlugPanelExtend,
PlugModel {
    private static Logger _LOG = Logger.getLogger(MCSPanel.class.getPackage().getName());
    private static final String PROP_COMPUTE_MCS_SELECT_TAB_MCS = "cecilia.ft.compute.mcs.SelectTabCuts";
    PlugPanelExtend.HelperClose _helperClose;
    ComputeMCS _compute;
    BooleanResult _result;
    BooleanStore _store;
    ParamComputeMCS _parameters;
    MCSFilter _currentFilter;
    MCS _currentMCS;
    Plugable _plugable;
    InfoDatum _idatum;
    MCSTablePanel _mcsPanel;
    JTextField _probaRoot;
    MCSOrdersWithFilterTableModel _orderTableModel;
    JTable _orderJTable;
    JButton _computeRelaunch;
    JLabel _infoCutsOrder = new JLabel();
    JLabel _infoCutsProba = null;
    JLabel _infoProba = new JLabel();
    JCheckBox _forOneHour;
    ArborForOneHourRenderer _renderer;
    String _title = null;

    public MCSPanel(ComputeMCS compute, Plugable plugable, InfoDatum idatum, ArborRenderer renderer) {
        this(compute, compute.getResults(), compute.getStore(), compute.getParameters(), plugable, idatum, renderer);
    }

    public MCSPanel(ComputeMCS compute, BooleanResult result, BooleanStore store, ParamComputeMCS parameters, Plugable plugable, InfoDatum idatum, ArborRenderer renderer) {
        super(new GridBagLayout());
        this._compute = compute;
        this._result = result;
        this._store = store;
        this._parameters = parameters;
        this._plugable = plugable;
        this._idatum = idatum;
        double missionTimeH = this._parameters.getMissionTimeH();
        double averageFlight = this._store.getAverageFlightDuration();
        if (!Double.isNaN(averageFlight)) {
            missionTimeH = averageFlight / 3600.0;
        }
        this._renderer = new ArborForOneHourRenderer(renderer, missionTimeH);
        this.create();
    }

    protected boolean withRelaunchCompute() {
        return true;
    }

    private void create() {
        String config;
        String commentRoot;
        String commentVersion;
        BooleanMCS mcs = this._result.getMCS();
        BooleanNode rootNode = this._store.getRoot();
        String warning = this._result.getWarning();
        JTabbedPane rootPanel = new JTabbedPane(3);
        Insets stdInsets = new Insets(2, 2, 2, 2);
        JPanel generalPanel = new JPanel(new GridBagLayout());
        JPanel infoPanel = new JPanel(new GridBagLayout());
        infoPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResCompute.getString("DLG_RESULT_INFOS")));
        GridBagConstraints labelConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, stdInsets, 0, 0);
        String commentTree = this._store.getInfo(BooleanStore.INFO_TREE_COMMENT);
        if (commentTree == null) {
            commentTree = "";
        }
        if ((commentVersion = this._store.getInfo(BooleanStore.INFO_VERSION_COMMENT)) == null) {
            commentVersion = "";
        }
        if ((commentRoot = rootNode.getInfo(Evt.KeyInfo.COMMENT, this._renderer).toString()) == null) {
            commentRoot = "";
        }
        if ((config = this._store.getInfo(BooleanStore.INFO_CONFIGURATION)) == null) {
            config = "";
        }
        infoPanel.add((Component)new JLabel(ResCompute.getString("DLG_RESULT_INFO_PROJECT")), labelConstraints);
        ++labelConstraints.gridy;
        infoPanel.add((Component)new JLabel(ResCompute.getString("DLG_RESULT_INFO_SYSTEM")), labelConstraints);
        ++labelConstraints.gridy;
        infoPanel.add((Component)new JLabel(ResCompute.getString("DLG_RESULT_INFO_TREE")), labelConstraints);
        ++labelConstraints.gridy;
        infoPanel.add((Component)new JLabel(ResCompute.getString("DLG_RESULT_INFO_VERSION")), labelConstraints);
        ++labelConstraints.gridy;
        infoPanel.add((Component)new JLabel(ResCompute.getString("DLG_RESULT_INFO_ROOT")), labelConstraints);
        if (config != null && config.length() > 0) {
            ++labelConstraints.gridy;
            infoPanel.add((Component)new JLabel(ResCompute.getString("DLG_RESULT_INFO_CONFIG")), labelConstraints);
        }
        if (this._store.getInfo(BooleanStore.INFO_CRITICITY) != null) {
            ++labelConstraints.gridy;
            infoPanel.add((Component)new JLabel(ResCompute.getString("DLG_RESULT_INFO_CRITICITY")), labelConstraints);
        }
        ++labelConstraints.gridx;
        labelConstraints.gridy = 0;
        infoPanel.add((Component)new JLabel(this._store.getInfo(BooleanStore.INFO_PROJECT)), labelConstraints);
        ++labelConstraints.gridy;
        infoPanel.add((Component)new JLabel(this._store.getInfo(BooleanStore.INFO_SYSTEM)), labelConstraints);
        ++labelConstraints.gridy;
        JLabel labelTree = new JLabel(this._store.getInfo(BooleanStore.INFO_TREE));
        if (commentTree.length() > 0) {
            labelTree.setToolTipText(new StringBuffer().append("<html>").append(commentTree.replaceAll("\\n", "<br/>")).append("</html>").toString());
        }
        infoPanel.add((Component)labelTree, labelConstraints);
        ++labelConstraints.gridy;
        JLabel labelVersion = new JLabel(this._store.getInfo(BooleanStore.INFO_VERSION));
        if (commentVersion.length() > 0) {
            labelVersion.setToolTipText(new StringBuffer().append("<html>").append(commentVersion.replaceAll("\\n", "<br/>")).append("</html>").toString());
        }
        infoPanel.add((Component)labelVersion, labelConstraints);
        ++labelConstraints.gridy;
        JLabel labelRoot = new JLabel(rootNode.getName());
        if (commentRoot.length() > 0) {
            labelRoot.setToolTipText(new StringBuffer().append("<html>").append(commentRoot.replaceAll("\\n", "<br/>")).append("</html>").toString());
        }
        infoPanel.add((Component)labelRoot, labelConstraints);
        if (config.length() > 0) {
            ++labelConstraints.gridy;
            infoPanel.add((Component)new JLabel(config), labelConstraints);
        }
        if (this._store.getInfo(BooleanStore.INFO_CRITICITY) != null) {
            ++labelConstraints.gridy;
            infoPanel.add((Component)new JLabel(this._store.getInfo(BooleanStore.INFO_CRITICITY)), labelConstraints);
        }
        infoPanel.add((Component)new JLabel(), new GridBagConstraints(labelConstraints.gridx + 1, 0, 1, labelConstraints.gridy, 1.0, 0.0, 17, 2, stdInsets, 0, 0));
        generalPanel.add((Component)infoPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, stdInsets, 0, 0));
        JPanel paramPanel = new JPanel(new GridBagLayout());
        paramPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResCompute.getString("DLG_RESULT_PARAMETERS")));
        JTextPane _resumeParameters = new JTextPane();
        _resumeParameters.setText(this._parameters.getAbstract());
        _resumeParameters.setEditable(false);
        paramPanel.add((Component)_resumeParameters, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, stdInsets, 0, 0));
        this._forOneHour = new JCheckBox(ResCompute.getString("KEY_0050"));
        this._forOneHour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MCSPanel.this._renderer.setForOneHour(MCSPanel.this._forOneHour.isSelected());
                MCSPanel.this._probaRoot.setText(MCSPanel.this._renderer.formatProbability(MCSPanel.this._result.getRootProbability()));
                MCSPanel.this.refreshStatusBar();
                MCSPanel.this._orderTableModel.fireTableChanged(new TableModelEvent(MCSPanel.this._orderTableModel));
                MCSPanel.this._mcsPanel.refreshRenderer();
            }
        });
        double averageFlight = this._store.getAverageFlightDuration();
        if (!Double.isNaN(averageFlight) && averageFlight != this._parameters.getMissionTimeH()) {
            StringBuilder sb = new StringBuilder();
            sb.append(ResMsgObj.getString((String)"DLG_AVERAGEFLIGHT_EXPORT"));
            sb.append(" ").append(this._renderer.formatMissionTime(averageFlight));
            this._forOneHour.setToolTipText(sb.toString());
        }
        paramPanel.add((Component)this._forOneHour, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, stdInsets, 0, 0));
        if (this._parameters.getTypeProbability() == TypeProbability.NONE) {
            this._forOneHour.setVisible(false);
        } else if (this._renderer.getMissionTime() == 1.0) {
            this._forOneHour.setEnabled(false);
        }
        if (this.withRelaunchCompute()) {
            this._computeRelaunch = new JButton(ResCompute.getString("DLG_RESULT_RELAUNCH"));
            this._computeRelaunch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MCSPanel.this.relaunchCompute();
                }
            });
            paramPanel.add((Component)this._computeRelaunch, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, stdInsets, 0, 0));
        }
        generalPanel.add((Component)paramPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, stdInsets, 0, 0));
        JPanel resultPanel = new JPanel(new GridBagLayout());
        JPanel probaPanel = new JPanel(new GridBagLayout());
        probaPanel.add((Component)new JLabel(ResCompute.getString("DLG_RESULT_PROBA")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, stdInsets, 0, 0));
        this._probaRoot = new JTextField(12);
        this._probaRoot.setEditable(true);
        this._probaRoot.setEnabled(false);
        this._probaRoot.setText(this._renderer.formatProbability(this._result.getRootProbability()));
        probaPanel.add((Component)this._probaRoot, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, stdInsets, 0, 0));
        resultPanel.add((Component)probaPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, stdInsets, 0, 0));
        JPanel orderPanel = new JPanel(new GridBagLayout());
        orderPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResCompute.getString("DLG_RESULT_ORDER")));
        this._orderTableModel = new MCSOrdersWithFilterTableModel(mcs);
        this._orderJTable = new MCSOrdersTable((TableModel)this._orderTableModel, this._renderer);
        orderPanel.add((Component)new JScrollPane(this._orderJTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, stdInsets, 0, 0));
        if (this._result.getCriticityResult() != null && this._result.getCriticityResult().isAComputeCriticity()) {
            final CriticityResultPanel criticityPanel = new CriticityResultPanel(this._store, this._result, this._renderer);
            this._forOneHour.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    criticityPanel.refresh();
                }
            });
            JSplitPane pane = new JSplitPane(0, orderPanel, criticityPanel);
            pane.setBorder(BorderFactory.createEmptyBorder());
            pane.setResizeWeight(0.74);
            resultPanel.add((Component)pane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        } else {
            resultPanel.add((Component)orderPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        }
        generalPanel.add((Component)resultPanel, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 10, 1, stdInsets, 0, 0));
        rootPanel.addTab(ResCompute.getString("DLG_RESULT_TAB_INFO"), generalPanel);
        this._mcsPanel = new MCSTableExtendedPanel(mcs, this._renderer, this._parameters.getTypeProbability() != TypeProbability.NONE, this._store.getAttributes());
        this._mcsPanel.addFilterListener(this);
        this._mcsPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 0, 5));
        rootPanel.addTab(ResCompute.getString("DLG_RESULT_TAB_CUTS"), this._mcsPanel);
        if (Boolean.getBoolean(PROP_COMPUTE_MCS_SELECT_TAB_MCS)) {
            rootPanel.setSelectedIndex(1);
        }
        if (warning != null) {
            rootPanel.setToolTipText(new StringBuffer().append("<html>").append(warning.replaceAll("\\n", "<br/>")).append("</html>").toString());
        }
        this.add((Component)rootPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, stdInsets, 0, 0));
        JPanel infoCutsPanel = new JPanel(new GridBagLayout());
        int fullCutCount = mcs.getCutCount();
        this._infoCutsOrder.setText(new StringBuffer().append(ResCompute.getString("DLG_RESULT_CUTS")).append(" : ").append(ResMsgCore.msgFormat((String)"MSG_X_ON_Y", (Object[])new Object[]{fullCutCount, fullCutCount})).toString());
        if (this._parameters.getTypeProbability() != TypeProbability.NONE) {
            String missionTime = this._renderer.formatNumber(this._parameters.getMissionTimeH());
            this._infoCutsProba = new JLabel(new StringBuffer().append("(").append(ResMsgCore.msgFormat((String)"MSG_X_ON_Y", (Object[])new Object[]{missionTime, missionTime})).append(")").toString());
            this._infoProba.setText(new StringBuffer().append(this._parameters.getTypeProbability().getLabel()).append(" ; ").append(missionTime).toString());
        } else {
            this._infoProba.setText(this._parameters.getTypeProbability().getLabel());
        }
        if (warning != null) {
            this._infoCutsOrder.setForeground(Color.blue);
            this._infoProba.setForeground(Color.blue);
            if (this._infoCutsProba != null) {
                this._infoCutsProba.setForeground(Color.blue);
            }
        }
        infoCutsPanel.add((Component)new JLabel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 11, 3, stdInsets, 0, 0));
        infoCutsPanel.add((Component)new JLabel("                                "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, stdInsets, 0, 0));
        infoCutsPanel.add((Component)this._infoProba, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, stdInsets, 0, 0));
        infoCutsPanel.add((Component)new JLabel(), new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, stdInsets, 0, 0));
        infoCutsPanel.add((Component)this._infoCutsOrder, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, stdInsets, 0, 0));
        if (this._infoCutsProba != null) {
            infoCutsPanel.add((Component)this._infoCutsProba, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, stdInsets, 0, 0));
        }
        this.add((Component)infoCutsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 14, 1, stdInsets, 0, 0));
        this.refreshStatusBar();
    }

    private void refreshStatusBar() {
        if (this._parameters.getTypeProbability() != TypeProbability.NONE) {
            StringBuffer sb = new StringBuffer().append(this._parameters.getTypeProbability().getLabel());
            if (this._forOneHour.isSelected()) {
                sb.append(" ; ").append(this._forOneHour.getText());
                double averageFlight = this._store.getAverageFlightDuration();
                if (!Double.isNaN(averageFlight) && averageFlight != this._parameters.getMissionTimeH()) {
                    sb.append(" (/").append(this._renderer.formatNumber(averageFlight / 3600.0)).append("h)");
                }
            }
            sb.append(" ; ").append(this._renderer.formatNumber(this._parameters.getMissionTimeH()));
            if (this._parameters.getPostTreatmentDormant().booleanValue()) {
                sb.append(" ; ");
                sb.append(ResCompute.getString("VOC_DORMANT"));
            }
            if (this._parameters.getPostTreatmentAtRisk().booleanValue()) {
                sb.append(" ; ");
                sb.append(ResCompute.getString("VOC_ENDOFFLY"));
                sb.append("(").append(this._renderer.formatNumber(this._parameters.getSpecificTime() / 3600.0)).append(")");
            }
            this._infoProba.setText(sb.toString());
        }
        boolean allCuts = false;
        int orderFilter = this._orderTableModel._filterOrdersNumber[this._orderTableModel._filterOrdersNumber.length - 1];
        int orderFull = this._orderTableModel._fullOrdersNumber[this._orderTableModel._fullOrdersNumber.length - 1];
        boolean bl = allCuts = orderFilter == orderFull;
        if (allCuts) {
            this._infoCutsOrder.setText(new StringBuffer().append(ResCompute.getString("DLG_RESULT_CUTS")).append(" : ").append(orderFilter).toString());
        } else {
            this._infoCutsOrder.setText(new StringBuffer().append(ResCompute.getString("DLG_RESULT_CUTS")).append(" : ").append(ResMsgCore.msgFormat((String)"MSG_X_ON_Y", (Object[])new Object[]{orderFilter, orderFull})).toString());
        }
        if (this._infoCutsProba != null) {
            String probaFull = this._renderer.formatProbability(this._orderTableModel._fullOrdersProbability[this._orderTableModel._fullOrdersProbability.length - 1]);
            if (allCuts) {
                this._infoCutsProba.setText(new StringBuffer().append("(").append(probaFull).append(")").toString());
            } else {
                String probaFilter = this._renderer.formatProbability(this._orderTableModel._filterOrdersProbability[this._orderTableModel._filterOrdersProbability.length - 1]);
                this._infoCutsProba.setText(new StringBuffer().append("(").append(ResMsgCore.msgFormat((String)"MSG_X_ON_Y", (Object[])new Object[]{probaFilter, probaFull})).append(")").toString());
            }
        }
    }

    private void relaunchCompute() {
        PluginModel pluginEngine = this._plugable.getPlugin(PluginCmdEngine.class.getName());
        if (pluginEngine == null || !(pluginEngine instanceof EngineBDDConfig)) {
            _LOG.log(Level.SEVERE, "No EngineBDDConfig");
            return;
        }
        EngineBDDConfig engineBDDCfg = (EngineBDDConfig)pluginEngine;
        BooleanStore store = this._compute.getStore();
        ParamComputeMCS parameters = this._compute.getParameters();
        EngineBDDMCS engineBDD = new EngineBDDMCS(engineBDDCfg);
        engineBDD.defineComputeType(store);
        StringBuffer pathTree = new StringBuffer();
        pathTree.append(store.getInfo(BooleanStore.INFO_PROJECT)).append("/");
        pathTree.append(store.getInfo(BooleanStore.INFO_SYSTEM)).append("/");
        pathTree.append(store.getInfo(BooleanStore.INFO_TREE)).append("(");
        pathTree.append(store.getInfo(BooleanStore.INFO_VERSION)).append(")");
        if (!store.getInfo(BooleanStore.INFO_TREE).equals(store.getRoot().getName())) {
            pathTree.append(" : ").append(store.getRoot().getName());
        }
        ParamComputeMCS newParameters = new ParamComputeMCS();
        newParameters.copy(parameters);
        if (store.oneOrMoreLeavesWithoutProbability()) {
            newParameters.setDefaultTypeProbability(TypeProbability.NONE);
        } else {
            String latentProbability = store.getInfo(BooleanStore.INFO_LATENT_PROBABILITY);
            if (latentProbability != null && latentProbability.length() > 0) {
                try {
                    newParameters.setDefaultTypeProbability(TypeProbability.valueOf((String)latentProbability));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        newParameters.setReferenceCompute(false, false);
        newParameters.setReferenceIgnore(false, false);
        if (!newParameters.displayDialog(store, this._plugable)) {
            return;
        }
        if (newParameters.equals(parameters)) {
            return;
        }
        boolean bLaunchCompute = true;
        boolean bSameCRCXml = false;
        String keyCRCXmlEquals = (String)this._idatum.getParameters().get("CRC.Xml.equals");
        if (keyCRCXmlEquals != null) {
            bSameCRCXml = keyCRCXmlEquals.equals("true");
        }
        if (newParameters.isCompatible(parameters, bSameCRCXml)) {
            bLaunchCompute = false;
        }
        if (_LOG.isLoggable(Level.FINER)) {
            _LOG.finer("MCSPanel.Action: Db[" + parameters.getShortAbstract() + "] User[" + newParameters.getShortAbstract() + "] Crc[" + (bSameCRCXml ? "1" : "0") + "] => " + (bLaunchCompute ? "C" : "D"));
        }
        ComputeMCS compute = new ComputeMCS(newParameters, new BooleanResult(this._store, newParameters));
        compute.defineFiles(this._compute.getDagFile(), this._compute.getXmlFile());
        this._compute.defineFiles(null, null);
        this._helperClose.close((PlugPanelExtend)this);
        if (bLaunchCompute) {
            compute.launchCompute(this._idatum, this._plugable, engineBDD, pathTree.toString());
        } else {
            compute.launchDisplay(this._idatum, this._plugable, true, pathTree.toString());
        }
    }

    @Override
    public void changeTable(MCS mcs, MCSFilter filter) {
        this._currentMCS = mcs;
        this._currentFilter = filter;
        this._orderTableModel.changeTable(mcs, filter);
        this.refreshStatusBar();
    }

    protected boolean withCAA() {
        return true;
    }

    protected boolean withPostTreatmentDormant() {
        return true;
    }

    protected boolean withPostTreatmentEndOfFly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File export(JChooserFileUtility.Type type) {
        if (this._currentMCS == null) {
            this._mcsPanel.refreshSorterFilter();
        }
        if (this._currentMCS == null || this._currentMCS.getRowCount() == 0) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResCompute.getString("KEY_1308"), ResMsgVoc.getString((String)"VOC_WARNING"), 2);
            return null;
        }
        StringBuilder defaultName = new StringBuilder();
        String treeName = FileUtility.protectFilename((String)this._store.getInfo(BooleanStore.INFO_TREE));
        String treeVersion = this._store.getInfo(BooleanStore.INFO_VERSION);
        defaultName.append(treeName).append("(").append(treeVersion).append(").mcs");
        File result = ExpBookUtility.selectFile((JChooserFileUtility.Type)type, (Plugable)this._plugable, (Component)this, null, (String)".mcs", (String)defaultName.toString());
        if (result == null) {
            return null;
        }
        ExportMCS export = new ExportMCS(this._compute.getStore(), this._parameters, this._result, this._result.getMCS(), (PrintExportMCS)this._plugable.getPreferencies(PrintExportMCS.PREF_KEY));
        export.setMCSFilter(this._currentMCS, this._currentFilter);
        export.setRenderer(this._renderer, this._renderer.isForOneHour());
        try {
            switch (type) {
                case DOCBOOK: 
                case WORD: {
                    if (export.verifyAnonymousReport(result, this)) {
                        DBKOutput writer = new DBKOutput(result.getAbsolutePath());
                        export.exportFormatDocBook(writer);
                        export.generateAnonymousReport(result, this);
                    }
                    break;
                }
                case XML: {
                    try (Writer writer = null;){
                        writer = new BufferedWriter(new FileWriter(result));
                        export.exportFormatXML(writer);
                        break;
                    }
                }
                default: {
                    throw new IOException("Unsupported format : " + type);
                }
            }
        }
        catch (IOException e) {
            result = null;
            StringBuffer buffer = new StringBuffer(256);
            buffer.append(ResCompute.getString("FILE_ERROR_EXPORT")).append("\n");
            buffer.append(e.getLocalizedMessage());
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), buffer.toString(), this.getTitle(), 0);
        }
        return result;
    }

    public Component getPanel() {
        return this;
    }

    public void trash() {
        File xmlFile;
        File dagFile = this._compute.getDagFile();
        if (dagFile != null && dagFile.exists() && !dagFile.delete()) {
            dagFile.deleteOnExit();
        }
        if ((xmlFile = this._compute.getXmlFile()) != null && xmlFile.exists() && !xmlFile.delete()) {
            xmlFile.deleteOnExit();
        }
    }

    protected String getBaseTitle() {
        return ResCompute.getString("PLUG_CMD_NOMINAL_NAME");
    }

    synchronized String getTitle() {
        if (this._title == null) {
            String config;
            StringBuffer sb = new StringBuffer();
            sb.append(this.getBaseTitle());
            sb.append(" : ");
            BooleanStore store = this._compute.getStore();
            sb.append(store.getInfo(BooleanStore.INFO_PROJECT)).append("/");
            sb.append(store.getInfo(BooleanStore.INFO_SYSTEM)).append("/");
            sb.append(store.getInfo(BooleanStore.INFO_TREE)).append("(");
            sb.append(store.getInfo(BooleanStore.INFO_VERSION)).append(")");
            if (!store.getRoot().getName().equals(store.getInfo(BooleanStore.INFO_TREE))) {
                sb.append(" - ").append(store.getRoot().getName());
            }
            if ((config = store.getInfo(BooleanStore.INFO_CONFIGURATION)) != null && !config.equalsIgnoreCase("default")) {
                sb.append(" [").append(config).append("]");
            }
            this._title = sb.toString();
        }
        return this._title;
    }

    public String getInfo(String key) {
        if (key.equals("ppanel.title")) {
            return this.getTitle();
        }
        if (key.equals("ppanel.button")) {
            String config;
            StringBuffer sb = new StringBuffer();
            BooleanStore store = this._compute.getStore();
            String treeName = store.getInfo(BooleanStore.INFO_TREE);
            sb.append(treeName).append(";");
            sb.append(store.getInfo(BooleanStore.INFO_VERSION));
            String treeRoot = store.getRoot().getName();
            if (!treeRoot.equals(treeName)) {
                sb.append(" !");
            }
            if ((config = store.getInfo(BooleanStore.INFO_CONFIGURATION)) != null && !config.equalsIgnoreCase("default")) {
                sb.append(" [-]");
            }
            return sb.toString();
        }
        if (key.equals("ppanel.default.width")) {
            return "750";
        }
        if (key.equals("ppanel.default.height")) {
            return "480";
        }
        return key;
    }

    public Icon getIcon(String key) {
        if (key.equals("ppanel.icon")) {
            return ResIcoCompute.getImageIcon("PLUGIN_MCS");
        }
        return null;
    }

    public boolean isPrinting() {
        return true;
    }

    public void print() {
        CAppl cAppl;
        Pageable fgPageable;
        PageFormat format = null;
        if (this._plugable instanceof ExtendedPlugable) {
            format = ((ExtendedPlugable)this._plugable).getPageFormat("docbook.file");
        }
        PrinterJob job = PrinterJob.getPrinterJob();
        if (format == null) {
            format = job.defaultPage();
        }
        if ((fgPageable = this.createPageable(null, (cAppl = (CAppl)this._plugable.getAppl()).getPreferencies())) == null) {
            return;
        }
        try {
            job.setPageable(fgPageable);
            if (job.printDialog()) {
                try {
                    job.print();
                }
                catch (PrinterException e) {
                    _LOG.log(Level.FINE, "Probleme d'impression d'un resultat de MCS : " + this._store.getInfo(BooleanStore.INFO_TREE), e);
                }
            }
        }
        catch (Throwable th) {
            _LOG.log(Level.WARNING, "Exception lors de l'impression d'un resultat de MCS : " + this._store.getInfo(BooleanStore.INFO_TREE), th);
        }
    }

    public boolean isPreviewing() {
        return true;
    }

    public void preview() {
        if (!(this._plugable.getAppl() instanceof CAppl)) {
            return;
        }
        CAppl cAppl = (CAppl)this._plugable.getAppl();
        Pageable fgPageable = this.createPageable(cAppl.getPageFormat(), cAppl.getPreferencies());
        if (fgPageable == null) {
            return;
        }
        PrintPreviewPrefsDlg dlg = new PrintPreviewPrefsDlg(JOptionCecilia.getWindowOf((Component)this), fgPageable, cAppl, new PrefFieldsCategory[]{(PrefFieldsCategory)cAppl.getPreferencies().getOptions(PrintExportMCS.PREF_KEY)}){

            public void updatePreferencies() {
                this.setBook(MCSPanel.this.createPageable(this.getFormat(), this.getPreferencies()));
            }
        };
        dlg.setLocationRelativeTo((Component)JOptionCecilia.getWindowOf((Component)this));
        dlg.setVisible(true);
    }

    public Pageable createPageable(final PageFormat callFormat, final Preferencies preferencies) {
        PageableThread thread = new PageableThread(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Pageable doCreatePageable() {
                ListProcessorJavaInteractive pageable = null;
                PageFormat format = callFormat;
                if (format == null) {
                    if (MCSPanel.this._plugable instanceof ExtendedPlugable) {
                        format = ((ExtendedPlugable)MCSPanel.this._plugable).getPageFormat("docbook.file");
                    }
                    PrinterJob job = PrinterJob.getPrinterJob();
                    if (format == null) {
                        format = job.defaultPage();
                    }
                }
                try {
                    try (SrbInputStream scribe = new SrbInputStream("");){
                        ExportMCS export = new ExportMCS(MCSPanel.this._compute.getStore(), MCSPanel.this._parameters, MCSPanel.this._result, MCSPanel.this._result.getMCS(), (PrintExportMCS)preferencies.getOptions(PrintExportMCS.PREF_KEY));
                        export.setMCSFilter(MCSPanel.this._currentMCS, MCSPanel.this._currentFilter);
                        export.setRenderer(MCSPanel.this._renderer, MCSPanel.this._renderer.isForOneHour());
                        export.exportFormatScribe(scribe);
                    }
                    pageable = new ListProcessorJavaInteractive(scribe);
                    pageable.processScribeFile();
                    pageable.computePageCount(format);
                }
                catch (Throwable th) {
                    _LOG.log(Level.WARNING, "Exception lors de l'impression d'un resultat de MCS : " + MCSPanel.this._store.getInfo(BooleanStore.INFO_TREE), th);
                }
                return pageable;
            }
        };
        thread.realiseDo();
        return thread.getPageable();
    }

    public boolean isExporting(String format) {
        if (format.equalsIgnoreCase("XML")) {
            return true;
        }
        return format.equalsIgnoreCase("DOCBOOK");
    }

    public File export(String format) {
        if (format.equalsIgnoreCase("XML")) {
            return this.export(JChooserFileUtility.Type.XML);
        }
        if (format.equalsIgnoreCase("DOCBOOK")) {
            return this.export(JChooserFileUtility.Type.DOCBOOK);
        }
        return null;
    }

    public boolean copy() {
        return false;
    }

    public boolean configCloseable(PlugPanelExtend.HelperClose helper) {
        this._helperClose = helper;
        return true;
    }

    public IModel getModel(String key) {
        File file = null;
        if (key.equals("docbook.file")) {
            file = this.export(JChooserFileUtility.Type.DOCBOOK);
        } else if (key.equals("word.file")) {
            file = this.export(JChooserFileUtility.Type.WORD);
        } else if (key.equals("xml.file")) {
            file = this.export(JChooserFileUtility.Type.XML);
        }
        if (file != null) {
            return new IModel.DefaultModel(key, file, this._idatum.getModel().getName(), this._idatum.getModel().getUID());
        }
        return null;
    }

    class MCSTableExtendedPanel
    extends MCSTablePanel {
        Map<Attr.Key, Set<String>> _attributesCAA;
        Collection<Attr.Key> _currentAttributesCAA;
        boolean _currentMergeCAA;

        public MCSTableExtendedPanel(MCS mcs, ArborRenderer renderer, boolean withProbability, Map<Attr.Key, Set<String>> attributes) {
            super(mcs, renderer, withProbability, attributes);
            this._currentAttributesCAA = null;
            this._currentMergeCAA = false;
        }

        @Override
        protected void create() {
            this._attributesCAA = new TreeMap<Attr.Key, Set<String>>();
            for (Map.Entry entryAttr : this._attributes.entrySet()) {
                Attr.Key attr = (Attr.Key)entryAttr.getKey();
                this._attributesCAA.put(attr, (Set)entryAttr.getValue());
            }
            super.create();
        }

        @Override
        protected boolean withCAA() {
            return this._mcs instanceof BooleanMCS && MCSPanel.this.withCAA();
        }

        @Override
        protected void launchCAA() {
            if (this._attributesCAA.size() == 0) {
                JOptionPane.showMessageDialog(this, ResCompute.getString("CAA_ERROR_NO_ATTRIBUTES"), MCSPanel.this.getTitle(), 0);
                return;
            }
            CAASelectorPanel panel = new CAASelectorPanel();
            panel.setAttributes(this._attributesCAA);
            panel.setSelectors(this._currentAttributesCAA);
            panel.setMergeValue(this._currentMergeCAA);
            panel.refreshCtrl();
            CAASelectorDlg dlg = new CAASelectorDlg((Component)((Object)this._table), panel);
            dlg.pack();
            dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf((Component)((Object)this._table)));
            dlg.setVisible(true);
            if (dlg.getResult()) {
                this._currentAttributesCAA = panel.getSelectors();
                this._currentMergeCAA = panel.isMergeValue();
                BooleanMCS mcs = (BooleanMCS)this._mcs;
                CAASelector selector = new CAASelector(this._currentAttributesCAA, this._currentMergeCAA);
                CAAItem rootItem = selector.playMCS(mcs);
                CAAItemPanel plugPanel = new CAAItemPanel(rootItem, selector, MCSPanel.this._result, this._renderer, this._withProbability);
                plugPanel.setExportUtilities(MCSPanel.this._plugable, MCSPanel.this._idatum, MCSPanel.this._parameters);
                plugPanel.setCtrlForOneHour(MCSPanel.this._forOneHour);
                MCSPanel.this._plugable.addPanel((PlugPanel)plugPanel, MCSPanel.this._idatum.getModel().getUID());
            }
        }

        @Override
        protected boolean withPostTreatmentDormant() {
            if (!(this._mcs instanceof BooleanMCS)) {
                return false;
            }
            return MCSPanel.this.withPostTreatmentDormant();
        }

        @Override
        protected void launchPostTreatmentDormant() {
            switch (MCSPanel.this._parameters.getTypeProbability()) {
                case ARP1: 
                case ARP3: 
                case MCS: {
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(this, ResCompute.getString("PTD_ERROR_COMPUTE_TYPE"), MCSPanel.this.getTitle(), 0);
                    return;
                }
            }
            BooleanMCS evidentMCS = ((BooleanMCS)this._mcs).postTreatmentHide(MCSPanel.this._parameters.getMissionTimeH());
            if (evidentMCS == this._mcs) {
                JOptionPane.showMessageDialog(this, ResCompute.getString("PTD_ERROR_NO_DORMANT"), MCSPanel.this.getTitle(), 0);
                return;
            }
            ParamComputeMCS parameters = new ParamComputeMCS();
            parameters.copy(MCSPanel.this._parameters);
            parameters.setPostTreatmentDormant(true);
            BooleanResult evidentResult = new BooleanResult(evidentMCS, parameters);
            ActionControl ctrl = new ActionControl(){

                @Override
                public boolean isCanceled() {
                    return false;
                }
            };
            evidentResult.computeProbabilities(parameters.getTypeProbability(), parameters.getMissionTimeH(), ctrl);
            CriticityResult critResult = TaskIResultCriticity.getCriticityInfo(evidentResult, parameters.getCriteriumLSR());
            if (critResult != null) {
                evidentResult.setCriticityResult(critResult);
            }
            MCSPanel plugPanel = new MCSPanel(MCSPanel.this._compute, evidentResult, MCSPanel.this._store, parameters, MCSPanel.this._plugable, MCSPanel.this._idatum, new ArborPreferenciesRenderer(MCSPanel.this._plugable)){

                @Override
                protected boolean withRelaunchCompute() {
                    return false;
                }

                @Override
                protected boolean withCAA() {
                    return false;
                }

                @Override
                protected boolean withPostTreatmentDormant() {
                    return false;
                }

                @Override
                protected boolean withPostTreatmentEndOfFly() {
                    return true;
                }

                @Override
                protected String getBaseTitle() {
                    return ResCompute.getString("PTD_TITLE");
                }
            };
            MCSPanel.this._plugable.addPanel((PlugPanel)plugPanel, MCSPanel.this._idatum.getModel().getUID());
        }

        @Override
        protected boolean withPostTreatmentEndOfFly() {
            return this._mcs instanceof BooleanMCS && MCSPanel.this.withPostTreatmentEndOfFly();
        }

        @Override
        protected void launchPostTreatmentEndOfFly() {
            DlgTime dlgTime = new DlgTime(JOptionCecilia.getWindowOf((Component)this), ResCompute.getString("PTF_TITLE"), ResCompute.getString("PTF_INPUT_RISK_SPECIFIC"), MCSPanel.this._parameters.getMissionTime() / 10.0);
            dlgTime.setLocationRelativeTo(JOptionCecilia.getTopContainerOf((Component)this));
            dlgTime.setVisible(true);
            if (!dlgTime.getResult()) {
                return;
            }
            final double specificRiskTime = dlgTime.getTime();
            BooleanMCS endOfFlyMCS = ((BooleanMCS)this._mcs).postTreatmentRisk(specificRiskTime / 3600.0);
            if (endOfFlyMCS == null) {
                JOptionPane.showMessageDialog(this, ResCompute.getString("PTF_DORMANT_ERROR"), ResCompute.getString("PTF_TITLE"), 0);
                return;
            }
            ParamComputeMCS parameters = new ParamComputeMCS();
            parameters.copy(MCSPanel.this._parameters);
            parameters.setPostTreatmentAtRisk(true);
            parameters.setSpecificTimeSec(specificRiskTime);
            BooleanResult atRiskResult = new BooleanResult(endOfFlyMCS, parameters);
            ActionControl ctrl = new ActionControl(){

                @Override
                public boolean isCanceled() {
                    return false;
                }
            };
            atRiskResult.computeProbabilities(parameters.getTypeProbability(), parameters.getMissionTimeH(), ctrl);
            CriticityResult critResult = TaskIResultCriticity.getCriticityInfo(atRiskResult, parameters.getCriteriumLSR());
            if (critResult != null) {
                atRiskResult.setCriticityResult(critResult);
            }
            MCSPanel plugPanel = new MCSPanel(MCSPanel.this._compute, atRiskResult, MCSPanel.this._store, parameters, MCSPanel.this._plugable, MCSPanel.this._idatum, new ArborPreferenciesRenderer(MCSPanel.this._plugable)){

                @Override
                protected boolean withRelaunchCompute() {
                    return false;
                }

                @Override
                protected boolean withCAA() {
                    return false;
                }

                @Override
                protected boolean withPostTreatmentDormant() {
                    return false;
                }

                @Override
                protected boolean withPostTreatmentEndOfFly() {
                    return false;
                }

                @Override
                protected String getBaseTitle() {
                    return ResCompute.getString("PTF_TITLE") + "[" + specificRiskTime + "]";
                }
            };
            MCSPanel.this._plugable.addPanel((PlugPanel)plugPanel, MCSPanel.this._idatum.getModel().getUID());
        }
    }

    static class CAASelectorDlg
    extends JDialogCecilia {
        CAASelectorPanel _panel;

        public CAASelectorDlg(Component owner, CAASelectorPanel panel) {
            super(SwingUtilities.getWindowAncestor(owner), ResCompute.getString("CAA_DLG_EDIT_TITLE"), true);
            this._panel = panel;
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this._panel, "Center");
            this.getContentPane().add((Component)this.createButPanel(true), "South");
            this.init();
        }

        protected boolean verifyParameters() {
            return this._panel.verifyParameters();
        }
    }
}

