/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSortingInProba;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class MCSSorterProba
implements MCSSorter {
    List<Cut> _tmpCuts;
    Cut[] _resCuts = null;
    static Comparator<Cut> _comparator = new Comparator<Cut>(){

        @Override
        public int compare(Cut cut1, Cut cut2) {
            int order2;
            int cmpProba = Double.compare(cut1.getProbability(), cut2.getProbability());
            if (cmpProba != 0) {
                return -cmpProba;
            }
            int order1 = cut1.getOrder();
            if (order1 < (order2 = cut2.getOrder())) {
                return -1;
            }
            if (order1 > order2) {
                return 1;
            }
            for (int i = 0; i < order1; ++i) {
                Evt evt1 = cut1.getEvent(i);
                Evt evt2 = cut2.getEvent(i);
                int cmpEvt = evt1.getName().compareToIgnoreCase(evt2.getName());
                if (cmpEvt == 0) continue;
                return cmpEvt;
            }
            return 0;
        }
    };
    boolean _isSorting = false;
    Object _lockerThread = new Object();

    public MCSSorterProba() {
        this._tmpCuts = new ArrayList<Cut>();
    }

    @Override
    public void addCut(Cut cut) {
        this._tmpCuts.add(cut);
    }

    protected void finishSorter() {
        this._resCuts = new Cut[this._tmpCuts.size()];
        this._resCuts = this._tmpCuts.toArray(this._resCuts);
        Arrays.sort(this._resCuts, _comparator);
        this._tmpCuts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MCS getMCS() {
        if (!this._isSorting) {
            Object object = this._lockerThread;
            synchronized (object) {
                this.finishSorter();
                this._isSorting = true;
            }
        }
        return new MCSSortingInProba(this._resCuts);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return obj instanceof MCSSorterProba;
    }

    public int hashCode() {
        return 1;
    }
}

