/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.lib.util.TestUtility;
import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSortingInProba;
import java.util.Collection;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class MCSSortingInProbaTest
extends TestUtility {
    static TestEvt _evt = new TestEvt();

    protected void verifyMCS(MCS mcs, Cut[] cuts) {
        int idx = 0;
        for (int i = 0; i < cuts.length; ++i) {
            Cut cut = cuts[i];
            for (int j = 0; j < cut.getOrder(); ++j) {
                if (j == 0) {
                    Assert.assertTrue((cut == mcs.getRowCut(idx) ? 1 : 0) != 0);
                } else {
                    Assert.assertNull((Object)mcs.getRowCut(idx));
                }
                Assert.assertEquals((Object)cut.getEvent(j).getName(), (Object)mcs.getRowEvent(idx).getName());
                ++idx;
            }
        }
    }

    protected void verifyIterate(MCS mcs, Cut[] cuts) {
        int idx = 0;
        MCS.CutIterator iter = mcs.cutIterate();
        while (iter.hasNext()) {
            Cut cut = iter.next();
            Assert.assertTrue((cut == cuts[idx] ? 1 : 0) != 0);
            ++idx;
        }
        Assert.assertEquals((long)idx, (long)cuts.length);
    }

    @Test
    public void test1Cut() {
        Cut[] cuts = new Cut[]{new TestCut(new String[]{"a", "b"})};
        MCSSortingInProba mcs = new MCSSortingInProba(cuts);
        this.verifyMCS(mcs, cuts);
        Assert.assertEquals((long)2L, (long)(mcs.getOrderMax() - 1));
        Assert.assertEquals((double)0.02, (double)mcs.getOrderProbability(2), (double)0.0);
        this.verifyIterate(mcs, cuts);
    }

    @Test
    public void test2Cuts() {
        Cut[] cuts = new Cut[]{new TestCut(new String[]{"a", "b"}), new TestCut(new String[]{"c"})};
        MCSSortingInProba mcs = new MCSSortingInProba(cuts);
        this.verifyMCS(mcs, cuts);
        this.verifyIterate(mcs, cuts);
    }

    @Test
    public void test3Cuts() {
        Cut[] cuts = new Cut[]{new TestCut(new String[]{"a", "b"}), new TestCut(new String[]{"b", "c"}), new TestCut(new String[]{"a", "c", "d"})};
        MCSSortingInProba mcs = new MCSSortingInProba(cuts);
        this.verifyMCS(mcs, cuts);
        Assert.assertEquals((long)3L, (long)(mcs.getOrderMax() - 1));
        Assert.assertEquals((double)0.04, (double)mcs.getOrderProbability(2), (double)0.0);
        Assert.assertEquals((long)1L, (long)mcs.getOrderNumber(3));
        this.verifyIterate(mcs, cuts);
    }

    @Test
    public void test8Cuts() {
        Cut[] cuts = new Cut[]{new TestCut(new String[]{"a", "b"}), new TestCut(new String[]{"b", "c", "d"}), new TestCut(new String[]{"a", "c", "d"}), new TestCut(new String[]{"b", "e"}), new TestCut(new String[]{"a", "c", "e", "f"}), new TestCut(new String[]{"g"}), new TestCut(new String[]{"b", "h"}), new TestCut(new String[]{"b", "e", "f"})};
        MCSSortingInProba mcs = new MCSSortingInProba(cuts);
        this.verifyMCS(mcs, cuts);
        Assert.assertEquals((long)4L, (long)(mcs.getOrderMax() - 1));
        Assert.assertEquals((double)0.09, (double)mcs.getOrderProbability(3), (double)0.0);
        Assert.assertEquals((double)0.04, (double)mcs.getOrderProbability(4), (double)0.0);
        Assert.assertEquals((long)1L, (long)mcs.getOrderNumber(1));
        this.verifyIterate(mcs, cuts);
    }

    @Test
    public void test9Cuts() {
        Cut[] cuts = new Cut[]{new TestCut(new String[]{"a", "b"}), new TestCut(new String[]{"b", "c", "d"}), new TestCut(new String[]{"a", "c", "d"}), new TestCut(new String[]{"b", "e"}), new TestCut(new String[]{"a", "c", "e", "f"}), new TestCut(new String[]{"g"}), new TestCut(new String[]{"b", "h"}), new TestCut(new String[]{"b", "e", "f"}), new TestCut(new String[]{"e", "h"})};
        MCSSortingInProba mcs = new MCSSortingInProba(cuts);
        this.verifyMCS(mcs, cuts);
        Assert.assertEquals((long)4L, (long)(mcs.getOrderMax() - 1));
        Assert.assertEquals((double)0.09, (double)mcs.getOrderProbability(3), (double)0.0);
        Assert.assertEquals((double)0.04, (double)mcs.getOrderProbability(4), (double)0.0);
        Assert.assertEquals((long)1L, (long)mcs.getOrderNumber(1));
        this.verifyIterate(mcs, cuts);
    }

    @Test
    public void testNoCut() {
        Cut[] cuts = new Cut[]{};
        MCSSortingInProba mcs = new MCSSortingInProba(cuts);
        this.verifyMCS(mcs, cuts);
        this.verifyIterate(mcs, cuts);
    }

    @Test
    public void testEmptyCut() {
        Cut[] cuts = new Cut[]{new TestCut(new String[0])};
        MCSSortingInProba mcs = new MCSSortingInProba(cuts);
        this.verifyMCS(mcs, cuts);
        this.verifyIterate(mcs, cuts);
    }

    static class TestCut
    implements Cut {
        String[] _evts;

        TestCut(String[] evts) {
            this._evts = evts;
        }

        @Override
        public int getOrder() {
            return this._evts.length;
        }

        @Override
        public double getProbability() {
            return 0.01 * (double)this._evts.length;
        }

        @Override
        public Evt getEvent(int idx) {
            MCSSortingInProbaTest._evt._name = this._evts[idx];
            return _evt;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this._evts.length * 5);
            for (int i = 0; i < this._evts.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(this._evts[i]);
            }
            return sb.toString();
        }
    }

    static class TestEvt
    implements Evt {
        String _name;

        TestEvt() {
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public double getProbability() {
            return 0.0;
        }

        @Override
        public boolean isExtern() {
            return false;
        }

        @Override
        public int getIndex() {
            return 0;
        }

        @Override
        public Object getInfo(Evt.KeyInfo key, ArborRenderer renderer) {
            return null;
        }

        @Override
        public Collection<? extends Attr> getAttributs() {
            return Collections.emptyList();
        }

        @Override
        public Attr getAttribute(Attr.Key jey) {
            return null;
        }
    }
}

