/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.core.swing.table.JTableTransfertHandler;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemDefaultJTable;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemTableModel;
import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class MCSTable
extends ItemDefaultJTable
implements JTableTransfertHandler.HelperConvert {
    Set<Evt> _selectedEvts;
    Evt _lastSelectedEvt;
    ArborRenderer _renderer;
    JTableTransfertHandler _transfertHandler = new JTableTransfertHandler();
    private static final Color CUTS_BACKGROUND = new Color(224, 224, 224);

    public MCSTable(MCSTableModel model, ArborRenderer renderer) {
        super((ItemTableModel)model);
        this._renderer = renderer;
        this._selectedEvts = new LinkedHashSet<Evt>();
        this._lastSelectedEvt = null;
        this.setTransferHandler((TransferHandler)this._transfertHandler);
        this.setDefaultRenderer(Boolean.class, new MCSBooleanCellRenderer());
        this.setDefaultRenderer(Double.class, new DoubleMCSCellRenderer());
        this.setDefaultRenderer(String.class, new MCSCellRenderer());
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LinkedHashSet<Evt> selectedEvts = new LinkedHashSet<Evt>();
                int[] rows = MCSTable.this.getSelectedRows();
                for (int i = rows.length - 1; i >= 0; --i) {
                    Evt evt = MCSTable.this.getModel().getRowEvent(rows[i]);
                    selectedEvts.add(evt);
                }
                boolean change = false;
                MCSTable.this._lastSelectedEvt = null;
                Iterator<Evt> previousIter = MCSTable.this._selectedEvts.iterator();
                while (previousIter.hasNext()) {
                    Evt evt = previousIter.next();
                    if (selectedEvts.contains(evt)) {
                        selectedEvts.remove(evt);
                        MCSTable.this._lastSelectedEvt = evt;
                        continue;
                    }
                    change = true;
                    previousIter.remove();
                }
                if (selectedEvts.size() > 0) {
                    change = true;
                    for (Evt evt : selectedEvts) {
                        MCSTable.this._selectedEvts.add(evt);
                        MCSTable.this._lastSelectedEvt = evt;
                    }
                }
                if (change) {
                    MCSTable.this.updateUI();
                    MCSTable.this.setTransferHandler((TransferHandler)MCSTable.this._transfertHandler);
                }
            }
        });
    }

    public MCSTableModel getModel() {
        return (MCSTableModel)super.getModel();
    }

    protected boolean isEvtSelected(Evt evt, boolean last) {
        if (last) {
            if (this._lastSelectedEvt != null) {
                return this._lastSelectedEvt.equals(evt);
            }
            return false;
        }
        return this._selectedEvts.contains(evt);
    }

    protected void defineCellRendererUI(Component comp, Evt evt, boolean rowCut) {
        if (this.isEvtSelected(evt, true)) {
            comp.setBackground(this._renderer.getColor(ArborRenderer.DisplayColor.BGNormalSelectedLast));
        } else if (this.isEvtSelected(evt, false)) {
            comp.setBackground(this._renderer.getColor(ArborRenderer.DisplayColor.BGNormalSelected));
        } else if (rowCut) {
            comp.setBackground(CUTS_BACKGROUND);
        } else {
            comp.setBackground(this._renderer.getColor(ArborRenderer.DisplayColor.BGNormal));
        }
        if (evt.isExtern()) {
            comp.setForeground(this._renderer.getColor(ArborRenderer.DisplayColor.FGExtern));
        } else {
            comp.setForeground(this._renderer.getColor(ArborRenderer.DisplayColor.FGOther));
        }
    }

    public String convertToString(Object obj, int row, int col) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof Double) {
            double dvalue = (Double)obj;
            if (Double.isNaN(dvalue)) {
                return "-";
            }
            if (this.convertColumnIndexToModel(col) == 0) {
                return Double.toString(this._renderer.convertProbability(dvalue));
            }
            return Double.toString(dvalue);
        }
        return obj.toString();
    }

    class MCSBooleanCellRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public MCSBooleanCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.setEnabled(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (MCSTable.this._renderer.isAltRenderer()) {
                row = table.convertRowIndexToModel(row);
                int idx = MCSTable.this.getModel().getRowIndexCut(row);
                Evt evt = MCSTable.this.getModel().getRowEvent(row);
                if (idx % 2 == 0) {
                    this.setBackground(CUTS_BACKGROUND);
                } else {
                    this.setBackground(MCSTable.this._renderer.getColor(ArborRenderer.DisplayColor.BGNormal));
                }
                if (table.convertColumnIndexToModel(column) != 0) {
                    if (MCSTable.this.isEvtSelected(evt, true)) {
                        this.setBackground(MCSTable.this._renderer.getColor(ArborRenderer.DisplayColor.BGNormalSelectedLast));
                    } else if (MCSTable.this.isEvtSelected(evt, false)) {
                        this.setBackground(MCSTable.this._renderer.getColor(ArborRenderer.DisplayColor.BGNormalSelected));
                    }
                }
            } else {
                row = table.convertRowIndexToModel(row);
                if (table.convertColumnIndexToModel(column) != 0) {
                    Cut cut = MCSTable.this.getModel().getRowCut(row);
                    Evt evt = MCSTable.this.getModel().getRowEvent(row);
                    MCSTable.this.defineCellRendererUI(this, evt, cut != null);
                }
            }
            this.setSelected(value != null && (Boolean)value != false);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(this.noFocusBorder);
            }
            return this;
        }
    }

    protected class DoubleMCSCellRenderer
    extends MCSCellRenderer {
        protected DoubleMCSCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value == null) {
                this.setText("");
            } else {
                double dvalue = (Double)value;
                if (Double.isNaN(dvalue)) {
                    this.setText("-");
                } else if (table.convertRowIndexToModel(column) == 0) {
                    this.setText(MCSTable.this._renderer.formatProbability(dvalue));
                } else {
                    this.setText(MCSTable.this._renderer.formatNumber(dvalue));
                }
            }
            return this;
        }
    }

    protected class MCSCellRenderer
    extends DefaultTableCellRenderer {
        private Font normalFont = this.getFont();
        private Font italicFont = new Font(this.getFont().getFamily(), this.getFont().getStyle() + 2, this.getFont().getSize());

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int col = table.convertColumnIndexToModel(column);
            this.setHorizontalAlignment(MCSTable.this.getAlignRenderer(table, col));
            if (MCSTable.this._renderer.isAltRenderer()) {
                row = table.convertRowIndexToModel(row);
                int idx = MCSTable.this.getModel().getRowIndexCut(row);
                Evt evt = MCSTable.this.getModel().getRowEvent(row);
                if (idx % 2 == 0) {
                    this.setBackground(CUTS_BACKGROUND);
                } else {
                    this.setBackground(MCSTable.this._renderer.getColor(ArborRenderer.DisplayColor.BGNormal));
                }
                if (col != 0) {
                    if (MCSTable.this.isEvtSelected(evt, true)) {
                        this.setBackground(MCSTable.this._renderer.getColor(ArborRenderer.DisplayColor.BGNormalSelectedLast));
                    } else if (MCSTable.this.isEvtSelected(evt, false)) {
                        this.setBackground(MCSTable.this._renderer.getColor(ArborRenderer.DisplayColor.BGNormalSelected));
                    }
                    if (evt.isExtern()) {
                        this.setForeground(MCSTable.this._renderer.getColor(ArborRenderer.DisplayColor.FGExtern));
                    } else {
                        this.setForeground(MCSTable.this._renderer.getColor(ArborRenderer.DisplayColor.FGOther));
                    }
                } else {
                    this.setForeground(MCSTable.this._renderer.getColor(ArborRenderer.DisplayColor.FGOther));
                }
                this.defineSpecificUI(col, value, evt);
            } else if (col != 0) {
                row = table.convertRowIndexToModel(row);
                Cut cut = MCSTable.this.getModel().getRowCut(row);
                Evt evt = MCSTable.this.getModel().getRowEvent(row);
                MCSTable.this.defineCellRendererUI(this, evt, cut != null);
                this.defineSpecificUI(col, value, evt);
            } else {
                this.setFont(this.normalFont);
                this.setForeground(MCSTable.this._renderer.getColor(ArborRenderer.DisplayColor.FGOther));
                if (value != null) {
                    this.setBackground(CUTS_BACKGROUND);
                } else {
                    this.setBackground(MCSTable.this._renderer.getColor(ArborRenderer.DisplayColor.BGNormal));
                }
            }
            return this;
        }

        protected void defineSpecificUI(int col, Object value, Evt evt) {
            String tooltip = null;
            if (evt.isExtern()) {
                this.setFont(this.italicFont);
            } else {
                this.setFont(this.normalFont);
            }
            if (value == null) {
                this.setText("-");
            } else {
                int idxCol = MCSTable.this.getModel().getColumnModel().getColumnField(col).getIdxCode();
                if (idxCol == 15 && ((String)value).length() > 0 && !Character.isDigit(((String)value).charAt(0))) {
                    tooltip = evt.getInfo(Evt.KeyInfo.INSPECTED_VALUE, MCSTable.this._renderer).toString();
                } else if (idxCol == 16 && ((String)value).length() > 0 && !Character.isDigit(((String)value).charAt(0))) {
                    tooltip = evt.getInfo(Evt.KeyInfo.TESTED_VALUE, MCSTable.this._renderer).toString();
                }
            }
            if (tooltip != null && tooltip.isEmpty()) {
                tooltip = null;
            }
            this.setToolTipText(tooltip);
        }
    }
}

