/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpBookUtility;
import com.dassault.cecilia.core.cecilia.export.JChooserFileUtility;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.cecilia.pref.PrintPreviewPrefsDlg;
import com.dassault.cecilia.core.cecilia.print.ListProcessorJavaInteractive;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.PlugModel;
import com.dassault.cecilia.core.plugin.PlugPanelExtend;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.pluginmanager.ExtendedPlugable;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.JTableTransfertHandler;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.dbobj.wrap.PageableThread;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMEL;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResIcoCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ComputeMELAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMEL;
import com.dassault.cecilia.plugin.faulttree.compute.export.ExportMEL;
import com.dassault.cecilia.plugin.faulttree.compute.pref.PrintExportMCS;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborForOneHourRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class MELPanel
extends JPanel
implements PlugPanelExtend,
PlugModel {
    private static Logger _LOG = Logger.getLogger(MELPanel.class.getPackage().getName());
    PlugPanelExtend.HelperClose _helperClose;
    ComputeMELAbstract _compute;
    ParamComputeMEL _parameters;
    BooleanStore _store;
    BooleanMEL _result;
    Plugable _plugable;
    InfoDatum _idatum;
    boolean _withProbabilities;
    boolean _withTrueItem;
    int _nbrOrder;
    int _nbrCols;
    private static final int ID_NAME = -1;
    private static final int ID_PROBA_VALUE = -2;
    private static final int ID_PROBA_FACTOR = -3;
    private static final int ID_TRUE = 0;
    MELTableModel _itemsModel;
    JLabel _infoProba = new JLabel();
    JCheckBox _forOneHour;
    ArborForOneHourRenderer _renderer;
    String _title = null;

    private void prepareAccessData() {
        this._withProbabilities = this._parameters.getTypeProbability() != TypeProbability.NONE;
        this._withTrueItem = this._result.withAlwaysTrue();
        this._nbrOrder = this._result.getMaxOrder();
        this._nbrCols = 1 + this._nbrOrder;
        if (this._withProbabilities) {
            this._nbrCols += 2;
        }
        if (this._withTrueItem) {
            ++this._nbrCols;
        }
    }

    private int convertColIndexToID(int columnIndex) {
        if (columnIndex == 0) {
            return -1;
        }
        if (this._withProbabilities) {
            if (columnIndex == 1) {
                return -2;
            }
            if (columnIndex == 2) {
                return -3;
            }
            columnIndex -= 2;
        }
        if (this._withTrueItem) {
            if (columnIndex == 1) {
                return 0;
            }
            --columnIndex;
        }
        return columnIndex;
    }

    public MELPanel(ComputeMELAbstract compute, Plugable plugable, InfoDatum idatum, ArborRenderer renderer) {
        super(new GridBagLayout());
        this._compute = compute;
        this._plugable = plugable;
        this._idatum = idatum;
        this._result = this._compute.getResults();
        this._store = this._compute.getStore();
        this._parameters = this._compute.getParameters();
        double missionTimeH = this._parameters.getMissionTimeH();
        double averageFlight = this._store.getAverageFlightDuration();
        if (!Double.isNaN(averageFlight)) {
            missionTimeH = averageFlight / 3600.0;
        }
        this._renderer = new ArborForOneHourRenderer(renderer, missionTimeH);
        this.prepareAccessData();
        this._itemsModel = new MELTableModel();
        this.create();
    }

    private void create() {
        TableCellRenderer headerRenderer;
        MELTable table = new MELTable(this._itemsModel);
        String warning = this._result.getNominalItem().getWarning();
        if (warning != null && (headerRenderer = table.getTableHeader().getDefaultRenderer()) != null && headerRenderer instanceof JLabel) {
            ((JLabel)((Object)headerRenderer)).setToolTipText(new StringBuffer().append("<html>").append(warning.replaceAll("\\n", "<br/>")).append("</html>").toString());
        }
        JScrollPane scroll = new JScrollPane(table);
        this.add((Component)scroll, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 10), 0, 0));
        this.add((Component)this._infoProba, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        this._forOneHour = new JCheckBox(ResCompute.getString("KEY_0050"));
        this._forOneHour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MELPanel.this._renderer.setForOneHour(MELPanel.this._forOneHour.isSelected());
                MELPanel.this._itemsModel.fireTableChanged(new TableModelEvent(MELPanel.this._itemsModel));
                MELPanel.this._itemsModel.fireTableChanged(new TableModelEvent(MELPanel.this._itemsModel, -1, MELPanel.this._itemsModel.getRowCount(), 1));
                MELPanel.this.refreshStatusBar();
            }
        });
        double averageFlight = this._store.getAverageFlightDuration();
        if (!Double.isNaN(averageFlight) && averageFlight != this._parameters.getMissionTimeH()) {
            StringBuilder sb = new StringBuilder();
            sb.append(ResMsgObj.getString((String)"DLG_AVERAGEFLIGHT_EXPORT"));
            sb.append(" ").append(this._renderer.formatMissionTime(averageFlight));
            this._forOneHour.setToolTipText(sb.toString());
        }
        this.add((Component)this._forOneHour, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 5, 10), 0, 0));
        if (this._parameters.getTypeProbability() == TypeProbability.NONE) {
            this._forOneHour.setVisible(false);
        } else if (this._renderer.getMissionTime() == 1.0) {
            this._forOneHour.setEnabled(false);
        }
        this.refreshStatusBar();
    }

    private void refreshStatusBar() {
        StringBuffer sb = new StringBuffer();
        if (this._parameters.getLimitOrder() > 0) {
            sb.append(ResMsgVoc.getString((String)"VOC_TRUNCATED")).append(" ").append(this._parameters.getLimitOrder());
            if (this._parameters.withPessimistCompute()) {
                sb.append("-");
            }
            sb.append(" ; ");
        }
        sb.append(this._parameters.getTypeProbability().getLabel());
        if (this._parameters.getTypeProbability() != TypeProbability.NONE) {
            if (this._forOneHour.isSelected()) {
                sb.append(" ; ").append(this._forOneHour.getText());
                double averageFlight = this._store.getAverageFlightDuration();
                if (!Double.isNaN(averageFlight) && averageFlight != this._parameters.getMissionTimeH()) {
                    sb.append(" (/").append(this._renderer.formatNumber(averageFlight / 3600.0)).append("h)");
                }
            }
            sb.append(" ; ").append(this._renderer.formatNumber(this._parameters.getMissionTimeH()));
        }
        if (this._parameters.getPostTreatmentDormant().booleanValue()) {
            sb.append(" ; ");
            sb.append(ResCompute.getString("VOC_DORMANT"));
        }
        if (this._parameters.getPostTreatmentAtRisk().booleanValue()) {
            sb.append(" ; ");
            sb.append(ResCompute.getString("VOC_ENDOFFLY"));
            sb.append("(").append(this._renderer.formatNumber(this._parameters.getSpecificTime() / 3600.0)).append(")");
        }
        this._infoProba.setText(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File export(JChooserFileUtility.Type type) {
        StringBuilder defaultName = new StringBuilder();
        String treeName = FileUtility.protectFilename((String)this._store.getInfo(BooleanStore.INFO_TREE));
        String treeVersion = this._store.getInfo(BooleanStore.INFO_VERSION);
        defaultName.append(treeName).append("(").append(treeVersion).append(")").append(this.getFileExtention());
        File result = ExpBookUtility.selectFile((JChooserFileUtility.Type)type, (Plugable)this._plugable, (Component)this, null, (String)this.getFileExtention(), (String)defaultName.toString());
        if (result == null) {
            return null;
        }
        ExportMEL export = new ExportMEL(this._compute, (PrintExportMCS)this._plugable.getPreferencies(PrintExportMCS.PREF_KEY));
        export.setRenderer(this._renderer, this._renderer.isForOneHour());
        try {
            switch (type) {
                case DOCBOOK: 
                case WORD: {
                    if (export.verifyAnonymousReport(result, this)) {
                        DBKOutput writer = new DBKOutput(result.getAbsolutePath());
                        export.exportFormatDocBook(writer);
                        export.generateAnonymousReport(result, this);
                    }
                    break;
                }
                case XML: {
                    try (Writer writer = null;){
                        writer = new BufferedWriter(new FileWriter(result));
                        export.exportFormatXML(writer);
                        break;
                    }
                }
                default: {
                    throw new IOException("Unsupported format : " + type);
                }
            }
        }
        catch (IOException e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(ResMsgCore.getString((String)"FILE_ERROR_SAVE"));
            buffer.append("\n").append(result);
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), buffer.toString(), this.getTitle(), 0);
            result = null;
        }
        return result;
    }

    public Component getPanel() {
        return this;
    }

    public void trash() {
        File xmlFile;
        File dagFile = this._compute.getDagFile();
        if (dagFile != null && dagFile.exists() && !dagFile.delete()) {
            dagFile.deleteOnExit();
        }
        if ((xmlFile = this._compute.getXmlFile()) != null && xmlFile.exists() && !xmlFile.delete()) {
            xmlFile.deleteOnExit();
        }
    }

    protected String getTitleHeader() {
        return ResCompute.getString("PLUG_CMD_MEL_NAME");
    }

    protected String getFileExtention() {
        return ".mel";
    }

    synchronized String getTitle() {
        if (this._title == null) {
            String config;
            StringBuilder sb = new StringBuilder();
            sb.append(this.getTitleHeader());
            sb.append(" : ");
            BooleanStore store = this._compute.getStore();
            sb.append(store.getInfo(BooleanStore.INFO_PROJECT)).append("/");
            sb.append(store.getInfo(BooleanStore.INFO_SYSTEM)).append("/");
            sb.append(store.getInfo(BooleanStore.INFO_TREE)).append("(");
            sb.append(store.getInfo(BooleanStore.INFO_VERSION)).append(")");
            if (!store.getRoot().getName().equals(store.getInfo(BooleanStore.INFO_TREE))) {
                sb.append(" - ").append(store.getRoot().getName());
            }
            if ((config = store.getInfo(BooleanStore.INFO_CONFIGURATION)) != null && !config.equalsIgnoreCase("default")) {
                sb.append(" [").append(config).append("]");
            }
            this._title = sb.toString();
        }
        return this._title;
    }

    public String getInfo(String key) {
        if (key.equals("ppanel.title")) {
            return this.getTitle();
        }
        if (key.equals("ppanel.button")) {
            String config;
            StringBuffer sb = new StringBuffer();
            BooleanStore store = this._compute.getStore();
            String treeName = store.getInfo(BooleanStore.INFO_TREE);
            sb.append(treeName).append(";");
            sb.append(store.getInfo(BooleanStore.INFO_VERSION));
            String treeRoot = store.getRoot().getName();
            if (!treeRoot.equals(treeName)) {
                sb.append(" !");
            }
            if ((config = store.getInfo(BooleanStore.INFO_CONFIGURATION)) != null && !config.equalsIgnoreCase("default")) {
                sb.append(" [-]");
            }
            return sb.toString();
        }
        if (key.equals("ppanel.default.width")) {
            return "800";
        }
        if (key.equals("ppanel.default.height")) {
            return "400";
        }
        return key;
    }

    public Icon getIcon(String key) {
        if (key.equals("ppanel.icon")) {
            return ResIcoCompute.getImageIcon("PLUGIN_MEL");
        }
        return null;
    }

    public boolean isPrinting() {
        return true;
    }

    public void print() {
        PageFormat format = null;
        if (this._plugable instanceof ExtendedPlugable) {
            format = ((ExtendedPlugable)this._plugable).getPageFormat("docbook.file");
        }
        PrinterJob job = PrinterJob.getPrinterJob();
        if (format == null) {
            format = job.defaultPage();
        }
        if (!(this._plugable.getAppl() instanceof CAppl)) {
            return;
        }
        CAppl cAppl = (CAppl)this._plugable.getAppl();
        Pageable fgPageable = this.createPageable(null, cAppl.getPreferencies());
        try {
            job.setPrintable(fgPageable.getPrintable(0), format);
            if (job.printDialog()) {
                try {
                    job.print();
                }
                catch (PrinterException e) {
                    _LOG.log(Level.FINE, "Probleme d'impression d'un resultat de MEL : " + this._store.getInfo(BooleanStore.INFO_TREE), e);
                }
            }
        }
        catch (Throwable th) {
            _LOG.log(Level.WARNING, "Exception lors de l'impression d'un resultat de MEL : " + this._store.getInfo(BooleanStore.INFO_TREE), th);
        }
    }

    public boolean isPreviewing() {
        return true;
    }

    public void preview() {
        if (!(this._plugable.getAppl() instanceof CAppl)) {
            return;
        }
        CAppl cAppl = (CAppl)this._plugable.getAppl();
        Pageable fgPageable = this.createPageable(cAppl.getPageFormat(), cAppl.getPreferencies());
        if (fgPageable == null) {
            return;
        }
        PrintPreviewPrefsDlg dlg = new PrintPreviewPrefsDlg(JOptionCecilia.getWindowOf((Component)this), fgPageable, cAppl, new PrefFieldsCategory[0]){

            public void updatePreferencies() {
                this.setBook(MELPanel.this.createPageable(this.getFormat(), this.getPreferencies()));
            }
        };
        dlg.setLocationRelativeTo((Component)JOptionCecilia.getWindowOf((Component)this));
        dlg.setVisible(true);
    }

    public Pageable createPageable(final PageFormat callFormat, Preferencies preferencies) {
        PageableThread thread = new PageableThread(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Pageable doCreatePageable() {
                ListProcessorJavaInteractive pageable = null;
                PageFormat format = callFormat;
                if (format == null) {
                    if (MELPanel.this._plugable instanceof ExtendedPlugable) {
                        format = ((ExtendedPlugable)MELPanel.this._plugable).getPageFormat("docbook.file");
                    }
                    PrinterJob job = PrinterJob.getPrinterJob();
                    if (format == null) {
                        format = job.defaultPage();
                    }
                }
                try {
                    try (SrbInputStream scribe = new SrbInputStream("");){
                        ExportMEL export = new ExportMEL(MELPanel.this._compute, (PrintExportMCS)MELPanel.this._plugable.getPreferencies(PrintExportMCS.PREF_KEY));
                        export.setRenderer(MELPanel.this._renderer, MELPanel.this._renderer.isForOneHour());
                        export.exportFormatScribe(scribe);
                    }
                    pageable = new ListProcessorJavaInteractive(scribe);
                    pageable.processScribeFile();
                    pageable.computePageCount(format);
                }
                catch (Throwable th) {
                    _LOG.log(Level.WARNING, "Exception lors de l'impression d'un resultat de MCS : " + MELPanel.this._store.getInfo(BooleanStore.INFO_TREE), th);
                }
                return pageable;
            }
        };
        thread.realiseDo();
        return thread.getPageable();
    }

    public boolean isExporting(String format) {
        if (format.equalsIgnoreCase("XML")) {
            return true;
        }
        return format.equalsIgnoreCase("DOCBOOK");
    }

    public File export(String format) {
        if (format.equalsIgnoreCase("XML")) {
            return this.export(JChooserFileUtility.Type.XML);
        }
        if (format.equalsIgnoreCase("DOCBOOK")) {
            return this.export(JChooserFileUtility.Type.DOCBOOK);
        }
        return null;
    }

    public boolean copy() {
        return false;
    }

    public boolean configCloseable(PlugPanelExtend.HelperClose helper) {
        this._helperClose = helper;
        return true;
    }

    public IModel getModel(String key) {
        File file = null;
        if (key.equals("docbook.file")) {
            file = this.export(JChooserFileUtility.Type.DOCBOOK);
        } else if (key.equals("word.file")) {
            file = this.export(JChooserFileUtility.Type.WORD);
        } else if (key.equals("xml.file")) {
            file = this.export(JChooserFileUtility.Type.XML);
        }
        if (file != null) {
            return new IModel.DefaultModel(key, file, this._idatum.getModel().getName(), this._idatum.getModel().getUID());
        }
        return null;
    }

    class MELTableModel
    implements TableModel {
        protected EventListenerList _listenerList = new EventListenerList();

        MELTableModel() {
        }

        @Override
        public int getRowCount() {
            return MELPanel.this._result.getNbrItems();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            BooleanMEL.Item item = MELPanel.this._result.getItemAt(rowIndex);
            int id = MELPanel.this.convertColIndexToID(columnIndex);
            switch (id) {
                case -1: {
                    BooleanNode node = item.getNode();
                    if (node == null) {
                        return ResCompute.getString("MEL_DLG_REFERENCE");
                    }
                    return node.getName();
                }
                case -2: {
                    return item.getProbability();
                }
                case -3: {
                    return item.getProbability() / MELPanel.this._result.getNominalItem().getProbability();
                }
                case 0: {
                    return item.isAlwaysTrue() ? "1" : "0";
                }
            }
            return item.getOrderNumber(id);
        }

        @Override
        public int getColumnCount() {
            return MELPanel.this._nbrCols;
        }

        @Override
        public String getColumnName(int columnIndex) {
            int id = MELPanel.this.convertColIndexToID(columnIndex);
            BooleanMEL.Item item = MELPanel.this._result.getNominalItem();
            String appendColor = "";
            if (item.isAlwaysTrue()) {
                appendColor = "Red";
            } else if (item.isAlwaysFalse()) {
                appendColor = "Green";
            } else if (item.getWarning() != null) {
                appendColor = "Blue";
            }
            String title = "";
            String value = "";
            switch (id) {
                case -1: {
                    title = ResMsgVoc.getString((String)"VOC_EVENTS");
                    value = ResCompute.getString("MEL_TARGET_NOMINAL");
                    break;
                }
                case -2: {
                    title = ResCompute.getString("MEL_DLG_MEL_PROBABILITIES");
                    value = MELPanel.this._renderer.formatProbability(item.getProbability());
                    break;
                }
                case -3: {
                    title = ResMsgVoc.getString((String)"VOC_FACTOR");
                    value = "-";
                    break;
                }
                case 0: {
                    title = ResCompute.msgFormat("MEL_DLG_ORDER_I", 0);
                    value = item.isAlwaysTrue() ? "1" : "0";
                    break;
                }
                default: {
                    title = ResCompute.msgFormat("MEL_DLG_ORDER_I", id);
                    value = Long.toString(item.getOrderNumber(id));
                }
            }
            StringBuffer sb = new StringBuffer(256);
            sb.append("<html>");
            sb.append("<center>").append(title).append("</center>");
            sb.append("<center><b>");
            if (appendColor.length() > 0) {
                sb.append("<font color='").append(appendColor).append("'>");
            }
            sb.append(value);
            if (appendColor.length() > 0) {
                sb.append("</font>");
            }
            sb.append("</b></center>");
            sb.append("</html>");
            return sb.toString();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            int id = MELPanel.this.convertColIndexToID(columnIndex);
            switch (id) {
                case -1: {
                    return String.class;
                }
                case -3: 
                case -2: {
                    return Double.class;
                }
            }
            return Long.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this._listenerList.add(TableModelListener.class, l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this._listenerList.remove(TableModelListener.class, l);
        }

        public void fireTableChanged(TableModelEvent e) {
            Object[] listeners = this._listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TableModelListener.class) continue;
                ((TableModelListener)listeners[i + 1]).tableChanged(e);
            }
        }
    }

    protected class MELTable
    extends JTable
    implements JTableTransfertHandler.HelperConvert {
        public MELTable(MELTableModel model) {
            super(model);
            this.setTransferHandler((TransferHandler)new JTableTransfertHandler());
            this.setDefaultRenderer(String.class, new MELCellRenderer());
            this.setDefaultRenderer(Long.class, new MELCellRenderer());
            this.setDefaultRenderer(Double.class, new MELDoubleCellRenderer());
            TableRowSorter<MELTableModel> sorterTable = new TableRowSorter<MELTableModel>(model);
            this.setRowSorter(sorterTable);
        }

        @Override
        public void createDefaultColumnsFromModel() {
            super.createDefaultColumnsFromModel();
            for (int col = 0; col < this.getColumnCount(); ++col) {
                int width = 4;
                switch (MELPanel.this.convertColIndexToID(col)) {
                    case -1: {
                        width = 10;
                        break;
                    }
                    case -2: {
                        width = 8;
                        break;
                    }
                    case -3: {
                        width = 8;
                        break;
                    }
                }
                this.getColumnModel().getColumn(col).setPreferredWidth(13 * width);
            }
        }

        public String convertToString(Object obj, int row, int col) {
            if (obj == null) {
                return "";
            }
            if (obj instanceof Double) {
                double dvalue = (Double)obj;
                if (Double.isNaN(dvalue)) {
                    return "-";
                }
                if (this.convertColumnIndexToModel(col) == 1) {
                    return Double.toString(MELPanel.this._renderer.convertProbability(dvalue));
                }
                return Double.toString(dvalue);
            }
            return obj.toString();
        }
    }

    protected class MELDoubleCellRenderer
    extends MELCellRenderer {
        protected MELDoubleCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value == null) {
                this.setText("");
            } else {
                double dvalue = (Double)value;
                if (Double.isNaN(dvalue)) {
                    this.setText("-");
                } else if (table.convertColumnIndexToModel(column) == 1) {
                    this.setText(MELPanel.this._renderer.formatProbability(dvalue));
                } else {
                    this.setText(MELPanel.this._renderer.formatNumber(dvalue));
                }
            }
            return this;
        }
    }

    protected class MELCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            row = table.convertRowIndexToModel(row);
            col = table.convertColumnIndexToModel(col);
            this.setHorizontalAlignment(col == 0 ? 2 : 0);
            BooleanMEL.Item item = MELPanel.this._result.getItemAt(row);
            if (item.isAlwaysTrue()) {
                this.setForeground(Color.red);
            } else if (item.isAlwaysFalse()) {
                this.setForeground(Color.green);
            } else if (item.getWarning() != null) {
                this.setForeground(Color.blue);
            } else if (isSelected) {
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(table.getForeground());
            }
            String warning = item.getWarning();
            if (warning == null) {
                this.setToolTipText(null);
            } else {
                this.setToolTipText(new StringBuffer().append("<html>").append(warning.replaceAll("\\n", "<br/>")).append("</html>").toString());
            }
            return this;
        }
    }
}

