/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.task;

import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDMEL;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMEL;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainer;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskItem;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskIEnginePrepareMELSimple
extends TaskItem
implements EngineBDDMEL.TargetsAccessor {
    private static Logger _LOG = Logger.getLogger(TaskIEnginePrepareMELSimple.class.getPackage().getName());
    Collection<String> _events;
    ParamComputeMEL _parameters;
    BooleanStore _store;
    boolean _error;
    boolean _bPrepareEngine = false;

    public TaskIEnginePrepareMELSimple(TaskContainer container, ParamComputeMEL parameters, BooleanStore store) {
        super(container);
        this._parameters = parameters;
        this._store = store;
    }

    @Override
    public void run() {
        this._error = true;
        try {
            this._events = this._parameters.getEvents(this._store, null);
            if (this._events.size() == 0) {
                throw new IOException("No events selected");
            }
            this._error = false;
        }
        catch (IOException e) {
            this.addError(ResCompute.getString("MSG_ENGINE_ERR_PREPARE"));
            _LOG.log(Level.WARNING, "IOException during write probabilities : " + e.getMessage(), e);
        }
    }

    @Override
    public Iterator<String> iterate() {
        if (this._events != null) {
            return this._events.iterator();
        }
        return null;
    }

    @Override
    public int size() {
        if (this._events != null) {
            return this._events.size();
        }
        return 0;
    }

    @Override
    public int getNbrEvents() {
        if (this._bPrepareEngine) {
            return this.size();
        }
        try {
            Collection<String> events = this._parameters.getEvents(this._store, null);
            return events.size();
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public String getInfo() {
        return ResCompute.getString("TASK_INFO_ENGINE_PREPARE");
    }

    @Override
    public void requestStop() {
    }

    @Override
    public boolean continueWhenFinnished() {
        return !this._error;
    }
}

