/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.task;

import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMCS;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainer;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultLoadMCS;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskItem;
import java.io.File;
import java.util.logging.Logger;

public class TaskIResultLoadMCSForMELSimple
extends TaskItem {
    private static Logger _LOG = Logger.getLogger(TaskIResultLoadMCSForMELSimple.class.getPackage().getName());
    BooleanStore _store;
    BooleanMCS _mcs;
    InfoDatum _idatum;
    Plugable _launcher;
    boolean _withError;
    boolean _requestStop = false;

    public TaskIResultLoadMCSForMELSimple(TaskContainer container, BooleanStore store, BooleanMCS mcs, InfoDatum idatum, Plugable launcher) {
        super(container);
        this._store = store;
        this._mcs = mcs;
        this._idatum = idatum;
        this._launcher = launcher;
        this._withError = false;
    }

    @Override
    public void run() {
        String key;
        InfoDatum idatum = this._idatum;
        if (!this._withError && (key = this._idatum.getKey()).endsWith(".Abstract")) {
            String config = (String)this._idatum.getParameters().get("Config");
            StringBuilder sbKey = new StringBuilder(key.length() + config.length());
            sbKey.append(key.substring(0, key.length() - ".Abstract".length()));
            sbKey.append("@").append(config);
            key = sbKey.toString();
            idatum = this._launcher.getDatum(key);
            if (idatum == null) {
                this.addError(ResCompute.getString("MSG_RESULT_ERR_GETDATUM"));
                this._withError = true;
            } else {
                String msgError = (String)idatum.getParameters().get("tree.error");
                if (msgError != null && !msgError.isEmpty()) {
                    this.addError(msgError);
                    this._withError = true;
                }
            }
        }
        if (!this._withError) {
            File file = (File)idatum.getInputFiles().get("result.cuts");
            if (file == null) {
                _LOG.severe("No input file for key = 'result.cuts'");
                this._withError = true;
            } else if (!TaskIResultLoadMCS.loadCuts(file, this._store, this._mcs)) {
                this._withError = true;
            }
        }
        if (this._withError) {
            this.addError(ResCompute.getString("MSG_RESULT_ERR_LOAD"));
        }
    }

    @Override
    public String getInfo() {
        return ResCompute.getString("TASK_INFO_RESULT_LOAD");
    }

    @Override
    public void requestStop() {
        this._requestStop = true;
    }

    @Override
    public boolean continueWhenFinnished() {
        return !this._withError;
    }
}

