/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.task;

import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.lib.util.io.XMLWriter;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanAttrAvg;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ComputeAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainer;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskItem;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TaskIResultSaveAbstract
extends TaskItem {
    private static Logger _LOG = Logger.getLogger(TaskIResultSaveAbstract.class.getPackage().getName());
    private ComputeAbstract _compute;

    public TaskIResultSaveAbstract(TaskContainer container, ComputeAbstract compute) {
        super(container);
        this._compute = compute;
    }

    protected ComputeAbstract getCompute() {
        return this._compute;
    }

    protected static void appendParameters(Writer writer, String indent, BooleanStore store, ParamComputeAbstract parameters) throws IOException {
        Collection<BooleanAttrAvg> attributeAverage;
        StringBuffer buffer = new StringBuffer();
        double averageFlight = store.getAverageFlightDuration();
        if (!Double.isNaN(averageFlight)) {
            buffer.append(" average-flight-duration='").append(Double.toString(averageFlight)).append("'");
        }
        if ((parameters.getTypeProbability() == TypeProbability.ARP1 || parameters.getTypeProbability() == TypeProbability.ARP2) && (attributeAverage = store.getAttributeAverage()) != null && attributeAverage.size() > 0) {
            BooleanAttrAvg attAvg = attributeAverage.iterator().next();
            buffer.append(" average-risk-approach-attribute='").append(XMLWriter.toXML((String)attAvg.getAttributeKey().getName())).append("'");
        }
        parameters.saveToXML(writer, indent, buffer.toString());
    }

    protected static void appendWarnings(Writer writer, String indent, BooleanStore store, BooleanResult results) throws IOException {
        String warning = results.getWarning();
        if (warning != null) {
            StringTokenizer st = new StringTokenizer(warning, "\n");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                writer.append(indent).append("  <ftc.warning");
                writer.append(" msg='").append(XMLWriter.toXML((String)token)).append("'");
                writer.append("/>\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveParameters(BooleanStore store, ParamComputeAbstract parameters) {
        File file = null;
        try {
            file = File.createTempFile("BParameters", ".xml");
            file.deleteOnExit();
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Error during create 'parameters file'", e);
            return null;
        }
        boolean bSuccess = false;
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.append("<?xml version='1.0' encoding='iso-8859-15'?>\n");
            TaskIResultSaveAbstract.appendParameters(writer, "", store, parameters);
            bSuccess = true;
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Error during save 'parameters file'", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    _LOG.log(Level.INFO, "Error during close 'parameters file'", e);
                }
            }
        }
        if (!bSuccess && file.exists()) {
            file.delete();
        }
        return file;
    }

    @Override
    public String getInfo() {
        return ResCompute.getString("TASK_INFO_RESULT_SAVE");
    }

    @Override
    public void requestStop() {
    }

    @Override
    public boolean continueWhenFinnished() {
        return true;
    }
}

