/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mcs.ban.aralia;

import com.dassault.cecilia.lib.ban.BanProcessComponent;
import com.dassault.cecilia.lib.ban.BanProcessException;
import java.util.StringTokenizer;

public class TypeTimes
extends BanProcessComponent {
    String _from;
    String _to;
    String _step;
    String _at;

    public void setFrom(String value) {
        this._from = value;
    }

    public void setTo(String value) {
        this._to = value;
    }

    public void setStep(String value) {
        this._step = value;
    }

    public void setAt(String value) {
        this._at = value;
    }

    public void startValid() {
        if (this._at != null ? this._from != null || this._to != null || this._step != null : this._from == null || this._to == null || this._step == null) {
            throw new BanProcessException("Element 'times' must have 'at' attribute or 'from', 'to' and 'step' attributs.");
        }
    }

    protected String toAraliaString() {
        if (this._at != null) {
            String at = this.expanse(this._at);
            StringBuffer sb = new StringBuffer((at.length() + 10) * 3 / 2);
            StringTokenizer st = new StringTokenizer(at, " \t\n;:");
            try {
                while (st.hasMoreTokens()) {
                    String value = st.nextToken();
                    double dval = Double.parseDouble(value);
                    if (dval < 0.0) {
                        throw new BanProcessException("Error in definition of attribute 'at' : " + at);
                    }
                    if (sb.length() > 0) {
                        sb.append(", ");
                    } else {
                        sb.append("at ");
                    }
                    sb.append(value);
                }
            }
            catch (NumberFormatException e) {
                throw new BanProcessException("Error in definition of attribute 'at' : " + at, e);
            }
            if (sb.length() == 0) {
                throw new BanProcessException("Error in definition of attribute 'at' : " + at);
            }
            return sb.toString();
        }
        StringBuffer sb = new StringBuffer(64);
        String from = this.expanse(this._from);
        String to = this.expanse(this._to);
        String step = this.expanse(this._step);
        sb.append("from ").append(from).append(" to ").append(to).append(" step ").append(step);
        double vfrom = this.verifyDouble("from", from);
        double vto = this.verifyDouble("to", to);
        double vstep = this.verifyDouble("step", step);
        if (vfrom > vto) {
            throw new BanProcessException("Error in definition of attributes " + sb.toString() + ": from>to");
        }
        if (vstep > vto - vfrom) {
            throw new BanProcessException("Error in definition of attributes " + sb.toString() + ": step>(to-from)");
        }
        return sb.toString();
    }

    private double verifyDouble(String attr, String value) {
        try {
            double dval = Double.parseDouble(value);
            if (dval < 0.0) {
                throw new BanProcessException("Error in definition of attribute '" + attr + "' : " + value);
            }
            return dval;
        }
        catch (NumberFormatException e) {
            throw new BanProcessException("Error in definition of attribute '" + attr + "' : " + value, e);
        }
    }
}

