/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.general.treatment;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.core.swing.other.JCRLabel;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.plugin.general.treatment.MapStringToStringPanel;
import com.dassault.cecilia.plugin.general.treatment.ResTreatment;
import com.dassault.cecilia.plugin.general.treatment.XsltParametersIO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class XsltParameters {
    String _inputKey;
    String _outputKey;
    String _xsltStyle;
    Map<String, String> _xsltParameters;
    Map<String, String> _xsltOutProperties;
    private static FileFilter __filterXSL = new FileFilterExtention("Stylesheet file (*.xsl)", ".xsl").verifyRead(true);
    protected static IOParameters _instance = new XsltParametersIO();

    public String getInput() {
        return this._inputKey;
    }

    public String getOutput() {
        return this._outputKey;
    }

    public String getStyle() {
        return this._xsltStyle;
    }

    public Map<String, String> getParameters() {
        return this._xsltParameters;
    }

    public Map<String, String> getOutputProperties() {
        return this._xsltOutProperties;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append(ResTreatment.getString("XSLT_INPUT"));
        sb.append(" : ").append(this._inputKey).append("\n");
        sb.append(ResTreatment.getString("XSLT_OUTPUT"));
        sb.append(" : ").append(this._outputKey).append("\n");
        sb.append(ResTreatment.getString("XSLT_STYLE_PATH"));
        sb.append(" : ").append(this._xsltStyle).append("\n");
        if (this._xsltParameters.size() > 0) {
            sb.append(ResTreatment.getString("XSLT_STYLE_PARAMETERS"));
            sb.append(" : \n");
            for (Map.Entry<String, String> entry : this._xsltParameters.entrySet()) {
                sb.append("    ").append(entry.getKey()).append(" = ");
                sb.append(entry.getValue()).append("\n");
            }
        }
        if (this._xsltOutProperties.size() > 0) {
            sb.append(ResTreatment.getString("XSLT_STYLE_OUTPUTPROPERTIES"));
            sb.append(" : \n");
            for (Map.Entry<String, String> entry : this._xsltOutProperties.entrySet()) {
                sb.append("    ").append(entry.getKey()).append(" = ");
                sb.append(entry.getValue()).append("\n");
            }
        }
        return sb.toString();
    }

    public XsltParameters() {
        this("");
    }

    public XsltParameters(String style) {
        this._xsltStyle = style;
        this._inputKey = "%{file}";
        this._outputKey = "%{path}/%{name}.html";
        this._xsltParameters = new LinkedHashMap<String, String>();
        this._xsltOutProperties = new LinkedHashMap<String, String>();
    }

    public XsltParameters(XsltParameters src) {
        this._xsltStyle = src._xsltStyle;
        this._inputKey = src._inputKey;
        this._outputKey = src._outputKey;
        this._xsltParameters = new LinkedHashMap<String, String>(src._xsltParameters);
        this._xsltOutProperties = new LinkedHashMap<String, String>(src._xsltOutProperties);
    }

    public boolean VerifyData(Plugable launcher) {
        if (this._xsltStyle.length() == 0) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResTreatment.getString("XSLT_STYLE_ERROR"), ResMsgVoc.getString((String)"VOC_ERROR"), 0);
            return false;
        }
        return true;
    }

    public boolean change(PluginManager launcher) {
        Window win = SwingUtilities.getWindowAncestor(launcher.getWindow());
        if (win == null) {
            win = launcher.getWindow();
        }
        DlgChangeXsltParameters dlg = new DlgChangeXsltParameters(win);
        dlg._ctrlInput.setText(this._inputKey);
        dlg._ctrlOutput.setText(this._outputKey);
        dlg._ctrlStyle.setText(this._xsltStyle);
        dlg._panelParams.setData(this._xsltParameters);
        dlg._panelOutProps.setData(this._xsltOutProperties);
        dlg.setVisible(true);
        if (dlg.getResult()) {
            this._inputKey = dlg._ctrlInput.getText().trim();
            this._outputKey = dlg._ctrlOutput.getText().trim();
            this._xsltStyle = dlg._ctrlStyle.getText().trim();
            this._xsltParameters = new LinkedHashMap<String, String>(dlg._panelParams.getData());
            this._xsltOutProperties = new LinkedHashMap<String, String>(dlg._panelOutProps.getData());
            return true;
        }
        return false;
    }

    public static IOParameters getIOParameters() {
        return _instance;
    }

    class DlgChangeXsltParameters
    extends JDialogCecilia {
        JTextField _ctrlStyle;
        JTextField _ctrlInput;
        JTextField _ctrlOutput;
        MapStringToStringPanel _panelParams;
        MapStringToStringPanel _panelOutProps;
        JButton _butStyle;
        JFileChooser _fileChooser;

        public DlgChangeXsltParameters(Window win) {
            super(win, true);
            this.init();
        }

        protected JComponent createInOutPanel() {
            JPanel root = new JPanel(new GridBagLayout());
            int line = 0;
            root.add((Component)new JCRLabel(ResTreatment.getString("XSLT_INPUT")), new GridBagConstraints(0, line, 1, 1, 100.0, 100.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlInput = new JTextField(20);
            root.add((Component)this._ctrlInput, new GridBagConstraints(1, line++, 1, 1, 10.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            root.add((Component)new JCRLabel(ResTreatment.getString("XSLT_OUTPUT")), new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlOutput = new JTextField(20);
            root.add((Component)this._ctrlOutput, new GridBagConstraints(1, line++, 1, 1, 10.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            return root;
        }

        protected JComponent createStylePanel() {
            JPanel root = new JPanel(new GridBagLayout());
            root.setBorder(BorderFactory.createTitledBorder(ResTreatment.getString("XSLT_STYLE_TITLE")));
            int line = 0;
            root.add((Component)new JCRLabel(ResTreatment.getString("XSLT_STYLE_PATH")), new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlStyle = new JTextField(20);
            root.add((Component)this._ctrlStyle, new GridBagConstraints(1, line, 1, 1, 10.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            this._butStyle = new JButton("...");
            root.add((Component)this._butStyle, new GridBagConstraints(2, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this._butStyle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser dlg;
                    if (DlgChangeXsltParameters.this._fileChooser == null) {
                        DlgChangeXsltParameters.this._fileChooser = new JFileChooser();
                        DlgChangeXsltParameters.this._fileChooser.setCurrentDirectory(new File("."));
                        DlgChangeXsltParameters.this._fileChooser.addChoosableFileFilter(__filterXSL);
                        DlgChangeXsltParameters.this._fileChooser.setFileFilter(__filterXSL);
                        DlgChangeXsltParameters.this._fileChooser.setSelectedFile(new File(DlgChangeXsltParameters.this._ctrlStyle.getText()));
                    }
                    if ((dlg = DlgChangeXsltParameters.this._fileChooser).showOpenDialog(DlgChangeXsltParameters.this._ctrlStyle) == 0) {
                        DlgChangeXsltParameters.this._ctrlStyle.setText(FileFilterExtention.addDefaultExtention((JFileChooser)dlg).getPath());
                    }
                }
            });
            this._panelParams = new MapStringToStringPanel(ResTreatment.getString("XSLT_STYLE_PARAMETERS"));
            this._panelParams.setPreferredHeight(75);
            root.add((Component)this._panelParams, new GridBagConstraints(0, ++line, 3, 1, 10.0, 10.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this._panelOutProps = new MapStringToStringPanel(ResTreatment.getString("XSLT_STYLE_OUTPUTPROPERTIES"));
            this._panelOutProps.setPreferredHeight(50);
            root.add((Component)this._panelOutProps, new GridBagConstraints(0, ++line, 3, 1, 10.0, 5.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            ++line;
            return root;
        }

        protected void init() {
            super.init();
            JPanel rPanel = new JPanel(new GridBagLayout());
            rPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            rPanel.add((Component)this.createInOutPanel(), new GridBagConstraints(0, 0, 1, 1, 10.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            rPanel.add((Component)this.createStylePanel(), new GridBagConstraints(0, 1, 1, 1, 10.0, 10.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            rPanel.add((Component)this.createButPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)rPanel, "Center");
            this.pack();
            Dimension tSize = this.getSize();
            Dimension pSize = this.getOwner().getSize();
            Point pLoc = this.getOwner().getLocation();
            this.setLocation(pLoc.x + pSize.width / 2 - tSize.width / 2, pLoc.y + pSize.height / 2 - tSize.height / 2);
            this.setTitle(ResTreatment.getString("XSLT_PARAMETERS_TITLE"));
        }

        protected boolean verifyParameters() {
            String stylesheet = this._ctrlStyle.getText();
            if (!FileUtility.verifyPath((String)stylesheet, (boolean)false, (Component)this._ctrlStyle, (String)this.getTitle())) {
                return false;
            }
            if (!this._panelParams.verifyData(true)) {
                return false;
            }
            return this._panelOutProps.verifyData(false);
        }
    }
}

