/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.cstepper.opt;

import com.dassault.cecilia.core.plugin.AbstractPlugPanelInfo;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableProxyModel;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.Translator;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.inference.StepperInference;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.cstepper.PluginInference;
import com.dassault.cecilia.plugin.mbsa.cstepper.ResCStep;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class PluginCmdIFlatness
extends PluginInference
implements PluginMAction {
    protected PluginCmdIFlatness() {
    }

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResCStep.getString("PLUG_CMD_FLATNESS_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResCStep.getString("PLUG_CMD_FLATNESS_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A2-04.svg"));
        }
        return super.getIcon(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSession(Plugable launch, Object params) {
        PlugableProxyModel launcher = new PlugableProxyModel(launch);
        IModel model = launcher.getModel("altarica.file");
        if (model == null) {
            return;
        }
        Translator trans = this.createTranslator((Plugable)launcher);
        if (trans == null) {
            return;
        }
        File outFile = this.createFile((Plugable)launcher);
        if (outFile == null) {
            return;
        }
        File resFile = null;
        try {
            if (!trans.translate(outFile, true)) {
                return;
            }
            resFile = this.createFile((Plugable)launcher);
            if (resFile == null) {
                return;
            }
            try {
                StepperInference.flatness((String)outFile.getAbsolutePath(), (String)model.getName(), (String)resFile.getAbsolutePath());
            }
            catch (StepperException e) {
                this.displayError((Plugable)launcher, trans, e);
                if (!outFile.delete()) {
                    outFile.deleteOnExit();
                }
                if (resFile != null && !resFile.delete()) {
                    resFile.deleteOnExit();
                }
                return;
            }
            try {
                AbstractPlugPanelInfo pPane = new AbstractPlugPanelInfo(){

                    protected String getLabel() {
                        return "Flatness model : ";
                    }
                };
                pPane.load(resFile);
                launcher.addPanel((PlugPanel)pPane, model.getUID());
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), "Display result file : " + e1.getMessage(), ResCStep.getString("DEF_TITLE"), 0);
            }
        }
        finally {
            if (!outFile.delete()) {
                outFile.deleteOnExit();
            }
            if (resFile != null && !resFile.delete()) {
                resFile.deleteOnExit();
            }
        }
    }
}

