/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.cstepper.opt;

import com.dassault.cecilia.core.plugin.AbstractPlugTaskBanWithLog;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.cstepper.PluginCmdXTree;
import com.dassault.cecilia.plugin.mbsa.cstepper.ResCStep;
import com.dassault.cecilia.plugin.mbsa.cstepper.UtilityPluginTargetsXTree;
import com.dassault.cecilia.plugin.mbsa.viewer.DlgTargetsSelection;
import com.dassault.cecilia.plugin.mbsa.viewer.ban.BatchTreeImport;
import java.awt.Component;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class PluginCmdITree
extends PluginCmdXTree {
    protected static final String DEPEND_CMD = "com.dassault.cecilia.plugin.mbsa.viewer.PluginCmdViewStepper";

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResCStep.getString("PLUG_CMD_ITREE_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResCStep.getString("PLUG_CMD_ITREE_DESC");
        }
        return super.getInfo(key);
    }

    @Override
    public boolean withOption(Plugable plugable) {
        return false;
    }

    @Override
    protected boolean specificPreVerify(Plugable launch) {
        PluginModel plugin = launch.getPlugin(DEPEND_CMD);
        if (plugin == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launch.getWindow()), ResCStep.getString("ERR_DEPEND_PLUGIN") + "\n   [com.dassault.cecilia.plugin.mbsa.viewer.PluginCmdViewStepper]");
            return false;
        }
        return true;
    }

    @Override
    protected Stepper createBanIStepper(Plugable launcher) {
        return this.createBanStepper(launcher);
    }

    @Override
    protected AbstractPlugTaskBanWithLog createTask(final Plugable launcher, IModel model, DlgTargetsSelection dlg, Stepper stepper) {
        File logFile = this.createFile(launcher, "ITree", ".log");
        if (logFile == null) {
            return null;
        }
        InputStream baseScript = ((Object)((Object)this)).getClass().getResourceAsStream("BanScriptITree.xml");
        if (baseScript == null) {
            Logger.getLogger(PluginCmdITree.class.getPackage().getName()).severe("Resource script not found : BanScriptITree.xml");
            return null;
        }
        UtilityPluginTargetsXTree util = new UtilityPluginTargetsXTree(this, dlg.getTargets(), dlg.getDbOutputSelection());
        BanInputStream script = util.createBanScript(launcher, "ITree", baseScript, logFile);
        if (script == null) {
            return null;
        }
        BanEntry entry = util.createBanEntry(launcher, null);
        if (entry == null) {
            return null;
        }
        entry.addUnit(BatchTreeImport.class);
        entry.setIdObject("stepper-id", (Object)stepper);
        entry.setUserProperty("itree.log.path", logFile.getAbsolutePath());
        AbstractPlugTaskBanWithLog task = new AbstractPlugTaskBanWithLog(model.getUID(), launcher, entry, script, logFile){

            protected String getDesc() {
                return ResCStep.getString("PLUG_CMD_ITREE_NAME");
            }

            protected String getName() {
                return "ITree";
            }

            public Icon getIcon(String key) {
                if (key.equals("ptask.icon")) {
                    return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A2-03.svg"));
                }
                return super.getIcon(key);
            }

            protected void displayResult(File pathInfo, boolean endTrace) {
                super.displayResult(pathInfo, endTrace);
                launcher.getAppl().refreshDAOFolder();
                launcher.getAppl().refreshFolders(true);
            }
        };
        launcher.addTask((PlugTask)task, model.getUID());
        return task;
    }
}

