/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.cstepper.opt;

import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMCompiler;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.cstepper.BanInferencePlugin;
import com.dassault.cecilia.plugin.mbsa.cstepper.PluginInference;
import com.dassault.cecilia.plugin.mbsa.cstepper.ResCStep;
import com.dassault.cecilia.plugin.mbsa.cstepper.opt.PluginStepperInference;
import java.io.File;
import java.net.URL;
import javax.swing.Icon;

public class PluginCompilerInference
extends PluginInference
implements PluginMCompiler {
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResCStep.getString("PLUG_COMPILER_NAME");
        }
        if (key.equals("plugin.description")) {
            return ResCStep.getString("PLUG_COMPILER_DESC");
        }
        if (key.equals("type")) {
            return "PluginCompiler";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A2-06.svg"));
        }
        return super.getIcon(key);
    }

    public boolean compileFile(Plugable launcher, Object parameters, File result) {
        if (this.verifyPluginTranslator(launcher) == null) {
            return false;
        }
        IModel model = launcher.getModel("altarica.file");
        if (model == null) {
            return false;
        }
        final String outpath = result.getAbsolutePath();
        BanInferencePlugin plugInf = new BanInferencePlugin(model){

            @Override
            protected void prepareBanEntry(Plugable launch, Object ... objects) {
                super.prepareBanEntry(launch, objects);
                BanEntry ban = this.getBanEntry();
                ban.setUserProperty("altr.input", this.getModel().getFile().getAbsolutePath());
                ban.setUserProperty("altr.main", this.getModel().getName());
                ban.setUserProperty("altr.output", outpath);
                ban.setUserProperty("action.stepper", "false");
            }
        };
        return plugInf.banExecute(launcher, null, new Object[0]) != null;
    }

    public Stepper createStepper(Plugable launcher, Object parameters, File compil) {
        if (this.verifyPluginTranslator(launcher) == null) {
            return null;
        }
        final String inpath = compil.getAbsolutePath();
        BanInferencePlugin plugInf = new BanInferencePlugin(null){

            @Override
            protected void prepareBanEntry(Plugable launch, Object ... objects) {
                BanEntry ban = this.getBanEntry();
                ban.setUserProperty("altr.input", inpath);
                ban.setUserProperty("action.translate", "false");
                ban.setUserProperty("simulator.loop", Boolean.toString(PlugableUtility.getBoolOpt((Plugable)launch, (String)PluginStepperInference.OPT_LOOP, (boolean)false)));
                ban.setUserProperty("instantaneous.auto", Boolean.toString(PlugableUtility.getBoolOpt((Plugable)launch, (String)Stepper.OPTION_INSTANTANEOUS_AUTO, (boolean)true)));
                String instLoop = PlugableUtility.getStrOpt((Plugable)launch, (String)Stepper.OPTION_INSTANTANEOUS_LOOP, (String)Integer.toString(100));
                try {
                    int value = Integer.parseInt(instLoop);
                    if (value > 0) {
                        ban.setUserProperty("instantaneous.loop", Integer.toString(value));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        BanEntry ban = plugInf.banExecute(launcher, null, new Object[0]);
        if (ban != null) {
            return (Stepper)ban.getIdObject("stepper-id");
        }
        return null;
    }
}

