/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.cstepper.opt;

import com.dassault.cecilia.core.plugin.AbstractPlugPanelInfo;
import com.dassault.cecilia.core.plugin.AbstractPlugTask;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.mbsa.inference.StepperInference;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.cstepper.ResCStep;
import com.dassault.cecilia.plugin.mbsa.cstepper.opt.TargetITree;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class TaskITree
extends AbstractPlugTask {
    protected Plugable _launcher;
    protected String _pathInfo;
    protected IModel _model;
    protected List<TargetITree> _tgts;
    protected int _cpt;
    protected String _msgRun;
    StepperInference _stepper;

    public TaskITree(Plugable launcher, IModel model, StepperInference infStepper, String pathInfo) {
        this._launcher = launcher;
        this._stepper = infStepper;
        this._pathInfo = pathInfo;
        this._tgts = new ArrayList<TargetITree>();
        this._msgRun = ResCStep.getString("PRV_CMD_ITREE_WORK");
        this._cpt = -1;
    }

    public void addCompute(TargetModel tgt) {
        this._tgts.add(new TargetITree(tgt, this._pathInfo, this._launcher));
    }

    public boolean isPriority() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInfo(String key) {
        if (key.equals("process.msg")) {
            TaskITree taskITree = this;
            synchronized (taskITree) {
                if (this._cpt < 0) {
                    return ResCStep.getString("PRV_CMD_ITREE_WAIT");
                }
                if (this._cpt >= this._tgts.size()) {
                    return ResCStep.getString("PRV_CMD_ITREE_FINISH");
                }
                return this._msgRun + this._tgts.get(this._cpt);
            }
        }
        if (key.equals("process.msg.high")) {
            int size = this._tgts.size();
            StringBuffer msg = new StringBuffer(10);
            msg.append(this._cpt >= size ? size : this._cpt + 1);
            msg.append("/");
            msg.append(size);
            return msg.toString();
        }
        if (key.equals("process.p1000")) {
            return Integer.toString(this._cpt < 0 ? 0 : 1000 * this._cpt / this._tgts.size());
        }
        if (key.equals("plugin.name")) {
            return "ITree";
        }
        if (key.equals("ptask.desc")) {
            return ResCStep.getString("PLUG_CMD_ITREE_NAME");
        }
        return null;
    }

    public Icon getIcon(String key) {
        if (key.equals("ptask.icon")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A2-03.svg"));
        }
        return super.getIcon(key);
    }

    public void run() {
        try {
            this._cpt = 0;
            while (!this.checkStopped() && this._cpt < this._tgts.size()) {
                this.checkSuspended(false);
                this.launchCompute(this._cpt);
                ++this._cpt;
            }
            this.displayResult();
            this._launcher = null;
            this._stepper = null;
        }
        catch (InterruptedException fileInfo) {
            this._launcher = null;
            this._stepper = null;
            System.gc();
            if (this.checkStopped()) {
                for (int i = 0; i < this._tgts.size(); ++i) {
                    new File(this._tgts.get((int)i)._model.getFilePath()).delete();
                }
            }
            if ((fileInfo = new File(this._pathInfo)).exists() && !fileInfo.delete()) {
                fileInfo.deleteOnExit();
            }
        }
        catch (Throwable throwable) {
            File fileInfo;
            this._launcher = null;
            this._stepper = null;
            System.gc();
            if (this.checkStopped()) {
                for (int i = 0; i < this._tgts.size(); ++i) {
                    new File(this._tgts.get((int)i)._model.getFilePath()).delete();
                }
            }
            if ((fileInfo = new File(this._pathInfo)).exists() && !fileInfo.delete()) {
                fileInfo.deleteOnExit();
            }
            throw throwable;
        }
        System.gc();
        if (this.checkStopped()) {
            for (int i = 0; i < this._tgts.size(); ++i) {
                new File(this._tgts.get((int)i)._model.getFilePath()).delete();
            }
        }
        if ((fileInfo = new File(this._pathInfo)).exists() && !fileInfo.delete()) {
            fileInfo.deleteOnExit();
        }
    }

    protected void launchCompute(int cpt) throws InterruptedException {
        Thread.sleep(100L);
        this._msgRun = ResCStep.getString("PRV_CMD_ITREE_WORK");
        TargetITree tgt = this._tgts.get(cpt);
        StringBuffer params = new StringBuffer(tgt._params.length() + 10);
        params.append("< ").append(tgt._params).append(" >");
        if (!this._stepper.generateTree(params.toString())) {
            new File(this._tgts.get((int)cpt)._model.getFilePath()).delete();
        }
    }

    private void displayResult() {
        try {
            AbstractPlugPanelInfo pPane = new AbstractPlugPanelInfo(){

                protected String getLabel() {
                    return ResCStep.getString("PRV_CMD_ITREE_INFO_LBL");
                }

                public String getInfo(String key) {
                    if (key.equals("ppanel.title")) {
                        return ResCStep.getString("PRV_CMD_ITREE_INFO_TITLE");
                    }
                    if (key.equals("ppanel.default.width")) {
                        return "600";
                    }
                    if (key.equals("ppanel.default.height")) {
                        return "480";
                    }
                    return super.getInfo(key);
                }
            };
            pPane.load(new File(this._pathInfo), true);
            this._launcher.addPanel((PlugPanel)pPane, this._model.getUID());
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this._launcher.getWindow()), "Display result file : " + e1.getMessage(), ResCStep.getString("DEF_TITLE"), 0);
        }
    }
}

