/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.abc.ban;

import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.util.FileUtility;
import com.dassault.cecilia.lib.mbsa.abc.ban.AltaEngine;
import com.dassault.cecilia.lib.mbsa.stepper.ban.BanTarget;
import com.dassault.cecilia.lib.util.io.IndentWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class AltaA2B
extends AltaEngine {
    public static final String PROP_ABC_VERBOSE = "cecilia.mbsa.abc.Verbose";
    protected List<BanTarget> _targets = new ArrayList<BanTarget>();

    public BanTarget createTarget() {
        BanTarget tgt = new BanTarget();
        this._targets.add(tgt);
        return tgt;
    }

    @Override
    public void endValid() {
        if (this._targets.size() == 0) {
            throw new BanProcessException("there are no 'target' elements");
        }
        super.endValid();
    }

    @Override
    protected String getIDRoot() {
        return "alta-a2b";
    }

    @Override
    protected File createXMLScript(File model) throws IOException {
        Map<String, String> opts = this.getParams();
        String id = this.getIDRoot();
        File fileCmds = this.createTempFile("cmd-" + id, ".xml");
        this.getFinnisher().addTmpFile(fileCmds);
        BufferedWriter bufWriter = new BufferedWriter(new FileWriter(fileCmds));
        IndentWriter writer = new IndentWriter(bufWriter, " ");
        writer.write(this.getXMLHeader());
        writer.write("<!DOCTYPE " + id + ">\n");
        writer.write("<" + id + ">\n");
        writer.addIndent(1);
        writer.write("<load file=\"");
        writer.writeEscapeXML(model.getAbsolutePath());
        writer.write("\" format=\"altarica\"/>\n");
        writer.write("<set node=\"");
        String node = this.expanse(this._node);
        writer.write(node, true);
        writer.write("\" />\n");
        writer.write("<set format=\"");
        writer.writeEscapeXML(this.getOpt(opts, "format", "aralia"));
        writer.write("\" />\n");
        writer.write("<set algorithm=\"");
        writer.writeEscapeXML(this.getOpt(opts, "algorithm", "ite"));
        writer.write("\" />\n");
        writer.write("<set verbose=\"");
        writer.write(Boolean.getBoolean(PROP_ABC_VERBOSE) ? "2" : "1");
        writer.write("\" />\n");
        writer.write("<set simplification=\"");
        writer.writeEscapeXML(this.getOpt(opts, "simplify", "0"));
        writer.write("\" />\n");
        writer.write("<compile>\n");
        writer.addIndent(1);
        for (BanTarget tgt : this._targets) {
            writer.write("<target variable=\"");
            writer.writeEscapeXML(tgt.getName());
            writer.write("\" value=\"");
            writer.writeEscapeXML(tgt.getValue());
            writer.write("\" output=\"");
            writer.writeEscapeXML(tgt.getDstFile().getAbsolutePath());
            writer.write("\" />\n");
        }
        writer.addIndent(-1);
        writer.write("</compile>\n");
        writer.addIndent(-1);
        writer.write("</" + id + ">\n");
        writer.close(true);
        return fileCmds;
    }

    @Override
    protected void findExecutable(ArrayList<String> cmds) {
        String execute = "alta-a2b";
        execute = this._launch.getExecutable() != null ? this.expanse(this._launch.getExecutable()) : FileUtility.findExePath(execute, this.getClass());
        cmds.add(execute);
    }

    @Override
    public void execute() {
        this.executeStd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeStdAfter() throws IOException {
        super.executeStdAfter();
        for (BanTarget tgt : this._targets) {
            Map<String, String> params = tgt.getParams();
            String criticity = params.get("criticity");
            String initialConf = params.get("initialConf");
            String userGeneration = params.get("userGeneration");
            String modelRefPath = params.get("refPath");
            String dateGeneration = params.get("lastModifiedDateModel");
            String target = params.get("target");
            Function<String, Boolean> func = string -> string != null && !string.trim().isEmpty();
            boolean withCrit = func.apply(criticity);
            boolean withConf = func.apply(initialConf);
            boolean withUserGeneration = func.apply(userGeneration);
            boolean withModelRefPath = func.apply(modelRefPath);
            boolean withDateGeneration = func.apply(dateGeneration);
            boolean withTarget = func.apply(target);
            if (!withCrit && !withConf) continue;
            OutputStreamWriter out = null;
            try {
                out = new FileWriter(tgt.getDstFile(), true);
                if (withCrit) {
                    this.writeInfo(out, "DassaultSpecialCriticity", tgt, criticity.trim());
                }
                if (withConf) {
                    this.writeInfo(out, "DassaultSpecialInitialConf", tgt, initialConf.trim());
                }
                if (withUserGeneration) {
                    this.writeInfo(out, "DassaultSpecialUserGeneration", tgt, userGeneration.trim());
                }
                if (withModelRefPath) {
                    this.writeInfo(out, "DassaultSpecialModelRefPath", tgt, modelRefPath.trim());
                }
                if (withDateGeneration) {
                    this.writeInfo(out, "DassaultSpecialDateGeneration", tgt, dateGeneration.trim());
                }
                if (!withTarget) continue;
                this.writeInfo(out, "DassaultSpecialTarget", tgt, target.trim());
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }

    private void writeInfo(Appendable out, String attributeKey, BanTarget tgt, String attributeValue) throws IOException {
        out.append("attribute set ");
        out.append(attributeKey);
        out.append(" ");
        out.append("").append(tgt.getName()).append(".").append(tgt.getValue()).append(" ");
        out.append("'").append(attributeValue).append("';\n");
    }
}

