/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.inference.ban;

import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.inference.StepperInference;
import com.dassault.cecilia.lib.mbsa.inference.ban.IEngineWithStepper;
import com.dassault.cecilia.lib.mbsa.stepper.ban.BanTarget;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class IEngineSeq
extends IEngineWithStepper {
    @Override
    protected boolean launchEngine(StepperInference stepper, File dst, BanTarget tgt, boolean append) throws StepperException {
        StringWriter writer = new StringWriter(256);
        try {
            writer.write("<");
            this.writeCmdOptions(writer, dst, tgt, append);
            writer.write(">");
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stepper.searchSequences(writer.toString());
    }

    protected void writeCmdOptions(Writer writer, File dst, BanTarget tgt, boolean append) throws IOException {
        Map<String, String> opts = this.getOptions();
        Map<String, String> params = tgt.getParams();
        writer.write(" output.file=\"");
        writer.write(tgt.getDstFile().getAbsolutePath());
        writer.write("\" info.file=\"");
        writer.write(dst.getAbsolutePath());
        writer.write("\" info.append=\"");
        writer.write(Boolean.toString(append));
        writer.write("\" target.length=\"1");
        writer.write("\" target.name.1=\"");
        writer.write(tgt.getName());
        writer.write("\" target.value.1=\"");
        writer.write(tgt.getValue());
        writer.write("\" generator.type=\"");
        String finder = this.getOpt(params, "finder", "permutation");
        writer.write(finder);
        writer.write("\" filter.order=\"");
        writer.write(this.getOpt(params, finder + ".order", "3"));
        boolean MCS = this.getOpt(params, "resultset", "minseqs").equals("mincuts");
        boolean fast = this.getOpt(opts, "fast.generator", "false").equals("true");
        if (MCS || fast) {
            writer.write("\" generator.option=\"");
            if (MCS) {
                writer.write("-MCS ");
            }
            if (fast) {
                writer.write("-fast ");
            }
        }
        writer.write("\" filter.locker=\"");
        writer.write(this.getOpt(params, "locker", "true"));
        String opt = this.getOpt(opts, "display.trace", null);
        if (opt != null && opt.length() > 0) {
            writer.write("\" display.trace=\"");
            writer.write(opt);
        }
        if ((opt = this.getOpt(opts, "display.error", null)) != null && opt.length() > 0) {
            writer.write("\" display.error=\"");
            writer.write(opt);
        }
        if ((opt = this.getOpt(opts, "display.sequence", null)) != null && opt.length() > 0) {
            writer.write("\" display.sequence=\"");
            writer.write(opt);
        }
        writer.write("\"");
    }

    @Override
    protected void writeCmdExtern(Writer writer, File src, File dst, String model, BanTarget tgt, boolean append) throws IOException {
        writer.write("< action=\"seq");
        writer.write("\" input.file=\"");
        writer.write(src.getAbsolutePath());
        writer.write("\" model=\"");
        writer.write(model);
        writer.write("\" language=\"");
        writer.write("english");
        writer.write("\"");
        this.writeCmdOptions(writer, dst, tgt, append);
        writer.write(">");
    }
}

