/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.jstepper.v1;

import java.util.ArrayList;
import java.util.List;

public abstract class JDomain {
    int _idx = -1;
    private static final JDomain jBool = new JDomain(){
        List<String> _values = null;
        List<Double> _doubleValues = null;

        @Override
        public int getIdx() {
            return 0;
        }

        @Override
        public double verify(double value) {
            return value == 0.0 || value == 1.0 ? value : Double.NaN;
        }

        @Override
        public String toString(double value) {
            return value == 0.0 ? "false" : "true";
        }

        @Override
        public double parse(String strValue) {
            if (strValue.equals("false")) {
                return 0.0;
            }
            if (strValue.equals("true")) {
                return 1.0;
            }
            return Double.NaN;
        }

        @Override
        public String displayScale() {
            return "bool";
        }

        @Override
        public List<String> getValues() {
            if (this._values == null) {
                this._values = new ArrayList<String>(3);
                this._values.add("false");
                this._values.add("true");
            }
            return this._values;
        }

        @Override
        public List<Double> getDoubleValues() {
            if (this._doubleValues == null) {
                this._doubleValues = new ArrayList<Double>(3);
                this._doubleValues.add(0.0);
                this._doubleValues.add(1.0);
            }
            return this._doubleValues;
        }
    };
    private static final JDomain jInt = new JDomain(){

        @Override
        public int getIdx() {
            return 1;
        }

        @Override
        public double verify(double value) {
            return Math.ceil(value);
        }

        @Override
        public String toString(double value) {
            return Long.toString((long)value);
        }

        @Override
        public double parse(String strValue) {
            try {
                return Long.parseLong(strValue);
            }
            catch (NumberFormatException exc) {
                return Double.NaN;
            }
        }

        @Override
        public String displayScale() {
            return "int";
        }

        @Override
        public List<String> getValues() {
            return null;
        }

        @Override
        public List<Double> getDoubleValues() {
            return null;
        }
    };
    private static final JDomain jFloat = new JDomain(){

        @Override
        public int getIdx() {
            return 2;
        }

        @Override
        public double verify(double value) {
            return value;
        }

        @Override
        public String toString(double value) {
            return Double.toString(value);
        }

        @Override
        public double parse(String strValue) {
            try {
                return Double.parseDouble(strValue);
            }
            catch (NumberFormatException exc) {
                return Double.NaN;
            }
        }

        @Override
        public String displayScale() {
            return "float";
        }

        @Override
        public List<String> getValues() {
            return null;
        }

        @Override
        public List<Double> getDoubleValues() {
            return null;
        }
    };

    public abstract double verify(double var1);

    public abstract String toString(double var1);

    public abstract double parse(String var1);

    public abstract String displayScale();

    public abstract List<String> getValues();

    public abstract List<Double> getDoubleValues();

    public int getIdx() {
        return this._idx;
    }

    public static JDomain JBool() {
        return jBool;
    }

    public static JDomain JInt() {
        return jInt;
    }

    public static JDomain JFloat() {
        return jFloat;
    }
}

