/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.jstepper.v1;

import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDefArchitecture;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDomain;
import java.util.ArrayList;
import java.util.List;

class JEnumDomain
extends JDomain {
    int[] _enums;
    JDefArchitecture _architect;
    List<String> _values = null;
    List<Double> _doubleValues = null;

    JEnumDomain(JDefArchitecture architect, int[] enums) {
        this._architect = architect;
        this._enums = enums;
    }

    private boolean find(int val) {
        for (int i = 0; i < this._enums.length; ++i) {
            if (this._enums[i] != val) continue;
            return true;
        }
        return false;
    }

    boolean equivalent(int[] enums) {
        if (this._enums.length != enums.length) {
            return false;
        }
        for (int i = 0; i < enums.length; ++i) {
            if (this.find(enums[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public double verify(double value) {
        int i = (int)value;
        return this.find(i) ? (double)i : Double.NaN;
    }

    @Override
    public String toString(double value) {
        if (Double.isNaN(value)) {
            return "NaN";
        }
        int i = (int)value;
        return this._architect.toEnumString(i);
    }

    @Override
    public double parse(String strValue) {
        int val = this._architect.getEnumValue(strValue);
        if (this.find(val)) {
            return val;
        }
        return Double.NaN;
    }

    @Override
    public String displayScale() {
        StringBuffer sb = new StringBuffer(this._enums.length * 32);
        sb.append("{");
        for (int i = 0; i < this._enums.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this._architect.toEnumString(this._enums[i]));
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public List<String> getValues() {
        if (this._values == null) {
            this._values = new ArrayList<String>(this._enums.length + 1);
            for (int i = 0; i < this._enums.length; ++i) {
                this._values.add(this._architect.toEnumString(this._enums[i]));
            }
        }
        return this._values;
    }

    @Override
    public List<Double> getDoubleValues() {
        if (this._doubleValues == null) {
            this._doubleValues = new ArrayList<Double>(this._enums.length + 1);
            for (int i = 0; i < this._enums.length; ++i) {
                this._doubleValues.add(Double.valueOf(this._enums[i]));
            }
        }
        return this._doubleValues;
    }
}

