/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.jstepper.v1;

import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDefComponent;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDefNode;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JEvent;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JVariable;
import com.dassault.cecilia.lib.util.io.IndentWriter;
import java.io.IOException;

public abstract class JTrans
implements Cloneable {
    private JEvent _evt;
    private JDefNode _parent;
    String _description;
    private double _firingTime = Double.POSITIVE_INFINITY;
    private int _idx = -1;
    long _step = -1L;
    boolean _valid = false;

    public JTrans(JEvent evt, JDefNode parent) {
        this._evt = evt;
        this._evt.addTrans(this);
        this._parent = parent;
    }

    public Object clone() {
        try {
            Object res = super.clone();
            return res;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String val) {
        this._description = val;
    }

    public JEvent getEvent() {
        return this._evt;
    }

    public JDefNode getNode() {
        return this._parent;
    }

    public void setFiringTime(double time) {
        this._firingTime = time;
    }

    public double getFiringTime() {
        return this._firingTime;
    }

    public void setIdx(int idx) {
        assert (this._idx == -1);
        this._idx = idx;
    }

    public int getIdx() {
        return this._idx;
    }

    protected JVariable getState(String name) {
        return ((JDefComponent)this._parent).getState(name);
    }

    protected JVariable getFlow(String name) {
        return this._parent.getFlow(name);
    }

    public boolean isValid() throws StepperException {
        long step = this.getNode().getSimulator().getCurrentStep();
        if (this._step != step) {
            this._step = step;
            this._valid = this.testValid();
        }
        return this._valid;
    }

    protected abstract boolean testValid() throws StepperException;

    public abstract void affect() throws StepperException;

    public void addSimul() {
        this._parent.addSimul();
    }

    public void print(IndentWriter out) throws IOException {
        out.write(this._evt.getPathName());
        out.write(" : ");
        out.write(this.getDescription());
        out.write("\n");
    }
}

