/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.jstepper.v1;

import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDefNode;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JEvent;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JTrans;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class JTransSync
extends JTrans {
    private ArrayList<JTrans> _sons;
    private boolean _diffusion;
    private BitSet _affectFlags;

    public JTransSync(JEvent evt, JDefNode parent, boolean diffusion, List<JTrans> transs) {
        super(evt, parent);
        this._sons = new ArrayList<JTrans>(transs);
        this._affectFlags = new BitSet(this._sons.size());
        this._diffusion = diffusion;
    }

    @Override
    public String getDescription() {
        StringBuffer sb = new StringBuffer(128);
        if (this._diffusion) {
            sb.append("Diff : ");
        } else {
            sb.append("Sync : ");
        }
        for (JTrans son : this._sons) {
            sb.append("< ");
            sb.append(son.getEvent().getPathName());
            sb.append(" || ");
            sb.append(son.getDescription());
            sb.append("> ");
        }
        return sb.toString();
    }

    @Override
    public boolean testValid() throws StepperException {
        for (JTrans son : this._sons) {
            if (son.testValid()) {
                if (!this._diffusion) continue;
                return true;
            }
            if (this._diffusion) continue;
            return false;
        }
        return !this._diffusion;
    }

    @Override
    public void affect() throws StepperException {
        if (this._diffusion) {
            int i;
            this._affectFlags.clear();
            int size = this._sons.size();
            for (i = 0; i < size; ++i) {
                JTrans son = this._sons.get(i);
                if (!son.testValid()) continue;
                this._affectFlags.set(i);
            }
            for (i = 0; i < size; ++i) {
                if (!this._affectFlags.get(i)) continue;
                this._sons.get(i).affect();
            }
        } else {
            for (JTrans son : this._sons) {
                son.affect();
            }
        }
    }

    @Override
    public void addSimul() {
        for (JTrans son : this._sons) {
            son.addSimul();
        }
        super.addSimul();
    }
}

