/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.jstepper.v1;

import com.dassault.cecilia.lib.mbsa.StepperViolatedAssertionException;
import com.dassault.cecilia.lib.mbsa.jstepper.MsgJStep;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JVariable;

public class JValue {
    private int _cptChg = 0;
    private long _step = -1L;
    private double _value = Double.NaN;
    private JVariable _var = null;
    protected static final int Monitor_NaN = 1;
    protected static final int Monitor_NaN_Domain = 2;
    protected static final int Monitor_Chg_Messag = 3;
    protected static final int Monitor_Chg_Warning = 4;
    protected static final int Monitor_Chg_Error = 5;
    protected static final int Monitor_Chg_First = 6;
    protected static final int Monitor_Set_Value = 10;

    public JValue(JVariable var) {
        this._var = var;
    }

    protected final JVariable getVar() {
        return this._var;
    }

    protected void monitoring(int K, double value) {
    }

    public boolean setValue(double value) throws StepperViolatedAssertionException {
        if (Double.isNaN(this._value) || this._value != value) {
            if (Double.isNaN(value)) {
                this.monitoring(1, value);
                throw new StepperViolatedAssertionException(MsgJStep.msgFormat("EXC_STEP_VALUE_UNDEF", this._var.getPathName()));
            }
            double vvalue = this._var.getDomain().verify(value);
            if (Double.isNaN(vvalue)) {
                this.monitoring(2, value);
                throw new StepperViolatedAssertionException(MsgJStep.msgFormat("EXC_STEP_VALUE_NO_CORRECT", this._var.getPathName(), this._var.getDomain().toString(value), this._var.getDomain().displayScale()));
            }
            value = vvalue;
            long step = this._var.getNode().getSimulator().getCurrentStep();
            if (step != this._step) {
                this._step = step;
                this._cptChg = 0;
                this._var.getNode().getSimulator().addBackValue(this, this._value);
                this.monitoring(6, value);
            } else {
                ++this._cptChg;
                int maxChg = this._var.getMaxChange();
                if (this._cptChg >= 1) {
                    this.monitoring(4, value);
                    this._var.getNode().getSimulator().setBeginLoop(true);
                    if (this._cptChg > maxChg) {
                        this.monitoring(5, value);
                        MsgJStep.LOG.fine(MsgJStep.msgFormat("EXC_STEP_VALUE_TWO_VALUE", this._var.getPathName()));
                        MsgJStep.LOG.fine("_value=" + this._value + ",value=" + value);
                        MsgJStep.LOG.fine("CptChg=" + this._cptChg + ",MaxChg=" + maxChg);
                        StepperViolatedAssertionException exc = new StepperViolatedAssertionException(MsgJStep.msgFormat("EXC_STEP_VALUE_TWO_VALUE", this._var.getPathName()));
                        exc.printStackTrace();
                        throw exc;
                    }
                } else {
                    this.monitoring(3, value);
                }
            }
            this._value = value;
            return true;
        }
        this.monitoring(10, value);
        return false;
    }

    public void setDirectValue(double value) {
        this._value = value;
    }

    public double getValue() {
        return this._value;
    }

    public boolean isValued() {
        return !Double.isNaN(this._value);
    }
}

