/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepper;

import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HelperStepper
implements Stepper {
    Map<String, Var> _varMap = new HashMap<String, Var>();
    Map<String, Event> _evtMap = new HashMap<String, Event>();
    Stepper _delegate;

    public HelperStepper(Stepper delegate) throws StepperException {
        this._delegate = delegate;
        if (this._delegate == null) {
            throw new StepperException("No stepper delegate");
        }
        this.init();
    }

    public Var getVar(String name) {
        return this._varMap.get(name);
    }

    public Event getEvent(String name) {
        return this._evtMap.get(name);
    }

    private void init() throws StepperException {
        Var var;
        String name;
        int i;
        int len = this._delegate.getNbrTransition();
        for (i = 1; i <= len; ++i) {
            name = this._delegate.getNameOfTransition(i);
            Event evt = this.getEvent(name);
            if (evt == null) {
                this._evtMap.put(name, new Event(name, i));
                continue;
            }
            evt._idxTrs.add(i);
        }
        len = this._delegate.getNbrState();
        for (i = 1; i <= len; ++i) {
            name = this._delegate.getNameOfState(i);
            var = this.getVar(name);
            if (var != null) {
                throw new StepperException("Same name for two var : " + name);
            }
            this._varMap.put(name, new Var(name, true, i));
        }
        len = this._delegate.getNbrFlow();
        for (i = 1; i <= len; ++i) {
            name = this._delegate.getNameOfFlow(i);
            var = this.getVar(name);
            if (var != null) {
                throw new StepperException("Same name for two var : " + name);
            }
            this._varMap.put(name, new Var(name, false, i));
        }
    }

    @Override
    public void dispose() {
        this._delegate.dispose();
    }

    @Override
    public long getUID() {
        return this._delegate.getUID();
    }

    @Override
    public int getCurrentCycle() {
        return this._delegate.getCurrentCycle();
    }

    @Override
    public double getCurrentTime() {
        return this._delegate.getCurrentTime();
    }

    @Override
    public String getDescOfTransition(int i) {
        return this._delegate.getDescOfTransition(i);
    }

    @Override
    public int getDomainOfFlow(int i) {
        return this._delegate.getDomainOfFlow(i);
    }

    @Override
    public int getDomainOfState(int i) {
        return this._delegate.getDomainOfState(i);
    }

    @Override
    public String getNameOfFlow(int idx) {
        return this._delegate.getNameOfFlow(idx);
    }

    @Override
    public String getNameOfState(int i) {
        return this._delegate.getNameOfState(i);
    }

    @Override
    public String getNameOfTransition(int i) {
        return this._delegate.getNameOfTransition(i);
    }

    @Override
    public int getNbrFlow() {
        return this._delegate.getNbrFlow();
    }

    @Override
    public int getNbrState() {
        return this._delegate.getNbrState();
    }

    @Override
    public int getNbrTransition() {
        return this._delegate.getNbrTransition();
    }

    @Override
    public int[] getSheduler() {
        return this._delegate.getSheduler();
    }

    @Override
    public double getValueOfFlow(int idx) {
        return this._delegate.getValueOfFlow(idx);
    }

    @Override
    public double getValueOfState(int i) {
        return this._delegate.getValueOfState(i);
    }

    @Override
    public List<String> getValuesOfDomain(int i) {
        return this._delegate.getValuesOfDomain(i);
    }

    @Override
    public List<Double> getDoubleValuesOfDomain(int i) {
        return this._delegate.getDoubleValuesOfDomain(i);
    }

    @Override
    public String getValueStringOfFlow(int idx) {
        return this._delegate.getValueStringOfFlow(idx);
    }

    @Override
    public String getValueStringOfState(int i) {
        return this._delegate.getValueStringOfState(i);
    }

    @Override
    public boolean goBackward(int nbrTrans) throws StepperException {
        return this._delegate.goBackward(nbrTrans);
    }

    @Override
    public boolean goForward(int idTrans) throws StepperException {
        return this._delegate.goForward(idTrans);
    }

    @Override
    public boolean goInitialState() throws StepperException {
        return this._delegate.goInitialState();
    }

    @Override
    public double isValidTransition(int idx) throws StepperException {
        return this._delegate.isValidTransition(idx);
    }

    @Override
    public boolean setSimulOptions(List<String> args) {
        return this._delegate.setSimulOptions(args);
    }

    @Override
    public boolean setValueOfState(int i, String value) throws StepperException {
        return this._delegate.setValueOfState(i, value);
    }

    @Override
    public boolean setValueOfState(int i, double value) throws StepperException {
        return this._delegate.setValueOfState(i, value);
    }

    @Override
    public boolean setInitOfState(int i, String value) {
        return this._delegate.setInitOfState(i, value);
    }

    @Override
    public boolean setInitOfState(int i, double value) {
        return this._delegate.setInitOfState(i, value);
    }

    @Override
    public boolean withDomain() {
        return this._delegate.withDomain();
    }

    @Override
    public boolean withSimul() {
        return this._delegate.withSimul();
    }

    public class Var {
        boolean _isState;
        int _idx;
        String _name;

        Var(String name, boolean isState, int idx) {
            this._name = name;
            this._isState = isState;
            this._idx = idx;
        }

        public boolean isState() {
            return this._isState;
        }

        public int getIdx() {
            return this._idx;
        }
    }

    public class Event {
        String _name;
        List<Integer> _idxTrs = new ArrayList<Integer>(2);
        Integer[] _result;

        Event(String name, int idx) {
            this._name = name;
            this._idxTrs.add(idx);
        }

        public Integer[] getAllIdx() {
            if (this._result == null) {
                this._result = new Integer[this._idxTrs.size()];
            }
            return this._idxTrs.toArray(this._result);
        }

        public int getNbrTrans() {
            return this._idxTrs.size();
        }

        public int getTrans(int idx) {
            return this._idxTrs.get(idx);
        }

        public String getName() {
            return this._name;
        }
    }
}

