/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepper;

import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatisticsStepper
implements Stepper {
    Stepper _delegate;
    private Map<String, StatItem> _statistics = new HashMap<String, StatItem>();

    public StatisticsStepper(Stepper delegate) {
        this._delegate = delegate;
    }

    protected void finalize() throws Throwable {
        Logger log = Logger.getLogger(StatisticsStepper.class.getPackage().getName());
        if (log.isLoggable(Level.INFO)) {
            StringBuffer sb = new StringBuffer(2048);
            this.printStatistics(sb);
            log.info(sb.toString());
        }
    }

    @Override
    public void dispose() {
        this._delegate.dispose();
    }

    private void beginMethod(String key) {
        StatItem item = this._statistics.get(key);
        if (item == null) {
            item = new StatItem();
            this._statistics.put(key, item);
        }
        ++item._cpt;
        item._beginTime = System.nanoTime();
    }

    private void endMethod(String key) {
        StatItem item = this._statistics.get(key);
        if (item != null) {
            long time = System.nanoTime();
            item._cumuledTime += time - item._beginTime;
        }
    }

    private void printStatistics(Appendable output) throws IOException {
        output.append("\n");
        output.append("\n");
        output.append("-------------------------------------------------------\n");
        output.append(String.format("%40s\n", this._delegate.getClass().getName()));
        output.append("-------------------------------------------------------\n");
        long totalCpt = 0L;
        long totalTime = 0L;
        if (Boolean.getBoolean("cecilia.mbsa.stepper.statistics.sortTime")) {
            TreeMap<Long, String> sortLine = new TreeMap<Long, String>(new Comparator<Long>(){

                @Override
                public int compare(Long o1, Long o2) {
                    if (o2 < o1) {
                        return -1;
                    }
                    if (o2 == o1) {
                        return 0;
                    }
                    return 1;
                }
            });
            for (Map.Entry<String, StatItem> entry : this._statistics.entrySet()) {
                long time = entry.getValue()._cumuledTime;
                String line = String.format("%-22s;% 9d;% 12d;% 9d\n", entry.getKey(), entry.getValue()._cpt, time, time / entry.getValue()._cpt);
                sortLine.put(time, line);
                totalCpt += entry.getValue()._cpt;
                totalTime += time;
            }
            for (String line : sortLine.values()) {
                output.append(line);
            }
        } else {
            TreeMap<String, StatItem> map = new TreeMap<String, StatItem>(this._statistics);
            for (Map.Entry entry : map.entrySet()) {
                long time = ((StatItem)entry.getValue())._cumuledTime;
                output.append(String.format("%-22s;% 9d;% 12d;% 9d\n", entry.getKey(), ((StatItem)entry.getValue())._cpt, time, time / ((StatItem)entry.getValue())._cpt));
                totalCpt += ((StatItem)entry.getValue())._cpt;
                totalTime += time;
            }
        }
        output.append("-------------------------------------------------------\n");
        output.append(String.format("%-22s;% 9d;% 12d\n", "Total", totalCpt, totalTime));
    }

    @Override
    public long getUID() {
        return this._delegate.getUID();
    }

    @Override
    public int getCurrentCycle() {
        this.beginMethod("getCurrentCycle");
        int result = this._delegate.getCurrentCycle();
        this.endMethod("getCurrentCycle");
        return result;
    }

    @Override
    public double getCurrentTime() {
        this.beginMethod("getCurrentTime");
        double result = this._delegate.getCurrentTime();
        this.endMethod("getCurrentTime");
        return result;
    }

    @Override
    public String getDescOfTransition(int i) {
        this.beginMethod("getDescOfTransition");
        String result = this._delegate.getDescOfTransition(i);
        this.endMethod("getDescOfTransition");
        return result;
    }

    @Override
    public int getDomainOfFlow(int i) {
        this.beginMethod("getDomainOfFlow");
        int result = this._delegate.getDomainOfFlow(i);
        this.endMethod("getDomainOfFlow");
        return result;
    }

    @Override
    public int getDomainOfState(int i) {
        this.beginMethod("getDomainOfState");
        int result = this._delegate.getDomainOfState(i);
        this.endMethod("getDomainOfState");
        return result;
    }

    @Override
    public String getNameOfFlow(int idx) {
        this.beginMethod("getNameOfFlow");
        String result = this._delegate.getNameOfFlow(idx);
        this.endMethod("getNameOfFlow");
        return result;
    }

    @Override
    public String getNameOfState(int i) {
        this.beginMethod("getNameOfState");
        String result = this._delegate.getNameOfState(i);
        this.endMethod("getNameOfState");
        return result;
    }

    @Override
    public String getNameOfTransition(int i) {
        this.beginMethod("getNameOfTransition");
        String result = this._delegate.getNameOfTransition(i);
        this.endMethod("getNameOfTransition");
        return result;
    }

    @Override
    public int getNbrFlow() {
        this.beginMethod("getNbrFlow");
        int result = this._delegate.getNbrFlow();
        this.endMethod("getNbrFlow");
        return result;
    }

    @Override
    public int getNbrState() {
        this.beginMethod("getNbrState");
        int result = this._delegate.getNbrState();
        this.endMethod("getNbrState");
        return result;
    }

    @Override
    public int getNbrTransition() {
        this.beginMethod("getNbrTransition");
        int result = this._delegate.getNbrTransition();
        this.endMethod("getNbrTransition");
        return result;
    }

    @Override
    public int[] getSheduler() {
        this.beginMethod("getSheduler");
        int[] result = this._delegate.getSheduler();
        this.endMethod("getSheduler");
        return result;
    }

    @Override
    public double getValueOfFlow(int idx) {
        this.beginMethod("getValueOfFlow");
        double result = this._delegate.getValueOfFlow(idx);
        this.endMethod("getValueOfFlow");
        return result;
    }

    @Override
    public double getValueOfState(int i) {
        this.beginMethod("getValueOfState");
        double result = this._delegate.getValueOfState(i);
        this.endMethod("getValueOfState");
        return result;
    }

    @Override
    public List<String> getValuesOfDomain(int i) {
        this.beginMethod("getValuesOfDomain");
        List<String> result = this._delegate.getValuesOfDomain(i);
        this.endMethod("getValuesOfDomain");
        return result;
    }

    @Override
    public List<Double> getDoubleValuesOfDomain(int i) {
        this.beginMethod("getDoubleValuesOfDomain");
        List<Double> result = this._delegate.getDoubleValuesOfDomain(i);
        this.endMethod("getDoubleValuesOfDomain");
        return result;
    }

    @Override
    public String getValueStringOfFlow(int idx) {
        this.beginMethod("getValueStringOfFlow");
        String result = this._delegate.getValueStringOfFlow(idx);
        this.endMethod("getValueStringOfFlow");
        return result;
    }

    @Override
    public String getValueStringOfState(int i) {
        this.beginMethod("getValueStringOfState");
        String result = this._delegate.getValueStringOfState(i);
        this.endMethod("getValueStringOfState");
        return result;
    }

    @Override
    public boolean goBackward(int nbrTrans) throws StepperException {
        this.beginMethod("goBackward");
        boolean result = this._delegate.goBackward(nbrTrans);
        this.endMethod("goBackward");
        return result;
    }

    @Override
    public boolean goForward(int idTrans) throws StepperException {
        this.beginMethod("goForward");
        boolean result = this._delegate.goForward(idTrans);
        this.endMethod("goForward");
        return result;
    }

    @Override
    public boolean goInitialState() throws StepperException {
        this.beginMethod("goInitialState");
        boolean result = this._delegate.goInitialState();
        this.endMethod("goInitialState");
        return result;
    }

    @Override
    public double isValidTransition(int idx) throws StepperException {
        this.beginMethod("isValidTransition");
        double result = this._delegate.isValidTransition(idx);
        this.endMethod("isValidTransition");
        return result;
    }

    @Override
    public boolean setSimulOptions(List<String> args) {
        this.beginMethod("setSimulOptions");
        boolean result = this._delegate.setSimulOptions(args);
        this.endMethod("setSimulOptions");
        return result;
    }

    @Override
    public boolean setValueOfState(int i, String value) throws StepperException {
        this.beginMethod("setValueOfState");
        boolean result = this._delegate.setValueOfState(i, value);
        this.endMethod("setValueOfState");
        return result;
    }

    @Override
    public boolean setValueOfState(int i, double value) throws StepperException {
        this.beginMethod("setValueOfStateD");
        boolean result = this._delegate.setValueOfState(i, value);
        this.endMethod("setValueOfStateD");
        return result;
    }

    @Override
    public boolean setInitOfState(int i, String value) {
        this.beginMethod("setInitOfState");
        boolean result = this._delegate.setInitOfState(i, value);
        this.endMethod("setInitOfState");
        return result;
    }

    @Override
    public boolean setInitOfState(int i, double value) {
        this.beginMethod("setInitOfStateD");
        boolean result = this._delegate.setInitOfState(i, value);
        this.endMethod("setInitOfStateD");
        return result;
    }

    @Override
    public boolean withDomain() {
        this.beginMethod("withDomain");
        boolean result = this._delegate.withDomain();
        this.endMethod("withDomain");
        return result;
    }

    @Override
    public boolean withSimul() {
        this.beginMethod("withSimul");
        boolean result = this._delegate.withSimul();
        this.endMethod("withSimul");
        return result;
    }

    class StatItem {
        long _cpt = 0L;
        long _cumuledTime = 0L;
        long _beginTime = 0L;

        StatItem() {
        }
    }
}

