/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.ban;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.UnitValued;
import com.dassault.cecilia.lib.ban.type.Param;
import com.dassault.cecilia.lib.ban.type.destination;
import com.dassault.cecilia.lib.ban.util.UtilFileDst;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.stepuser.ban.SeqManagerUnit;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenLayoutSimple;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenLayoutXML;
import com.dassault.cecilia.lib.mbsa.stepuser.fmea.TriggerManager;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.util.destination.DestinationConsole;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class GenManagerUnit
extends SeqManagerUnit
implements UnitValued {
    protected boolean _result;
    UtilFileDst _dst = new UtilFileDst();
    String _stepperId;
    String _modelId;
    protected List<Param> _params = new ArrayList<Param>();

    @Override
    public Object getResult() {
        return this._result;
    }

    @Override
    public void freeResult() {
    }

    public void setDestfile(String value) {
        this._dst.setFile("destfile", value);
    }

    public void setDestref(String value) {
        this._dst.setRef("destref", value);
    }

    @Override
    public void setProcess(BanProcess process) {
        super.setProcess(process);
        this._dst.setProcess(process);
    }

    public void setStepper(String value) {
        this._stepperId = value;
    }

    protected Stepper getStepper() {
        String id = this.expanse(this._stepperId);
        if (!this.isSimpleID(id)) {
            throw this.errorComplexId("stepper", id, this._stepperId);
        }
        Object obj = this.getProcess().getIdObject(id);
        if (obj == null) {
            throw new BanProcessException("Stepper '" + this._stepperId + "' unknow");
        }
        if (!(obj instanceof Stepper)) {
            throw new BanProcessException("Object with id '" + this._stepperId + "' is not stepper");
        }
        return (Stepper)obj;
    }

    public void setModel(String value) {
        this._modelId = value;
    }

    protected Model getModel() {
        String id = this.expanse(this._modelId);
        if (!this.isSimpleID(id)) {
            throw this.errorComplexId("model", id, this._modelId);
        }
        Object obj = this.getProcess().getIdObject(id);
        if (obj == null) {
            throw new BanProcessException("Model '" + this._modelId + "' unknow");
        }
        if (!(obj instanceof Model)) {
            throw new BanProcessException("Object with id '" + this._modelId + "' is not model");
        }
        return (Model)obj;
    }

    public Param createParam() {
        Param param = new Param();
        this._params.add(param);
        return param;
    }

    protected Map<String, String> getParams() {
        return Param.mapParams(this._params);
    }

    public void endValid() {
        this._dst.endValid();
        if (this._destinations.size() == 0) {
            destination dest = this.createDestination();
            dest.setProcess(this.getProcess());
            dest.setClass(DestinationConsole.class.getName());
        }
        if (this._stepperId == null) {
            throw new BanProcessException("No attribut 'stepper' define");
        }
    }

    @Override
    public Class configureLayout(String key, Map<String, String> params) {
        if (key.equals("default") || key.equals("txt")) {
            return LogGenLayoutSimple.class;
        }
        if (key.equals("xml")) {
            return LogGenLayoutXML.class;
        }
        throw new BanProcessException("layout unknow for stepgen unit : " + key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        String selectFlow;
        String selectState;
        this._result = false;
        boolean failOnError = this.getFailOnError();
        String selectEvent = this.getParams().get("select.event");
        if (selectEvent == null) {
            selectEvent = "";
        }
        if ((selectState = this.getParams().get("select.state")) == null) {
            selectState = "";
        }
        if ((selectFlow = this.getParams().get("select.flow")) == null) {
            selectFlow = "";
        }
        boolean onlyChange = true;
        String optOnlyChg = this.getParams().get("onlychange");
        if (optOnlyChg != null) {
            onlyChange = this.castBool(optOnlyChg, null);
        }
        Stepper stepper = this.getStepper();
        String title = this.getParams().get("title");
        if (title == null) {
            title = "";
        }
        File dst = this._dst.getDstFile();
        TriggerManager seqManager = this.createTrigger(stepper, title, dst);
        seqManager.setSelectors(selectEvent, selectState, selectFlow, onlyChange);
        seqManager.setXMLHeader(this.getXMLHeader());
        this.configureTrigger(seqManager);
        try {
            for (destination dest : this._destinations) {
                seqManager.addDestination(dest.constructDestination(this));
            }
            this.defineCtrlProcess(seqManager);
            try {
                this._result = seqManager.run();
            }
            catch (Exception e) {
                if (failOnError) {
                    throw new BanProcessException(e);
                }
                this.log(e.getMessage(), 0);
            }
        }
        finally {
            this.defineCtrlProcess(null);
        }
    }

    protected abstract TriggerManager createTrigger(Stepper var1, String var2, File var3);

    protected abstract void configureTrigger(TriggerManager var1);
}

