/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.ban;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.UnitValued;
import com.dassault.cecilia.lib.ban.type.LayoutDefiner;
import com.dassault.cecilia.lib.ban.type.Param;
import com.dassault.cecilia.lib.ban.type.destination;
import com.dassault.cecilia.lib.ban.util.UtilFileSrc;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepuser.StepperInterruptException;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenLayoutSimple;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenLayoutXML;
import com.dassault.cecilia.lib.mbsa.stepuser.seqverif.SeqSetDefine;
import com.dassault.cecilia.lib.mbsa.stepuser.seqverif.SeqVerifManager;
import com.dassault.cecilia.lib.util.destination.DestinationConsole;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SeqVerify
extends Unit
implements UnitValued,
LayoutDefiner {
    protected int _result;
    String _stepperId;
    protected List<Param> _options = new ArrayList<Param>();
    protected List<destination> _destinations = new ArrayList<destination>();
    protected List<Param> _inits = new ArrayList<Param>();
    protected List<SeqSet> _seqsets = new ArrayList<SeqSet>();
    protected List<SeqGenFile> _seqgens = new ArrayList<SeqGenFile>();
    String _failOnError;
    SeqVerifManager _process;

    @Override
    public Object getResult() {
        return this._result;
    }

    @Override
    public void freeResult() {
    }

    public void setStepper(String value) {
        this._stepperId = value;
    }

    protected Stepper getStepper() {
        String id = this.expanse(this._stepperId);
        if (!this.isSimpleID(id)) {
            throw this.errorComplexId("stepper", id, this._stepperId);
        }
        Object obj = this.getProcess().getIdObject(id);
        if (obj == null) {
            throw new BanProcessException("Stepper '" + this._stepperId + "' unknow");
        }
        if (!(obj instanceof Stepper)) {
            throw new BanProcessException("Object with id '" + this._stepperId + "' is not stepper");
        }
        return (Stepper)obj;
    }

    public Param createParam() {
        Param param = new Param();
        this._options.add(param);
        return param;
    }

    public destination createDestination() {
        destination app = new destination();
        this._destinations.add(app);
        return app;
    }

    @Override
    public Class configureLayout(String key, Map<String, String> params) {
        if (key.equals("default") || key.equals("txt")) {
            return LogGenLayoutSimple.class;
        }
        if (key.equals("xml")) {
            return LogGenLayoutXML.class;
        }
        throw new BanProcessException("layout unknow for stepgen unit : " + key);
    }

    public Init createInit() {
        return new Init();
    }

    public SeqSet createSeqset() {
        SeqSet tgt = new SeqSet();
        this._seqsets.add(tgt);
        return tgt;
    }

    public SeqGenFile createSeqgen() {
        SeqGenFile tgt = new SeqGenFile();
        this._seqgens.add(tgt);
        return tgt;
    }

    public void setFailonerror(String value) {
        this._failOnError = value;
    }

    public void endValid() {
        if (this._destinations.size() == 0) {
            destination dest = this.createDestination();
            dest.setProcess(this.getProcess());
            dest.setClass(DestinationConsole.class.getName());
        }
        if (this._seqsets.size() + this._seqgens.size() == 0) {
            throw new BanProcessException("No element 'seqset' or 'seqgen' define");
        }
        if (this._stepperId == null) {
            throw new BanProcessException("No attribut 'stepper' define");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        this._result = -1;
        Stepper stepper = this.getStepper();
        try {
            this._process = new SeqVerifManager(stepper);
            this._process.setParams(Param.mapParams(this._options));
            for (destination dest : this._destinations) {
                this._process.addDestination(dest.constructDestination(this));
            }
            this._process.setInits(Param.mapParams(this._inits));
            for (SeqSet sset : this._seqsets) {
                SeqSetDefine def = this._process.createSeqSet(sset.getTargets(), sset.getLockerTargets());
                for (SeqSet.Sequence seq : sset._seqs) {
                    this._process.addSequenceToSet(seq.getSequence(), def);
                }
            }
            for (SeqGenFile sgen : this._seqgens) {
                this._process.addSeqGenFile(sgen._util.getSrcFile());
            }
            if (this._process.getNbrError() > 0) {
                throw new StepperException("Error during initialise : " + this._process.getNbrError());
            }
            this._result = this._process.run();
        }
        catch (StepperInterruptException e) {
            this._result = this._process.getNbrError();
        }
        catch (Exception e) {
            boolean failOnError = true;
            if (this._failOnError != null) {
                failOnError = this.castBool(this.expanse(this._failOnError), "failonerror");
            }
            if (failOnError) {
                throw new BanProcessException(e);
            }
            this.log(e.getMessage(), 0);
        }
        finally {
            this._process = null;
        }
    }

    class Init {
        Init() {
        }

        public Param createState() {
            Param param = new Param();
            SeqVerify.this._inits.add(param);
            return param;
        }
    }

    public class SeqSet {
        protected List<Param> _tgts = new ArrayList<Param>();
        protected List<Param> _lockers = new ArrayList<Param>();
        protected List<Sequence> _seqs = new ArrayList<Sequence>();

        Map<String, String> getTargets() {
            return Param.mapParams(this._tgts);
        }

        Map<String, String> getLockerTargets() {
            return Param.mapParams(this._lockers);
        }

        public Param createTarget() {
            Param param = new Param();
            this._tgts.add(param);
            return param;
        }

        public TargetSet createVerifier() {
            return new TargetSet(false);
        }

        public TargetSet createLocker() {
            return new TargetSet(true);
        }

        public Sequence createSequence() {
            Sequence seq = new Sequence();
            this._seqs.add(seq);
            return seq;
        }

        public class TargetSet {
            boolean _locker;

            TargetSet(boolean locker) {
                this._locker = locker;
            }

            public Param createTarget() {
                Param param = new Param();
                if (this._locker) {
                    SeqSet.this._lockers.add(param);
                } else {
                    SeqSet.this._tgts.add(param);
                }
                return param;
            }
        }

        public class Sequence {
            protected List<Event> _evts = new ArrayList<Event>();

            public Event createEvent() {
                Event evt = new Event();
                this._evts.add(evt);
                return evt;
            }

            List<String> getSequence() {
                ArrayList<String> result = new ArrayList<String>(this._evts.size());
                for (Event evt : this._evts) {
                    result.add(evt.getName());
                }
                return result;
            }

            public class Event {
                String _name;

                public void setName(String value) {
                    this._name = value;
                }

                String getName() {
                    return SeqVerify.this.expanse(this._name);
                }

                public void startValid() {
                    if (this._name == null) {
                        throw new BanProcessException("Attribute 'name' not define for element 'event'");
                    }
                }
            }
        }
    }

    public class SeqGenFile {
        UtilFileSrc _util = new UtilFileSrc();

        public void setProcess(BanProcess process) {
            this._util.setProcess(process);
        }

        public void endValid() {
            this._util.endValid();
        }

        public void setFile(String value) {
            this._util.setFile("file", value);
        }

        public void setFileref(String value) {
            this._util.setRef("fileref", value);
        }
    }
}

