/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.fmea;

import com.dassault.cecilia.lib.mbsa.stepuser.MsgStepUser;
import com.dassault.cecilia.lib.util.ControllableAction;
import com.dassault.cecilia.lib.util.destination.DestinationConsole;
import com.dassault.cecilia.lib.util.diff.Diff;
import com.dassault.cecilia.lib.util.diff.DiffLayoutSimple;
import com.dassault.cecilia.lib.util.diff.DiffRecDefine;
import com.dassault.cecilia.lib.util.diff.DiffRecord;
import com.dassault.cecilia.lib.util.xmlparser.xmlException;
import com.dassault.cecilia.lib.util.xmlparser.xmlNode;
import com.dassault.cecilia.lib.util.xmlparser.xmlParser;
import com.dassault.cecilia.lib.util.xmlparser.xmlTypeNode;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

public class DiffFMEA
extends Diff
implements ControllableAction {
    protected File _file1;
    protected File _file2;
    private xmlParser _parse1;
    private xmlParser _parse2;
    private double _fileslength = -1.0;
    protected String _filterEvent;
    protected String _filterState;
    protected String _filterFlow;
    private Pattern _patternEvent;
    private Pattern _patternState;
    private Pattern _patternFlow;
    protected State _state;
    private Object _locker = new Object();
    private boolean _requestSuspend = false;
    private boolean _requestStop = false;

    public DiffFMEA(File file1, File file2) {
        this._state = State.WAIT;
        this._file1 = file1;
        this._file2 = file2;
        this._filterEvent = "";
        this._filterState = "";
        this._filterFlow = "^\\*NO\\*";
    }

    public void setFilters(String evt, String stt, String flw) {
        if (evt != null) {
            this._filterEvent = evt;
        }
        if (stt != null) {
            this._filterState = stt;
        }
        if (flw != null) {
            this._filterFlow = flw;
        }
    }

    protected double getFilesRead() {
        double result = 0.0;
        result += (double)this._parse1.nbrChar();
        return result += (double)this._parse2.nbrChar();
    }

    public boolean run(String header) throws IOException, xmlException {
        return this.run(header, null, null);
    }

    public boolean run(String header, String title1, String title2) throws IOException, xmlException {
        DiffRecDefine define = new DiffRecDefine(header == null ? "Diff FMEA" : header);
        if (title1 != null) {
            define.setDesc1(title1);
        } else {
            define.setDesc1(this._file1);
        }
        if (title2 != null) {
            define.setDesc2(title2);
        } else {
            define.setDesc2(this._file2);
        }
        this.setDefine(define);
        return this.run();
    }

    private boolean run() throws IOException, xmlException {
        boolean result = false;
        try {
            this._state = State.INIT;
            this._parse1 = new xmlParser(this._file1);
            this._parse2 = new xmlParser(this._file2);
            this._fileslength = this._file1.length() + this._file2.length();
            this._patternEvent = this._filterEvent.length() == 0 ? null : Pattern.compile(this._filterEvent);
            this._patternState = this._filterState.length() == 0 ? null : Pattern.compile(this._filterState);
            this._patternFlow = this._filterFlow.length() == 0 ? null : Pattern.compile(this._filterFlow);
            this._state = State.WORK;
            xmlNode tr1 = this.readNextTrans(this._parse1);
            xmlNode tr2 = this.readNextTrans(this._parse2);
            while (!(this.checkStopped() || this.isEOFNode(tr1) && this.isEOFNode(tr2))) {
                this.checkSuspended();
                if (this.isEOFNode(tr1)) {
                    this.writeDiff(tr2, null, this._parse2);
                    tr2 = this.readNextTrans(this._parse2);
                    continue;
                }
                if (this.isEOFNode(tr2)) {
                    this.writeDiff(tr1, null, this._parse1);
                    tr1 = this.readNextTrans(this._parse1);
                    continue;
                }
                int diff = this.getEventAttribOfTrans(tr1, this._parse1).compareTo(this.getEventAttribOfTrans(tr2, this._parse2));
                if (diff < 0) {
                    this.writeDiff(tr1, null, this._parse1);
                    tr1 = this.readNextTrans(this._parse1);
                    continue;
                }
                if (diff > 0) {
                    this.writeDiff(tr2, null, this._parse2);
                    tr2 = this.readNextTrans(this._parse2);
                    continue;
                }
                this.compareTrans(tr1, tr2);
                tr1 = this.readNextTrans(this._parse1);
                tr2 = this.readNextTrans(this._parse2);
            }
            result = !this.withDiff();
        }
        catch (InterruptedException tr1) {
        }
        catch (xmlException e) {
            this.addRecord(new DiffRecord("XMLException --> " + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            this.addRecord(new DiffRecord("IOException --> " + e.getMessage()));
            throw e;
        }
        finally {
            this.close();
            try {
                if (this._parse1 != null) {
                    this._parse1.close();
                }
                if (this._parse2 != null) {
                    this._parse2.close();
                }
            }
            catch (IOException iOException) {}
            this._fileslength = Double.NaN;
            this._parse1 = null;
            this._parse2 = null;
            this._state = State.FINISH;
        }
        return result;
    }

    private void writeDiff(xmlNode tr, xmlNode var, xmlParser parse) throws IOException, xmlException {
        DiffRecord rec = new DiffRecord((int)this._parse1.nbrLine());
        StringBuffer msg = new StringBuffer(128);
        msg.append("Evt(").append(this.getEventAttribOfTrans(tr, parse)).append(")\t");
        if (var == null) {
            msg.append("...");
        } else if (var.getValue().equals("flow")) {
            msg.append("Flw(").append(var.getAttrib("name"));
            msg.append(") = ").append(var.getAttrib("value"));
        } else if (var.getValue().equals("state")) {
            msg.append("Stt(").append(var.getAttrib("name"));
            msg.append(") = ").append(var.getAttrib("value"));
        }
        if (parse == this._parse2) {
            rec.setCompare(1).setMsg2(msg.toString());
        } else {
            rec.setCompare(-1).setMsg1(msg.toString());
        }
        this.addRecord(rec);
    }

    private boolean isEOFNode(xmlNode node) {
        return node.getType() == xmlTypeNode.ENDSTREAM;
    }

    private xmlNode readNextTrans(xmlParser parser) throws IOException, xmlException {
        xmlNode result = null;
        boolean stop = false;
        while (!stop) {
            String name;
            result = parser.nextNode();
            if (result.getType() == xmlTypeNode.ENDSTREAM) {
                stop = true;
                continue;
            }
            if (result.getType() != xmlTypeNode.START) continue;
            if (result.getValue().equals("trans")) {
                if (this._patternEvent == null) {
                    stop = true;
                    continue;
                }
                name = result.getAttrib("event");
                if (this._patternEvent.matcher(name).find()) continue;
                stop = true;
                continue;
            }
            if (!result.getValue().equals("tr")) continue;
            if (this._patternEvent == null) {
                stop = true;
                continue;
            }
            name = result.getAttrib("evt");
            if (this._patternEvent.matcher(name).find()) continue;
            stop = true;
        }
        return result;
    }

    private String getEventAttribOfTrans(xmlNode tr, xmlParser parser) throws xmlException {
        if (tr.getValue().equals("trans")) {
            return tr.getAttrib("event");
        }
        if (tr.getValue().equals("tr")) {
            return tr.getAttrib("evt");
        }
        throw new xmlException("No attribute 'evt' for 'tr' element", parser);
    }

    private boolean isEOTransNode(xmlNode node) {
        return node.getType() == xmlTypeNode.STOP;
    }

    private xmlNode readNextVar(xmlParser parser) throws IOException, xmlException {
        xmlNode result = null;
        boolean stop = false;
        while (!stop) {
            String name;
            result = parser.nextNode();
            if (result.getType() == xmlTypeNode.STOP) {
                if (result.getValue().equals("trans")) {
                    stop = true;
                    continue;
                }
                if (!result.getValue().equals("tr")) continue;
                stop = true;
                continue;
            }
            if (result.getType() != xmlTypeNode.START) continue;
            if (result.getValue().equals("flow")) {
                if (this._patternFlow == null) {
                    stop = true;
                    continue;
                }
                name = result.getAttrib("name");
                if (this._patternFlow.matcher(name).find()) continue;
                stop = true;
                continue;
            }
            if (result.getValue().equals("state")) {
                if (this._patternState == null) {
                    stop = true;
                    continue;
                }
                name = result.getAttrib("name");
                if (this._patternState.matcher(name).find()) continue;
                stop = true;
                continue;
            }
            throw new xmlException("Only 'flow' or 'state' element for child element of 'tr'", parser);
        }
        return result;
    }

    private void compareTrans(xmlNode tr1, xmlNode tr2) throws IOException, xmlException {
        xmlNode var1 = this.readNextVar(this._parse1);
        xmlNode var2 = this.readNextVar(this._parse2);
        while (!this.isEOTransNode(var1) || !this.isEOTransNode(var2)) {
            int typ2;
            if (this.isEOTransNode(var1)) {
                this.writeDiff(tr2, var2, this._parse2);
                var2 = this.readNextVar(this._parse2);
                continue;
            }
            if (this.isEOTransNode(var2)) {
                this.writeDiff(tr1, var1, this._parse1);
                var1 = this.readNextVar(this._parse1);
                continue;
            }
            int diff = 0;
            int typ1 = var1.getValue().equals("state") ? 1 : 2;
            diff = typ1 - (typ2 = var2.getValue().equals("state") ? 1 : 2);
            if (diff == 0) {
                diff = var1.getAttrib("name").compareTo(var2.getAttrib("name"));
            }
            if (diff < 0) {
                this.writeDiff(tr1, var1, this._parse1);
                var1 = this.readNextVar(this._parse1);
                continue;
            }
            if (diff > 0) {
                this.writeDiff(tr2, var2, this._parse2);
                var2 = this.readNextVar(this._parse2);
                continue;
            }
            diff = var1.getAttrib("value").compareTo(var2.getAttrib("value"));
            if (diff != 0) {
                DiffRecord rec = new DiffRecord((int)this._parse1.nbrLine());
                StringBuffer msg = new StringBuffer(128);
                msg.append("Evt(").append(this.getEventAttribOfTrans(tr1, this._parse1)).append(")\t");
                if (var1.getValue().equals("flow")) {
                    msg.append("Flw(").append(var1.getAttrib("name")).append(") = ");
                } else if (var1.getValue().equals("state")) {
                    msg.append("Stt(").append(var1.getAttrib("name")).append(") = ");
                }
                rec.setHeader(msg.toString());
                rec.setMsg1(var1.getAttrib("value"));
                rec.setMsg2(var2.getAttrib("value"));
                this.addRecord(rec);
            }
            var1 = this.readNextVar(this._parse1);
            var2 = this.readNextVar(this._parse2);
        }
    }

    @Override
    public void requestSuspend() {
        this._requestSuspend = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSuspended() throws InterruptedException {
        Object object = this._locker;
        synchronized (object) {
            while (this._requestSuspend) {
                this._locker.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestResume() {
        this._requestSuspend = false;
        Object object = this._locker;
        synchronized (object) {
            this._locker.notify();
        }
    }

    @Override
    public void requestStop() {
        this._requestStop = true;
        if (this._requestSuspend) {
            this.requestResume();
        }
    }

    protected boolean checkStopped() {
        return this._requestStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInfo(String key) {
        if (key.equals("process.msg") || key.equals("process.msg.high")) {
            DiffFMEA diffFMEA = this;
            synchronized (diffFMEA) {
                switch (this._state) {
                    case WAIT: {
                        return MsgStepUser.getString("PRV_CMD_SEQ_WAIT");
                    }
                    case INIT: {
                        return MsgStepUser.getString("PRV_CMD_SEQ_INIT");
                    }
                    case WORK: {
                        return MsgStepUser.getString("PRV_CMD_SEQ_WORK");
                    }
                    case FINISH: {
                        return MsgStepUser.getString("PRV_CMD_SEQ_FINISH");
                    }
                    case MARK1: {
                        return "Mark1";
                    }
                    case MARK2: {
                        return "Mark2";
                    }
                }
            }
        }
        if (key.equals("process.p1000")) {
            if (this._fileslength < 0.0) {
                return "0";
            }
            if (Double.isNaN(this._fileslength)) {
                return "1001";
            }
            return Integer.toString((int)(this.getFilesRead() / this._fileslength * 1000.0));
        }
        return null;
    }

    private static int Main(String[] args) {
        File file1 = null;
        File file2 = null;
        try {
            if (args.length == 2) {
                file1 = new File(args[0]);
                file2 = new File(args[1]);
                DiffFMEA diff = new DiffFMEA(file1, file2);
                DestinationConsole destination2 = new DestinationConsole(false);
                destination2.setLayout(new DiffLayoutSimple());
                diff.addDestination(destination2);
                boolean result = diff.run("Diff FMEA");
                return result ? 0 : 1;
            }
            return 2;
        }
        catch (IOException e) {
            return 3;
        }
        catch (xmlException e) {
            return 4;
        }
    }

    public static void main(String[] args) {
        System.exit(DiffFMEA.Main(args));
    }

    public static enum State {
        WAIT,
        INIT,
        WORK,
        FINISH,
        MARK1,
        MARK2;

    }
}

