/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.model;

import com.dassault.cecilia.lib.mbsa.stepuser.MsgStepUser;
import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.error.GenerateException;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.Event;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.Extern;
import com.dassault.cecilia.lib.mbsa.translator.model.Flow;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.Init;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Simular;
import com.dassault.cecilia.lib.mbsa.translator.model.State;
import com.dassault.cecilia.lib.mbsa.translator.model.Tree;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DataNodeExtract {
    TreeMap<String, DataEvent> _events = new TreeMap();
    TreeMap<String, DataState> _states = new TreeMap();
    TreeMap<String, DataFlow> _flows = new TreeMap();
    LinkedHashMap<String, DataParam> _params = new LinkedHashMap();
    LinkedHashMap<String, DataProperty> _properties = new LinkedHashMap();
    LinkedHashSet<String> _araliaParams = new LinkedHashSet();
    Node _node;

    public Collection<DataEvent> getCollectEvent() {
        return this._events.values();
    }

    public Collection<DataState> getCollectState() {
        return this._states.values();
    }

    public Collection<DataFlow> getCollectFlow() {
        return this._flows.values();
    }

    public Collection<DataParam> getCollectParam() {
        return this._params.values();
    }

    public Collection<DataProperty> getCollectProperty() {
        return this._properties.values();
    }

    public DataNodeExtract(Node node) {
        this._node = node;
    }

    protected Event convertToEvent(Object obj) {
        return (Event)obj;
    }

    protected State convertToState(Object obj) {
        return (State)obj;
    }

    protected Flow convertToFlow(Object obj) {
        return (Flow)obj;
    }

    protected String getInitForFlow(Flow flow) {
        return null;
    }

    public void extract(Set evts, Set states, Set flows) throws IOException {
        int i;
        DataState data;
        Iterator it = evts.iterator();
        while (it.hasNext()) {
            Event evt = this.convertToEvent(it.next());
            if (evt == null) continue;
            this._events.put(evt.getName(), new DataEvent(evt));
        }
        it = states.iterator();
        while (it.hasNext()) {
            double initValue;
            State state = this.convertToState(it.next());
            if (state == null) continue;
            data = new DataState(state);
            data._domain = state.getDomain().getName();
            if (data._domain == null) {
                data._domain = state.getDomain().toString();
            }
            this._states.put(state.getName(), data);
            Simular simState = state.getSimular();
            if (simState == null || Double.isNaN(initValue = simState.getInitValue())) continue;
            data._init = simState.getDomain().toString(initValue);
        }
        it = flows.iterator();
        while (it.hasNext()) {
            Flow flow = this.convertToFlow(it.next());
            if (flow == null) continue;
            data = new DataFlow(flow);
            ((DataFlow)data)._domain = flow.getDomain().getName();
            if (((DataFlow)data)._domain == null) {
                ((DataFlow)data)._domain = flow.getDomain().toString();
            }
            switch (flow.getOrientation()) {
                case '\u0001': {
                    ((DataFlow)data)._orientation = "in";
                    break;
                }
                case '\u0002': {
                    ((DataFlow)data)._orientation = "out";
                    break;
                }
                case '\u0003': {
                    ((DataFlow)data)._orientation = "private";
                }
            }
            ((DataFlow)data)._init = this.getInitForFlow(flow);
            this._flows.put(flow.getName(), (DataFlow)data);
        }
        for (i = 0; i < this._node.getInitCount(); ++i) {
            Init init = this._node.getInit(i);
            data = this._states.get(init.getPathVar());
            if (data == null) {
                data = this._flows.get(init.getPathVar());
            }
            if (data == null) continue;
            data._init = init.getValue();
        }
        for (i = 0; i < this._node.getExternCount(); ++i) {
            Extern ext = this._node.getExtern(i);
            String type = ext.getTree()._sval;
            if (type.equals("law")) {
                this.extractLaw(ext);
                continue;
            }
            if (type.equals("attribute")) {
                this.extractAttribute(ext);
                continue;
            }
            if (type.equals("parameter")) {
                this.extractParameter(ext);
                continue;
            }
            if (type.equals("remark")) {
                this.extractRemark(ext);
                continue;
            }
            if (type.equals("priority")) {
                this.extractPriority(ext);
                continue;
            }
            if (type.equals("bucket")) {
                this.extractBucket(ext);
                continue;
            }
            if (!type.equals("nodeproperty")) continue;
            this.extractProperty(ext);
        }
    }

    private void extractRemark(Extern ext) throws IOException {
        ArrayList<Data> datum = new ArrayList<Data>();
        int nbrData = Extern.verifyOnlyRemarkObject(ext.getVar(), datum);
        if (nbrData <= 0) {
            throw new GenerateException(MsgTrans.getString("WRN_XREMARK_NO_OBJ"));
        }
        if (ext.getVal() == null || ext.getVal()._type != 303) {
            return;
        }
        String value = Extern.toString(ext.getVal());
        if (value.length() > 1 && value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        for (Data data : datum) {
            Object ddata;
            if (data instanceof Event) {
                ddata = this._events.get(((Event)data).getName());
                if (ddata == null) continue;
                ((DataEvent)ddata)._remark = value;
                continue;
            }
            if (data instanceof State) {
                ddata = this._states.get(((State)data).getName());
                if (ddata == null) continue;
                ((DataState)ddata)._remark = value;
                continue;
            }
            if (!(data instanceof Flow) || (ddata = this._flows.get(((Flow)data).getName())) == null) continue;
            ((DataFlow)ddata)._remark = value;
        }
    }

    private void extractPriority(Extern ext) throws IOException {
        ArrayList<Event> evts = new ArrayList<Event>();
        int nbrEvt = Extern.verifyOnlyEvent(ext.getVar(), evts, true);
        if (nbrEvt <= 0) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XPRIORITY"));
        }
        Tree val = ext.getVal();
        if (val == null || val._type != 258) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XPRIORITY"));
        }
        Expr eval = (Expr)val._son;
        if (!eval.isConstant() || eval.getScale() != Expr.Scale.Integer) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XPRIORITY"));
        }
        if (eval.getInt() < 0L) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XPRIORITY"));
        }
        for (Event evt : evts) {
            DataEvent data = this._events.get(evt.getName());
            if (data == null) continue;
            data._priority = eval.getInt();
        }
    }

    private void extractBucket(Extern ext) throws IOException {
        ArrayList<Event> evts = new ArrayList<Event>();
        int nbrEvt = Extern.verifyOnlyEvent(ext.getVar(), evts, true);
        if (nbrEvt <= 0) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XBUCKET"));
        }
        for (Event evt : evts) {
            DataEvent data = this._events.get(evt.getName());
            if (data == null) continue;
            data._bucket = true;
        }
    }

    private void extractLaw(Extern ext) throws IOException {
        ArrayList<Event> evts = new ArrayList<Event>();
        int nbrEvt = Extern.verifyOnlyEvent(ext.getVar(), evts, true);
        if (nbrEvt <= 0) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XLAW"));
        }
        String aralLaw = null;
        String mocaLaw = null;
        String altaLaw = null;
        for (Event evt : evts) {
            DataEvent data = this._events.get(evt.getName());
            if (data == null) continue;
            if (altaLaw == null) {
                altaLaw = Extern.toString(ext.getVal());
                try {
                    StringWriter aralWriter = new StringWriter(64);
                    ext.printAraliaLaw(aralWriter, this._node, this._araliaParams);
                    aralWriter.close();
                    aralLaw = aralWriter.toString();
                }
                catch (GenerateException aralWriter) {
                    // empty catch block
                }
                try {
                    StringWriter mocaWriter = new StringWriter(64);
                    ext.printMocaLaw(new IndentWriter(mocaWriter, ""), this._node);
                    mocaWriter.close();
                    mocaLaw = mocaWriter.toString();
                }
                catch (GenerateException generateException) {
                    // empty catch block
                }
            }
            data._lawAlta = altaLaw;
            data._lawAral = aralLaw;
            data._lawMoca = mocaLaw;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void extractAttribute(Extern ext) throws IOException {
        ArrayList<Event> evts = new ArrayList<Event>();
        int nbrEvt = Extern.verifyOnlyEvent(ext.getVar(), evts, false);
        if (nbrEvt <= 0) {
            throw new GenerateException(MsgStepUser.getString("EXC_GEN_XATTRIB"));
        }
        String name = ext.getVar()._sval;
        if (name.length() == 0) {
            throw new GenerateException(MsgStepUser.getString("EXC_GEN_XATTRIB"));
        }
        String value = "true";
        Tree val = ext.getVal();
        if (val != null) {
            if (val._type == 258) {
                Expr eval = (Expr)val._son;
                if (!eval.isConstant()) throw new GenerateException(MsgStepUser.getString("EXC_GEN_XATTRIB"));
                value = this._node.valueToString(eval);
            } else {
                if (val._type != 303) throw new GenerateException(MsgStepUser.getString("EXC_GEN_XATTRIB"));
                value = val._sval;
            }
        }
        if (value.length() > 1 && value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        for (Event evt : evts) {
            DataEvent data = this._events.get(evt.getName());
            if (data == null) continue;
            data.addAttrib(name, value);
        }
    }

    private void extractParameter(Extern ext) throws IOException {
        StringWriter paramWriter2;
        Object name = null;
        Tree var = ext.getVar();
        if (var._type == 258) {
            Expr evar = (Expr)var._son;
            if (evar.isConstant() && evar.isSymbolic()) {
                name = evar.toString();
            }
        } else if (var._type == 267) {
            name = "'" + var._sval + "'";
        }
        if (name == null) {
            throw new GenerateException(MsgStepUser.getString("EXC_GEN_XPARAM"));
        }
        DataParam data = this._params.get(name);
        if (data == null) {
            data = new DataParam((String)name);
            this._params.put((String)name, data);
        } else {
            data.init();
        }
        data._valAlta = Extern.toString(ext.getVal());
        try {
            paramWriter2 = new StringWriter(64);
            Extern.printAraliaParam(paramWriter2, this._node, ext.getVal(), this._araliaParams);
            paramWriter2.close();
            data._valAral = paramWriter2.toString();
        }
        catch (GenerateException paramWriter2) {
            // empty catch block
        }
        try {
            paramWriter2 = new StringWriter(64);
            Extern.printMocaParam(new IndentWriter(paramWriter2, ""), this._node, ext.getVal());
            paramWriter2.close();
            data._valMoca = paramWriter2.toString();
        }
        catch (GenerateException generateException) {
            // empty catch block
        }
    }

    private void extractProperty(Extern ext) throws IOException {
        String value;
        Expr evar;
        String name = null;
        Tree var = ext.getVar();
        if (var._type == 258 && (evar = (Expr)var._son).isConstant() && evar.isSymbolic()) {
            name = evar.toString();
        }
        if (name == null) {
            throw new GenerateException(MsgStepUser.getString("EXC_GEN_XPARAM"));
        }
        DataProperty data = this._properties.get(name);
        if (data == null) {
            data = new DataProperty(name);
            this._properties.put(name, data);
        }
        if ((value = Extern.toString(ext.getVal())).length() > 1 && value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        data._value = value;
    }

    private void printAttribute(com.dassault.cecilia.lib.util.io.IndentWriter writer, String name, String value) throws IOException {
        if (value != null) {
            writer.write(" ");
            writer.write(name);
            writer.write("=\"");
            writer.writeEscapeXML(value);
            writer.write("\"");
        }
    }

    public void write(com.dassault.cecilia.lib.util.io.IndentWriter writer) throws IOException {
        String init;
        String remark;
        writer.write("<model>\n");
        writer.addIndent(1);
        for (DataFlow flow : this.getCollectFlow()) {
            writer.write("<flow");
            this.printAttribute(writer, "name", flow.getData().getName());
            this.printAttribute(writer, "domain", flow.getDomain());
            this.printAttribute(writer, "orientation", flow.getOrientation());
            writer.write(">");
            writer.addIndent(1);
            remark = flow.getRemark();
            if (remark != null) {
                writer.write("\n<remark>");
                writer.writeEscapeXML(remark, false);
                writer.write("</remark>");
            }
            if ((init = flow.getInit()) != null) {
                writer.write("\n<init value=\"");
                writer.writeEscapeXML(init);
                writer.write("\"/>");
            }
            writer.addIndent(-1);
            writer.write("</flow>\n");
        }
        for (DataState state : this.getCollectState()) {
            writer.write("<state");
            this.printAttribute(writer, "name", state.getData().getName());
            this.printAttribute(writer, "domain", state.getDomain());
            writer.write(">");
            writer.addIndent(1);
            remark = state.getRemark();
            if (remark != null) {
                writer.write("\n<remark>");
                writer.writeEscapeXML(remark, false);
                writer.write("</remark>");
            }
            if ((init = state.getInit()) != null) {
                writer.write("\n<init value=\"");
                writer.writeEscapeXML(init);
                writer.write("\"/>");
            }
            writer.addIndent(-1);
            writer.write("</state>\n");
        }
        for (DataEvent event : this.getCollectEvent()) {
            String law;
            Map<String, String> attribs;
            writer.write("<event");
            this.printAttribute(writer, "name", event.getData().getName());
            long priority = event.getPriority();
            if (priority != 0L) {
                this.printAttribute(writer, "priority", Long.toString(priority));
            }
            if (event.isBucketed()) {
                this.printAttribute(writer, "bucket", "true");
            }
            writer.write(">");
            writer.addIndent(1);
            String remark2 = event.getRemark();
            if (remark2 != null) {
                writer.write("\n<remark>");
                writer.writeEscapeXML(remark2, false);
                writer.write("</remark>");
            }
            if ((attribs = event.getAttributes()) != null) {
                for (Map.Entry<String, String> entry : attribs.entrySet()) {
                    writer.write("\n<attribute");
                    this.printAttribute(writer, "name", entry.getKey());
                    this.printAttribute(writer, "value", entry.getValue());
                    writer.write("/>");
                }
            }
            if ((law = event.getLawAlta()) != null) {
                writer.write("\n<law");
                this.printAttribute(writer, "value", law);
                this.printAttribute(writer, "aralia", event.getLawAral());
                this.printAttribute(writer, "moca", event.getLawMoca());
                writer.write("/>");
            }
            writer.addIndent(-1);
            writer.write("</event>\n");
        }
        for (DataParam param : this.getCollectParam()) {
            writer.write("<parameter");
            this.printAttribute(writer, "name", param.getData());
            this.printAttribute(writer, "value", param.getValueAlta());
            this.printAttribute(writer, "aralia", param.getValueAral());
            this.printAttribute(writer, "moca", param.getValueMoca());
            writer.write("/>\n");
        }
        for (DataProperty prop : this.getCollectProperty()) {
            writer.write("<nodeproperty");
            this.printAttribute(writer, "name", prop.getData());
            this.printAttribute(writer, "value", prop.getValue());
            writer.write("/>\n");
        }
        writer.addIndent(-1);
        writer.write("</model>\n");
    }

    public class DataEvent {
        Event _evt;
        String _lawAral;
        String _lawAlta;
        String _lawMoca;
        Map<String, String> _attrib;
        String _remark;
        long _priority;
        boolean _bucket;

        DataEvent(Event evt) {
            this._evt = evt;
            this._priority = 0L;
            this._bucket = false;
        }

        public Event getData() {
            return this._evt;
        }

        void addAttrib(String name, String value) {
            if (this._attrib == null) {
                this._attrib = new TreeMap<String, String>();
            }
            this._attrib.put(name, value);
        }

        public Map<String, String> getAttributes() {
            return this._attrib;
        }

        public String getLawAlta() {
            return this._lawAlta;
        }

        public String getLawAral() {
            return this._lawAral;
        }

        public String getLawMoca() {
            return this._lawMoca;
        }

        public String getRemark() {
            return this._remark;
        }

        public long getPriority() {
            return this._priority;
        }

        public boolean isBucketed() {
            return this._bucket;
        }
    }

    public class DataState {
        Var _var;
        String _init;
        String _domain;
        String _remark;

        DataState(Var state) {
            this._var = state;
        }

        public Var getData() {
            return this._var;
        }

        public String getInit() {
            return this._init;
        }

        public String getDomain() {
            return this._domain;
        }

        public String getRemark() {
            return this._remark;
        }
    }

    public class DataFlow
    extends DataState {
        String _orientation;

        DataFlow(Flow flow) {
            super(flow);
        }

        public String getOrientation() {
            return this._orientation;
        }
    }

    public class DataParam {
        String _name;
        String _valAral;
        String _valAlta;
        String _valMoca;

        DataParam(String name) {
            this._name = name;
        }

        void init() {
            this._valAral = null;
            this._valAlta = null;
            this._valMoca = null;
        }

        public String getData() {
            return this._name;
        }

        public String getValueAlta() {
            return this._valAlta;
        }

        public String getValueAral() {
            return this._valAral;
        }

        public String getValueMoca() {
            return this._valMoca;
        }
    }

    public class DataProperty {
        String _name;
        String _value;

        DataProperty(String name) {
            this._name = name;
        }

        void init() {
            this._value = null;
        }

        public String getData() {
            return this._name;
        }

        public String getValue() {
            return this._value;
        }
    }
}

