/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.stepuser.MsgStepUser;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenLayoutXML;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenRecord;
import com.dassault.cecilia.lib.mbsa.stepuser.model.DataNodeExtract;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.FormatSeqs;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.FormatSeqsMCS;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSet;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenTarget;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenerator;
import com.dassault.cecilia.lib.mbsa.translator.error.GenerateException;
import com.dassault.cecilia.lib.mbsa.translator.model.Event;
import com.dassault.cecilia.lib.mbsa.translator.model.Flow;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.util.io.IndentWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class FormatSeqsXML
implements FormatSeqs {
    Node _node;

    public FormatSeqsXML(Node node) {
        this._node = node;
    }

    private void printAttribute(IndentWriter writer, String name, String value) throws IOException {
        if (value != null) {
            writer.write(" ");
            writer.write(name);
            writer.write("=\"");
            writer.writeEscapeXML(value);
            writer.write("\"");
        }
    }

    protected String getXMLHeader(SeqGenTarget tgt) {
        String encoding = tgt._params.get("format.xml.encoding");
        if (encoding != null && encoding.length() > 0) {
            StringBuffer sb = new StringBuffer(256);
            sb.append("<?xml version='1.0' encoding='");
            sb.append(encoding);
            sb.append("'?>\n");
            return sb.toString();
        }
        return "<?xml version='1.0'?>\n";
    }

    @Override
    public void printResult(ResultSet set, Writer outWriter, SeqGenTarget tgt, SeqGenerator generator) throws IOException {
        IdentityHashMap<Event, Event> events = new IdentityHashMap<Event, Event>();
        IndentWriter writer = new IndentWriter(outWriter, "\t");
        writer.write(this.getXMLHeader(tgt));
        writer.write("<seqgen>\n");
        writer.addIndent(1);
        writer.write("<define>\n");
        writer.addIndent(1);
        writer.write("<target");
        this.printAttribute(writer, "name", tgt.getName());
        this.printAttribute(writer, "value", tgt.getValue());
        writer.write(">\n");
        writer.addIndent(1);
        for (Map.Entry<String, String> entry : new TreeMap<String, String>(tgt._params).entrySet()) {
            writer.write("<param");
            this.printAttribute(writer, "name", entry.getKey());
            this.printAttribute(writer, "value", entry.getValue());
            writer.write("/>\n");
        }
        writer.addIndent(-1);
        writer.write("</target>\n");
        writer.addIndent(-1);
        TreeSet<String> evts = new TreeSet<String>();
        for (ModelTrans tr : generator.getTranss()) {
            evts.add(tr.getName());
        }
        if (evts.size() != this._node.getEventCount()) {
            writer.addIndent(1);
            writer.write("<filter> <!-- nbr events : ");
            writer.write(Integer.toString(evts.size()));
            writer.write("-->\n");
            writer.addIndent(1);
            for (String evt : evts) {
                writer.write("<include");
                this.printAttribute(writer, "name", evt);
                writer.write("/>\n");
            }
            writer.addIndent(-1);
            writer.write("</filter>\n");
            writer.addIndent(-1);
        }
        writer.write("</define>\n");
        boolean error = false;
        if (generator != null) {
            Iterator<LogGenRecord> iterator = generator.getErrorList().iterator();
            if (iterator.hasNext()) {
                writer.write("<errors>\n");
                writer.addIndent(1);
                LogGenLayoutXML layout2 = new LogGenLayoutXML();
                layout2.configure(FormatSeqsMCS.__LayoutConfig);
                while (iterator.hasNext()) {
                    writer.write(layout2.format(iterator.next()));
                }
                writer.addIndent(-1);
                writer.write("</errors>\n");
                error = true;
            }
            if (Boolean.getBoolean("cecilia.mbsa.seqgen.DisplayResultsWithError")) {
                error = false;
            }
        }
        if (error) {
            writer.write("<result>\n");
            writer.addIndent(1);
            writer.write("<seq></seq>\n");
            writer.addIndent(-1);
            writer.write("</result>\n");
        } else {
            Map<Integer, Integer> map = set.getOrders();
            if (map != null && map.size() > 0) {
                writer.write("<orders>\n");
                writer.addIndent(1);
                int total = 0;
                for (Integer order : new TreeSet<Integer>(map.keySet())) {
                    int nbr = map.get(order);
                    writer.write("<seq-number order='");
                    writer.write(Integer.toString(order));
                    writer.write("' number='");
                    writer.write(Integer.toString(nbr));
                    writer.write("'/>\n");
                    total += nbr;
                }
                writer.write("<seq-number order='all' number='");
                writer.write(Integer.toString(total));
                writer.write("'/>\n");
                writer.addIndent(-1);
                writer.write("</orders>\n");
            }
            writer.write("<result>\n");
            writer.addIndent(1);
            Iterator iTrs = set.getSeqIterator();
            while (iTrs.hasNext()) {
                ModelTrans[] cut = (ModelTrans[])iTrs.next();
                for (int j = 0; j < cut.length; ++j) {
                    Event evt = this._node.getEvent(cut[j].getName());
                    if (evt == null) {
                        throw new GenerateException(MessageFormat.format(MsgStepUser.getString("ERR_NO_EVT_FIND"), cut[j].getName()));
                    }
                    events.put(evt, evt);
                }
                writer.write("<seq>");
                writer.addIndent(1);
                for (int i = 0; i < cut.length; ++i) {
                    if (i > 0) {
                        writer.write("\n");
                    }
                    writer.write("<tr id=\"");
                    writer.write(Integer.toString(cut[i].getIdx()));
                    writer.write("\" evt=\"");
                    writer.write(cut[i].getName());
                    writer.write("\"/>");
                }
                writer.addIndent(-1);
                writer.write("</seq>\n");
            }
            writer.addIndent(-1);
            writer.write("</result>\n");
        }
        DataNodeExtract dataNodeExtract = new DataNodeExtract(this._node);
        Set flowSet = Collections.emptySet();
        Flow flowTarget = this._node.getFlow(tgt.getName());
        if (flowTarget != null) {
            flowSet = new HashSet();
            flowSet.add(flowTarget);
        }
        dataNodeExtract.extract(events.keySet(), this._node.getStates(), flowSet);
        dataNodeExtract.write(writer);
        writer.addIndent(-1);
        writer.write("</seqgen>\n");
    }
}

